/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.ParcelamentoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarRPBean;
import jalis.model.dao.financeiro.ParcelamentoDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.AbstractThreadService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public class ParcelamentoService
extends AbstractThreadService {
    public ParcelamentoService() {
        this.dao = new ParcelamentoDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((ParcelamentoDao)this.dao).getBean(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((ParcelamentoDao)this.dao).getBean(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    public void insert(AbstractThreadBean bean, String filial, String filiais) throws Exception {
        ReceberPagarBean originalBean = null;
        Set<ReceberPagarBean> parcelasSet = null;
        if (!(bean instanceof ParcelamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        originalBean = ((ParcelamentoBean)bean).getTituloOriginal();
        if (originalBean == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Parcelamento. N\u00e3o h\u00e1 t\u00edtulo Original.", null);
            return;
        }
        parcelasSet = ((ParcelamentoBean)bean).getParcelas();
        if (parcelasSet != null) {
            if (parcelasSet.size() <= 0) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Parcelamento. N\u00e3o h\u00e1 Parcelas.", null);
                return;
            }
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Parcelamento. N\u00e3o h\u00e1 Parcelas.", null);
            return;
        }
        originalBean.setSituacao("L");
        originalBean.setObservacao(originalBean.getObservacao() == null ? "" : originalBean.getObservacao() + " - T\u00edtulo Parcelado.");
        originalBean.setOrigem("R");
        originalBean = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(originalBean, originalBean.getCodigo(), filial, filiais, true);
        for (ReceberPagarBean aux : parcelasSet) {
            if (aux.isRemover()) continue;
            aux.setDataHora(new Date());
            if (aux.getCodigo() != null) {
                new ReceberPagarService().gravaAutoCopiaSemCommit(aux, 1, filial, filiais);
            } else {
                new ReceberPagarService().gravaAutoCopiaSemCommit(aux, 0, filial, filiais);
            }
            ReceberPagarRPBean recPagRP = new ReceberPagarRPBean();
            recPagRP.setFilialOrigem(originalBean.getFilial());
            recPagRP.setReceberPagarOrigem((ReceberPagarVO)originalBean.toVO());
            recPagRP.setFilialDestino(aux.getFilial());
            recPagRP.setReceberPagarDestino((ReceberPagarVO)aux.toVO());
            recPagRP.setTipo("R");
            this.dao.insert(recPagRP, filial);
        }
        Conexao.arquivaSQL();
    }

    public boolean isParcela(String filialParcela, String codigoParcela) throws SQLException {
        return ((ParcelamentoDao)this.dao).isParcela(filialParcela, codigoParcela);
    }

    public Integer getCodigoTituloOriginal(String filialParcela, String codigoParcela) throws SQLException {
        return ((ParcelamentoDao)this.dao).getCodigoTituloOriginal(filialParcela, codigoParcela);
    }

    public Set getParcelas(String filialTituloOriginal, String codigoTituloOriginal) throws Exception {
        return ((ParcelamentoDao)this.dao).getParcelas(filialTituloOriginal, codigoTituloOriginal);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public void update(AbstractThreadBean bean, String filial, String filiais) throws Exception {
        ReceberPagarBean originalBean = null;
        Set<ReceberPagarBean> parcelasSet = null;
        if (!(bean instanceof ParcelamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        originalBean = ((ParcelamentoBean)bean).getTituloOriginal();
        if (originalBean == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Parcelamento. N\u00e3o h\u00e1 t\u00edtulo Original.", null);
            return;
        }
        parcelasSet = ((ParcelamentoBean)bean).getParcelas();
        if (parcelasSet != null) {
            if (parcelasSet.size() <= 0) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Parcelamento. N\u00e3o h\u00e1 Parcelas.", null);
                return;
            }
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Parcelamento. N\u00e3o h\u00e1 Parcelas.", null);
            return;
        }
        originalBean = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(originalBean, originalBean.getCodigo(), filial, filiais, true);
        for (ReceberPagarBean aux : parcelasSet) {
            aux.setDataHora(new Date());
            if (!aux.isRemover()) {
                if (aux.isAlterar() && !aux.isInserir()) {
                    aux = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(aux, aux.getCodigo(), filial, filiais, true);
                    continue;
                }
                if (!aux.isAlterar() && !aux.isInserir()) continue;
                new ReceberPagarService().gravaAutoCopiaSemCommit(aux, 0, filial, filiais);
                ReceberPagarRPBean recPagRP = new ReceberPagarRPBean();
                recPagRP.setFilialOrigem(originalBean.getFilial());
                recPagRP.setReceberPagarOrigem((ReceberPagarVO)originalBean.toVO());
                recPagRP.setFilialDestino(aux.getFilial());
                recPagRP.setReceberPagarDestino((ReceberPagarVO)aux.toVO());
                recPagRP.setTipo("R");
                this.dao.insert(recPagRP, filial);
                continue;
            }
            if (!aux.isRemover() || aux.isInserir()) continue;
            aux.setSituacao("C");
            aux.setObservacao(aux.getObservacao() + " - Cancelado por remo\u00e7\u00e3o do parcelamento.");
            aux = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(aux, aux.getCodigo(), filial, filiais, true);
        }
        Conexao.arquivaSQL();
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public void delete(AbstractThreadBean bean, String filial, String filiais) throws Exception {
        ReceberPagarBean originalBean = null;
        Set<ReceberPagarBean> parcelamentoSet = null;
        if (!(bean instanceof ParcelamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        originalBean = ((ParcelamentoBean)bean).getTituloOriginal();
        if (originalBean == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer Parcelamento. N\u00e3o h\u00e1 t\u00edtulo Original.", null);
            return;
        }
        parcelamentoSet = ((ParcelamentoBean)bean).getParcelas();
        if (parcelamentoSet != null) {
            if (parcelamentoSet.size() <= 0) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel desfazer Parcelamento. N\u00e3o h\u00e1 Parcelas.", null);
                return;
            }
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Parcelamento. N\u00e3o h\u00e1 Parcelas.", null);
            return;
        }
        originalBean.setSituacao("A");
        originalBean.setObservacao("");
        new ReceberPagarService().update(originalBean, originalBean.getCodigo(), filial, filiais);
        for (ReceberPagarBean aux : parcelamentoSet) {
            aux.setSituacao("C");
            aux.setObservacao(aux.getObservacao() == null ? "" : aux.getObservacao() + " - Parcela cancelada por Canc. do Parcelamento.");
            new ReceberPagarService().gravaAutoCopiaSemCommit(aux, 1, filial, filiais);
        }
        Conexao.arquivaSQL();
    }
}

