/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import br.com.thread.pdfbox.pdmodel.PDDocument;
import jalis.comum.Conexao;
import jalis.comum.ConexaoEmail;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.CancelamentoException;
import jalis.laboratorio.financeiro.faturamento.integracao.SistemaEmissaoNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.IntegracaoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.RespostaEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.StatusNota;
import jalis.laboratorio.financeiro.faturamento.integracao.tecnospeed.IntegracaoTecnospeed;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.financeiro.util.Impostos;
import jalis.laboratorio.recepcao.util.SolicitarMotivoCancelamento;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.convenio.ConvenioBean;
import jalis.model.bean.estoque.ConferenciaEntradaBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.NotaFiscalLanctoEstoqueBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.FaturaReceberPagarBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalComposicaoBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarCentroCustoBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.bean.recepcao.PacienteBean;
import jalis.model.dao.cadastro.auxiliares.FilialDao;
import jalis.model.dao.financeiro.NotaFiscalDao;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioEntidadeBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.relatorio.Gerador;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.ConvenioEntidadeService;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.NotaFiscalLanctoEstoqueService;
import jalis.service.estoque.NotaFiscalMaterialService;
import jalis.service.financeiro.BaixaService;
import jalis.service.financeiro.DadosEmail;
import jalis.service.financeiro.FaturaNotaFiscalService;
import jalis.service.financeiro.FaturaReceberPagarService;
import jalis.service.financeiro.FaturaService;
import jalis.service.financeiro.NotaFiscalComposicaoService;
import jalis.service.financeiro.NotaFiscalServicoService;
import jalis.service.financeiro.ObjetoImpostoAcumulado;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.impressao.matricial.ImpressaoRelatorio;
import jalis.util.impressao.matricial.Relatorio;
import jalis.util.logger.ErrorLogger;
import java.awt.print.PrinterAbortException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class NotaFiscalService
extends AbstractThreadService {
    private final long ACESSO_ALTERAR_PLANOCONTAS = Long.parseLong("0600400505");
    private final long ACESSO_ALTERAR_CENTROSCUSTO = Long.parseLong("0600400506");
    private LancamentoEstoqueService serviceLanctoEstoque = new LancamentoEstoqueService();
    private MaterialLoteService serviceMaterialLote = new MaterialLoteService();
    private MaterialService materialService = new MaterialService();
    public static final SistemaEmissaoNFSe sistemaEmissaoNFSe = Laboratorio.sistemaEmissorNFSe;
    private final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    public NotaFiscalService() {
        this.dao = new NotaFiscalDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof NotaFiscalBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        ArrayList<NotaFiscalMaterialBean> materiais = ((NotaFiscalBean)bean).getMateriais();
        if (materiais != null) {
            NotaFiscalMaterialService servicoMaterial = new NotaFiscalMaterialService();
            for (int i = 0; i < materiais.size(); ++i) {
                NotaFiscalMaterialBean material = materiais.get(i);
                servicoMaterial.delete(material, 2, filial, filiais);
            }
        }
        this.removerServicosNota(filial, ((NotaFiscalBean)bean).getCodigo().toString());
        this.dao.delete(bean, filial);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((NotaFiscalDao)this.dao).getBean(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((NotaFiscalDao)this.dao).getVOCodigo(filial, codigo);
    }

    public AbstractThreadBean getVO(String filial, String serie, String numero) throws Exception {
        return ((NotaFiscalDao)this.dao).getVO(filial, serie, numero);
    }

    public AbstractThreadBean getNotaEntradaFornecedorBean(String filial, String serie, String numero, String codigoFornecedor) throws Exception {
        return ((NotaFiscalDao)this.dao).getNotaEntradaFornecedorBean(filial, serie, numero, codigoFornecedor);
    }

    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais, String[] faturas, boolean[] conferidas) throws Exception {
        StringBuilder buf = new StringBuilder();
        if (conferidas != null && faturas != null) {
            for (int i = 0; i < conferidas.length; ++i) {
                if (conferidas[i]) continue;
                buf.setLength(0);
                buf.append(" update fatura ");
                buf.append("    set usr_codconferencia = '").append(Variaveis.login).append("' ");
                buf.append("       ,fat_dtconferencia = current_timestamp ");
                buf.append("  where fil_codigo = ").append(filial);
                buf.append("    and fat_codigo = ").append(faturas[i]);
                Conexao.executeUpdate(filial, Conexao.getStatement(), buf.toString());
            }
        }
        this.insert(bean, codigo, filial, filiais);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        ArrayList<NotaFiscalVO> composicaoList;
        Set<FaturaNotaFiscalBean> faturasNotaFiscal;
        Set parcelas;
        ArrayList<NotaFiscalMaterialBean> listaMateriais;
        if (!(bean instanceof NotaFiscalBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        if (codigo == null) {
            ((NotaFiscalBean)bean).setCodigo(this.dao.getProximoCodigo(bean));
        } else {
            ((NotaFiscalBean)bean).setCodigo((Integer)codigo);
        }
        if (null != Laboratorio.sistemaEmissorNFSe && Laboratorio.sistemaEmissorNFSe.equals((Object)SistemaEmissaoNFSe.TECNOSPEED) && !((NotaFiscalBean)bean).getSerie().getSolicitarRps().booleanValue() && (((NotaFiscalBean)bean).getNumeroRps() == null || ((NotaFiscalBean)bean).getNumeroRps() == 0L)) {
            ((NotaFiscalBean)bean).setNumeroRps(NotaFiscalService.getNumeroRPSComLock((NotaFiscalBean)bean));
        }
        this.dao.insert(bean, filial);
        FaturaNotaFiscalService servicoFaturaNF = new FaturaNotaFiscalService();
        NotaFiscalServicoService servicoService = new NotaFiscalServicoService();
        NotaFiscalMaterialService serviceMateriais = new NotaFiscalMaterialService();
        NotaFiscalComposicaoService notaFiscalComposicaoService = new NotaFiscalComposicaoService();
        ReceberPagarService serviceRecPag = new ReceberPagarService();
        int numeroUltimaParcelaNF = -1;
        NotaFiscalServicoBean notaServico = ((NotaFiscalBean)bean).getServico();
        if (notaServico != null) {
            notaServico.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
            notaServico.setServico(((NotaFiscalBean)bean).getServico().getServico());
            servicoService.insert(notaServico, null, filial, filiais);
        }
        if ((listaMateriais = ((NotaFiscalBean)bean).getMateriais()) != null) {
            MaterialService serviceMaterial = new MaterialService();
            Double quantidade = 0.0;
            for (NotaFiscalMaterialBean material : listaMateriais) {
                quantidade = quantidade + material.getQuantidade();
            }
            for (NotaFiscalMaterialBean material : listaMateriais) {
                material.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
                LancamentoEstoqueBean lanctoEstoqueBean = serviceMateriais.insertRetornaLancamento(material, null, filial, filiais);
                LancamentoEstoqueVO lanctoEstoqueVO = lanctoEstoqueBean != null ? (LancamentoEstoqueVO)lanctoEstoqueBean.toVO() : null;
                if (lanctoEstoqueVO == null || !ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) continue;
                Object matLoteAux = null;
                Double valorFrete = ((NotaFiscalBean)bean).getValorFrete();
                if (valorFrete > 0.0) {
                    valorFrete = valorFrete / quantidade;
                }
                for (int j = 0; j < ((NotaFiscalBean)bean).getMateriaisAlterados().size(); ++j) {
                    if (((NotaFiscalBean)bean).getMateriaisAlterados().get(j).getCodigo().intValue() != material.getMaterial().getCodigo().intValue()) continue;
                    matLoteAux = ((NotaFiscalBean)bean).getMateriaisAlterados().get(j);
                    Integer codigoNFI = ((NotaFiscalBean)bean).getCodigo();
                    ((MaterialBean)matLoteAux).setCodigoUltimaCompraNfi(codigoNFI);
                    ((MaterialBean)matLoteAux).setCalculoRateioFreteUltimaCompra(valorFrete);
                    if (matLoteAux == null || ((MaterialBean)matLoteAux).getLotes() == null) continue;
                    for (int l = 0; l < ((MaterialBean)matLoteAux).getLotes().size(); ++l) {
                        MaterialLoteBean lote = ((MaterialBean)matLoteAux).getLotes().get(l);
                        if (lote.getRemovido().booleanValue()) continue;
                        serviceMaterial.gerarMaterialLoteLancEstoque(((MaterialBean)matLoteAux).getFilial(), lanctoEstoqueVO, lote);
                    }
                }
                serviceMaterial.gravaAutoCopiaSemCommit((AbstractThreadBean)matLoteAux, 1, filial, null);
            }
        }
        if ((parcelas = ((NotaFiscalBean)bean).getParcelas()) != null && !((NotaFiscalBean)bean).getTipo().equalsIgnoreCase("F")) {
            for (ReceberPagarBean parcela : parcelas) {
                parcela.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
                parcela.setOrigem("N");
                if (NotaFiscalService.isGerarNotaFiscalEletronica(((NotaFiscalBean)bean).getSerie()) && !((NotaFiscalBean)bean).getTipo().equals("E")) {
                    parcela.setSituacao("P");
                } else {
                    parcela.setSituacao("A");
                }
                parcela.setCodigo(new ReceberPagarDao().getProximoCodigo(parcela));
                parcela.setTipoCadastro(((NotaFiscalBean)bean).getTipoCadastro());
                if (((NotaFiscalBean)bean).getEntidade() != null) {
                    parcela.setEntidade(((NotaFiscalBean)bean).getEntidade());
                } else if (((NotaFiscalBean)bean).getConvenio() != null) {
                    parcela.setConvenio(((NotaFiscalBean)bean).getConvenio());
                } else if (((NotaFiscalBean)bean).getPaciente() != null) {
                    parcela.setPaciente(((NotaFiscalBean)bean).getPaciente());
                }
                if (NotaFiscalService.isGerarNotaFiscalEletronica(((NotaFiscalBean)bean).getSerie()) && !((NotaFiscalBean)bean).getTipo().equals("E")) {
                    parcela.setObservacao("Parcela nr " + parcela.getParcela() + " referente a nota fiscal RPS = " + ((NotaFiscalBean)bean).getNumeroRps());
                } else {
                    parcela.setObservacao("Parcela nr " + parcela.getParcela() + " referente a nota fiscal n\u00famero " + ((NotaFiscalBean)bean).getNumero().toString());
                }
                if (Funcoes.textoVazio(parcela.getNumeroDocumento())) {
                    if (((NotaFiscalBean)bean).getNumeroRps() != null) {
                        parcela.setNumeroDocumento(((NotaFiscalBean)bean).getNumeroRps() == null ? null : ((NotaFiscalBean)bean).getNumeroRps().toString());
                    } else {
                        parcela.setNumeroDocumento(((NotaFiscalBean)bean).getNumero() == null ? null : ((NotaFiscalBean)bean).getNumero().toString());
                    }
                }
                parcela.setSerie(((NotaFiscalBean)bean).getSerie());
                if (parcela.getParcela() > numeroUltimaParcelaNF) {
                    numeroUltimaParcelaNF = parcela.getParcela();
                }
                serviceRecPag.insert(parcela, null, filial, filiais);
            }
        }
        if ((faturasNotaFiscal = ((NotaFiscalBean)bean).getFaturasNotaFiscal()) != null) {
            for (FaturaNotaFiscalBean fatNF : faturasNotaFiscal) {
                ArrayList<ReceberPagarVO> listaPreviasFaturamento = null;
                try {
                    listaPreviasFaturamento = new FaturaReceberPagarService().getListaPreviasFaturamento(Variaveis.filialPadrao, fatNF.getFatura().getCodigo().toString());
                }
                catch (ThreadDaoException e) {
                    throw new Exception("N\u00e3o foi poss\u00edvel carregar lista de pr\u00e9vias de recebimento do faturamento.\n" + e.getMessage());
                }
                Date dataCancelamento = new Date();
                if (listaPreviasFaturamento != null) {
                    for (ReceberPagarVO recVo : listaPreviasFaturamento) {
                        serviceRecPag.cancelarReceberPagar(recVo.getFilial().getCodigo().toString(), recVo.getCodigo().toString(), dataCancelamento, Variaveis.login);
                    }
                }
                if (fatNF.getListaPrevias() != null) {
                    FaturaReceberPagarService serviceFaturaRecPag = new FaturaReceberPagarService();
                    for (ReceberPagarBean aux : fatNF.getListaPrevias()) {
                        serviceRecPag.gravaAutoCopiaSemCommit(aux, 0, Variaveis.filialPadrao, null);
                        FaturaReceberPagarBean fatRecPagBean = new FaturaReceberPagarBean();
                        fatRecPagBean.setFilial(fatNF.getFilial());
                        fatRecPagBean.setFatura(fatNF.getFatura());
                        fatRecPagBean.setReceberPagar((ReceberPagarVO)aux.toVO());
                        fatRecPagBean.setTipo("F");
                        serviceFaturaRecPag.insert(fatRecPagBean, null, Variaveis.filialPadrao, null);
                    }
                }
                fatNF.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
                if (fatNF.getValorFatura() == 0.0) {
                    fatNF.setValorFatura(new FaturaService().getValorRestanteFatura(fatNF.getFatura().getFilial().getCodigo().toString(), fatNF.getFatura().getCodigo().toString()).doubleValue());
                }
                servicoFaturaNF.insert(fatNF, null, filial, filiais);
            }
        }
        if ((((NotaFiscalBean)bean).getTipo().equalsIgnoreCase("S") || ((NotaFiscalBean)bean).getTipo().equalsIgnoreCase("F")) && (composicaoList = new NotaFiscalService().getComposicaoImpostosNota((NotaFiscalBean)bean)) != null && composicaoList.size() > 0) {
            NotaFiscalComposicaoBean composicaoBean = new NotaFiscalComposicaoBean();
            composicaoBean.setFilial(((NotaFiscalBean)bean).getFilial());
            composicaoBean.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
            composicaoBean.setNotasFiscaisComposicao(composicaoList);
            notaFiscalComposicaoService.insert(composicaoBean, filial);
        }
        this.gerarComissao((NotaFiscalBean)bean, faturasNotaFiscal, parcelas, numeroUltimaParcelaNF);
        if (((NotaFiscalBean)bean).getTipo().equalsIgnoreCase("S")) {
            this.gerarComissaoFaturas(faturasNotaFiscal, ((NotaFiscalBean)bean).getConvenio().getCodigo().toString());
        }
        if (((NotaFiscalBean)bean).getTipo().equalsIgnoreCase("F")) {
            this.gerarNotaFiscalPessoaFisica(filial, (NotaFiscalBean)bean);
        }
    }

    public String gerarNotaFiscalEletronica(NotaFiscalBean notaBean, String filial) throws Exception {
        String idExterno = "";
        if (notaBean.getTipo().equalsIgnoreCase("S") || notaBean.getTipo().equalsIgnoreCase("F") && NotaFiscalService.isGerarNotaFiscalEletronica(notaBean.getSerie())) {
            if (sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS) {
                idExterno = this.enviarNotaFiscalENotas(notaBean);
            }
            notaBean.clearCamposAlterados();
        }
        return idExterno;
    }

    private boolean enviarNotaFiscalTecnoSpeed(NotaFiscalBean notaBean) throws Exception {
        notaBean.setSituacao("X");
        notaBean.setNotaEnviada(true);
        Conexao.arquivaSQL();
        IntegracaoTecnospeed eletronico = new IntegracaoTecnospeed();
        return eletronico.enviaNotaFiscalEletronica(notaBean, false);
    }

    private String enviarNotaFiscalENotas(NotaFiscalBean notaBean) {
        new IntegracaoEnotas(notaBean).enviarNotaFiscalEletronica();
        return notaBean.getChaveNfse();
    }

    public boolean consultarNotaFiscal(NotaFiscalBean notaBean) {
        IntegracaoTecnospeed eletronica = new IntegracaoTecnospeed();
        try {
            boolean isOk = eletronica.consultarNotaFiscalEletronica(notaBean);
            return isOk;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel realizar a consulta da nota.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    public static boolean isGerarNotaFiscalEletronica(SeriesVO serie) {
        return serie != null && SeriesService.podeGerarNotaFiscalEletronica(serie.getFilial().getCodigo(), serie.getCodigo()) && (sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS || !Funcoes.textoVazio(ParametrosGerais.getIpWsNfse()) && !Funcoes.textoVazio(ParametrosGerais.getPortaWsNfse()));
    }

    public void imprimirNFSe(NotaFiscalBean bean) {
        if (bean == null) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select nfi_pdfrps from notafiscal ");
        buf.append("where fil_codigo = ").append(bean.getFilial().getCodigo());
        buf.append("  and nfi_codigo = ").append(bean.getCodigo());
        try {
            byte[] bytePdf;
            block23: {
                ResultSet rs = st.executeQuery(buf.toString());
                bytePdf = null;
                while (rs.next()) {
                    if (rs.getLong("nfi_pdfrps") > 0L) {
                        long oid = rs.getLong("nfi_pdfrps");
                        LargeObjectManager lobj = ((PGConnection)st.getConnection()).getLargeObjectAPI();
                        LargeObject obj = lobj.open(oid, 262144);
                        bytePdf = new byte[obj.size()];
                        obj.read(bytePdf, 0, obj.size());
                        obj.close();
                        continue;
                    }
                    if (sistemaEmissaoNFSe.equals((Object)SistemaEmissaoNFSe.ENOTAS)) continue;
                    st.close();
                    Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel gerar a impress\u00e3o da nota fiscal. ", 5);
                    return;
                }
                if (sistemaEmissaoNFSe.equals((Object)SistemaEmissaoNFSe.ENOTAS)) {
                    try (PDDocument document = PDDocument.load((InputStream)new ByteArrayInputStream(bytePdf));){
                        this.debug("PDF da nota valido");
                    }
                    catch (Exception e) {
                        this.debug("PDF da nota invalido");
                        IntegracaoEnotas integracao = new IntegracaoEnotas(bean);
                        for (int i = 0; i < 10 && (bytePdf = integracao.baixarPdf()) == null; ++i) {
                        }
                        if (bytePdf != null) break block23;
                        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel gerar a impress\u00e3o da nota fiscal.\n Falha na consulta externa ", 5);
                        return;
                    }
                }
            }
            String impressora = Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraNotaFiscal"));
            if (bytePdf != null) {
                Funcoes.imprimirPDF(bytePdf, impressora);
            }
            st.close();
        }
        catch (PrinterAbortException rs) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean enviarEmailNFSe(final NotaFiscalBean bean) {
        ArrayList<String> listaEmails;
        String email;
        boolean isConvenio;
        ConvenioBean convenio = null;
        PacienteBean paciente = null;
        boolean bl = isConvenio = bean.getConvenio() != null;
        if (!isConvenio) {
            try {
                paciente = (PacienteBean)new PacienteService().get(bean.getPaciente().getFilial().getCodigo().toString(), bean.getPaciente().getCodigo().toString());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados do paciente.\n" + e.getMessage(), e.getStackTrace());
            }
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fil_codigo", bean.getFilial().getCodigo());
            map.put("con_codigo", bean.getConvenio().getCodigo());
            try {
                convenio = (ConvenioBean)new ConvenioService().getBean(map);
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados do conv\u00eanio.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        FilialBean filialBean = null;
        try {
            filialBean = (FilialBean)new FilialService().get(bean.getFilial().getCodigo().toString());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados da filial.\n" + e.getMessage(), e.getStackTrace());
        }
        boolean enviarEmailNFSe = filialBean != null ? filialBean.getEmailNFSe() : false;
        final DadosEmail dados = NotaFiscalService.getDadosEmailPreenchido(bean);
        if (dados == null || !dados.isEnviar()) {
            return false;
        }
        String string = isConvenio ? convenio.getEmail1() : (email = paciente != null && paciente.getEmail() != null ? paciente.getEmail() : "");
        if (!Funcoes.textoVazio(email)) {
            listaEmails = StringUtil.explode(email, ";, ");
            if (listaEmails == null) {
                return false;
            }
        } else {
            return false;
        }
        final String emailFinal = listaEmails.get(0);
        HashMap<String, Object> valores = new HashMap<String, Object>();
        valores.put("numeronotafiscal", dados.getNumeroNfse());
        valores.put("codigoverificacaonfse", dados.getCodigoVerificacaoNfse());
        valores.put("cnpjprestador", dados.getCnpjPrestador());
        final String mensagemEmail = EmailUtil.parseEmail(dados.getMensagem(), valores);
        if (enviarEmailNFSe && !Funcoes.textoVazio(email)) {
            new Thread(){

                @Override
                public void run() {
                    EmailUtil.enviaEmail(NotaFiscalService.getXMLConfiguracaoEnvio(bean.getFilial().getCodigo()), emailFinal, mensagemEmail, dados.getAssunto(), dados.getPdf(), dados.getXml() != null ? dados.getXml() : dados.getZip(), null, dados.getZip() != null);
                }
            }.start();
        }
        return true;
    }

    private static DadosEmail getDadosEmailPreenchido(NotaFiscalBean bean) {
        NotaFiscalBean notaBean = bean;
        Object mesg = null;
        DadosEmail dados = new DadosEmail();
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_fraseemailnfse as mensagem ");
        buf.append("\t     ,COALESCE(fil_enviaremail, false) AND COALESCE(fil_emailnfse, false) as enviar ");
        buf.append("       ,fil_assuntoemailnfse as assunto ");
        buf.append("       ,fil_cnpj as cnpj ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  where fil_codigo = ? ");
        PreparedStatement prepEmail = Conexao.getPreparedStatement(buf.toString());
        try {
            prepEmail.setInt(1, notaBean.getFilial().getCodigo());
            ResultSet rs = prepEmail.executeQuery();
            if (rs.next()) {
                dados.setMensagem(rs.getString("mensagem"));
                dados.setAssunto(rs.getString("assunto"));
                dados.setEnviar(rs.getBoolean("enviar"));
                dados.setCnpjPrestador(rs.getString("cnpj"));
            }
            prepEmail.close();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os dados de email.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        dados.setNumeroNfse(bean.getNumero().toString());
        dados.setCodigoVerificacaoNfse(bean.getProtocoloNfse());
        if (dados == null || !dados.isEnviar()) {
            return dados;
        }
        buf.delete(0, buf.length());
        buf.append("select nfi_xmlnfse as xml ");
        buf.append("\t,nfi_pdfrps as pdf ");
        buf.append("from notafiscal ");
        buf.append("where fil_codigo = ?");
        buf.append("  and nfi_codigo = ?");
        PreparedStatement prepNota = Conexao.getPreparedStatement(buf.toString());
        try {
            prepNota.setInt(1, notaBean.getFilial().getCodigo());
            prepNota.setInt(2, notaBean.getCodigo());
            ResultSet rsNota = prepNota.executeQuery();
            if (rsNota.next()) {
                long pdfLong = rsNota.getLong("pdf");
                long xmlLong = rsNota.getLong("xml");
                byte[] bytePdf = null;
                byte[] byteXml = null;
                if (pdfLong > 0L && xmlLong > 0L) {
                    LargeObjectManager lobj = ((PGConnection)prepNota.getConnection()).getLargeObjectAPI();
                    LargeObject objPdf = lobj.open(pdfLong, 262144);
                    bytePdf = new byte[objPdf.size()];
                    objPdf.read(bytePdf, 0, objPdf.size());
                    objPdf.close();
                    LargeObject objXml = lobj.open(xmlLong, 262144);
                    byteXml = new byte[objXml.size()];
                    objXml.read(byteXml, 0, objXml.size());
                    objXml.close();
                }
                dados.setPdf(bytePdf);
                if (Laboratorio.sistemaEmissorNFSe == SistemaEmissaoNFSe.TECNOSPEED) {
                    dados.setZip(byteXml);
                } else {
                    dados.setXml(byteXml);
                }
            }
            prepNota.close();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os dados de email da nota fiscal.\n" + e.getMessage(), e.getStackTrace());
        }
        return dados;
    }

    private static String getXMLConfiguracaoEnvio(Integer codigoFilial) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fil_configuracaoemail as xml ");
        buf.append("   from filiais_postocoleta ");
        buf.append("  where fil_codigo = ").append(codigoFilial);
        try {
            ResultSet rs = ConexaoEmail.executeQuery(ConexaoEmail.getStatement(), buf.toString());
            if (rs.next()) {
                return rs.getString("xml");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o XML de envio de e-mail.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        return null;
    }

    private void gerarNotaFiscalPessoaFisica(String filial, NotaFiscalBean notaFiscal) throws Exception {
        boolean isNotaFiscalEletronicaAtivada = this.haNotaFiscalEletronicaGerada(filial) && NotaFiscalService.isGerarNotaFiscalEletronica(notaFiscal.getSerie());
        BaixaService baixaService = new BaixaService();
        ReceberPagarService recPagService = new ReceberPagarService();
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(filial));
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setFilial(filialVO);
        usuarioVO.setCodigo(Variaveis.login);
        HashSet<ReceberPagarBean> titulos = new HashSet<ReceberPagarBean>();
        int i = 1;
        ReceberPagarBean recPag = new ReceberPagarBean();
        recPag.setFilial(filialVO);
        String descMensagem = String.format("GERADO PELA NOTA FISCAL DE %s - C\u00d3D.:", notaFiscal.getTipoCadastro().equals("E") ? "EMPRESA" : "PESSOA F\u00cdSICA");
        if (isNotaFiscalEletronicaAtivada) {
            if (notaFiscal.getNumeroRps() != null) {
                recPag.setNumeroDocumento(notaFiscal.getNumeroRps().toString());
                recPag.setCodigoDocumento(notaFiscal.getNumeroRps().toString());
                recPag.setObservacao(descMensagem + notaFiscal.getCodigo() + ", RPS.: " + notaFiscal.getNumeroRps());
            } else {
                recPag.setObservacao(descMensagem + notaFiscal.getCodigo());
            }
        } else if (notaFiscal.getNumero() != null) {
            recPag.setNumeroDocumento(notaFiscal.getNumero().toString());
            recPag.setCodigoDocumento(notaFiscal.getNumero().toString());
            recPag.setObservacao(descMensagem + notaFiscal.getCodigo() + ", N\u00daM.: " + notaFiscal.getNumero());
        } else {
            recPag.setObservacao(descMensagem + notaFiscal.getCodigo());
        }
        recPag.setDataCompetencia(notaFiscal.getDataEmissao());
        recPag.setDataDocumento(notaFiscal.getDataEmissao());
        recPag.setDataVencimento(notaFiscal.getDataEmissao());
        recPag.setDataHora(new Date());
        recPag.setDataProcessamento(new Date());
        recPag.setTipoCadastro("P");
        recPag.setPaciente(notaFiscal.getPaciente());
        recPag.setInserir(true);
        recPag.setNotaFiscal((NotaFiscalVO)notaFiscal.toVO());
        if (isNotaFiscalEletronicaAtivada) {
            recPag.setSituacao("P");
        } else {
            recPag.setSituacao("Q");
        }
        recPag.setOrigem("N");
        recPag.setParcela(i++);
        recPag.setSerie(notaFiscal.getSerie());
        recPag.setTipo("R");
        recPag.setTipoDocumento("C");
        recPag.setUsuario(usuarioVO);
        recPag.setValor(notaFiscal.getSubTotal());
        recPag.setCofinsValor(notaFiscal.getCofinsValor());
        recPag.setCsllValor(notaFiscal.getCsllValor());
        recPag.setInssValor(notaFiscal.getInssValor());
        recPag.setIrrfValor(notaFiscal.getIrrfValor());
        recPag.setIssValor(notaFiscal.getIssValor());
        recPag.setPisValor(notaFiscal.getPisValor());
        recPag.setIssRetidoValor(notaFiscal.getValorISSRetido());
        recPag.setCofinsPercentual(notaFiscal.getCofinsPercentual());
        recPag.setCsllPercentual(notaFiscal.getCsllPercentual());
        recPag.setInssPercentual(notaFiscal.getInssPercentual());
        recPag.setIrrfPercentual(notaFiscal.getIrrfPercentual());
        recPag.setIssPercentual(notaFiscal.getIssPercentual());
        recPag.setPisPercentual(notaFiscal.getPisPercentual());
        recPag.setIssRetidoPercentual(notaFiscal.getPercentualISSRetido());
        recPag.setValorTotal((double)notaFiscal.getValor());
        recPag = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)recPag, new PanelPlanoContaCentroCusto(null, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, recPag.getFilial().getCodigo().toString()), 2, null);
        recPagService.gravaAutoCopiaSemCommit(recPag, 0, filial, null);
        titulos.add(recPag);
        BaixaBean baixa = new BaixaBean();
        baixa.setDataHora(new Date());
        baixa.setFilial(filialVO);
        baixa.setFormasPagamento(notaFiscal.getLancamentosRequisicao());
        baixa.setQuantidadeTitulos(i - 1);
        if (!isNotaFiscalEletronicaAtivada) {
            baixa.setSituacao("Q");
        } else {
            baixa.setSituacao("P");
        }
        baixa.setSubTotal(notaFiscal.getValor());
        baixa.setTipo("C");
        baixa.setTitulos(titulos);
        baixa.setUsuario(usuarioVO);
        baixa.setValorPago(notaFiscal.getValor());
        baixa.setValorTotal(notaFiscal.getValor());
        baixaService.gravaAutoCopiaSemCommit(baixa, 0, filial, null);
    }

    private void gerarComissaoFaturas(Set<FaturaNotaFiscalBean> listaFaturas, String codigoConvenio) throws Exception {
        if (listaFaturas == null || codigoConvenio == null) {
            return;
        }
        ReceberPagarService service = new ReceberPagarService();
        FaturaService serviceFatura = new FaturaService();
        FaturaReceberPagarService serviceFaturaRecPag = new FaturaReceberPagarService();
        for (FaturaNotaFiscalBean fatNota : listaFaturas) {
            Set<ConvenioEntidadeBean> listaConvenioEntidade = new ConvenioEntidadeService().getRepresentantesConvenio(Variaveis.filialPadrao, codigoConvenio);
            if (listaConvenioEntidade == null) continue;
            Iterator<ConvenioEntidadeBean> it = listaConvenioEntidade.iterator();
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            FaturaBean fatura = (FaturaBean)serviceFatura.get(Variaveis.filialPadrao, fatNota.getFatura().getCodigo().toString());
            FilialVO filial = new FilialVO();
            filial = (FilialVO)new FilialDao().getVO(Variaveis.filialPadrao);
            SeriesVO serie = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serie"));
            if (serie == null) {
                throw new Exception("S\u00e9rie padr\u00e3o n\u00e3o configurada para a esta\u00e7\u00e3o.");
            }
            while (it.hasNext()) {
                ConvenioEntidadeBean convenioEntidade = it.next();
                if (!convenioEntidade.getTipoParcela().equalsIgnoreCase("C") || fatura.getComissaoGerada()) continue;
                fatura.setCodigoUsuarioComissao(usuario);
                fatura.setDataComissao(new Date());
                serviceFatura.gravaAutoCopiaSemCommit(fatura, 1, Variaveis.filialPadrao, null);
                if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("E") || convenioEntidade.getTipoPagamento().equalsIgnoreCase("V")) {
                    ReceberPagarBean recpag = this.getReceberPagarBasicoComissao(null);
                    recpag.setFilial(filial);
                    recpag.setUsuario(usuario);
                    recpag.setSerie(serie);
                    recpag.setEntidade(convenioEntidade.getEntidade());
                    recpag.setValor(new BigDecimal(fatura.getValorTotalExames() + fatura.getValorTotalMateriais() + fatura.getValorAdicional() + fatura.getValorDespCobranca() - (fatura.getValorTotalMateriais() + fatura.getValorTotalExames()) * fatura.getPercentualDesconto() / 100.0 * convenioEntidade.getPercentualComissao() / 100.0).setScale(2, RoundingMode.HALF_UP).doubleValue());
                    recpag.setParcela(1);
                    recpag.setOrigem("C");
                    recpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - FATURA C\u00d3D.: " + fatura.getCodigo() + " - COMISS\u00c3O GERADA PELA CONFER\u00caNCIA DA FATURA.");
                    recpag = FinanceiroUtil.atualizaTotalSemRecalculo(recpag);
                    if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("E")) {
                        recpag.setDataVencimento(fatura.getDataEmissao());
                        recpag.setDataCompetencia(fatura.getDataEmissao());
                        recpag.setDataDocumento(fatura.getDataEmissao());
                    } else if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("V")) {
                        recpag.setDataVencimento(fatura.getVencimento());
                        recpag.setDataCompetencia(fatura.getVencimento());
                        recpag.setDataDocumento(fatura.getVencimento());
                    }
                    service.gravaAutoCopiaSemCommit(recpag, 0, Variaveis.filialPadrao, null);
                    FaturaReceberPagarBean faturaRecPag = new FaturaReceberPagarBean();
                    faturaRecPag.setFilial(recpag.getFilial());
                    faturaRecPag.setFatura((FaturaVO)fatura.toVO());
                    faturaRecPag.setReceberPagar((ReceberPagarVO)recpag.toVO());
                    faturaRecPag.setTipo("C");
                    serviceFaturaRecPag.insert(faturaRecPag, null, Variaveis.filialPadrao, null);
                    continue;
                }
                Double valorComissao = new BigDecimal((fatura.getValorTotalExames() + fatura.getValorTotalMateriais() + fatura.getValorAdicional() + fatura.getValorDespCobranca() - (fatura.getValorTotalMateriais() + fatura.getValorTotalExames()) * fatura.getPercentualDesconto() / 100.0) * convenioEntidade.getPercentualComissao() / 100.0).setScale(2, RoundingMode.HALF_UP).doubleValue();
                Set parcelas = new FormaPagamentoParcelaService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and fpg_codigo = " + convenioEntidade.getFormaPagamento().getCodigo());
                Date dataInicial = null;
                if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("A")) {
                    dataInicial = fatura.getVencimento();
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(5, convenioEntidade.getDiaComissao());
                    calendar.add(2, 1);
                    dataInicial = calendar.getTime();
                }
                ArrayList<ReceberPagarBean> listaRecPag = FinanceiroUtil.gerarParcelas(valorComissao, valorComissao, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, dataInicial, "P", parcelas);
                for (int i = 0; i < listaRecPag.size(); ++i) {
                    ReceberPagarBean beanRecpag = listaRecPag.get(i);
                    beanRecpag = this.getReceberPagarBasicoComissao(beanRecpag);
                    beanRecpag.setFilial(filial);
                    beanRecpag.setUsuario(usuario);
                    beanRecpag.setSerie(serie);
                    beanRecpag.setEntidade(convenioEntidade.getEntidade());
                    beanRecpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - FATURA C\u00d3D.: " + fatura.getCodigo() + " - COMISS\u00c3O GERADA PELA CONFER\u00caNCIA DA FATURA.");
                    beanRecpag.setOrigem("C");
                    beanRecpag.setDataCompetencia(beanRecpag.getDataVencimento());
                    beanRecpag.setDataDocumento(beanRecpag.getDataVencimento());
                    service.gravaAutoCopiaSemCommit(beanRecpag, 0, Variaveis.filialPadrao, null);
                    FaturaReceberPagarBean faturaRecPag = new FaturaReceberPagarBean();
                    faturaRecPag.setFilial(beanRecpag.getFilial());
                    faturaRecPag.setFatura((FaturaVO)fatura.toVO());
                    faturaRecPag.setReceberPagar((ReceberPagarVO)beanRecpag.toVO());
                    faturaRecPag.setTipo("C");
                    serviceFaturaRecPag.insert(faturaRecPag, null, Variaveis.filialPadrao, null);
                }
            }
        }
    }

    private void gerarComissao(NotaFiscalBean beanNota, Set faturasNotaFiscal, Set parcelas, int numeroUltimaParcelaNF) throws Exception {
        Set<ConvenioEntidadeBean> listaConvenioEntidade;
        ReceberPagarService serviceRecPag = new ReceberPagarService();
        FaturaService serviceFatura = new FaturaService();
        if (beanNota.getConvenio() != null && beanNota.getTipo() != null && beanNota.getTipo().equalsIgnoreCase("S") && (listaConvenioEntidade = new ConvenioEntidadeService().getRepresentantesConvenio(Variaveis.filialPadrao, beanNota.getConvenio().getCodigo().toString())) != null) {
            Iterator<ConvenioEntidadeBean> it = listaConvenioEntidade.iterator();
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            while (it.hasNext()) {
                ConvenioEntidadeBean convenioEntidade = it.next();
                if (convenioEntidade.getTipoParcela() == null || !convenioEntidade.getTipoParcela().equalsIgnoreCase("F")) continue;
                if (faturasNotaFiscal != null) {
                    for (FaturaNotaFiscalBean fatRecPagBean : faturasNotaFiscal) {
                        FaturaBean faturaBean = (FaturaBean)serviceFatura.get(fatRecPagBean.getFilial().getCodigo().toString(), fatRecPagBean.getFatura().getCodigo().toString());
                    }
                }
                if (faturasNotaFiscal != null) {
                    for (FaturaNotaFiscalBean fatRecPagBean : faturasNotaFiscal) {
                        FaturaBean fat = (FaturaBean)serviceFatura.get(fatRecPagBean.getFilial().getCodigo().toString(), fatRecPagBean.getFatura().getCodigo().toString());
                        fat.setCodigoUsuarioComissao(usuario);
                        fat.setDataComissao(new Date());
                        serviceFatura.gravaAutoCopiaSemCommit(fat, 1, Variaveis.filialPadrao, null);
                    }
                }
                if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("M") || convenioEntidade.getTipoPagamento().equalsIgnoreCase("P") || convenioEntidade.getTipoPagamento().equalsIgnoreCase("U")) {
                    ReceberPagarBean recpag = this.getReceberPagarBasicoComissao(null);
                    recpag.setFilial(beanNota.getFilial());
                    recpag.setUsuario(usuario);
                    recpag.setSerie(beanNota.getSerie());
                    recpag.setEntidade(convenioEntidade.getEntidade());
                    recpag.setValor(new BigDecimal(beanNota.getValor().toString()).subtract(new BigDecimal(beanNota.getIssPercentual().toString())).setScale(4, RoundingMode.HALF_UP).multiply(new BigDecimal(convenioEntidade.getPercentualComissao())).divide(new BigDecimal(100.0).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP).doubleValue());
                    recpag.setParcela(1);
                    recpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - NOTA FISCAL C\u00d3D.: " + beanNota.getCodigo() + " - COMISS\u00c3O GERADA PELA GERA\u00c7\u00c3O DA NOTA FISCAL.");
                    recpag.setNotaFiscal((NotaFiscalVO)beanNota.toVO());
                    recpag.setOrigem("C");
                    recpag = FinanceiroUtil.atualizaTotalSemRecalculo(recpag);
                    if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("M")) {
                        recpag.setDataVencimento(beanNota.getDataEmissao());
                        recpag.setDataCompetencia(beanNota.getDataEmissao());
                        recpag.setDataDocumento(beanNota.getDataEmissao());
                    } else if ((convenioEntidade.getTipoPagamento().equalsIgnoreCase("P") || convenioEntidade.getTipoPagamento().equalsIgnoreCase("U")) && parcelas != null) {
                        Iterator itParc = parcelas.iterator();
                        ReceberPagarBean beanParcela = null;
                        while (itParc.hasNext()) {
                            ReceberPagarBean aux = (ReceberPagarBean)itParc.next();
                            if ((!convenioEntidade.getTipoPagamento().equalsIgnoreCase("P") || aux.getParcela() != 1) && (!convenioEntidade.getTipoPagamento().equalsIgnoreCase("U") || aux.getParcela() != numeroUltimaParcelaNF)) continue;
                            beanParcela = aux;
                            break;
                        }
                        if (beanParcela != null) {
                            recpag.setDataVencimento(beanParcela.getDataVencimento());
                            recpag.setDataCompetencia(beanParcela.getDataVencimento());
                            recpag.setDataDocumento(beanParcela.getDataVencimento());
                        }
                    }
                    serviceRecPag.gravaAutoCopiaSemCommit(recpag, 0, Variaveis.filialPadrao, null);
                    continue;
                }
                if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("S") || convenioEntidade.getTipoPagamento().equalsIgnoreCase("X")) {
                    Double valorComissao = new BigDecimal(beanNota.getValor()).setScale(4, RoundingMode.HALF_UP).multiply(new BigDecimal(convenioEntidade.getPercentualComissao())).divide(new BigDecimal(100.0).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP).doubleValue();
                    Set parcelamento = new FormaPagamentoParcelaService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and fpg_codigo = " + convenioEntidade.getFormaPagamento().getCodigo());
                    Date dataInicial = null;
                    if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("S")) {
                        dataInicial = beanNota.getDataEmissao();
                    } else {
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(5, convenioEntidade.getDiaComissao());
                        calendar.add(2, 1);
                        dataInicial = calendar.getTime();
                    }
                    ArrayList<ReceberPagarBean> listaRecPag = FinanceiroUtil.gerarParcelas(valorComissao, valorComissao, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, dataInicial, "P", parcelamento);
                    for (int i = 0; i < listaRecPag.size(); ++i) {
                        ReceberPagarBean beanRecpag = listaRecPag.get(i);
                        beanRecpag = this.getReceberPagarBasicoComissao(beanRecpag);
                        beanRecpag.setFilial(beanNota.getFilial());
                        beanRecpag.setUsuario(usuario);
                        beanRecpag.setSerie(beanNota.getSerie());
                        beanRecpag.setEntidade(convenioEntidade.getEntidade());
                        beanRecpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - PARCELA: " + beanRecpag.getParcela() + "  - NOTA FISCAL C\u00d3D.: " + beanNota.getCodigo());
                        beanRecpag.setDataDocumento(beanRecpag.getDataVencimento());
                        beanRecpag.setDataCompetencia(beanRecpag.getDataVencimento());
                        beanRecpag.setOrigem("C");
                        beanRecpag.setNotaFiscal((NotaFiscalVO)beanNota.toVO());
                        serviceRecPag.gravaAutoCopiaSemCommit(beanRecpag, 0, Variaveis.filialPadrao, null);
                    }
                    continue;
                }
                if (!convenioEntidade.getTipoPagamento().equalsIgnoreCase("F")) continue;
                ArrayList listaRecPag = new ArrayList(beanNota.getParcelas());
                Collections.sort(listaRecPag);
                for (int i = 0; i < listaRecPag.size(); ++i) {
                    ReceberPagarBean beanRecPag = (ReceberPagarBean)listaRecPag.get(i);
                    ReceberPagarBean recpag = this.getReceberPagarBasicoComissao(null);
                    recpag.setFilial(beanNota.getFilial());
                    recpag.setUsuario(usuario);
                    recpag.setSerie(beanNota.getSerie());
                    recpag.setEntidade(convenioEntidade.getEntidade());
                    recpag.setValor(new BigDecimal(beanRecPag.getValorTotal()).setScale(4, RoundingMode.HALF_UP).multiply(new BigDecimal(convenioEntidade.getPercentualComissao())).divide(new BigDecimal(100.0).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP).doubleValue());
                    recpag.setParcela(beanRecPag.getParcela());
                    recpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - PARCELA: " + recpag.getParcela() + "  - NOTA FISCAL C\u00d3D.: " + beanNota.getCodigo());
                    recpag.setOrigem("C");
                    recpag.setNotaFiscal((NotaFiscalVO)beanNota.toVO());
                    recpag = FinanceiroUtil.atualizaTotalSemRecalculo(recpag);
                    recpag.setDataVencimento(beanRecPag.getDataVencimento());
                    recpag.setDataCompetencia(recpag.getDataVencimento());
                    recpag.setDataDocumento(recpag.getDataVencimento());
                    serviceRecPag.gravaAutoCopiaSemCommit(recpag, 0, Variaveis.filialPadrao, null);
                }
            }
        }
    }

    private ReceberPagarBean getReceberPagarBasicoComissao(ReceberPagarBean recpag) {
        if (recpag == null) {
            recpag = new ReceberPagarBean();
        }
        recpag.setSituacao("A");
        recpag.setDataHora(new Date());
        recpag.setTipo("P");
        recpag.setTipoDocumento("D");
        recpag.setTipoJuro("V");
        recpag.setPercentualMulta(0.0);
        recpag.setPercentualDesconto(0.0);
        recpag.setPercentualAcrescimo(0.0);
        recpag.setIrrfPercentual(0.0);
        recpag.setIssPercentual(0.0);
        recpag.setPisPercentual(0.0);
        recpag.setCsllPercentual(0.0);
        recpag.setCofinsPercentual(0.0);
        recpag.setInssPercentual(0.0);
        recpag.setIssRetidoPercentual(0.0);
        recpag.setValorMulta(0.0);
        recpag.setValorAcrescimo(0.0);
        recpag.setTaxa(0.0);
        recpag.setIrrfValor(0.0);
        recpag.setIssValor(0.0);
        recpag.setPisValor(0.0);
        recpag.setCsllValor(0.0);
        recpag.setCofinsValor(0.0);
        recpag.setInssValor(0.0);
        recpag.setIssRetidoValor(0.0);
        recpag.setPercentualJuro(0.0);
        recpag.setValorJuro(0.0);
        recpag.setNumeroDocumento(null);
        recpag.setCodigoDocumento(null);
        recpag.setDataProcessamento(new Date());
        recpag.setTipoCadastro("R");
        recpag.setOrigem("C");
        return recpag;
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(NotaFiscalBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(NotaFiscalVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("serie", "S\u00e9rie", 0, "", 2, 75);
        tela.adicionaCampo("numero", "N\u00famero", 1, "", 3, 0);
        tela.adicionaCampo("dataEmissao", "Emiss\u00e3o", 2, "", 3, 0);
        tela.adicionaCampo("numeroRps", "RPS", 1, "", 3, 0);
        tela.adicionaCampo("valor", "Valor", 1, "", 3, 0);
        tela.setFiltroInicial("N\u00famero", 2);
        StringBuilder buf = new StringBuilder();
        buf.append(" fil_codigo = ").append(Variaveis.filialPadrao);
        tela.setFiltro(buf.toString());
        tela.setColunaOrdenacao("Emiss\u00e3o");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaNotaFiscalPessoaJuridica(Object owner, AbstractThreadVO bean, String titulo, String filial) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("serie", "S\u00e9rie", 0, "", 2, 75);
        tela.adicionaCampo("numero", "N\u00famero", 1, "", 3, 0);
        tela.adicionaCampo("dataEmissao", "Emiss\u00e3o", 2, "", 3, 0);
        tela.adicionaCampo("numeroRps", "RPS", 1, "", 3, 0);
        tela.adicionaCampo("valor", "Valor", 1, "", 3, 0);
        tela.setFiltroInicial("N\u00famero", 2);
        StringBuilder buf = new StringBuilder();
        buf.append(" fil_codigo = ").append(filial);
        buf.append(" and upper(nfi_tipo) = upper('").append("S").append("') ");
        tela.setFiltro(buf.toString());
        tela.setColunaOrdenacao("Emiss\u00e3o");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public Hashtable pesquisaNotaEntradaAutorizadaVO(Object owner, AbstractThreadVO bean, String titulo) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, titulo);
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct nfi.ser_codigo ");
            buf.append("       ,nfi.nfi_numero ");
            buf.append("       ,nfi.nfi_dataemissao ");
            buf.append("       ,ent.ent_fantasia ");
            buf.append("       ,nfi.nfi_valortotal ");
            buf.append("       ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("           from (select mat_descricao ");
            buf.append("                   from notafiscalmaterial nfmaux ");
            buf.append("                   join material mataux on nfmaux.fil_codigo = mataux.fil_codigo and nfmaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                  where nfmaux.fil_codigo = nfi.fil_codigo ");
            buf.append("                    and nfmaux.nfi_codigo = nfi.nfi_codigo ");
            buf.append("                  order by mat_descricao) as mataux) as materiais ");
            buf.append("   from notafiscal nfi ");
            buf.append("   join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo ");
            buf.append("   join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
            buf.append("   join material mat on nfm.fil_codigo = mat.fil_codigo and nfm.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.adicionaCampo("ser_codigo", "S\u00e9rie", 0, "", 2);
            p.adicionaCampo("nfi_numero", "N\u00famero", 1, "", 3);
            p.adicionaCampo("nfi_dataemissao", "Emiss\u00e3o", 2, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("nfi_valortotal", "Valor", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("N\u00famero", 2);
            String filtro = " nfi.fil_codigo = " + Variaveis.filialPadrao;
            filtro = filtro + " and nfi.nfi_situacao NOT IN ('C', 'E') ";
            filtro = filtro + " and nfi.usr_codautorizafinanceira IS NOT NULL and nfi.nfi_dataautorizafinanceira IS NOT NULL  and nfi.nfi_tipo = upper('E') ";
            p.setFiltro(filtro);
            p.setOrdem("Emiss\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public Hashtable pesquisaNotaEntradaAutorizadaNaoConferidaVO(Object owner, AbstractThreadVO bean, String titulo) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, titulo);
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct nfi.nfi_codigo ");
            buf.append("       ,nfi.ser_codigo ");
            buf.append("       ,nfi.nfi_numero ");
            buf.append("       ,nfi.nfi_dataemissao ");
            buf.append("       ,ent.ent_fantasia ");
            buf.append("       ,nfi.nfi_valortotal ");
            buf.append("       ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("           from (select mat_descricao ");
            buf.append("                   from notafiscalmaterial nfmaux ");
            buf.append("                   join material mataux on nfmaux.fil_codigo = mataux.fil_codigo and nfmaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                  where nfmaux.fil_codigo = nfi.fil_codigo ");
            buf.append("                    and nfmaux.nfi_codigo = nfi.nfi_codigo ");
            buf.append("                  order by mat_descricao) as mataux) as materiais ");
            buf.append("   from notafiscal nfi ");
            buf.append("   join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo ");
            buf.append("   join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
            buf.append("   join material mat on nfm.fil_codigo = mat.fil_codigo and nfm.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.adicionaCampo("nfi.nfi_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ser_codigo", "S\u00e9rie", 0, "", 2);
            p.adicionaCampo("nfi_numero", "N\u00famero", 1, "", 3);
            p.adicionaCampo("nfi_dataemissao", "Emiss\u00e3o", 2, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("nfi_valortotal", "Valor", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("N\u00famero", 2);
            String filtro = " nfi.fil_codigo = " + Variaveis.filialPadrao;
            filtro = filtro + " and nfi.nfi_situacao NOT IN ('C', 'E') ";
            filtro = filtro + " and nfi.usr_codautorizafinanceira IS NOT NULL and nfi.nfi_dataautorizafinanceira IS NOT NULL ";
            filtro = filtro + " and (nfi.fil_codigo, nfi.nfi_codigo) NOT IN (select cen.fil_codigo, cen.nfi_codigo from conferenciaentrada cen where cen.usr_codcancelamento IS NULL and cen.nfi_codigo is not null)  and nfi.nfi_tipo = upper('E') ";
            filtro = filtro + " and (select count(1) ";
            filtro = filtro + "        from notafiscallanctoestoque nle ";
            filtro = filtro + "        join lanctoestoque lce on nle.fil_codigo = lce.fil_codigo and nle.lce_codigo = lce.lce_codigo";
            filtro = filtro + "       where nle.fil_codigo = nfi.fil_codigo ";
            filtro = filtro + "         and nle.nfi_codigo = nfi.nfi_codigo ";
            filtro = filtro + "     ) = 0 ";
            p.setFiltro(filtro);
            p.setOrdem("Emiss\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public Hashtable pesquisaNotaEntradaVO(Object owner, AbstractThreadVO bean, String titulo) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, titulo);
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct nfi.nfi_codigo ");
            buf.append("       ,nfi.ser_codigo ");
            buf.append("       ,nfi.nfi_numero ");
            buf.append("       ,nfi.nfi_dataemissao ");
            buf.append("       ,ent.ent_fantasia ");
            buf.append("       ,nfi.nfi_valortotal ");
            buf.append("       ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("           from (select mat_descricao ");
            buf.append("                   from notafiscalmaterial nfmaux ");
            buf.append("                   join material mataux on nfmaux.fil_codigo = mataux.fil_codigo and nfmaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                  where nfmaux.fil_codigo = nfi.fil_codigo ");
            buf.append("                    and nfmaux.nfi_codigo = nfi.nfi_codigo ");
            buf.append("                  order by mat_descricao) as mataux) as materiais ");
            buf.append("   from notafiscal nfi ");
            buf.append("   join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo ");
            buf.append("   join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
            buf.append("   join material mat on nfm.fil_codigo = mat.fil_codigo and nfm.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.adicionaCampo("nfi.nfi_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ser_codigo", "S\u00e9rie", 0, "", 2);
            p.adicionaCampo("nfi_numero", "N\u00famero", 1, "", 3);
            p.adicionaCampo("nfi_dataemissao", "Emiss\u00e3o", 2, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("nfi_valortotal", "Valor", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltro(" nfi.fil_codigo = " + Variaveis.filialPadrao + " and upper(nfi.nfi_situacao) <> upper('" + "C" + "') and upper(nfi.nfi_situacao) <> upper('" + "E" + "') and nfi.nfi_tipo = upper('" + "E" + "') ");
            p.setFiltroInicial("N\u00famero", 2);
            p.setOrdem("Emiss\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public Hashtable pesquisaNotaEntradaNaoConferidaVO(Object owner, AbstractThreadVO bean, String titulo) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, titulo);
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct nfi.nfi_codigo ");
            buf.append("       ,nfi.ser_codigo ");
            buf.append("       ,nfi.nfi_numero ");
            buf.append("       ,nfi.nfi_dataemissao ");
            buf.append("       ,ent.ent_fantasia ");
            buf.append("       ,nfi.nfi_valortotal ");
            buf.append("       ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("           from (select mat_descricao ");
            buf.append("                   from notafiscalmaterial nfmaux ");
            buf.append("                   join material mataux on nfmaux.fil_codigo = mataux.fil_codigo and nfmaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                  where nfmaux.fil_codigo = nfi.fil_codigo ");
            buf.append("                    and nfmaux.nfi_codigo = nfi.nfi_codigo ");
            buf.append("                  order by mat_descricao) as mataux) as materiais ");
            buf.append("   from notafiscal nfi ");
            buf.append("   join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo ");
            buf.append("   join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
            buf.append("   join material mat on nfm.fil_codigo = mat.fil_codigo and nfm.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.adicionaCampo("nfi.nfi_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ser_codigo", "S\u00e9rie", 0, "", 2);
            p.adicionaCampo("nfi_numero", "N\u00famero", 1, "", 3);
            p.adicionaCampo("nfi_dataemissao", "Emiss\u00e3o", 2, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("nfi_valortotal", "Valor", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("N\u00famero", 2);
            String filtro = " nfi.fil_codigo = " + Variaveis.filialPadrao;
            filtro = filtro + " and nfi.nfi_situacao NOT IN (upper('C'), upper('E'))  and nfi.nfi_tipo = upper('E') ";
            filtro = filtro + " and (nfi.fil_codigo, nfi.nfi_codigo) NOT IN (select cen.fil_codigo, cen.nfi_codigo from conferenciaentrada cen where cen.usr_codcancelamento IS NULL and cen.nfi_codigo is not null) ";
            filtro = filtro + " and (select count(1) ";
            filtro = filtro + "        from notafiscallanctoestoque nle ";
            filtro = filtro + "        join lanctoestoque lce on nle.fil_codigo = lce.fil_codigo and nle.lce_codigo = lce.lce_codigo";
            filtro = filtro + "       where nle.fil_codigo = nfi.fil_codigo ";
            filtro = filtro + "         and nle.nfi_codigo = nfi.nfi_codigo ";
            filtro = filtro + "     ) = 0 ";
            p.setFiltro(filtro);
            p.setOrdem("Emiss\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public Hashtable pesquisaEstornoCancelamentoPessoaJuridicaVO(Object owner, String titulo, boolean mostrarCadastro) {
        FrmPesquisa tela = FrmPesquisa.novaInstancia(owner, titulo);
        StringBuilder buf = new StringBuilder();
        if (tela != null) {
            buf.append("select nfi.nfi_codigo, ");
            buf.append("       con.con_codigo, ");
            buf.append("\t\t\t con.con_razao, ");
            buf.append("       ent.ent_codigo, ");
            buf.append("       ent.ent_razaosocial, ");
            buf.append("\t\t\t ser.ser_descricao,\t\t");
            buf.append("\t\t\t nfi.nfi_numero, \t\t\t");
            buf.append("\t\t\t nfi.nfi_numerorps,    ");
            buf.append("\t\t\t nfi.nfi_dataemissao,  ");
            buf.append("\t\t\t nfi.nfi_valortotal, \t");
            buf.append("\t\t\t nfi.nfi_codigo \t\t\t");
            buf.append("from notafiscal nfi ");
            buf.append("\tleft join series    ser\ton nfi.fil_codigo = ser.fil_codigo and ser.ser_codigo = nfi.ser_codigo ");
            buf.append("\tleft join entidade  ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
            buf.append("\tleft join paciente  pac on nfi.fil_codigo = pac.fil_codigo and nfi.pac_codigo = pac.pac_codigo ");
            buf.append("\tleft join convenios con on nfi.fil_codigo = con.fil_codigo and nfi.con_codigo = con.con_codigo ");
            tela.setSql(buf.toString());
            tela.adicionaCampo("nfi.nfi_codigo", "C\u00f3digo", 1, "", 3);
            tela.adicionaCampo("con.con_codigo", "C\u00f3d. Conv.", 1, "", 3);
            tela.adicionaCampo("con.con_razao", "Raz\u00e3o. Conv.", 0, "", 2);
            tela.adicionaCampo("ent.ent_codigo", "C\u00f3d. Ent.", 1, "", 3);
            tela.adicionaCampo("ent.ent_razaosocial", "Raz\u00e3o Ent.", 0, "", 2);
            tela.adicionaCampo("ser.ser_descricao", "S\u00e9rie", 0, "", 2);
            tela.adicionaCampo("nfi.nfi_numero", "N\u00famero", 1, "", 3);
            tela.adicionaCampo("nfi.nfi_numerorps", "N\u00famero RPS", 1, "", 3);
            tela.adicionaCampo("nfi.nfi_dataemissao", "Emiss\u00e3o", 2, "", 3);
            tela.adicionaCampo("nfi.nfi_valortotal", "Valor", 1, "", 3);
            tela.setFiltroInicial("N\u00famero", 2);
            buf.delete(0, buf.length());
            buf.append(" nfi.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and ( (nfi.nfi_numerorps IS NULL and nfi.nfi_situacao NOT IN (upper('").append("C").append("'), upper('").append("E").append("'))) ");
            buf.append("    or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao <> upper('").append("C").append("')) ) ");
            buf.append(" and nfi.nfi_tipo = upper('").append("S").append("') ");
            tela.setFiltro(buf.toString());
            tela.setOrdem("Emiss\u00e3o");
            tela.setExecutarAoAbrir(false);
            tela.setVisible(true);
            if (tela.selecionouRegistro()) {
                return tela.getRegistroSelecionado();
            }
        }
        return null;
    }

    public AbstractThreadVO pesquisaEstornoCancelamentoPessoaJuridicaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("serie", "S\u00e9rie", 0, "", 2, 80);
        tela.adicionaCampo("numero", "N\u00famero", 1, "", 3, 0);
        tela.adicionaCampo("dataEmissao", "Emiss\u00e3o", 2, "", 3, 80);
        tela.adicionaCampo("numeroRps", "N\u00famero RPS", 1, "", 3, 80);
        tela.adicionaCampo("valor", "Valor", 1, "", 3, 80);
        tela.setFiltroInicial("N\u00famero", 2);
        StringBuilder buf = new StringBuilder();
        buf.append(" fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and ( (nfi_numerorps IS NULL and nfi_situacao NOT IN (upper('").append("C").append("'), upper('").append("E").append("'))) ");
        buf.append("    or (nfi_numerorps IS NOT NULL and nfi_situacao <> upper('").append("C").append("')) ) ");
        buf.append(" and nfi_tipo = '").append("S").append("' ");
        tela.setFiltro(buf.toString());
        tela.setColunaOrdenacao("Emiss\u00e3o");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaEstornoCancelamentoPessoaFisicaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String tipoCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("serie", "S\u00e9rie", 0, "", 2, 80);
        tela.adicionaCampo("numero", "N\u00famero", 1, "", 3, 0);
        tela.adicionaCampo("dataEmissao", "Emiss\u00e3o", 2, "", 3, 80);
        tela.adicionaCampo("numeroRps", "N\u00famero RPS", 1, "", 3, 80);
        tela.adicionaCampo("valor", "Valor", 1, "", 3, 80);
        tela.setFiltroInicial("N\u00famero", 2);
        StringBuilder buf = new StringBuilder();
        buf.append(" fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" and ( (nfi_numerorps IS NULL and nfi_situacao NOT IN (upper('").append("C").append("'), upper('").append("E").append("'))) ");
        buf.append("    or (nfi_numerorps IS NOT NULL and nfi_situacao <> upper('").append("C").append("')) )  ");
        buf.append(" and nfi_tipo = '").append("F").append("' ");
        buf.append(" and nfi_tipocadastro = '").append(tipoCadastro).append("' ");
        tela.setFiltro(buf.toString());
        tela.setColunaOrdenacao("Emiss\u00e3o");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public Hashtable pesquisaCancelamentoNotaEntradaVO(Object owner, AbstractThreadVO bean, String titulo) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, titulo);
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct nfi.nfi_codigo ");
            buf.append("       ,nfi.ser_codigo ");
            buf.append("       ,nfi.nfi_numero ");
            buf.append("       ,nfi.nfi_dataemissao ");
            buf.append("       ,nfi.nfi_dataautorizafinanceira ");
            buf.append("       ,ent.ent_fantasia ");
            buf.append("       ,nfi.nfi_valortotal ");
            buf.append("       ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("           from (select mat_descricao ");
            buf.append("                   from notafiscalmaterial nfmaux ");
            buf.append("                   join material mataux on nfmaux.fil_codigo = mataux.fil_codigo and nfmaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                  where nfmaux.fil_codigo = nfi.fil_codigo ");
            buf.append("                    and nfmaux.nfi_codigo = nfi.nfi_codigo ");
            buf.append("                  order by mat_descricao) as mataux) as materiais ");
            buf.append("   from notafiscal nfi ");
            buf.append("   join notafiscalmaterial nfm on nfi.fil_codigo = nfm.fil_codigo and nfi.nfi_codigo = nfm.nfi_codigo ");
            buf.append("   join entidade ent on nfi.fil_codigo = ent.fil_codigo and nfi.ent_codigo = ent.ent_codigo ");
            buf.append("   join material mat on nfm.fil_codigo = mat.fil_codigo and nfm.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.adicionaCampo("nfi.nfi_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ser_codigo", "S\u00e9rie", 0, "", 2);
            p.adicionaCampo("nfi_numero", "N\u00famero", 1, "", 3);
            p.adicionaCampo("nfi_dataemissao", "Emiss\u00e3o", 2, "", 3);
            p.adicionaCampo("nfi_dataautorizafinanceira", "Dt. Aut. Financ.", 4, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("nfi_valortotal", "Valor", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("N\u00famero", 2);
            String filtro = " nfi.fil_codigo = " + Variaveis.filialPadrao + " and nfi.nfi_situacao NOT IN (upper('" + "C" + "'), upper('" + "E" + "')) ";
            filtro = filtro + " and nfi.nfi_tipo = upper('E') ";
            p.setFiltro(filtro);
            p.setOrdem("Emiss\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        ArrayList<NotaFiscalMaterialBean> listaMateriais;
        if (!(bean instanceof NotaFiscalBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido.");
        }
        Date dataCancelamento = new Date();
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setFilial(((NotaFiscalBean)bean).getFilial());
        usuarioVO.setCodigo(Variaveis.login);
        this.dao.update(bean, filial);
        this.removerServicosNota(filial, ((NotaFiscalBean)bean).getCodigo().toString());
        NotaFiscalServicoBean notaServico = ((NotaFiscalBean)bean).getServico();
        if (notaServico != null) {
            NotaFiscalServicoService servicoService = new NotaFiscalServicoService();
            notaServico.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
            notaServico.setServico(((NotaFiscalBean)bean).getServico().getServico());
            servicoService.insert(notaServico, 0, filial, filiais);
        }
        FaturaNotaFiscalService serviceFaturaNota = new FaturaNotaFiscalService();
        serviceFaturaNota.removerFaturasNotaFiscal(((NotaFiscalBean)bean).getFilial().getCodigo().toString(), ((NotaFiscalBean)bean).getCodigo().toString());
        Set<FaturaNotaFiscalBean> faturasNotaFiscal = ((NotaFiscalBean)bean).getFaturasNotaFiscal();
        if (faturasNotaFiscal != null) {
            for (FaturaNotaFiscalBean fatNF : faturasNotaFiscal) {
                fatNF.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
                serviceFaturaNota.insert(fatNF, null, filial, filiais);
            }
        }
        NotaFiscalMaterialService serviceNotaMaterial = new NotaFiscalMaterialService();
        ArrayList<NotaFiscalMaterialBean> listaMateriaisNota = serviceNotaMaterial.getMateriaisNotaFiscal(filial, ((NotaFiscalBean)bean).getCodigo().toString());
        ArrayList<MaterialBean> materialBeansAlterados = ((NotaFiscalBean)bean).getMateriaisAlterados();
        if (listaMateriaisNota != null) {
            ArrayList<NotaFiscalLanctoEstoqueBean> lanctos = null;
            Double quantidade = 0.0;
            for (NotaFiscalMaterialBean material : listaMateriaisNota) {
                quantidade = quantidade + material.getQuantidade();
            }
            if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N") && bean != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", ((NotaFiscalBean)bean).getFilial().getCodigo());
                chaves.put("nfi_codigo", ((NotaFiscalBean)bean).getCodigo());
                lanctos = new NotaFiscalLanctoEstoqueService().getBeans(chaves);
            }
            for (int i = 0; i < listaMateriaisNota.size(); ++i) {
                NotaFiscalMaterialBean notaMaterial = listaMateriaisNota.get(i);
                notaMaterial.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
                if (materialBeansAlterados != null && this.podeCancelar(notaMaterial, materialBeansAlterados)) {
                    serviceNotaMaterial.delete(notaMaterial, null, filial, filiais);
                    if (lanctos == null) continue;
                    for (int j = 0; j < lanctos.size(); ++j) {
                        LancamentoEstoqueBean lanctoBean;
                        NotaFiscalLanctoEstoqueBean auxNotaLancto = lanctos.get(j);
                        if (auxNotaLancto == null || auxNotaLancto.getLancamentoEstoque().getMaterial().getCodigo().intValue() != notaMaterial.getMaterial().getCodigo().intValue() || (lanctoBean = this.serviceLanctoEstoque.get(auxNotaLancto.getFilial().getCodigo().toString(), auxNotaLancto.getLancamentoEstoque().getCodigo().toString())) == null) continue;
                        lanctoBean.setDataHoraCancelamento(dataCancelamento);
                        lanctoBean.setUsuarioCancelamento(usuarioVO);
                        this.serviceLanctoEstoque.gravaAutoCopiaSemCommit(lanctoBean, 1, filial, true, null);
                        this.serviceMaterialLote.removerLoteLancamentoEstoque(lanctoBean.getFilial().getCodigo().toString(), lanctoBean.getCodigo().toString(), dataCancelamento);
                    }
                    continue;
                }
                Double valorFrete = ((NotaFiscalBean)bean).getValorFrete();
                if (valorFrete > 0.0) {
                    valorFrete = valorFrete / quantidade;
                }
                if (null == materialBeansAlterados) continue;
                for (MaterialBean matBean : materialBeansAlterados) {
                    MaterialService matService = new MaterialService();
                    if (((NotaFiscalDao)this.dao).isUltimaNota(((NotaFiscalBean)bean).getCodigo(), ((NotaFiscalBean)bean).getFilial(), matBean.getCodigo()) && matBean.getCodigo().equals(notaMaterial.getMaterial().getCodigo())) {
                        Integer codigoNFI = ((NotaFiscalBean)bean).getCodigo();
                        matBean.setCodigoUltimaCompraNfi(codigoNFI);
                        matBean.setCalculoRateioFreteUltimaCompra(valorFrete);
                        matService.gravaAutoCopiaSemCommit(matBean, 1, Variaveis.filialPadrao, null);
                    }
                    matService.gravaAutoCopiaSemCommit(matBean, 1, filial, null);
                }
            }
        }
        if (((NotaFiscalBean)bean).getDataHoraCancelada() == null && (listaMateriais = ((NotaFiscalBean)bean).getMateriais()) != null) {
            MaterialService serviceMaterial = new MaterialService();
            NotaFiscalMaterialService serviceMateriais = new NotaFiscalMaterialService();
            for (int i = 0; i < listaMateriais.size(); ++i) {
                LancamentoEstoqueVO lanctoEstoqueVO;
                NotaFiscalMaterialBean material = listaMateriais.get(i);
                if (material == null || !material.getMaterial().isInserir()) continue;
                material.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
                LancamentoEstoqueBean lanctoEstoqueBean = serviceMateriais.insertRetornaLancamento(material, null, filial, filiais);
                LancamentoEstoqueVO lancamentoEstoqueVO = lanctoEstoqueVO = lanctoEstoqueBean != null ? (LancamentoEstoqueVO)lanctoEstoqueBean.toVO() : null;
                if (lanctoEstoqueVO == null || !ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) continue;
                MaterialBean matLoteAux = null;
                for (int j = 0; ((NotaFiscalBean)bean).getMateriaisAlterados() != null && j < ((NotaFiscalBean)bean).getMateriaisAlterados().size(); ++j) {
                    if (((NotaFiscalBean)bean).getMateriaisAlterados().get(j).getCodigo().intValue() != material.getMaterial().getCodigo().intValue()) continue;
                    matLoteAux = ((NotaFiscalBean)bean).getMateriaisAlterados().get(j);
                    for (int k = 0; k < matLoteAux.getLotes().size(); ++k) {
                        MaterialLoteBean materialLoteBeanGravar = matLoteAux.getLotes().get(k);
                        if (materialLoteBeanGravar.getRemovido().booleanValue() || !materialLoteBeanGravar.getInserir()) continue;
                        FilialVO filialVO = new FilialVO();
                        filialVO.setCodigo(Integer.parseInt(filial));
                        materialLoteBeanGravar.setCodigo(null);
                        materialLoteBeanGravar.setInserir(true);
                        materialLoteBeanGravar.setAlterar(false);
                        materialLoteBeanGravar.setRemovido(false);
                        materialLoteBeanGravar.setDataHoraRemovido(null);
                        materialLoteBeanGravar.setUsuarioRemocao(null);
                        this.materialService.gerarMaterialLoteLancEstoque(filialVO, lanctoEstoqueVO, materialLoteBeanGravar);
                        this.serviceMaterialLote.gravaAutoCopiaSemCommit(materialLoteBeanGravar, 0, filial, filiais);
                    }
                    matLoteAux.getLotes().clear();
                    serviceMaterial.gravaAutoCopiaSemCommit(matLoteAux, 1, Variaveis.filialPadrao, null);
                }
            }
        }
        if (((NotaFiscalBean)bean).getTipo().equalsIgnoreCase("E") && !((NotaFiscalBean)bean).getSituacao().equalsIgnoreCase("C")) {
            Set parcelas;
            int i;
            ReceberPagarService serviceRecPag = new ReceberPagarService();
            ArrayList<ReceberPagarBean> titulos = this.getReceberPagarNotaFiscal(filial, ((NotaFiscalBean)bean).getCodigo().toString());
            boolean isPrevia = false;
            for (i = 0; i < titulos.size(); ++i) {
                if (!titulos.get(i).getSituacao().equalsIgnoreCase("P")) continue;
                isPrevia = true;
                break;
            }
            if (isPrevia) {
                for (i = 0; i < titulos.size(); ++i) {
                    serviceRecPag.gravaAutoCopiaSemCommit(titulos.get(i), 2, Variaveis.filialPadrao, null);
                }
            } else {
                for (i = 0; i < titulos.size(); ++i) {
                    if (!titulos.get(i).getSituacao().equalsIgnoreCase("A")) {
                        throw new Exception("A parcela " + titulos.get(i).getParcela() + " est\u00e1 com a situa\u00e7\u00e3o diferente de ABERTO.\nN\u00e3o \u00e9 poss\u00edvel alterar a nota fiscal.");
                    }
                    titulos.get(i).setSituacao("X");
                    serviceRecPag.gravaAutoCopiaSemCommit(titulos.get(i), 1, Variaveis.filialPadrao, null);
                }
            }
            if ((parcelas = ((NotaFiscalBean)bean).getParcelas()) != null) {
                for (ReceberPagarBean parcela : parcelas) {
                    Set centros;
                    parcela.setNotaFiscal((NotaFiscalVO)((NotaFiscalBean)bean).toVO());
                    parcela.setOrigem("N");
                    parcela.setCodigo(new ReceberPagarDao().getProximoCodigo(parcela));
                    parcela.setTipoCadastro(((NotaFiscalBean)bean).getTipoCadastro());
                    if (((NotaFiscalBean)bean).getEntidade() != null) {
                        parcela.setEntidade(((NotaFiscalBean)bean).getEntidade());
                    } else if (((NotaFiscalBean)bean).getConvenio() != null) {
                        parcela.setConvenio(((NotaFiscalBean)bean).getConvenio());
                    } else if (((NotaFiscalBean)bean).getPaciente() != null) {
                        parcela.setPaciente(((NotaFiscalBean)bean).getPaciente());
                    }
                    parcela.setObservacao("Parcela nr " + parcela.getParcela() + " referente a nota fiscal n\u00famero " + ((NotaFiscalBean)bean).getNumero());
                    parcela.setNumeroDocumento(((NotaFiscalBean)bean).getNumero() == null ? null : ((NotaFiscalBean)bean).getNumero().toString());
                    parcela.setSerie(((NotaFiscalBean)bean).getSerie());
                    Set planos = parcela.getPlanosContas();
                    if (planos != null) {
                        for (ReceberPagarPlanoContaBean plano : planos) {
                            plano.setInserir(true);
                        }
                    }
                    if ((centros = parcela.getCentrosCusto()) != null) {
                        for (ReceberPagarCentroCustoBean centro : centros) {
                            centro.setInserir(true);
                        }
                    }
                    serviceRecPag.insert(parcela, null, filial, filiais);
                }
            }
        }
    }

    private boolean podeCancelar(NotaFiscalMaterialBean notaMaterial, List<MaterialBean> materialBeansAlterados) {
        for (MaterialBean bean : materialBeansAlterados) {
            if (!bean.getCodigo().equals(notaMaterial.getMaterial().getCodigo()) || !bean.isInserir() && !bean.isExcluido()) continue;
            return true;
        }
        return false;
    }

    public void removerServicosNota(String filial, String codigoFilial) throws SQLException {
        ((NotaFiscalDao)this.dao).removerServicosNota(filial, codigoFilial);
    }

    public void autorizarNotaFiscalEntrada(NotaFiscalBean notaBean) throws Exception {
        if (notaBean == null) {
            return;
        }
        if (notaBean.getTipo() == null || !notaBean.getTipo().equalsIgnoreCase("E")) {
            throw new Exception("N\u00e3o \u00e9 poss\u00edvel autorizar a nota fiscal. Somente notas fiscais de entrada podem ser autorizadas.");
        }
        if (notaBean.getUsuarioAutorizacaoFinanceira() == null || notaBean.getDataHoraAutorizacaoFinanceira() == null) {
            throw new Exception("Usu\u00e1rio ou Data/Hora da autoriza\u00e7\u00e3o n\u00e3o informado.");
        }
        this.gravaAutoCopiaSemCommit(notaBean, 1, notaBean.getFilial().getCodigo().toString(), null);
        Set setRecPag = notaBean.getParcelas();
        if (setRecPag != null) {
            Iterator it = setRecPag.iterator();
            ReceberPagarService serviceRecPag = new ReceberPagarService();
            while (it.hasNext()) {
                ReceberPagarBean bean = (ReceberPagarBean)it.next();
                bean.setSituacao("A");
                serviceRecPag.gravaAutoCopiaSemCommit(bean, 1, bean.getFilial().getCodigo().toString(), null);
            }
        }
    }

    public ArrayList<ReceberPagarBean> gerarParcelas(NotaFiscalBean bean, Set formaPagamentoParcelas) throws Exception {
        ArrayList<ReceberPagarBean> parcelas = FinanceiroUtil.gerarParcelas(bean.getSubTotal(), bean.getValor(), bean.getIssValor(), 0.0, 0.0, 0.0, 0.0, 0.0, bean.getValorISSRetido(), bean.getValorInssRetido(), bean.getValorCofinsRetido(), bean.getValorCsllRetido(), bean.getValorIrrfRetido(), bean.getValorPisRetido(), 0.0, bean.getDataEmissao(), "R", formaPagamentoParcelas);
        for (int i = 0; parcelas != null && i < parcelas.size(); ++i) {
            ReceberPagarBean beanRP = parcelas.get(i);
            beanRP.setDataDocumento(new Date());
            beanRP.setDataHora(new Date());
            beanRP.setDataCompetencia(new Date());
            beanRP.setDataProcessamento(new Date());
            beanRP.setSerie(bean.getSerie());
            beanRP.setFilial(bean.getFilial());
            beanRP.setTipo("R");
            beanRP.setSituacao("A");
            beanRP.setTipoDocumento("B");
            beanRP.setUsuario(bean.getUsuario());
            beanRP.setDataHora(new Date());
            if (bean.getNumeroRps() != null) {
                beanRP.setNumeroDocumento(bean.getNumeroRps().toString());
            } else if (bean.getNumero() != null) {
                beanRP.setNumeroDocumento(bean.getNumero().toString());
            }
            beanRP.setIrrfPercentual(bean.getIrrfPercentual());
            beanRP.setIssPercentual(bean.getIssPercentual());
            beanRP.setPisPercentual(bean.getPisPercentual());
            beanRP.setCsllPercentual(bean.getCsllPercentual());
            beanRP.setCofinsPercentual(bean.getCofinsPercentual());
            beanRP.setInssPercentual(bean.getInssPercentual());
            beanRP.setIssRetidoPercentual(bean.getPercentualISSRetido());
            beanRP.setInssRetidoPercentual(bean.getPercentualInssRetido());
            beanRP.setCofinsRetidoPercentual(bean.getPercentualCofinsRetido());
            beanRP.setCsllRetidoPercentual(bean.getPercentualCsllRetido());
            beanRP.setIrrfRetidoPercentual(bean.getPercentualIrrfRetido());
            beanRP.setPisRetidoPercentual(bean.getPercentualPisRetido());
            beanRP.setInserir(true);
            PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(beanRP, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, beanRP.getFilial().getCodigo().toString());
            panelPlanoCentro.setService(new ReceberPagarService());
            if (beanRP.getTipo().equals("R")) {
                panelPlanoCentro.setTipoDebitoCredito("C");
            } else {
                panelPlanoCentro.setTipoDebitoCredito("D");
            }
            beanRP = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)beanRP, panelPlanoCentro, 2, bean.getConvenio());
        }
        return parcelas;
    }

    public Set recalcularValoresParcelas(ReceberPagarBean novaParcela, Set parcelas, double novoValorParcela, double valorTotal) {
        Double diferenca = 0.0;
        Double somaValores = 0.0;
        for (ReceberPagarBean bean2 : parcelas) {
            if (bean2.getParcela().doubleValue() < (double)novaParcela.getParcela().intValue()) {
                diferenca = diferenca + bean2.getValor();
                continue;
            }
            if (bean2.getParcela().doubleValue() != (double)novaParcela.getParcela().intValue()) continue;
            diferenca = diferenca + novoValorParcela;
        }
        diferenca = Funcoes.arredondar(valorTotal - diferenca, 2);
        novaParcela.setValor(novoValorParcela);
        if (diferenca != 0.0) {
            ReceberPagarBean bean2;
            bean2 = null;
            int qtdeParcRestantes = 0;
            for (ReceberPagarBean bean2 : parcelas) {
                if (!(bean2.getParcela().doubleValue() > novaParcela.getParcela().doubleValue())) continue;
                ++qtdeParcRestantes;
            }
            if (qtdeParcRestantes <= 0) {
                return parcelas;
            }
            diferenca = Double.parseDouble(Funcoes.formataDecimal(diferenca / (double)qtdeParcRestantes).replaceAll(",", "."));
            Iterator it = parcelas.iterator();
            Boolean erro = false;
            while (it.hasNext()) {
                bean2 = (ReceberPagarBean)it.next();
                if (bean2.getParcela().doubleValue() > novaParcela.getParcela().doubleValue()) {
                    if (diferenca > 0.0) {
                        bean2.setValor(diferenca);
                    } else {
                        bean2.setValor(0.0);
                        erro = true;
                    }
                }
                if (bean2.getParcela().doubleValue() != novaParcela.getParcela().doubleValue()) {
                    somaValores = Funcoes.arredondar(somaValores + bean2.getValor(), 2);
                    continue;
                }
                somaValores = Funcoes.arredondar(somaValores + novoValorParcela, 2);
            }
            if (erro.booleanValue()) {
                return parcelas;
            }
            somaValores = Funcoes.arredondar(valorTotal - somaValores, 2);
            for (ReceberPagarBean bean2 : parcelas) {
                if (bean2.getParcela().doubleValue() != novaParcela.getParcela().doubleValue() + 1.0) continue;
                if (Funcoes.arredondar(bean2.getValor() + somaValores, 2) > 0.0) {
                    bean2.setValor(Funcoes.arredondar(bean2.getValor() + somaValores, 2));
                    continue;
                }
                bean2.setValor(0.0);
            }
        }
        return parcelas;
    }

    public Integer pegaProximoNumeroDasParcelas(NotaFiscalBean bean) {
        Integer retorno = 0;
        Set parcelas = bean.getParcelas();
        for (ReceberPagarBean p : parcelas) {
            if (p.getParcela() == null || p.getParcela() <= retorno) continue;
            retorno = p.getParcela();
        }
        return retorno + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer pegaNumeroProximaNota(SeriesVO serie) {
        Integer retorno = 1;
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select max(nfi_numero) from notafiscal ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and ser_codigo = '").append(StringUtil.textoDB(serie.getCodigo())).append("' ");
            buf.append(" and nfi_tipo IN ('").append("S").append("', '").append("F").append("') ");
            buf.append(" and nfi_situacao <> '").append("E").append("' ");
            buf.append(" and nfi_numerorps IS NULL ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            retorno = rs != null && rs.next() ? rs.getInt(1) + 1 : 1;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "NotaFiscalService: 248");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static Long getRpsTemporario(NotaFiscalBean bean) {
        String filialNota = Funcoes.preencheZero(bean.getFilial().getCodigo(), 2);
        String codigoNota = Funcoes.preencheZero(bean.getCodigo(), 8);
        Long numeroRpsTemporario = Long.parseLong(filialNota + codigoNota);
        return numeroRpsTemporario;
    }

    public static Long getNumeroRPSComLock(NotaFiscalBean bean) throws SQLException {
        Statement st = Conexao.getStatement();
        SeriesVO serie = bean.getSerie();
        if (serie.getSolicitarRps().booleanValue() && sistemaEmissaoNFSe == SistemaEmissaoNFSe.TECNOSPEED) {
            return NotaFiscalService.getRpsTemporario(bean) * -1L;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" LOCK TABLE series IN EXCLUSIVE MODE; ");
        Conexao.executeUpdate(serie.getFilial().getCodigo().toString(), Conexao.getStatement(), buf.toString());
        buf.setLength(0);
        buf.append(" UPDATE series ");
        buf.append("    SET ser_rps = (SELECT COALESCE(ser_rps, 0) + 1 ");
        buf.append("                     FROM series ");
        buf.append("                    WHERE fil_codigo = ").append(serie.getFilial().getCodigo());
        buf.append("                      AND ser_codigo = '").append(serie.getCodigo()).append("') ");
        buf.append("  WHERE fil_codigo = ").append(serie.getFilial().getCodigo());
        buf.append("    AND ser_codigo = '").append(serie.getCodigo()).append("' ");
        Conexao.executeUpdate(serie.getFilial().getCodigo().toString(), Conexao.getStatement(), buf.toString());
        Conexao.arquivaSQL();
        buf.setLength(0);
        buf.append(" SELECT ser_rps as rps ");
        buf.append("   FROM series ");
        buf.append("  WHERE fil_codigo = ").append(serie.getFilial().getCodigo());
        buf.append("    AND ser_codigo = '").append(serie.getCodigo()).append("' ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        return rs != null && rs.next() ? Long.valueOf(rs.getLong("rps")) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjetoImpostoAcumulado pegaValorAcumuladoPeriodo(NotaFiscalBean bean, boolean usarNumeroNota) {
        boolean isComposicaoNotaFiscalJuridica;
        ObjetoImpostoAcumulado imp = new ObjetoImpostoAcumulado(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        boolean isComposicaoNotaFiscalFisica = bean.getFilial().getNaoComporNfseFisica() == false;
        boolean bl = isComposicaoNotaFiscalJuridica = bean.getFilial().getNaoComporNfseJuridica() == false;
        if (bean != null && bean.getFilial() != null && bean.getDataEmissao() != null && bean.getTipoCadastro() != null && (bean.getEntidade() != null || bean.getConvenio() != null || bean.getPaciente() != null)) {
            Statement st;
            block28: {
                st = Conexao.getStatement();
                try {
                    ResultSet rs;
                    String cnpj;
                    ArrayList<Integer> codigos = new ArrayList<Integer>();
                    StringBuilder buf = new StringBuilder();
                    if (bean.getTipoCadastro().equals("U") || bean.getTipoCadastro().equals("F") || bean.getTipoCadastro().equals("C") || bean.getTipoCadastro().equals("R") && isComposicaoNotaFiscalFisica) {
                        String string = cnpj = bean.getConvenio() != null ? bean.getConvenio().getCnpj() : "";
                        if (bean.getConvenio() != null && !bean.getConvenio().getCnpjIntegralImposto().booleanValue()) {
                            cnpj = cnpj.indexOf("/") > -1 ? cnpj.substring(0, cnpj.indexOf("/")) : cnpj;
                        }
                        buf.append("select ent_codigo from entidade where fil_codigo = ").append(bean.getFilial().getCodigo());
                        if (!Funcoes.textoVazio(cnpj)) {
                            buf.append(" and ent_cpfcnpj ilike '").append(StringUtil.textoDB(cnpj)).append("%'");
                        } else {
                            buf.append(" and ent_codigo = ").append(bean.getEntidade().getCodigo());
                        }
                    } else if (bean.getTipoCadastro().equals("P") && isComposicaoNotaFiscalFisica) {
                        String cpfPaciente = StringUtil.limpaString(bean.getPaciente().getCpf(), new String[]{".", "-"});
                        buf.append("select pac_codigo from paciente where fil_codigo = ").append(bean.getFilial().getCodigo());
                        if (bean.getPaciente() != null && !Funcoes.textoVazio(cpfPaciente) && Funcoes.isNumeric(cpfPaciente)) {
                            buf.append(" and pac_cpf = '").append(StringUtil.textoDB(bean.getPaciente().getCpf())).append("'");
                        } else {
                            buf.append(" and pac_codigo = ").append(bean.getPaciente().getCodigo());
                        }
                    } else if (bean.getTipoCadastro().equals("O") && isComposicaoNotaFiscalJuridica) {
                        String string = cnpj = bean.getConvenio() != null ? bean.getConvenio().getCnpj() : "";
                        if (cnpj != null && bean.getConvenio() != null && !bean.getConvenio().getCnpjIntegralImposto().booleanValue()) {
                            cnpj = cnpj.indexOf("/") > -1 ? cnpj.substring(0, cnpj.indexOf("/")) : cnpj;
                        }
                        buf.append("select con_codigo from convenios where fil_codigo = ").append(bean.getFilial().getCodigo());
                        if (!Funcoes.textoVazio(cnpj)) {
                            buf.append(" and con_cnpjcpf ilike '").append(StringUtil.textoDB(cnpj)).append("%'");
                        } else {
                            buf.append(" and con_codigo = ").append(bean.getConvenio().getCodigo());
                        }
                    }
                    if (buf.length() > 0) {
                        rs = Conexao.executeQuery(st, buf);
                        while (rs.next()) {
                            if (codigos.contains(rs.getInt(1))) continue;
                            codigos.add(rs.getInt(1));
                        }
                    }
                    if (codigos.size() > 0) {
                        buf.setLength(0);
                        buf.append(" select sum(nfi_subtotal) as somaTotal ");
                        buf.append("       ,sum(nfi_issvalor) as somaIss ");
                        buf.append("       ,sum(nfi_pisvalor) as somaPis ");
                        buf.append("       ,sum(nfi_csllvalor) as somaCsll ");
                        buf.append("       ,sum(nfi_cofinsvalor) as somaCofins ");
                        buf.append("       ,sum(nfi_inssvalor) as somaInss ");
                        buf.append("       ,sum(nfi_issretidovalor) as somaIssRetido ");
                        buf.append("       ,sum(nfi_inssretidovalor) as somaInssRetido ");
                        buf.append("       ,sum(nfi_cofinsretidovalor) as somaCofinsRetido ");
                        buf.append("       ,sum(nfi_csllretidovalor) as somaCsllRetido ");
                        buf.append("       ,sum(nfi_irrfretidovalor) as somaIrrfRetido ");
                        buf.append("       ,sum(nfi_pisretidovalor) as somaPisRetido ");
                        buf.append("   from notafiscal ");
                        buf.append("  where fil_codigo = ").append(bean.getFilial().getCodigo());
                        buf.append("    and nfi_tipocadastro = '").append(bean.getTipoCadastro()).append("' ");
                        if (bean.getTipoCadastro().equals("U") || bean.getTipoCadastro().equals("F") || bean.getTipoCadastro().equals("C") || bean.getTipoCadastro().equals("R")) {
                            buf.append(" and ent_codigo in (").append(this.separarArrayList(codigos)).append(")");
                        } else if (bean.getTipoCadastro().equals("P")) {
                            buf.append(" and pac_codigo in (").append(this.separarArrayList(codigos)).append(")");
                        } else if (bean.getTipoCadastro().equals("O")) {
                            buf.append(" and con_codigo in (").append(this.separarArrayList(codigos)).append(")");
                        }
                        buf.append(" and extract(month from nfi_dataemissao) = ").append(Funcoes.formataData("MM", bean.getDataEmissao()));
                        buf.append(" and extract(year from nfi_dataemissao) = ").append(Funcoes.formataData("yyyy", bean.getDataEmissao()));
                        buf.append(" and ((nfi_numerorps IS NULL and nfi_situacao NOT IN (upper('").append("C").append("'), upper('").append("E").append("'), upper('").append("R").append("'), upper('").append("X").append("'))) ");
                        buf.append("   or (nfi_numerorps IS NOT NULL and nfi_situacao = '").append("A").append("') ) ");
                        if (usarNumeroNota && null != bean.getCodigo()) {
                            buf.append(" and nfi_codigo < ").append(bean.getCodigo());
                        }
                        if ((rs = Conexao.executeQuery(st, buf)).next()) {
                            imp = new ObjetoImpostoAcumulado(rs.getDouble("somaTotal"), rs.getDouble("somaInss"), rs.getDouble("somaIss"), rs.getDouble("somaCsll"), rs.getDouble("somaCofins"), rs.getDouble("somaPis"), rs.getDouble("somaIssRetido"), rs.getDouble("somaInssRetido"), rs.getDouble("somaCofinsRetido"), rs.getDouble("somaCsllRetido"), rs.getDouble("somaIrrfRetido"), rs.getDouble("somaPisRetido"));
                        }
                    }
                    if (null == imp) break block28;
                    imp.setTotalNotas(imp.getTotalNotas() + bean.getSubTotal());
                }
                catch (Exception ex) {
                    try {
                        ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "NotaFiscalService: 402");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        return imp;
    }

    public NotaFiscalComposicaoBean getComposicaoImpostosNotaImpressa(NotaFiscalBean bean) throws Exception {
        return (NotaFiscalComposicaoBean)new NotaFiscalComposicaoService().get(String.valueOf(bean.getFilial().getCodigo()), String.valueOf(bean.getCodigo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NotaFiscalVO> getComposicaoImpostosNota(NotaFiscalBean bean) {
        boolean isComposicaoNotaFiscalJuridica;
        ArrayList<NotaFiscalVO> notas = new ArrayList<NotaFiscalVO>();
        boolean isComposicaoNotaFiscalFisica = bean.getFilial().getNaoComporNfseFisica() == false;
        boolean bl = isComposicaoNotaFiscalJuridica = bean.getFilial().getNaoComporNfseJuridica() == false;
        if (bean != null && bean.getFilial() != null && bean.getDataEmissao() != null && bean.getTipoCadastro() != null && (bean.getEntidade() != null || bean.getConvenio() != null || bean.getPaciente() != null)) {
            Statement st;
            block26: {
                st = Conexao.getStatement();
                try {
                    ResultSet rs;
                    String cnpj;
                    ArrayList<Integer> codigos = new ArrayList<Integer>();
                    StringBuilder buf = new StringBuilder();
                    if (bean.getTipoCadastro().equals("U") || bean.getTipoCadastro().equals("F") || bean.getTipoCadastro().equals("C") || bean.getTipoCadastro().equals("R") && isComposicaoNotaFiscalFisica) {
                        String string = cnpj = bean.getConvenio() != null ? bean.getConvenio().getCnpj() : "";
                        if (bean.getConvenio() != null && !bean.getConvenio().getCnpjIntegralImposto().booleanValue()) {
                            cnpj = cnpj.indexOf("/") > -1 ? cnpj.substring(0, cnpj.indexOf("/")) : cnpj;
                        }
                        buf.append("select ent_codigo from entidade where fil_codigo = ").append(bean.getFilial().getCodigo());
                        if (!Funcoes.textoVazio(cnpj)) {
                            buf.append(" and ent_cpfcnpj ilike '").append(StringUtil.textoDB(cnpj)).append("%'");
                        } else {
                            buf.append(" and ent_codigo = ").append(bean.getEntidade().getCodigo());
                        }
                    } else if (bean.getTipoCadastro().equals("P") && isComposicaoNotaFiscalFisica) {
                        buf.append("select pac_codigo from paciente where fil_codigo = ").append(bean.getFilial().getCodigo());
                        String cpfPaciente = StringUtil.limpaString(bean.getPaciente().getCpf(), new String[]{".", "-"});
                        if (!Funcoes.textoVazio(bean.getPaciente().getCpf()) && !Funcoes.textoVazio(cpfPaciente) && Funcoes.isNumeric(cpfPaciente)) {
                            buf.append(" and pac_cpf = '").append(StringUtil.textoDB(bean.getPaciente().getCpf())).append("'");
                        } else {
                            buf.append(" and pac_codigo = ").append(bean.getPaciente().getCodigo());
                        }
                    } else if (bean.getTipoCadastro().equals("O") && isComposicaoNotaFiscalJuridica) {
                        String string = cnpj = bean.getConvenio() != null ? bean.getConvenio().getCnpj() : "";
                        if (bean.getConvenio() != null && !bean.getConvenio().getCnpjIntegralImposto().booleanValue()) {
                            cnpj = cnpj.indexOf("/") > -1 ? cnpj.substring(0, cnpj.indexOf("/")) : cnpj;
                        }
                        buf.append("select con_codigo from convenios where fil_codigo = ").append(bean.getFilial().getCodigo());
                        if (!Funcoes.textoVazio(cnpj)) {
                            buf.append(" and con_cnpjcpf ilike '").append(StringUtil.textoDB(cnpj)).append("%'");
                        } else {
                            buf.append(" and con_codigo = ").append(bean.getConvenio().getCodigo());
                        }
                    }
                    if (buf.length() > 0) {
                        rs = Conexao.executeQuery(st, buf);
                        while (rs.next()) {
                            if (codigos.contains(rs.getInt(1))) continue;
                            codigos.add(rs.getInt(1));
                        }
                    }
                    if (codigos.size() <= 0) break block26;
                    buf.setLength(0);
                    buf.append("select nfi_codigo as codigo, ");
                    buf.append("       fil_codigo as filial ");
                    buf.append(" from notafiscal where ");
                    buf.append(" fil_codigo = ").append(bean.getFilial().getCodigo());
                    buf.append(" and nfi_tipocadastro = '").append(bean.getTipoCadastro()).append("' ");
                    if (bean.getTipoCadastro().equals("U") || bean.getTipoCadastro().equals("F") || bean.getTipoCadastro().equals("C") || bean.getTipoCadastro().equals("R")) {
                        buf.append(" and ent_codigo in (").append(this.separarArrayList(codigos)).append(")");
                    } else if (bean.getTipoCadastro().equals("P")) {
                        buf.append(" and pac_codigo in (").append(this.separarArrayList(codigos)).append(")");
                    } else if (bean.getTipoCadastro().equals("O")) {
                        buf.append(" and con_codigo in (").append(this.separarArrayList(codigos)).append(")");
                    }
                    buf.append(" and extract(month from nfi_dataemissao) = ").append(Funcoes.formataData("MM", bean.getDataEmissao()));
                    buf.append(" and extract(year from nfi_dataemissao) = ").append(Funcoes.formataData("yyyy", bean.getDataEmissao()));
                    buf.append(" and ((nfi_numerorps IS NULL and nfi_situacao NOT IN (upper('").append("C").append("'), upper('").append("E").append("'), upper('").append("R").append("'), upper('").append("X").append("'))) ");
                    buf.append(" or (nfi_numerorps IS NOT NULL and nfi_situacao = '").append("A").append("') ) ");
                    buf.append(" order by nfi_numero ");
                    rs = Conexao.executeQuery(st, buf);
                    while (rs.next()) {
                        notas.add((NotaFiscalVO)this.getVO(rs.getString("filial"), rs.getString("codigo")));
                    }
                }
                catch (Exception ex) {
                    try {
                        ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "NotaFiscalService: 402");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        return notas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBaseCalculoNota(NotaFiscalBean bean) {
        Statement st;
        block5: {
            double d;
            if (bean == null) {
                return 0.0;
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select SUM(nfi_subtotal) as baseCalculo from notafiscalcomposicao nfc ");
            buf.append(" where nf.fil_codigo = ").append(bean.getFilial().getCodigo());
            buf.append(" left join notafiscal nf on nfc.fil_codigo = nf.fil_codigo and nf.nfi_codigo = nfc.nfi_codigo ");
            buf.append("   and nf.nfi_codigo = ").append(bean.getCodigo());
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block5;
                d = rs.getDouble("baseCalculo");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi possivel carregar o valor da base de calculo.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return d;
        }
        Conexao.fecharStatement(st);
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pegaValorImpostos(NotaFiscalBean bean, boolean zerarPercentuais) {
        if (bean != null && bean.getFilial() != null && bean.getDataEmissao() != null && bean.getTipoCadastro() != null && (bean.getEntidade() != null || bean.getConvenio() != null || bean.getPaciente() != null)) {
            ObjetoImpostoAcumulado imposto = this.pegaValorAcumuladoPeriodo(bean, false);
            if (null != bean.getServico()) {
                bean.setImpostoAcumulado(imposto.getTotalNotas());
            }
            if (zerarPercentuais) {
                bean.setInssPercentual(0.0);
                bean.setInssPercentualOriginal(0.0);
                bean.setInssValor(0.0);
                bean.setCofinsPercentual(0.0);
                bean.setCofinsPercentualOriginal(0.0);
                bean.setCofinsValor(0.0);
                bean.setCsllPercentual(0.0);
                bean.setCsllPercentualOriginal(0.0);
                bean.setCsllValor(0.0);
                bean.setIrrfPercentual(0.0);
                bean.setIrrfPercentualOriginal(0.0);
                bean.setIrrfValor(0.0);
                bean.setIssPercentual(0.0);
                bean.setIssPercentualOriginal(0.0);
                bean.setIssValor(0.0);
                bean.setPisPercentual(0.0);
                bean.setPisPercentualOriginal(0.0);
                bean.setPisValor(0.0);
                bean.setValorISSRetido(0.0);
                bean.setPercentualISSRetido(0.0);
                bean.setPercentualIssRetidoOriginal(0.0);
                bean.setValorInssRetido(0.0);
                bean.setPercentualInssRetido(0.0);
                bean.setPercentualIssRetidoOriginal(0.0);
                bean.setValorCofinsRetido(0.0);
                bean.setPercentualCofinsRetido(0.0);
                bean.setPercentualCofinsRetidoOriginal(0.0);
                bean.setValorCsllRetido(0.0);
                bean.setPercentualCsllRetido(0.0);
                bean.setPercentualCsllRetidoOriginal(0.0);
                bean.setValorIrrfRetido(0.0);
                bean.setPercentualIrrfRetido(0.0);
                bean.setPercentualIrrfRetidoOriginal(0.0);
                bean.setValorPisRetido(0.0);
                bean.setPercentualPisRetido(0.0);
                bean.setPercentualPisRetidoOriginal(0.0);
            }
            if (bean.getServico() == null || bean.getServico().getServico() == null) {
                return;
            }
            Statement st = Conexao.getStatement();
            try {
                String s;
                StringBuilder buf = new StringBuilder();
                buf.setLength(0);
                buf.append(" select sim_imposto ");
                buf.append("       ,sim_valorinicial ");
                buf.append("       ,sim_valorfinal ");
                buf.append("       ,sim_valoraplicar ");
                buf.append("       ,svc.svc_percentualdeduzir ");
                buf.append("   from servicoimposto sim ");
                buf.append("   join servico svc on sim.fil_codigo = svc.fil_codigo and sim.svc_codigo = svc.svc_codigo ");
                buf.append("  where svc.fil_codigo = ").append(bean.getFilial().getCodigo());
                buf.append("    and svc.svc_codigo = ").append(bean.getServico().getServico().getCodigo());
                buf.append("    and sim.sim_valorinicial <= ").append(Funcoes.limpaDecimal(bean.getImpostoAcumulado()));
                buf.append("    and sim.sim_valorfinal >= ").append(Funcoes.limpaDecimal(bean.getImpostoAcumulado()));
                buf.append("  order by sim_imposto ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                while (rs.next()) {
                    s = rs.getString("sim_imposto");
                    if (s.equals(Impostos.INSS.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setInssPercentual(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setInssPercentualOriginal(rs.getDouble("sim_valoraplicar"));
                        bean.setInssValor(this.calculaValor(bean, bean.getInssPercentual(), false, null, imposto.getInss(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.COFINS.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setCofinsPercentual(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setCofinsPercentualOriginal(rs.getDouble("sim_valoraplicar"));
                        bean.setCofinsValor(this.calculaValor(bean, bean.getCofinsPercentual(), false, null, imposto.getCofins(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.CSLL.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setCsllPercentual(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setCsllPercentualOriginal(rs.getDouble("sim_valoraplicar"));
                        bean.setCsllValor(this.calculaValor(bean, bean.getCsllPercentual(), false, null, imposto.getCsll(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.ISS.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setIssPercentual(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setIssPercentualOriginal(rs.getDouble("sim_valoraplicar"));
                        Double issValor = bean.getFilial().getSimplesNacional() != false ? 0.0 : this.calculaValor(bean, bean.getIssPercentual(), true, bean.getServico() == null ? null : bean.getServico().getServico(), imposto.getIss(), imposto);
                        bean.setIssValor(issValor);
                        continue;
                    }
                    if (s.equals(Impostos.PIS.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setPisPercentual(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setPisPercentualOriginal(rs.getDouble("sim_valoraplicar"));
                        bean.setPisValor(this.calculaValor(bean, bean.getPisPercentual(), false, null, imposto.getPis(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.ISS_RETIDO.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setPercentualISSRetido(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setPercentualISSRetido(rs.getDouble("sim_valoraplicar"));
                        bean.setValorISSRetido(this.calculaValor(bean, bean.getPercentualISSRetido(), false, null, imposto.getIssRetido(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.INSS_RETIDO.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setPercentualInssRetido(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setPercentualInssRetido(rs.getDouble("sim_valoraplicar"));
                        bean.setValorInssRetido(this.calculaValor(bean, bean.getPercentualInssRetido(), false, null, imposto.getInssRetido(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.COFINS_RETIDO.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setPercentualCofinsRetido(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setPercentualCofinsRetido(rs.getDouble("sim_valoraplicar"));
                        bean.setValorCofinsRetido(this.calculaValor(bean, bean.getPercentualCofinsRetido(), false, null, imposto.getCofinsRetido(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.CSLL_RETIDO.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setPercentualCsllRetido(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setPercentualCsllRetido(rs.getDouble("sim_valoraplicar"));
                        bean.setValorCsllRetido(this.calculaValor(bean, bean.getPercentualCsllRetido(), false, null, imposto.getCsllRetido(), imposto));
                        continue;
                    }
                    if (s.equals(Impostos.IRRF_RETIDO.getCodigo())) {
                        if (zerarPercentuais) {
                            bean.setPercentualIrrfRetido(rs.getDouble("sim_valoraplicar"));
                        }
                        bean.setPercentualIrrfRetido(rs.getDouble("sim_valoraplicar"));
                        bean.setValorIrrfRetido(this.calculaValor(bean, bean.getPercentualIrrfRetido(), false, null, imposto.getIrrfRetido(), imposto));
                        continue;
                    }
                    if (!s.equals(Impostos.PIS_RETIDO.getCodigo())) continue;
                    if (zerarPercentuais) {
                        bean.setPercentualPisRetido(rs.getDouble("sim_valoraplicar"));
                    }
                    bean.setPercentualPisRetido(rs.getDouble("sim_valoraplicar"));
                    bean.setValorPisRetido(this.calculaValor(bean, bean.getPercentualPisRetido(), false, null, imposto.getPisRetido(), imposto));
                }
                buf.setLength(0);
                buf.append(" select sim_imposto ");
                buf.append("       ,sim_valorinicial ");
                buf.append("       ,sim_valorfinal ");
                buf.append("       ,sim_valoraplicar ");
                buf.append("   from servicoimposto ");
                buf.append("  where fil_codigo = ").append(bean.getFilial().getCodigo());
                buf.append("    and svc_codigo = ").append(bean.getServico().getServico().getCodigo());
                buf.append("    and sim_valorinicial <= ").append(Funcoes.limpaDecimal(bean.getSubTotal()));
                buf.append("    and sim_valorfinal >= ").append(Funcoes.limpaDecimal(bean.getSubTotal()));
                buf.append("    and sim_imposto = '").append(Impostos.IRRF.getCodigo()).append("' ");
                buf.append("  order by sim_imposto ");
                rs = Conexao.executeQuery(st, buf);
                while (rs.next()) {
                    s = rs.getString("sim_imposto");
                    if (!s.equals(Impostos.IRRF.getCodigo())) continue;
                    if (zerarPercentuais) {
                        bean.setIrrfPercentual(rs.getDouble("sim_valoraplicar"));
                    }
                    bean.setIrrfPercentualOriginal(rs.getDouble("sim_valoraplicar"));
                    bean.setIrrfValor(this.calculaValor(bean, bean.getIrrfPercentual(), false, null, 0.0, imposto, true));
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private String separarArrayList(ArrayList<Integer> array) {
        StringBuilder buf = new StringBuilder();
        for (Integer i : array) {
            if (buf.length() > 0) {
                buf.append(",").append(i);
                continue;
            }
            buf.append(i);
        }
        return buf.toString();
    }

    public Double calculaValor(NotaFiscalBean bean, Double percentual, boolean isISS, ServicoVO servico, Double impostoAcumulado, ObjetoImpostoAcumulado imposto) {
        return this.calculaValor(bean, percentual, isISS, servico, impostoAcumulado, imposto, false);
    }

    public Double calculaValor(NotaFiscalBean bean, Double percentual, boolean isISS, ServicoVO servico, Double impostoAcumulado, ObjetoImpostoAcumulado imposto, boolean isIrrf) {
        int CASAS = ParametrosGerais.getCasasPrecoImposto();
        RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoImposto();
        double perc = percentual / 100.0;
        boolean isUtilizarValorNota = true;
        BigDecimal valorTotalAcumulado = new BigDecimal(imposto.getTotalNotas());
        valorTotalAcumulado = valorTotalAcumulado.subtract(new BigDecimal(bean.getSubTotal())).setScale(4, ROUND);
        if ((valorTotalAcumulado = valorTotalAcumulado.multiply(new BigDecimal(perc)).setScale(2, ROUND)).doubleValue() == impostoAcumulado.doubleValue()) {
            isUtilizarValorNota = true;
        }
        Double valorImpostoAcumulado = isIrrf || isUtilizarValorNota ? bean.getSubTotal() : bean.getImpostoAcumulado();
        BigDecimal valor = new BigDecimal(valorImpostoAcumulado).setScale(4, ROUND);
        if (isISS && servico != null) {
            valor = valor.multiply(new BigDecimal(servico.getPercentualDeduzir() == null ? "0" : servico.getPercentualDeduzir().toString()));
            valor = valor.divide(new BigDecimal("100"));
        }
        valor = valor.multiply(new BigDecimal(perc)).setScale(4, ROUND);
        if (!isUtilizarValorNota) {
            valor = valor.subtract(new BigDecimal(impostoAcumulado)).setScale(4, ROUND);
        }
        valor = valor.setScale(CASAS, ROUND);
        return valor.doubleValue();
    }

    public void calculaImpostosAlterados(NotaFiscalBean bean) {
        if (bean != null && bean.getValor() != null) {
            ObjetoImpostoAcumulado imposto = this.pegaValorAcumuladoPeriodo((NotaFiscalBean)bean.clonar(), false);
            if (imposto == null) {
                imposto = new ObjetoImpostoAcumulado(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            bean.setCofinsPercentual(bean.getCofinsPercentual());
            bean.setCofinsValor(bean.getCofinsPercentual() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getCofinsPercentual(), false, null, imposto.getCofins(), imposto));
            bean.setInssPercentual(bean.getInssPercentual());
            bean.setInssValor(bean.getInssPercentual() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getInssPercentual(), false, null, imposto.getInss(), imposto));
            bean.setIrrfPercentual(bean.getIrrfPercentual());
            bean.setIrrfValor(bean.getIrrfPercentual() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getIrrfPercentual(), false, null, 0.0, imposto, true));
            bean.setIssPercentual(bean.getIssPercentual());
            bean.setIssValor(bean.getIssPercentual() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getIssPercentual(), false, bean.getServico() == null ? null : bean.getServico().getServico(), imposto.getIss(), imposto));
            bean.setPisPercentual(bean.getPisPercentual());
            bean.setPisValor(bean.getPisPercentual() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getPisPercentual(), false, null, imposto.getPis(), imposto));
            bean.setCsllPercentual(bean.getCsllPercentual());
            bean.setCsllValor(bean.getCsllPercentual() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getCsllPercentual(), false, null, imposto.getCsll(), imposto));
            bean.setPercentualISSRetido(bean.getPercentualISSRetido());
            bean.setValorISSRetido(bean.getPercentualISSRetido() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getPercentualISSRetido(), false, null, imposto.getIssRetido(), imposto));
            bean.setPercentualInssRetido(bean.getPercentualInssRetido());
            bean.setValorInssRetido(bean.getPercentualInssRetido() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getPercentualInssRetido(), false, null, imposto.getInssRetido(), imposto));
            bean.setPercentualCofinsRetido(bean.getPercentualCofinsRetido());
            bean.setValorCofinsRetido(bean.getPercentualCofinsRetido() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getPercentualCofinsRetido(), false, null, imposto.getCofinsRetido(), imposto));
            bean.setPercentualCsllRetido(bean.getPercentualCsllRetido());
            bean.setValorCsllRetido(bean.getPercentualCsllRetido() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getPercentualCsllRetido(), false, null, imposto.getCsllRetido(), imposto));
            bean.setPercentualIrrfRetido(bean.getPercentualIrrfRetido());
            bean.setValorIrrfRetido(bean.getPercentualIrrfRetido() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getPercentualIrrfRetido(), false, null, imposto.getIrrfRetido(), imposto));
            bean.setPercentualPisRetido(bean.getPercentualPisRetido());
            bean.setValorPisRetido(bean.getPercentualPisRetido() <= 0.0 ? 0.0 : this.calculaValor(bean, bean.getPercentualPisRetido(), false, null, imposto.getPisRetido(), imposto));
        }
    }

    public boolean imprimirNotaServico(NotaFiscalVO nota) throws Exception {
        boolean retorno = false;
        if (nota == null || nota.getFilial() == null) {
            return false;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (NotaFiscalService.isGerarNotaFiscalEletronica(nota.getSerie()) && nota.getNumeroRps() != null) {
            this.imprimirNFSe((NotaFiscalBean)this.get(nota.getFilial().getCodigo().toString(), nota.getCodigo().toString()));
            this.atualizarImpressaoNotaFiscal(nota, st, true);
            return true;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select a.nfi_numero as numeroNotaFiscal, a.nfi_tipocadastro as tipoCadastroNotaFiscal, a.nfi_datahora as datahoraNotaFiscal, ");
        buf.append("a.nfi_dataemissao as dataEmissaoNotaFiscal, a.nfi_situacao as situacaoNotaFiscal, a.nfi_datahoraimpressao as dataHoraImpressaoNotaFiscal, ");
        buf.append("COALESCE(a.nfi_observacao, '') as observacaoNotaFiscal, a.nfi_valortotal as valorTotalNotaFiscal, COALESCE(a.nfi_tipo, '").append("S").append("') as tipoNotaFiscal, ");
        buf.append("a.nfi_subtotal as subTotalNotaFiscal, '' as faturasNotaFiscal, ");
        buf.append("a.nfi_datahoracancelada as dataHoraCanceladoNotaFiscal, ");
        buf.append("a.nfi_irrfvalor as valorIRRFNotaFiscal, a.nfi_irrfpercentual as percentualIRRFNotaFiscal, ");
        buf.append("a.nfi_issvalor as valorISSNotaFiscal, a.nfi_isspercentual as percentualISSNotaFiscal, ");
        buf.append("a.nfi_pisvalor as valorPISNotaFiscal, a.nfi_pispercentual as percentualPISNotaFiscal, ");
        buf.append("a.nfi_csllvalor as valorCSLLNotaFiscal, a.nfi_csllpercentual as percentualCSLLNotaFiscal, ");
        buf.append("a.nfi_cofinsvalor as valorCOFINSNotaFiscal, a.nfi_cofinspercentual as percentualCOFINSNotaFiscal, ");
        buf.append("a.nfi_inssvalor as valorINSSNotaFiscal, a.nfi_insspercentual as percentualINSSNotaFiscal, ");
        buf.append("a.ser_codigo as codigoSerie, serie.ser_descricao as descricaoSerie, ");
        buf.append("a.fpg_codigo as codigoFormaPagamento, forma.fpg_descricao as descricaoFormaPagamento, ");
        buf.append("a.usr_codigo as codigoUsuarioNotaFiscal, usuario.usr_nome as nomeUsuarioNotaFiscal, ");
        buf.append("a.usr_codimpressao as codigoUsuarioImpressaoNotaFiscal, usuarioimpressao.usr_nome as nomeUsuarioImpressaoNotaFiscal, ");
        buf.append("a.usr_codcancelada as codigoUsuarioCanceladoNotaFiscal, usuariocancelado.usr_nome as nomeUsuarioCanceladoNotaFiscal, ");
        buf.append("null as datasVencimentoNotaFiscal, null as datasVencimentoFatura,");
        buf.append("a.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, ");
        buf.append("filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, ");
        buf.append("filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, ");
        buf.append("filial.fil_razaosocial as razaoSocialFilial, ");
        buf.append("a.nfi_nomepagador as nomePagador, a.nfi_cpfpagador as cpfPagador, ");
        buf.append("0 as quantidadeRequisicoesFaturas, 0 as quantidadeExamesFaturas, null as menorDataPeriodoFiltroFaturas, null as maiorDataPeriodoFiltroFaturas, ");
        buf.append("cidfilial.cid_codigo as codigoCidadeFilial, cidfilial.cid_nome as descricaoCidadeFilial, cidfilial.cid_uf as estadoCidadeFilial, ");
        buf.append("baifilial.bai_codigo as codigoBairroFilial, baifilial.bai_descricao as descricaoBairroFilial, ");
        buf.append("b.svc_codigo as codigoServicoNotaFiscal, b.nfs_valor as valorServicoNotaFiscal, servico.svc_descricao as descricaoServicoNotaFiscal, ");
        buf.append("case ");
        buf.append("  when a.nfi_tipocadastro = '").append("O").append("' then a.con_codigo ");
        buf.append("  when a.nfi_tipocadastro = '").append("P").append("' then a.pac_codigo ");
        buf.append("  else a.ent_codigo ");
        buf.append("end as codigoCadastro, ");
        buf.append("'' as fantasiaCadastro, '' as razaoSocialCadastro, '' as foneCadastro, ");
        buf.append("'' as enderecoCadastro, '' as faxCadastro, '' as complementoCadastro, '' as cepCadastro, ");
        buf.append("'' as cnpjCpfCadastro, '' as ieRgCadastro, ");
        buf.append("'' as codigoCidadeCadastro, '' as nomeCidadeCadastro, '' as estadoCidadeCadastro, ");
        buf.append("'' as codigoBairroCadastro, '' as descricaoBairroCadastro ");
        buf.append("from notafiscal a ");
        buf.append("left join notafiscalservico b on a.fil_codigo = b.fil_codigo and a.nfi_codigo = b.nfi_codigo ");
        buf.append("left join servico servico on b.fil_codigo = servico.fil_codigo and b.svc_codigo = servico.svc_codigo ");
        buf.append("left join series serie on a.fil_codigo = serie.fil_codigo and a.ser_codigo = serie.ser_codigo ");
        buf.append("left join formapagto forma on a.fil_codigo = forma.fil_codigo and a.fpg_codigo = forma.fpg_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo ");
        buf.append("left join cidades cidfilial on filial.fil_codigo = cidfilial.fil_codigo and filial.cid_codigo = cidfilial.cid_codigo ");
        buf.append("left join bairro baifilial on filial.fil_codigo = baifilial.fil_codigo and filial.bai_codigo = baifilial.bai_codigo ");
        buf.append("left join usuario usuario on a.usr_codigo = usuario.usr_codigo ");
        buf.append("left join usuario usuarioimpressao on a.usr_codimpressao = usuarioimpressao.usr_codigo ");
        buf.append("left join usuario usuariocancelado on a.usr_codcancelada = usuariocancelado.usr_codigo ");
        buf.append("where a.fil_codigo = ").append(nota.getFilial().getCodigo());
        buf.append(" and a.nfi_codigo = ").append(nota.getCodigo());
        buf.append(" order by b.svc_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        boolean isPessoaFisica = false;
        ModeloGridTable modelo = null;
        if (rs.next()) {
            isPessoaFisica = rs.getString("tipoNotaFiscal").equalsIgnoreCase("F");
            modelo = new ModeloGridTable(!isPessoaFisica ? Impressao.CAMPOS_NOTA_FISCAL_SAIDA : Impressao.CAMPOS_NOTA_FISCAL_PESSOA_FISICA){

                @Override
                public int findColumn(String columnName) {
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        if (!columnName.equalsIgnoreCase(this.getColumnName(i))) continue;
                        return i;
                    }
                    return -1;
                }
            };
            do {
                Object[] o = new Object[modelo.getColumnCount()];
                for (int i = 0; i < modelo.getColumnCount(); ++i) {
                    int pos = -1;
                    pos = modelo.findColumn(modelo.getColumnName(i));
                    if (pos <= -1) continue;
                    o[pos] = modelo.getColumnName(i).equalsIgnoreCase("faturasNotaFiscal") ? this.pegaFaturas(st2, nota.getFilial().getCodigo(), nota.getCodigo()) : (modelo.getColumnName(i).equalsIgnoreCase("datasVencimentoNotaFiscal") ? this.pegaVencimentoParcelas(st2, nota.getFilial().getCodigo(), nota.getCodigo()) : (modelo.getColumnName(i).equalsIgnoreCase("datasVencimentoFatura") ? this.pegaVencimentoFaturas(st2, nota.getFilial().getCodigo(), nota.getCodigo()) : (modelo.getColumnName(i).equalsIgnoreCase("quantidadeRequisicoesFaturas") ? Integer.valueOf(this.contaQuantidadeRequisicoesFaturas(st2, nota.getFilial().getCodigo(), nota.getCodigo())) : (modelo.getColumnName(i).equalsIgnoreCase("quantidadeExamesFaturas") ? Integer.valueOf(this.contaQuantidadeExamesFaturas(st2, nota.getFilial().getCodigo(), nota.getCodigo())) : (modelo.getColumnName(i).equalsIgnoreCase("menorDataPeriodoFiltroFaturas") ? this.pegaMenorDataPeriodoFaturas(st2, nota.getFilial().getCodigo(), nota.getCodigo()) : (modelo.getColumnName(i).equalsIgnoreCase("maiorDataPeriodoFiltroFaturas") ? this.pegaMaiorDataPeriodoFaturas(st2, nota.getFilial().getCodigo(), nota.getCodigo()) : (modelo.getColumnName(i).equalsIgnoreCase("observacaoNotaFiscal") ? rs.getString(modelo.getColumnName(i)).replaceAll("\n", " ") : rs.getObject(modelo.getColumnName(i)))))))));
                }
                this.pegaDadosCadastro(st2, modelo, o, rs.getString("tipoCadastroNotaFiscal"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                modelo.addLine(o);
            } while (rs.next());
        }
        if (modelo != null && modelo.getRowCount() > 0) {
            buf.setLength(0);
            if (isPessoaFisica) {
                buf.append("select b.ser_tipomodelonotacpf as ser_tipomodelonota ");
                buf.append("      ,b.ser_modelonotacpf as ser_modelonota ");
            } else {
                buf.append("select b.ser_tipomodelonota ");
                buf.append("      ,b.ser_modelonota ");
            }
            buf.append("  from notafiscal a ");
            buf.append("  left join series b on a.fil_codigo = b.fil_codigo and a.ser_codigo = b.ser_codigo ");
            buf.append(" where a.fil_codigo = ").append(nota.getFilial().getCodigo());
            buf.append("   and a.nfi_codigo = ").append(nota.getCodigo());
            rs = Conexao.executeQuery(st, buf);
            String tipoLayout = "D";
            String layout = "";
            if (rs.next()) {
                tipoLayout = rs.getString("ser_tipomodelonota");
                layout = rs.getString("ser_modelonota");
            }
            if (!Funcoes.textoVazio(layout)) {
                String impressora = Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraNotaFiscal"));
                if (tipoLayout.equals("C")) {
                    Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    gerador.setImpressora(Impressao.comparaNomeImpressoraReduzido(impressora));
                    gerador.executar(layout, modelo);
                } else {
                    Relatorio rel = new Relatorio();
                    rel.setCabecalhoRodape(layout, modelo);
                    for (int i = 0; i < modelo.getRowCount(); ++i) {
                        rel.addItem(modelo.getLine(i));
                    }
                    ImpressaoRelatorio ip = new ImpressaoRelatorio(impressora);
                    if (ip.imprimir(rel) && ParametrosLocais.getParametro("impressaoLaserMapa") != null && ParametrosLocais.getParametro("impressaoFinalizarMapa") != null && ParametrosLocais.getParametro("impressaoLaserMapa").equalsIgnoreCase("1") && ParametrosLocais.getParametro("impressaoFinalizarMapa").equalsIgnoreCase("1") && !rel.isCupom()) {
                        ip.terminar();
                    }
                }
                this.atualizarImpressaoNotaFiscal(nota, st, false);
                retorno = true;
            }
        }
        return retorno;
    }

    private void atualizarImpressaoNotaFiscal(NotaFiscalVO nota, Statement st, boolean isEletronica) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.setLength(0);
        buf.append("update notafiscal set ");
        if (!isEletronica) {
            buf.append("nfi_situacao = '").append("I").append("', ");
        }
        buf.append("nfi_datahoraimpressao = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("', ");
        buf.append("usr_codimpressao = '").append(StringUtil.textoDB(Variaveis.login)).append("' ");
        buf.append("where fil_codigo = ").append(nota.getFilial().getCodigo());
        buf.append(" and nfi_codigo = ").append(nota.getCodigo());
        Conexao.execute(String.valueOf(nota.getFilial().getCodigo()), st, buf);
    }

    public boolean imprimirNotaServico(NotaFiscalVO nota, String[] faturas, boolean[] conferidas) throws Exception {
        StringBuilder buf = new StringBuilder();
        if (conferidas != null && faturas != null) {
            for (int i = 0; i < conferidas.length; ++i) {
                if (conferidas[i]) continue;
                buf.setLength(0);
                buf.append(" update fatura ");
                buf.append("    set usr_codconferencia = '").append(Variaveis.login).append("' ");
                buf.append("       ,fat_dtconferencia = current_timestamp ");
                buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat_codigo = ").append(faturas[i]);
                Conexao.executeUpdate(Variaveis.filialPadrao, Conexao.getStatement(), buf.toString());
            }
        }
        return this.imprimirNotaServico(nota);
    }

    private int contaQuantidadeRequisicoesFaturas(Statement st, int filial, int codigoNota) throws SQLException {
        int retorno = 0;
        StringBuilder buf = new StringBuilder("select sum(b.fat_qtderequisicao) from faturanotafiscal a ");
        buf.append(" left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.nfi_codigo = ").append(codigoNota);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = rs.getInt(1);
        }
        return retorno;
    }

    private int contaQuantidadeExamesFaturas(Statement st, int filial, int codigoNota) throws SQLException {
        int retorno = 0;
        StringBuilder buf = new StringBuilder("select sum(b.fat_qtdeexames) from faturanotafiscal a ");
        buf.append(" left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.nfi_codigo = ").append(codigoNota);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = rs.getInt(1);
        }
        return retorno;
    }

    private Date pegaMenorDataPeriodoFaturas(Statement st, int filial, int codigoNota) throws SQLException {
        java.sql.Date retorno = null;
        StringBuilder buf = new StringBuilder("select min(b.fat_dtinicio) from faturanotafiscal a ");
        buf.append(" left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.nfi_codigo = ").append(codigoNota);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = rs.getDate(1);
        }
        return retorno;
    }

    private Date pegaMaiorDataPeriodoFaturas(Statement st, int filial, int codigoNota) throws SQLException {
        java.sql.Date retorno = null;
        StringBuilder buf = new StringBuilder("select max(b.fat_dtfim) from faturanotafiscal a ");
        buf.append(" left join fatura b on a.fil_codigo = b.fil_codigo and a.fat_codigo = b.fat_codigo ");
        buf.append(" where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.nfi_codigo = ").append(codigoNota);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = rs.getDate(1);
        }
        return retorno;
    }

    private String pegaFaturas(Statement st, int filial, int codigoNota) throws SQLException {
        StringBuilder buf = new StringBuilder("select fat_codigo from faturanotafiscal where fil_codigo = ");
        buf.append(filial);
        buf.append(" and nfi_codigo = ").append(codigoNota);
        buf.append(" order by fat_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        StringBuilder retorno = new StringBuilder("");
        while (rs.next()) {
            if (retorno.length() > 0) {
                retorno.append(",").append(rs.getInt("fat_codigo"));
                continue;
            }
            retorno.append(rs.getInt("fat_codigo"));
        }
        return retorno.toString();
    }

    public String pegaVencimentoParcelas(Statement st, int filial, int codigoNota) throws SQLException {
        StringBuilder buf = new StringBuilder("select rpg_vencimento from receberpagar where fil_codigo = ");
        buf.append(filial);
        buf.append(" and nfi_codigo = ").append(codigoNota);
        buf.append(" and rpg_situacao IN('").append("A").append("', '").append("Q").append("') ");
        buf.append(" order by rpg_vencimento ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        StringBuilder retorno = new StringBuilder("");
        while (rs.next()) {
            if (retorno.length() > 0) {
                retorno.append(",").append(Funcoes.formataData(rs.getDate("rpg_vencimento")));
                continue;
            }
            retorno.append(Funcoes.formataData(rs.getDate("rpg_vencimento")));
        }
        return retorno.toString();
    }

    private String pegaVencimentoFaturas(Statement st, int filial, int codigoNota) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select fat.fat_dtvenc ");
        buf.append("   from faturanotafiscal fnf ");
        buf.append("       ,notafiscal nfi ");
        buf.append("       ,fatura fat ");
        buf.append("  where fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo ");
        buf.append("    and fnf.fil_codigo = fat.fil_codigo and fnf.fat_codigo = fat.fat_codigo ");
        buf.append("    and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
        buf.append("      or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("') ) ");
        buf.append("    and fnf.fil_codigo = ").append(filial);
        buf.append("    and fnf.nfi_codigo = ").append(codigoNota);
        buf.append("    and fat.fat_datacancelamento is null ");
        buf.append("  order by fat_dtvenc ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        StringBuilder retorno = new StringBuilder("");
        while (rs.next()) {
            if (retorno.length() > 0) {
                retorno.append(",").append(Funcoes.formataData(rs.getDate("fat_dtvenc")));
                continue;
            }
            retorno.append(Funcoes.formataData(rs.getDate("fat_dtvenc")));
        }
        return retorno.toString();
    }

    private void pegaDadosCadastro(Statement st, ModeloGridTable modeloColunas, Object[] array, String tipo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("pac.pac_nome as fantasiaCadastro, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("pac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro,  pac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("pac.pac_cpf as cnpjCpfCadastro, pac.pac_rg as ieRgCadastro, ");
            buf.append("pac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro, cidpac.cid_uf as estadoCidadeCadastro, ");
            buf.append("pac.bai_codigo as codigoBairroCadastro, baipac.bai_descricao as descricaoBairroCadastro ");
            buf.append("from paciente pac ");
            buf.append("left join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("left join bairro baipac on pac.fil_codigo = baipac.fil_codigo and pac.bai_codigo = baipac.bai_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("con.con_fantasia as fantasiaCadastro, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("con.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, con.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("con.con_cnpjcpf as cnpjCpfCadastro, con.con_inscrest as ieRgCadastro, ");
            buf.append("con.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro, cidcon.cid_uf as estadoCidadeCadastro, ");
            buf.append("con.bai_codigo as codigoBairroCadastro, baicon.bai_descricao as descricaoBairroCadastro ");
            buf.append("from convenios con ");
            buf.append("left join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("left join bairro baicon on con.fil_codigo = baicon.fil_codigo and con.bai_codigo = baicon.bai_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("ent.ent_fantasia as fantasiaCadastro, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("ent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("ent.ent_cpfcnpj as cnpjCpfCadastro, ent.ent_rgie as ieRgCadastro, ");
            buf.append("ent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro, cident.cid_uf as estadoCidadeCadastro, ");
            buf.append("ent.bai_codigo as codigoBairroCadastro, baient.bai_descricao as descricaoBairroCadastro ");
            buf.append("from entidade ent ");
            buf.append("left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("left join bairro baient on ent.fil_codigo = baient.fil_codigo and ent.bai_codigo = baient.bai_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                int pos = -1;
                pos = modeloColunas.findColumn(rs.getMetaData().getColumnName(i));
                if (pos <= -1) continue;
                array[pos] = rs.getMetaData().getColumnName(i).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(i)) : rs.getObject(i);
            }
        }
    }

    public void servicosAlterados(NotaFiscalBean bean) throws Exception {
        double valorTotalServicos = 0.0;
        NotaFiscalServicoBean notaServico = bean.getServico();
        if (notaServico != null) {
            valorTotalServicos += notaServico.getValor().doubleValue();
        }
        if (bean.getValor() != valorTotalServicos && valorTotalServicos > 0.0) {
            bean.setSubTotal(valorTotalServicos);
            this.pegaValorImpostos(bean, false);
            if (bean.getFormaPagamento() != null) {
                FormaPagamentoParcelaService serviceFormaPagamentoParcela = new FormaPagamentoParcelaService();
                Set parcelas = serviceFormaPagamentoParcela.load(" where fil_codigo = " + String.valueOf(bean.getFilial().getCodigo()) + " and fpg_codigo = " + bean.getFormaPagamento().getCodigo());
                bean.setParcelas(new HashSet<ReceberPagarBean>(this.gerarParcelas(bean, parcelas)));
            }
        }
    }

    public ArrayList<Object[]> buscaNotasFiscaisCadastro(String filial, String codigoCadastro, String tipoCadastro, Statement st) throws SQLException {
        StringBuilder buf = new StringBuilder();
        String campoCadastro = "";
        ArrayList<Object[]> listaNotas = new ArrayList<Object[]>();
        campoCadastro = tipoCadastro.equals(Tipos.tipoCadastro("P")) ? "pac_codigo" : (tipoCadastro.equals(Tipos.tipoCadastro("O")) ? "con_codigo" : "ent_codigo");
        buf.append(" select nfi.nfi_numero as numero ");
        buf.append("       ,nfi.nfi_valortotal as valor ");
        buf.append("       ,nfi.nfi_dataemissao as emissao ");
        buf.append("       ,nfi.nfi_codigo as codigo ");
        buf.append("   from notafiscal nfi ");
        buf.append("  where nfi.fil_codigo = " + filial);
        buf.append("    and nfi." + campoCadastro + " = " + codigoCadastro);
        buf.append("    and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
        buf.append("      or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("') ) ");
        buf.append("  order by nfi.nfi_numero ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        Object[] aux = null;
        while (rs.next()) {
            aux = new Object[]{rs.getString("numero"), rs.getDouble("valor"), rs.getDate("emissao"), rs.getInt("codigo")};
            listaNotas.add(aux);
        }
        return listaNotas;
    }

    public ArrayList<Object[]> buscaNotasFiscaisCadastroFornecedor(String filial, String codigoCadastro, String tipoCadastro, Statement st, boolean somenteEntrada) throws SQLException {
        StringBuilder buf = new StringBuilder();
        String campoCadastro = "";
        ArrayList<Object[]> listaNotas = new ArrayList<Object[]>();
        campoCadastro = tipoCadastro.equals(Tipos.tipoCadastro("P")) ? "pac_codigo" : (tipoCadastro.equals(Tipos.tipoCadastro("O")) ? "con_codigo" : "ent_codigo");
        buf.append(" select nfi.nfi_numero as numero ");
        buf.append("       ,nfi.nfi_valortotal as valor ");
        buf.append("       ,nfi.nfi_dataemissao as emissao ");
        buf.append("       ,nfi.nfi_codigo as codigo ");
        buf.append("\t\t\t ,nfi.nfi_pesquisafornecedor as pesquisafornecedor ");
        buf.append("   from notafiscal nfi ");
        buf.append("  where nfi.fil_codigo = " + filial);
        if (somenteEntrada) {
            buf.append("  and nfi.nfi_tipo = '").append("E").append("' ");
        }
        buf.append("    and nfi." + campoCadastro + " = " + codigoCadastro);
        buf.append("    and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
        buf.append("      or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao = '").append("A").append("') ) ");
        buf.append("  order by nfi.nfi_numero ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        Object[] aux = null;
        while (rs.next()) {
            aux = new Object[]{rs.getString("numero"), rs.getDouble("valor"), rs.getDate("emissao"), rs.getInt("codigo"), rs.getString("pesquisafornecedor")};
            listaNotas.add(aux);
        }
        return listaNotas;
    }

    public ArrayList<NotaFiscalBean> buscaNotasFiscaisCadastroFatura(String filial, String codigoFatura, String codigoCadastro, String tipoCadastro, Statement st) throws Exception {
        StringBuilder buf = new StringBuilder();
        String campoCadastro = "";
        ArrayList<NotaFiscalBean> listaNotas = new ArrayList<NotaFiscalBean>();
        campoCadastro = tipoCadastro.equals("P") ? "pac_codigo" : (tipoCadastro.equals("O") ? "con_codigo" : "ent_codigo");
        buf.append(" select nfi.fil_codigo as filial ");
        buf.append("       ,nfi.nfi_codigo as codigo ");
        buf.append("   from notafiscal nfi ");
        buf.append("\t left join faturanotafiscal fat on nfi.fil_codigo = fat.fil_codigo and nfi.nfi_codigo = fat.nfi_codigo ");
        buf.append("  where nfi.fil_codigo = " + filial);
        buf.append("\t  and fat.fat_codigo = " + codigoFatura);
        buf.append("    and nfi." + campoCadastro + " = " + codigoCadastro);
        buf.append("    and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
        buf.append("     or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("A").append("', '");
        buf.append("C").append("', '").append("O").append("', '").append("E").append("', '");
        buf.append("R").append("', '").append("N").append("' )) ) ");
        buf.append("  order by nfi.nfi_numero ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        NotaFiscalService serviceNota = new NotaFiscalService();
        while (rs.next()) {
            NotaFiscalBean bean = (NotaFiscalBean)serviceNota.get(rs.getString("filial"), rs.getString("codigo"));
            listaNotas.add(bean);
        }
        Conexao.fecharStatement(st);
        return listaNotas;
    }

    public boolean verificaNumeroNotaFiscalExiste(String filial, String numero) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(" select 1 from notafiscal ");
        buf.append(" where fil_codigo = ").append(filial).append(" and nfi_numero = ").append(numero).append(" ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        return rs.next();
    }

    public NotaFiscalBean verificaNumeroSerieNotaFiscalDisponivel(String filial, String numero, String serie) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" select nfi_codigo ");
        buf.append("   from notafiscal ");
        buf.append("  where nfi_numero = ").append(numero);
        buf.append("    and ser_codigo = '").append(serie).append("' ");
        buf.append("    and fil_codigo = ").append(filial);
        buf.append("    and nfi_tipo in ('").append("S").append("' , '").append("F").append("') ");
        buf.append("    and nfi_situacao <> '").append("E").append("' ");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            NotaFiscalBean nota = (NotaFiscalBean)this.get(filial, rs.getString("nfi_codigo"));
            return nota;
        }
        return null;
    }

    public String cancelarEstornaNF(boolean cancelaNF, NotaFiscalBean notaFiscalBean, Set<ReceberPagarBean> parcelas, SolicitarMotivoCancelamento telaMotivoCancelamento) throws Exception {
        String mensagem = "";
        if (notaFiscalBean.getMateriaisAlterados() == null) {
            notaFiscalBean.setMateriaisAlterados(new ArrayList<MaterialBean>());
        }
        Date dataCancelamento = new Date();
        UsuarioVO usuarioCanc = new UsuarioVO();
        usuarioCanc.setCodigo(Variaveis.login);
        if (notaFiscalBean.getTipo() != null && notaFiscalBean.getTipo().equalsIgnoreCase("E")) {
            mensagem = "Cancelamento NF Entrada";
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", notaFiscalBean.getFilial().getCodigo());
            chaves.put("nfi_codigo", notaFiscalBean.getCodigo().toString());
            ArrayList<NotaFiscalLanctoEstoqueBean> lancamentos = new NotaFiscalLanctoEstoqueService().getBeans(chaves);
            if (lancamentos != null) {
                Iterator<NotaFiscalLanctoEstoqueBean> itLancto = lancamentos.iterator();
                LancamentoEstoqueService lanctoEstoqueService = new LancamentoEstoqueService();
                while (itLancto.hasNext()) {
                    LancamentoEstoqueBean lanctoEstoqueBean;
                    NotaFiscalLanctoEstoqueBean beanLancto = itLancto.next();
                    if (beanLancto == null || (lanctoEstoqueBean = lanctoEstoqueService.get(beanLancto.getLancamentoEstoque().getFilial().getCodigo().toString(), beanLancto.getLancamentoEstoque().getCodigo().toString())) == null) continue;
                    lanctoEstoqueBean.setDataHoraCancelamento(dataCancelamento);
                    lanctoEstoqueBean.setUsuarioCancelamento(notaFiscalBean.getUsuarioCancelada());
                    lanctoEstoqueService.gravaAutoCopiaSemCommit(lanctoEstoqueBean, 1, lanctoEstoqueBean.getFilial().getCodigo().toString(), true, null);
                    this.serviceMaterialLote.removerLoteLancamentoEstoque(lanctoEstoqueBean.getFilial().getCodigo().toString(), lanctoEstoqueBean.getCodigo().toString(), dataCancelamento);
                }
            }
            this.atualizarSituacaoNFSe(cancelaNF, notaFiscalBean, false);
            this.atualizarNotaFiscalBean(notaFiscalBean, usuarioCanc, telaMotivoCancelamento, true);
            this.cancelarEstornarReceberPagar(cancelaNF, parcelas, notaFiscalBean);
        } else {
            boolean falhou = false;
            RespostaEnotas respostaCancelamento = RespostaEnotas.getInstanciaDeConsulta();
            IntegracaoEnotas integracao = new IntegracaoEnotas(notaFiscalBean);
            if (NotaFiscalService.isGerarNotaFiscalEletronica(notaFiscalBean.getSerie()) && notaFiscalBean.getNumeroRps() != null && sistemaEmissaoNFSe.equals((Object)SistemaEmissaoNFSe.ENOTAS)) {
                try {
                    respostaCancelamento = integracao.cancelarNotaFiscal();
                }
                catch (Exception e) {
                    falhou = true;
                    mensagem = "";
                }
            }
            if (!falhou) {
                boolean incluirUsuarioEDataCancelamento = false;
                StatusNota sn = null;
                if (!Funcoes.textoVazio(respostaCancelamento.getData().getStatus())) {
                    String motivo;
                    sn = StatusNota.fromString(respostaCancelamento.getData().getStatus());
                    String string = motivo = Funcoes.textoVazio(respostaCancelamento.getData().getMotivoStatus()) ? respostaCancelamento.getData().getStatus() : respostaCancelamento.getData().getMotivoStatus();
                    if (sn.cancelado()) {
                        this.cancelarEstornarReceberPagar(cancelaNF, parcelas, notaFiscalBean);
                        this.removerComissao(notaFiscalBean, parcelas);
                        new FaturaNotaFiscalService().removerFaturasNotaFiscal(notaFiscalBean.getFilial().getCodigo().toString(), notaFiscalBean.getCodigo().toString());
                    }
                    incluirUsuarioEDataCancelamento = sn != null && sn.cancelado();
                    mensagem = sn != null && sn.equals((Object)StatusNota.CANCELAMENTO_NEGADO) ? "Cancelamento Negado para a nota fiscal n\u00famero: \"" + notaFiscalBean.getNumero() + "\" \nMotivo: " + motivo : this.getMensagemCancelamento(notaFiscalBean, cancelaNF, respostaCancelamento);
                }
                boolean cancelamentoNegado = sn != null && sn.equals((Object)StatusNota.CANCELAMENTO_NEGADO);
                this.atualizarSituacaoNFSe(cancelaNF, notaFiscalBean, cancelamentoNegado);
                this.atualizarNotaFiscalBean(notaFiscalBean, usuarioCanc, telaMotivoCancelamento, incluirUsuarioEDataCancelamento);
                this.atualizarCancelamentoNFSe(respostaCancelamento, notaFiscalBean, integracao);
            }
        }
        this.gravaAutoCopiaSemCommit(notaFiscalBean, 1, Variaveis.filialPadrao, null);
        for (NotaFiscalMaterialBean notaFiscalMaterialBean : notaFiscalBean.getMateriais()) {
            new MaterialService().alteraCodigoNFI(notaFiscalMaterialBean.getMaterial().getFilial().getCodigo(), notaFiscalMaterialBean.getMaterial().getCodigo());
        }
        return mensagem;
    }

    private void atualizarSituacaoNFSe(boolean cancelaNF, NotaFiscalBean notaFiscalBean, boolean cancelamentoNegado) {
        if (!cancelamentoNegado) {
            String situacao = "";
            if (notaFiscalBean.getNumeroRps() == null) {
                situacao = cancelaNF ? "C" : "E";
                notaFiscalBean.setSituacao(situacao);
            } else {
                situacao = !cancelaNF ? "E" : "S";
                notaFiscalBean.setSituacao(situacao);
            }
        }
    }

    private void atualizarNotaFiscalBean(NotaFiscalBean notaFiscalBean, UsuarioVO usuarioCanc, SolicitarMotivoCancelamento telaMotivoCancelamento, boolean incluirUsuarioEDataCancelamento) {
        if (incluirUsuarioEDataCancelamento) {
            notaFiscalBean.setUsuarioCancelada(usuarioCanc);
            notaFiscalBean.setDataHoraCancelada(new Date());
        }
        notaFiscalBean.setDescricaoCancelamento(telaMotivoCancelamento.getDescricaoMotivo());
        notaFiscalBean.setMotivoCancelamento((MotivoCancelamentoVO)telaMotivoCancelamento.getMotivoCancelamento().toVO());
    }

    private void cancelarEstornarReceberPagar(boolean cancelaNF, Set<ReceberPagarBean> parcelas, NotaFiscalBean notaFiscalBean) throws Exception {
        StringBuilder listaCodigos = new StringBuilder();
        ReceberPagarService serviceRecPag = new ReceberPagarService();
        for (ReceberPagarBean recPagAux : parcelas) {
            if (recPagAux.getSituacao() != null && recPagAux.getSituacao().equalsIgnoreCase("P")) {
                serviceRecPag.gravaAutoCopiaSemCommit(recPagAux, 2, Variaveis.filialPadrao, null);
                continue;
            }
            if (recPagAux.getSituacao() != null && !recPagAux.getSituacao().equalsIgnoreCase("A")) {
                if (listaCodigos.length() > 0) {
                    listaCodigos.append(", ");
                }
                listaCodigos.append(recPagAux.getCodigo());
                continue;
            }
            UsuarioVO usuarioCanc = new UsuarioVO();
            usuarioCanc.setCodigo(Variaveis.login);
            recPagAux.setUsuarioCancelado(usuarioCanc);
            recPagAux.setDataCancelado(new Date());
            recPagAux.setSituacao(cancelaNF ? "C" : "E");
            serviceRecPag.gravaAutoCopiaSemCommit(recPagAux, 1, Variaveis.filialPadrao, null);
        }
        if (listaCodigos.length() > 0) {
            StringBuilder msg = new StringBuilder();
            if (listaCodigos.length() == 1) {
                msg.append("O t\u00edtulo: ").append(listaCodigos.toString()).append(", filial: ").append(notaFiscalBean.getFilial().getCodigo()).append(" n\u00e3o est\u00e1 aberto.\n");
            } else if (listaCodigos.length() > 1) {
                msg.append("Os t\u00edtulos: \"").append(listaCodigos.toString()).append("\", filial: ").append(notaFiscalBean.getFilial().getCodigo()).append(" n\u00e3o est\u00e3o abertos.\n");
            }
            msg.append("N\u00e3o \u00e9 poss\u00edvel ").append(cancelaNF ? "cancelar" : "estornar").append(" a nota fiscal se os Receber/Pagar n\u00e3o estiverem ABERTOS.\n");
            msg.append("Por favor, verifique.");
            throw new CancelamentoException(msg.toString(), true);
        }
    }

    public String cancelarEstornaNFPessoaFisica(boolean cancelaNF, NotaFiscalBean notaFiscalBean, SolicitarMotivoCancelamento telaMotivoCancelamento) throws Exception {
        String motivo;
        String mensagem = "";
        String situacao = "";
        if (notaFiscalBean.getNumeroRps() == null) {
            situacao = cancelaNF ? "C" : "E";
            notaFiscalBean.setSituacao(situacao);
        } else {
            situacao = !cancelaNF ? "E" : "S";
            notaFiscalBean.setSituacao(situacao);
        }
        boolean falhou = false;
        RespostaEnotas respostaCancelamento = RespostaEnotas.getInstanciaDeConsulta();
        IntegracaoEnotas integracao = new IntegracaoEnotas(notaFiscalBean);
        if (cancelaNF && NotaFiscalService.isGerarNotaFiscalEletronica(notaFiscalBean.getSerie()) && notaFiscalBean.getNumeroRps() != null) {
            try {
                respostaCancelamento = integracao.cancelarNotaFiscal();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha na solicita\u00e7\u00e3o de cancelamento a Enotas.\n" + e.getMessage(), e.getStackTrace());
                falhou = true;
            }
        }
        StatusNota sn = StatusNota.fromString(respostaCancelamento.getData().getStatus());
        String string = motivo = Funcoes.textoVazio(respostaCancelamento.getData().getMotivoStatus()) ? respostaCancelamento.getData().getStatus() : respostaCancelamento.getData().getMotivoStatus();
        if (sn != null && sn.equals((Object)StatusNota.CANCELAMENTO_NEGADO)) {
            mensagem = "Cancelamento Negado para a nota fiscal n\u00famero: \"" + notaFiscalBean.getNumero() + "\" \nMotivo: " + motivo;
        } else if (!falhou) {
            if (!cancelaNF || sn != null && !sn.processandoCancelamento()) {
                UsuarioVO usuarioCanc = new UsuarioVO();
                usuarioCanc.setCodigo(Variaveis.login);
                notaFiscalBean.setUsuarioCancelada(usuarioCanc);
                notaFiscalBean.setDataHoraCancelada(new Date());
            }
            notaFiscalBean.setDescricaoCancelamento(telaMotivoCancelamento.getDescricaoMotivo());
            notaFiscalBean.setMotivoCancelamento((MotivoCancelamentoVO)telaMotivoCancelamento.getMotivoCancelamento().toVO());
            this.atualizarCancelamentoNFSe(respostaCancelamento, notaFiscalBean, integracao);
            mensagem = this.getMensagemCancelamento(notaFiscalBean, cancelaNF, respostaCancelamento);
            this.gravaAutoCopiaSemCommit(notaFiscalBean, 1, Variaveis.filialPadrao, null);
        }
        return mensagem;
    }

    private void atualizarCancelamentoNFSe(RespostaEnotas respostaCancelamento, NotaFiscalBean notaFiscalBean, IntegracaoEnotas integracaoEnotas) {
        if (!Funcoes.textoVazio(respostaCancelamento.getData().getStatus())) {
            String motivo = Funcoes.textoVazio(respostaCancelamento.getData().getMotivoStatus()) ? respostaCancelamento.getData().getStatus() : respostaCancelamento.getData().getMotivoStatus();
            notaFiscalBean.setMotivoNfse(motivo);
            StatusNota sn = StatusNota.fromString(respostaCancelamento.getData().getStatus());
            if (sn != null && sn.equals((Object)StatusNota.CANCELAMENTO_NEGADO)) {
                return;
            }
            if (sn != null && !sn.processandoCancelamento()) {
                notaFiscalBean.setSituacao("C");
                integracaoEnotas.atualizarPDF(respostaCancelamento.getData().getLinkDownloadPDF(), null);
                integracaoEnotas.atualizarXML(respostaCancelamento.getData().getLinkDownloadXML());
            }
            if (sn != null && sn.processandoCancelamento()) {
                notaFiscalBean.setSituacao("S");
            }
        }
    }

    public String atualizarSolicitacaoCancelamentoNFSe(NotaFiscalBean notaFiscalBean) throws Exception {
        IntegracaoEnotas integracaoEnotas = new IntegracaoEnotas(notaFiscalBean);
        RespostaEnotas resposta = integracaoEnotas.consultarNotaFiscal(notaFiscalBean.getChaveNfse());
        this.atualizarCancelamentoNFSe(resposta, notaFiscalBean, integracaoEnotas);
        String mensagem = this.getMensagemCancelamento(notaFiscalBean, true, resposta);
        this.gravaAutoCopiaSemCommit(notaFiscalBean, 1, Variaveis.filialPadrao, null);
        return mensagem;
    }

    private String getMensagemCancelamento(NotaFiscalBean notaFiscalBean, boolean cancelaNF, RespostaEnotas respostaCancelamento) {
        String mensagem = "";
        if (Funcoes.textoVazio(respostaCancelamento.getData().getStatus())) {
            if (notaFiscalBean.getNumeroRps() == null) {
                mensagem = "A nota fiscal n\u00famero: \"" + notaFiscalBean.getNumero() + "\" foi" + (cancelaNF ? " cancelada " : " estornada ") + "com sucesso.";
            } else if (cancelaNF) {
                mensagem = "Requisitado cancelamento da  nota fiscal (RPS = \"" + notaFiscalBean.getNumeroRps() + "\").";
            }
        } else {
            StatusNota sn = StatusNota.fromString(respostaCancelamento.getData().getStatus());
            String motivo = Funcoes.textoVazio(respostaCancelamento.getData().getMotivoStatus()) ? respostaCancelamento.getData().getStatus() : respostaCancelamento.getData().getMotivoStatus();
            mensagem = sn != null && sn.processandoCancelamento() ? "Cancelamento da nota fiscal (RPS = \"" + notaFiscalBean.getNumeroRps() + "\") foi solicitado e n\u00e3o foi respondido. \nClique em Atualizar NF para verificar o status do Cancelamento" : "Nota fiscal n\u00famero: \"" + notaFiscalBean.getNumero() + "\" foi cancelada com sucesso.";
        }
        return mensagem;
    }

    private String removerComissao(NotaFiscalBean notaBean, Set<ReceberPagarBean> parcelas) throws Exception {
        ArrayList<ReceberPagarBean> listaRecPag = new NotaFiscalService().getPagarComissaoNotaFiscal(notaBean.getFilial().getCodigo().toString(), notaBean.getCodigo().toString());
        ReceberPagarService serviceRecPag = new ReceberPagarService();
        if (listaRecPag != null) {
            for (int i = 0; i < listaRecPag.size(); ++i) {
                ReceberPagarBean recPag = listaRecPag.get(i);
                ReceberPagarVO recPagAux = serviceRecPag.getUltimoEstadoReceberPagar((ReceberPagarVO)recPag.toVO());
                if ((recPag = (ReceberPagarBean)serviceRecPag.get(recPagAux.getFilial().getCodigo().toString(), recPagAux.getCodigo().toString())).getOrigem() != null && recPag.getOrigem().equalsIgnoreCase("C") && recPag.getSituacao() != null && !recPag.getSituacao().equalsIgnoreCase("A") && !recPag.getSituacao().equalsIgnoreCase("C") && !recPag.getSituacao().equalsIgnoreCase("X")) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("O pagar de comiss\u00e3o (c\u00f3d.: ").append(recPag.getCodigo()).append(") est\u00e1 com a situa\u00e7\u00e3o \"").append(Tipos.tipoSituacaoReceberPagar(recPag.getSituacao())).append("\".\n");
                    buf.append("N\u00e3o \u00e9 poss\u00edvel estornar/cancelar a nota fiscal.\n");
                    if (recPag.getSituacao().equalsIgnoreCase("Q")) {
                        buf.append("Estorne as baixas");
                    } else if (recPag.getSituacao().equalsIgnoreCase("L")) {
                        buf.append("Desfa\u00e7a o parcelamento");
                    } else if (recPag.getSituacao().equalsIgnoreCase("G")) {
                        buf.append("Desfa\u00e7a o agrupamento");
                    }
                    buf.append(" do pagar para poder estornar/cancelar a nota fiscal.");
                    return buf.toString();
                }
                recPag.setSituacao("X");
                serviceRecPag.gravaAutoCopiaSemCommit(recPag, 1, notaBean.getFilial().getCodigo().toString(), null);
            }
            Set<FaturaNotaFiscalBean> listaFaturas = notaBean.getFaturasNotaFiscal();
            if (listaFaturas != null) {
                for (FaturaNotaFiscalBean faturaNota : listaFaturas) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(" update fatura ");
                    buf.append("    set fat_datacomissao = null ");
                    buf.append("       ,usr_codcomissao = null ");
                    buf.append("  where fil_codigo = ").append(faturaNota.getFilial().getCodigo().toString());
                    buf.append("    and fat_codigo = ").append(faturaNota.getFatura().getCodigo().toString());
                    Conexao.executeUpdate(faturaNota.getFilial().getCodigo().toString(), Conexao.getStatement(), buf.toString());
                }
            }
            return null;
        }
        return null;
    }

    public ArrayList<ReceberPagarBean> getReceberPagarNotaFiscal(String filial, String codigo) throws Exception {
        return ((NotaFiscalDao)this.dao).getReceberPagarNotaFiscal(filial, codigo);
    }

    public ArrayList<ReceberPagarBean> getPagarComissaoNotaFiscal(String filial, String codigo) throws Exception {
        return ((NotaFiscalDao)this.dao).getReceberPagarNotaFiscal(filial, codigo);
    }

    public boolean haNotaFiscalEletronicaGerada(String filial) throws SQLException {
        return ((NotaFiscalDao)this.dao).haNotaFiscalEletronicaGerada(filial);
    }

    public ArrayList<NotaFiscalBean> getNotasFiscaisFornecedor(String filial, String serie, String numero, String codigoFornecedor) throws ThreadDaoException {
        return ((NotaFiscalDao)this.dao).getNotasFiscaisFornecedor(filial, serie, numero, codigoFornecedor);
    }

    public ArrayList<NotaFiscalBean> getNotasFiscaisPendentes(Integer filial, String cnpjCpf) throws ThreadDaoException {
        return ((NotaFiscalDao)this.dao).getNotasFiscaisPendentes(filial, cnpjCpf);
    }

    public ConferenciaEntradaBean getConferenciaEntradaNotaFiscalEntrada(String filial, String nota) throws Exception {
        return ((NotaFiscalDao)this.dao).getConferenciaEntradaNotaFiscalEntrada(filial, nota);
    }

    public ArrayList<NotaFiscalBean> getNotasFiscaisRequisicao(String filial, String requisicao) throws Exception {
        return ((NotaFiscalDao)this.dao).getNotasFiscaisRequisicao(filial, requisicao);
    }

    public void serieAlterada(NotaFiscalBean notaFiscalBean, String filial) throws Exception {
        NotaFiscalBean notaAnterior;
        if (notaFiscalBean != null && notaFiscalBean.getCodigo() != null && (notaAnterior = (NotaFiscalBean)this.get(notaFiscalBean.getFilial().getCodigo().toString(), notaFiscalBean.getCodigo().toString())) != null && notaFiscalBean != null && notaFiscalBean.getSerie() != null) {
            notaFiscalBean.setSerieAlterada(!notaFiscalBean.getSerie().getCodigo().equalsIgnoreCase(notaAnterior.getSerie().getCodigo()));
            if (notaFiscalBean.getSerieAlterada().booleanValue()) {
                notaFiscalBean.setRpsDaSerieAlterada(notaAnterior.getNumeroRps());
            }
        }
    }

    public void corrigirObsRpsSerieAlterada(NotaFiscalBean notaFiscalBean, String filial) throws SQLException {
        if (notaFiscalBean.getSerieAlterada().booleanValue()) {
            StringBuilder sql = new StringBuilder();
            sql.append("update receberpagar set ser_codigo = '");
            sql.append(notaFiscalBean.getSerie().getCodigo()).append("'");
            if (notaFiscalBean.getTipoCadastro().equals("O")) {
                sql.append(", rpg_obs = replace(rpg_obs, 'RPS = ");
                sql.append(notaFiscalBean.getRpsDaSerieAlterada()).append("', 'RPS = ");
                sql.append(notaFiscalBean.getNumeroRps()).append("')");
            } else {
                sql.append(", rpg_obs = replace(rpg_obs, 'RPS.: ");
                sql.append(notaFiscalBean.getRpsDaSerieAlterada()).append("', 'RPS.: ");
                sql.append(notaFiscalBean.getNumeroRps()).append("')");
            }
            sql.append(" where fil_codigo = ");
            sql.append(filial).append(" and nfi_codigo = ").append(notaFiscalBean.getCodigo()).append(";");
            Conexao.executeUpdate(filial, Conexao.getStatement(), sql);
        }
    }

    private void debug(String mensagem) {
        if (this.DEBUG) {
            System.out.println("Debug: " + mensagem);
        }
    }
}

