/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.bean.financeiro.BaixaLancamentoBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoRPBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaRPBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.dao.financeiro.BaixaDao;
import jalis.model.dao.financeiro.LancamentoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.financeiro.BaixaLancamentoService;
import jalis.service.financeiro.LancamentoCentroCustoRPService;
import jalis.service.financeiro.LancamentoCentroCustoService;
import jalis.service.financeiro.LancamentoPlanoContaRPService;
import jalis.service.financeiro.LancamentoPlanoContaService;
import jalis.util.Funcoes;
import jalis.util.sql.ConstrutorException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class LancamentoService
extends AbstractThreadService {
    public LancamentoService() {
        this.dao = new LancamentoDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof LancamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        Set planos = ((LancamentoBean)bean).getPlanosContas();
        if (planos != null) {
            Iterator it = planos.iterator();
            LancamentoPlanoContaService planoService = new LancamentoPlanoContaService();
            while (it.hasNext()) {
                LancamentoPlanoContaBean lancamento = (LancamentoPlanoContaBean)it.next();
                planoService.gravaAutoCopiaSemCommit(lancamento, 2, filial, filiais);
            }
        }
        this.dao.delete(bean, filial);
    }

    public AbstractThreadBean get(String filial, String codigoLancamento, String codigoEstacao) throws Exception {
        return ((LancamentoDao)this.dao).getBean(filial, codigoLancamento, codigoEstacao);
    }

    public AbstractThreadBean getVO(String filial, String codigoLancamento, String codigoEstacao) throws Exception {
        return ((LancamentoDao)this.dao).getVO(filial, codigoLancamento, codigoEstacao);
    }

    public Set getVOs(String filial, String codigoLancamento) throws Exception {
        return ((LancamentoDao)this.dao).getVOs(filial, codigoLancamento);
    }

    public AbstractThreadBean getLancamentoAberto(String filial, String codigoLancamento, String codigoEstacao) throws Exception {
        return ((LancamentoDao)this.dao).getLancamentoAberto(filial, codigoLancamento, codigoEstacao);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof LancamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        try {
            Set<LancamentoCentroCustoRPBean> centrosRP;
            Set<LancamentoPlanoContaRPBean> planosRP;
            Set centros;
            ContaCorrenteBean conta;
            if (((LancamentoBean)bean).getCodigo() == null) {
                ((LancamentoBean)bean).setCodigo(Integer.parseInt(codigo.toString()));
            }
            if (((LancamentoBean)bean).getContaCorrente() != null && (conta = (ContaCorrenteBean)new ContaCorrenteDao().getBean(filial, String.valueOf(((LancamentoBean)bean).getContaCorrente().getReduzido()))) != null && conta.getDataSaldoInicial() != null) {
                if (((LancamentoBean)bean).getDataVencimento() != null && ((LancamentoBean)bean).getDataVencimento().compareTo(conta.getDataSaldoInicial()) < 0) {
                    throw new Exception("A data de Vencimento do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Corrente/Caixa");
                }
                if (((LancamentoBean)bean).getDataCompetencia() != null && ((LancamentoBean)bean).getDataCompetencia().compareTo(conta.getDataSaldoInicial()) < 0) {
                    throw new Exception("A data de Compet\u00eancia do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Corrente/Caixa");
                }
                if (((LancamentoBean)bean).getDataConciliacao() != null && ((LancamentoBean)bean).getDataConciliacao().compareTo(conta.getDataSaldoInicial()) < 0) {
                    throw new Exception("A data de Concilia\u00e7\u00e3o do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Corrente/Caixa");
                }
            }
            if (((LancamentoBean)bean).getHistoricoPadrao() == null) {
                ContaCorrenteService serv = new ContaCorrenteService();
                ContaCorrenteVO conta2 = ((LancamentoBean)bean).getContaCorrente();
                ((LancamentoBean)bean).setHistoricoPadrao(serv.getHistoricoPadrao(conta2));
                if (((LancamentoBean)bean).getHistoricoPadrao() == null) {
                    throw new Exception("O hist\u00f3rico padr\u00e3o n\u00e3o foi configurado para a conta \"" + conta2.getConta() + "\".");
                }
            }
            this.dao.insert(bean, filial);
            Set planos = ((LancamentoBean)bean).getPlanosContas();
            if (planos != null) {
                Iterator it = planos.iterator();
                LancamentoPlanoContaService planoService = new LancamentoPlanoContaService();
                while (it.hasNext()) {
                    LancamentoPlanoContaBean lancamento = (LancamentoPlanoContaBean)it.next();
                    lancamento.setLancamento((LancamentoVO)((LancamentoBean)bean).toVO());
                    if (lancamento.isRemover()) {
                        planoService.delete(lancamento, null, filial, filiais);
                        continue;
                    }
                    if (lancamento.isInserir() && lancamento.getValor() > 0.0) {
                        planoService.insert(lancamento, null, filial, filiais);
                        continue;
                    }
                    if (!lancamento.isAlterar()) continue;
                    planoService.update(lancamento, null, filial, filiais);
                }
            }
            if ((centros = ((LancamentoBean)bean).getCentrosCusto()) != null) {
                Iterator it = centros.iterator();
                LancamentoCentroCustoService centroService = new LancamentoCentroCustoService();
                while (it.hasNext()) {
                    LancamentoCentroCustoBean lancamento = (LancamentoCentroCustoBean)it.next();
                    lancamento.setLancamento((LancamentoVO)((LancamentoBean)bean).toVO());
                    if (lancamento.isRemover()) {
                        centroService.delete(lancamento, null, filial, filiais);
                        continue;
                    }
                    if (lancamento.isInserir() && lancamento.getValor() > 0.0) {
                        centroService.insert(lancamento, null, filial, filiais);
                        continue;
                    }
                    if (!lancamento.isAlterar()) continue;
                    centroService.update(lancamento, null, filial, filiais);
                }
            }
            if ((planosRP = ((LancamentoBean)bean).getPlanosContasRP()) != null) {
                Iterator<LancamentoPlanoContaRPBean> it = planosRP.iterator();
                LancamentoPlanoContaRPService planoRPService = new LancamentoPlanoContaRPService();
                while (it.hasNext()) {
                    LancamentoPlanoContaRPBean lancamentoRP = it.next();
                    lancamentoRP.setLancamento((LancamentoVO)((LancamentoBean)bean).toVO());
                    planoRPService.insert(lancamentoRP, null, filial, filiais);
                }
            }
            if ((centrosRP = ((LancamentoBean)bean).getCentrosCustoRP()) != null) {
                Iterator<LancamentoCentroCustoRPBean> it = centrosRP.iterator();
                LancamentoCentroCustoRPService centroRPService = new LancamentoCentroCustoRPService();
                while (it.hasNext()) {
                    LancamentoCentroCustoRPBean lancamentoRP = it.next();
                    lancamentoRP.setLancamento((LancamentoVO)((LancamentoBean)bean).toVO());
                    centroRPService.insert(lancamentoRP, null, filial, filiais);
                }
            }
        }
        catch (ThreadDaoException e) {
            throw new Exception(e.getMessage());
        }
    }

    public boolean validaCheque(LancamentoBean bean) throws SQLException {
        if (bean.getTipoPagamento() != null && (bean.getTipoPagamento().equalsIgnoreCase("H") || bean.getTipoPagamento().equalsIgnoreCase("T") || bean.getTipoPagamento().equalsIgnoreCase("A") || bean.getTipoPagamento().equalsIgnoreCase("P"))) {
            if (bean.getBanco() != null && bean.getAgencia() != null && bean.getConta() != null && bean.getNumeroCheque() != null) {
                String cheque;
                String conta;
                String agencia;
                String banco = bean.getBanco().toString();
                HashSet setLanctos = (HashSet)new LancamentoDao().validaCheque(banco, agencia = bean.getAgencia(), conta = bean.getConta(), cheque = bean.getNumeroCheque());
                return setLanctos == null || setLanctos.size() <= 0;
            }
            return true;
        }
        return true;
    }

    public Set<LancamentoVO> getChequesUsados(LancamentoBean bean) throws SQLException {
        if (bean.getTipoPagamento() != null && (bean.getTipoPagamento().equalsIgnoreCase("H") || bean.getTipoPagamento().equalsIgnoreCase("T") || bean.getTipoPagamento().equalsIgnoreCase("A") || bean.getTipoPagamento().equalsIgnoreCase("P"))) {
            if (bean.getBanco() != null && bean.getAgencia() != null && bean.getConta() != null && bean.getNumeroCheque() != null) {
                String cheque;
                String conta;
                String agencia;
                String banco = bean.getBanco().toString();
                HashSet setLanctos = (HashSet)new LancamentoDao().validaCheque(banco, agencia = bean.getAgencia(), conta = bean.getConta(), cheque = bean.getNumeroCheque());
                if (setLanctos != null && setLanctos.size() > 0) {
                    return setLanctos;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(LancamentoBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(LancamentoVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, "", mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String appendFiltro, boolean mostrarCadastro) {
        StringBuilder b = new StringBuilder("select l.fil_codigo, l.est_codigo, l.lcx_codigo, l.lcx_documento, l.lcx_vencimento, l.lcx_conciliacao, l.cco_reduzido, l.lcx_valor, ");
        b.append("l.lcx_valortotal,  ");
        b.append("unnest(array_agg(rl.req_codigo)) as requisicao ");
        b.append("from lanctocaixa l ");
        b.append("left join requisicaolanctocaixa rl on l.fil_codigo = rl.fil_codigo and l.lcx_codigo = rl.lcx_codigo and l.est_codigo = rl.est_codigo ");
        FrmPesquisa tela = FrmPesquisa.novaInstancia(owner, titulo);
        tela.adicionaCampo("fil_codigo", "Filial", 1, "", 3, 3);
        tela.adicionaCampo("est_codigo", "Esta\u00e7\u00e3o", 1, "", 3, 3);
        tela.adicionaCampo("l.lcx_codigo", "C\u00f3digo", 1, "", 3, 0);
        tela.adicionaCampo("lcx_documento", "Documento", 0, "", 2, 0);
        tela.adicionaCampo("lcx_vencimento", "Vencimento", 2, "", 3, 0);
        tela.adicionaCampo("lcx_conciliacao", "Concilia\u00e7\u00e3o", 2, "", 3, 0);
        tela.adicionaCampo("cco_reduzido", "C\u00f3d. Conta", 1, "", 3, 0);
        tela.adicionaCampo("lcx_valor", "Valor", 1, "", 3, 0);
        tela.adicionaCampo("lcx_valortotal", "Valor Total", 1, "", 3, 0);
        tela.adicionaCampo("rl.req_codigo", "Requisi\u00e7\u00e3o", 1, "", 3, 0);
        tela.setFiltroInicial("Documento", 2);
        tela.setFiltro("l.fil_codigo = " + Variaveis.filialPadrao + appendFiltro);
        tela.setOrdem("C\u00f3digo");
        tela.setSql(b.toString());
        tela.setGroupBy("group by l.fil_codigo, l.est_codigo, l.lcx_codigo, l.lcx_documento, l.lcx_vencimento, l.lcx_conciliacao, l.cco_reduzido, l.lcx_valor, l.lcx_valortotal");
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return null != tela.getRegistroSelecionado() ? this.converterParaVO(tela.getRegistroSelecionado()) : null;
    }

    private LancamentoVO converterParaVO(Hashtable<String, Object> hash) {
        LancamentoVO vo = new LancamentoVO();
        FilialVO fil = new FilialVO();
        fil.setCodigo((Integer)hash.get("fil_codigo"));
        EstacaoVO est = new EstacaoVO();
        est.setCodigo((Integer)hash.get("est_codigo"));
        ContaCorrenteVO con = new ContaCorrenteVO();
        con.setReduzido((Integer)hash.get("cco_reduzido"));
        vo.setFilial(fil);
        vo.setEstacao(est);
        vo.setContaCorrente(con);
        vo.setCodigo((Integer)hash.get("lcx_codigo"));
        vo.setDataConciliacao(null != hash.get("lcx_conciliacao") && !Funcoes.textoVazio(hash.get("lcx_conciliacao").toString()) ? Funcoes.stringToDate("dd/MM/yyyy", hash.get("lcx_conciliacao").toString()) : null);
        vo.setDataVencimento(null != hash.get("lcx_vencimento") && !Funcoes.textoVazio(hash.get("lcx_vencimento").toString()) ? Funcoes.stringToDate("dd/MM/yyyy", hash.get("lcx_vencimento").toString()) : null);
        vo.setDocumento(null != hash.get("lcx_documento") ? hash.get("lcx_documento").toString() : null);
        return vo;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        Set centros;
        ContaCorrenteBean conta;
        if (!(bean instanceof LancamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        if (bean instanceof LancamentoBean && ((LancamentoBean)bean).getHistoricoPadrao() == null) {
            ContaCorrenteService serv = new ContaCorrenteService();
            ContaCorrenteVO conta2 = ((LancamentoBean)bean).getContaCorrente();
            ((LancamentoBean)bean).setHistoricoPadrao(serv.getHistoricoPadrao(conta2));
        }
        if (((LancamentoBean)bean).getContaCorrente() != null && (conta = (ContaCorrenteBean)new ContaCorrenteDao().getBean(filial, String.valueOf(((LancamentoBean)bean).getContaCorrente().getReduzido()))) != null && conta.getDataSaldoInicial() != null) {
            if (((LancamentoBean)bean).getDataVencimento() != null && ((LancamentoBean)bean).getDataVencimento().compareTo(conta.getDataSaldoInicial()) < 0) {
                throw new Exception("A data de Vencimento do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Corrente/Caixa");
            }
            if (((LancamentoBean)bean).getDataCompetencia() != null && ((LancamentoBean)bean).getDataCompetencia().compareTo(conta.getDataSaldoInicial()) < 0) {
                throw new Exception("A data de Compet\u00eancia do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Corrente/Caixa");
            }
            if (((LancamentoBean)bean).getDataConciliacao() != null && ((LancamentoBean)bean).getDataConciliacao().compareTo(conta.getDataSaldoInicial()) < 0) {
                throw new Exception("A data de Concilia\u00e7\u00e3o do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Corrente/Caixa");
            }
        }
        this.dao.update(bean, filial);
        Set planos = ((LancamentoBean)bean).getPlanosContas();
        if (planos != null) {
            Iterator it = planos.iterator();
            LancamentoPlanoContaService planoService = new LancamentoPlanoContaService();
            while (it.hasNext()) {
                LancamentoPlanoContaBean lancamento = (LancamentoPlanoContaBean)it.next();
                lancamento.setLancamento((LancamentoVO)((LancamentoBean)bean).toVO());
                if (lancamento.isRemover()) {
                    planoService.delete(lancamento, null, filial, filiais);
                    continue;
                }
                if (lancamento.isInserir() && lancamento.getValor() > 0.0) {
                    planoService.insert(lancamento, null, filial, filiais);
                    continue;
                }
                if (!lancamento.isAlterar()) continue;
                planoService.update(lancamento, null, filial, filiais);
            }
        }
        if ((centros = ((LancamentoBean)bean).getCentrosCusto()) != null) {
            Iterator it = centros.iterator();
            LancamentoCentroCustoService centroService = new LancamentoCentroCustoService();
            while (it.hasNext()) {
                LancamentoCentroCustoBean lancamento = (LancamentoCentroCustoBean)it.next();
                lancamento.setLancamento((LancamentoVO)((LancamentoBean)bean).toVO());
                if (lancamento.isRemover()) {
                    centroService.delete(lancamento, null, filial, filiais);
                    continue;
                }
                if (lancamento.isInserir() && lancamento.getValor() > 0.0) {
                    centroService.insert(lancamento, null, filial, filiais);
                    continue;
                }
                if (!lancamento.isAlterar()) continue;
                centroService.update(lancamento, null, filial, filiais);
            }
        }
    }

    public void cancelamento(LancamentoBean bean) throws Exception {
        this.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, null);
    }

    public boolean transferenciaEntreContas(ContaCorrenteVO contaOrigem, ContaCorrenteVO contaDestino, Date data, Double valor, LancamentoBean lanctoAux, FilialVO filial, UsuarioVO usuario, EstacaoVO estacao, HistoricoPadraoVO historicoOrigem, HistoricoPadraoVO historicoDestino, boolean entreFilial, ArrayList<?> planoContaOigem, ArrayList<?> centroCustoOrigem, ArrayList<?> planoContaDestino, ArrayList<?> centroCustoDestino) throws Exception {
        ContaCorrenteBean conta;
        if (contaOrigem != null && (conta = (ContaCorrenteBean)new ContaCorrenteDao().getBean(String.valueOf(contaOrigem.getFilial().getCodigo()), String.valueOf(contaOrigem.getReduzido()))) != null) {
            if (conta.getDataSaldoInicial() == null) {
                throw new Exception("A data do saldo inicial da conta origem n\u00e3o foi informada.");
            }
            if (data != null && data.compareTo(conta.getDataSaldoInicial()) < 0) {
                throw new ConstrutorException("A data do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Origem: " + conta.getConta());
            }
        }
        if (contaOrigem != null && (conta = (ContaCorrenteBean)new ContaCorrenteDao().getBean(String.valueOf(contaDestino.getFilial().getCodigo()), String.valueOf(contaDestino.getReduzido()))) != null) {
            if (conta.getDataSaldoInicial() == null) {
                throw new Exception("A data do saldo inicial da conta destino n\u00e3o foi informada.");
            }
            if (data != null && data.compareTo(conta.getDataSaldoInicial()) < 0) {
                throw new ConstrutorException("A data do Lan\u00e7amento deve ser maior ou igual a data do Saldo Inicial da Conta Destino: " + conta.getConta());
            }
        }
        LancamentoBean lc = new LancamentoBean();
        lc.setFilial(filial);
        lc.setTipo("D");
        lc.setDataHora(new Date());
        lc.setDataVencimento(data);
        lc.setDataConciliacao(data);
        lc.setDataCompetencia(data);
        lc.setValor(valor);
        lc.setUsuario(usuario);
        lc.setContaCorrente(contaOrigem);
        lc.setEstacao(estacao);
        lc.setValorTotal(valor);
        lc.setValorMulta(0.0);
        lc.setValorJuro(0.0);
        lc.setValorAcrescimo(0.0);
        lc.setValorDesconto(0.0);
        lc.setPercentualMulta(0.0);
        lc.setPercentualJuro(0.0);
        lc.setPercentualAcrescimo(0.0);
        lc.setPercentualDesconto(0.0);
        lc.setHistoricoPadrao(historicoOrigem);
        lc.setSituacao("O");
        if (!entreFilial) {
            lc.setTipoOrigem("E");
        } else {
            lc.setTipoOrigem("F");
        }
        if (lanctoAux != null && lanctoAux.getFilialTransferencia() != null && entreFilial) {
            lc.setFilialTransferencia(lanctoAux.getFilialTransferencia());
        }
        if (lanctoAux != null && lanctoAux.getTipoPagamento() != null) {
            lc.setTipoPagamento(lanctoAux.getTipoPagamento());
            lc.setObservacao(lanctoAux.getObservacao());
            lc.setTipoDocumento(lanctoAux.getTipoDocumento());
            lc.setBanco(lanctoAux.getBanco());
            lc.setAgencia(lanctoAux.getAgencia());
            lc.setConta(lanctoAux.getConta());
            lc.setNumeroCheque(lanctoAux.getNumeroCheque());
            lc.setValidadeCartao(lanctoAux.getValidadeCartao());
            lc.setNumeroCartao(lanctoAux.getNumeroCartao());
            lc.setCartaoCredito(lanctoAux.getCartaoCredito());
            lc.setNumeroDocumento(lanctoAux.getNumeroDocumento());
            lc.setSacado(lanctoAux.getSacado());
            lc.setDescricaoHistorico(historicoOrigem.getDescricao());
            if (!Funcoes.textoVazio(lanctoAux.getTipoTransferencia())) {
                lc.setTipoTransferencia(lanctoAux.getTipoTransferencia());
            }
            if (null != lanctoAux.getDataVencimento()) {
                lc.setDataVencimento(lanctoAux.getDataVencimento());
            }
            if (!Funcoes.textoVazio(lanctoAux.getPix())) {
                lc.setPix(lanctoAux.getPix());
            }
        }
        lc.setPlanosContas(new HashSet(planoContaOigem));
        lc.setCentrosCusto(new HashSet(centroCustoOrigem));
        this.gravaAutoCopiaSemCommit(lc, 0, filial.getCodigo().toString(), null);
        int codigo = lc.getCodigo();
        lc = new LancamentoBean();
        if (!entreFilial) {
            lc.setFilial(filial);
        } else {
            lc.setFilial(lanctoAux.getFilialTransferencia());
        }
        lc.setTipo("C");
        lc.setDataHora(new Date());
        lc.setDataVencimento(data);
        lc.setDataConciliacao(data);
        lc.setDataCompetencia(data);
        lc.setValor(valor);
        lc.setUsuario(usuario);
        lc.setContaCorrente(contaDestino);
        lc.setEstacao(estacao);
        lc.setValorTotal(valor);
        lc.setValorMulta(0.0);
        lc.setValorJuro(0.0);
        lc.setValorAcrescimo(0.0);
        lc.setValorDesconto(0.0);
        lc.setPercentualMulta(0.0);
        lc.setPercentualJuro(0.0);
        lc.setPercentualAcrescimo(0.0);
        lc.setPercentualDesconto(0.0);
        lc.setHistoricoPadrao(historicoDestino);
        lc.setSituacao("O");
        if (!entreFilial) {
            lc.setTipoOrigem("E");
        } else {
            lc.setTipoOrigem("F");
        }
        if (entreFilial) {
            lc.setFilialTransferencia(filial);
        }
        lc.setComplementarCodigo(codigo);
        lc.setComplementarEstacao(estacao);
        if (lanctoAux != null && lanctoAux.getTipoPagamento() != null) {
            lc.setTipoPagamento(lanctoAux.getTipoPagamento());
            lc.setObservacao(lanctoAux.getObservacao());
            lc.setTipoDocumento(lanctoAux.getTipoDocumento());
            lc.setBanco(lanctoAux.getBanco());
            lc.setAgencia(lanctoAux.getAgencia());
            lc.setConta(lanctoAux.getConta());
            lc.setNumeroCheque(lanctoAux.getNumeroCheque());
            lc.setValidadeCartao(lanctoAux.getValidadeCartao());
            lc.setNumeroCartao(lanctoAux.getNumeroCartao());
            lc.setCartaoCredito(lanctoAux.getCartaoCredito());
            lc.setNumeroDocumento(lanctoAux.getNumeroDocumento());
            lc.setSacado(lanctoAux.getSacado());
            lc.setDescricaoHistorico(historicoDestino.getDescricao());
        }
        lc.setPlanosContas(new HashSet(planoContaDestino));
        lc.setCentrosCusto(new HashSet(centroCustoDestino));
        if (!entreFilial) {
            this.gravaAutoCopiaSemCommit(lc, 0, filial.getCodigo().toString(), null);
        } else {
            this.gravaAutoCopiaSemCommit(lc, 0, lanctoAux.getFilialTransferencia().getCodigo().toString(), null);
        }
        return true;
    }

    public boolean isOrigemBaixa(LancamentoBean bean) throws Exception {
        try {
            BaixaBean baixa;
            BaixaLancamentoBean baixalancto = new BaixaLancamentoService().getBaixaOrigemLancamento(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString(), bean.getEstacao().getCodigo().toString());
            if (baixalancto != null && (baixa = (BaixaBean)new BaixaDao().getBean(baixalancto.getBaixa().getCodigo().toString())) != null) {
                return true;
            }
        }
        catch (ThreadDaoException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar origem do Lan\u00e7amento.\n" + e.getMessage());
        }
        return false;
    }

    public BaixaBean getBaixaOrigem(LancamentoBean bean) throws Exception {
        try {
            BaixaLancamentoBean baixalancto = new BaixaLancamentoService().getBaixaOrigemLancamento(bean.getFilial().getCodigo().toString(), bean.getCodigo().toString(), bean.getEstacao().getCodigo().toString());
            if (baixalancto != null) {
                BaixaBean baixa = (BaixaBean)new BaixaDao().getBean(baixalancto.getBaixa().getCodigo().toString());
                return baixa;
            }
        }
        catch (ThreadDaoException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar origem do Lan\u00e7amento.\n" + e.getMessage());
        }
        return null;
    }

    public Integer getRequisicaoOrigem(LancamentoBean bean) throws Exception {
        try {
            return ((LancamentoDao)this.dao).getRequisicaoOrigem(bean);
        }
        catch (SQLException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar requisicao associada ao lan\u00e7amento.\n" + e.getMessage());
        }
    }

    public boolean estornoCancelamento(LancamentoBean bean, String origemNovoLancto, boolean gerarNovoLancamento, ContaCorrenteVO contaNovoLancamento) throws Exception {
        if (bean == null) {
            return false;
        }
        LancamentoBean original = bean;
        EstacaoVO estacao = new EstacaoVO();
        estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        bean = (LancamentoBean)bean.clonar();
        bean.setEstacao(estacao);
        bean.setCodigo(null);
        if (contaNovoLancamento != null) {
            bean.setContaCorrente(contaNovoLancamento);
        }
        for (LancamentoPlanoContaBean plano : (HashSet)bean.getPlanosContas()) {
            plano.setEstacao(estacao);
            plano.setInserir(true);
        }
        for (LancamentoCentroCustoBean centro : (HashSet)bean.getCentrosCusto()) {
            centro.setEstacao(estacao);
            centro.setInserir(true);
        }
        bean.setObservacao("Lan\u00e7amento gerado por \"" + Tipos.tipoOrigemLancamento(origemNovoLancto) + "\" - C\u00f3d.: " + original.getCodigo() + ", Filial: " + bean.getFilial().getCodigo() + ", Estacao: " + bean.getEstacao().getCodigo().toString() + ".");
        bean.setTipoOrigem(origemNovoLancto);
        bean.setComplementarEstacao(estacao);
        bean.setComplementarCodigo(original.getCodigo());
        bean.setCodigo(null);
        if (!bean.getSituacao().equalsIgnoreCase("O")) {
            bean.setSituacao("C");
        }
        bean.setUsuarioCancelado(usuario);
        bean.setDataCancelado(new Date());
        bean.setDataHora(new Date());
        if (Funcoes.textoVazio(bean.getDescricaoCancelado())) {
            bean.setDescricaoCancelado("Cancelado automaticamente.");
            bean.setMotivoCancelado(null);
        }
        if (bean.getTipo().equalsIgnoreCase("D")) {
            bean.setTipo("C");
        } else {
            bean.setTipo("D");
        }
        try {
            this.gravaAutoCopiaSemCommit(bean, 0, bean.getFilial().getCodigo().toString(), null);
        }
        catch (Exception e) {
            throw new Exception("N\u00e3o foi poss\u00edvel gerar o Lan\u00e7amento Complementar.\n" + e.getMessage());
        }
        if (origemNovoLancto.equalsIgnoreCase("L") || origemNovoLancto.equalsIgnoreCase("X") || origemNovoLancto.equalsIgnoreCase("R") || origemNovoLancto.equalsIgnoreCase("S") || origemNovoLancto.equalsIgnoreCase("P")) {
            try {
                bean.setSituacao("C");
                this.gravaAutoCopiaSemCommit(bean, 1, bean.getFilial().getCodigo().toString(), null);
            }
            catch (Exception e) {
                throw new Exception("N\u00e3o foi poss\u00edvel cancelar o Lan\u00e7amento Complementar.\n" + e.getMessage());
            }
        }
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" update lanctocaixa ");
            buf.append("    set lcx_situacao = '").append("C").append("' ");
            buf.append("        ,usr_codcancelado = '").append(Variaveis.login).append("' ");
            buf.append("        ,lcx_datacancelado = now() ");
            if (origemNovoLancto.equalsIgnoreCase("L") || origemNovoLancto.equalsIgnoreCase("X") || origemNovoLancto.equalsIgnoreCase("R") || origemNovoLancto.equalsIgnoreCase("S") || origemNovoLancto.equalsIgnoreCase("P")) {
                buf.append("        ,lcx_descricaocancelado = 'Lan\u00e7amento Estornado. ").append(original.getDescricaoCancelado() == null ? "" : original.getDescricaoCancelado()).append("' ");
            } else {
                buf.append("        ,lcx_descricaocancelado = 'Lan\u00e7amento Cancelado. ").append(original.getDescricaoCancelado() == null ? "" : original.getDescricaoCancelado()).append("' ");
            }
            if (original.getMotivoCancelado() != null) {
                buf.append("        ,mov_codigo = ").append(original.getMotivoCancelado().getCodigo().toString());
            }
            buf.append("  where fil_codigo = ").append(original.getFilial().getCodigo());
            buf.append("    and lcx_codigo = ").append(original.getCodigo());
            buf.append("    and est_codigo = ").append(original.getEstacao().getCodigo());
            int qtde = Conexao.executeUpdate(String.valueOf(original.getFilial().getCodigo()), Conexao.getStatement(), buf.toString());
            if (qtde == 0) {
                throw new SQLException("Nenhum Lan\u00e7amento atualizado. (C\u00f3d.: " + original.getCodigo() + ", Fil.: " + original.getFilial().getCodigo() + "Est.: " + original.getEstacao().getCodigo() + ")");
            }
        }
        catch (SQLException sqle) {
            throw new Exception("N\u00e3o foi poss\u00edvel estornar/cancelar o Lan\u00e7amento.\n" + sqle.getMessage());
        }
        if (origemNovoLancto.equalsIgnoreCase("S")) {
            LancamentoBean complementar = this.getLancamentoParTransferencia(original);
            if (complementar == null) {
                throw new Exception("N\u00e3o foi poss\u00edvel estornar a transfer\u00eancia. Lan\u00e7amento complementar nulo.");
            }
            if (complementar.getSituacao().equalsIgnoreCase("O")) {
                this.estornoCancelamento(complementar, "S", false, null);
            }
        }
        if (origemNovoLancto.equalsIgnoreCase("L") && gerarNovoLancamento) {
            bean.setSituacao("A");
            bean.setDataConciliacao(null);
            bean.setCodigo(null);
            bean.setDataCancelado(null);
            bean.setUsuarioCancelado(null);
            bean.setDescricaoCancelado("");
            if (bean.getTipo().equalsIgnoreCase("D")) {
                bean.setTipo("C");
            } else {
                bean.setTipo("D");
            }
            bean.setObservacao("Lan\u00e7amento gerado por \"" + Tipos.tipoOrigemLancamento(origemNovoLancto) + "\" - C\u00f3d.: " + original.getCodigo() + ", Filial: " + bean.getFilial().getCodigo() + ", Estacao: " + bean.getEstacao().getCodigo().toString() + ".");
            bean.setTipoOrigem("U");
            try {
                this.gravaAutoCopiaSemCommit(bean, 0, bean.getFilial().getCodigo().toString(), null);
            }
            catch (Exception e) {
                throw new Exception(" N\u00e3o foi poss\u00edvel gerar o novo Lan\u00e7amento.\n" + e.getMessage());
            }
        }
        if (origemNovoLancto.equalsIgnoreCase("R")) {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select req_codigo as codigo ");
            buf.append("   from requisicaolanctocaixa ");
            buf.append("  where fil_codigo = ").append(original.getFilial().getCodigo());
            buf.append("    and lcx_codigo = ").append(original.getCodigo());
            buf.append("    and est_codigo = ").append(original.getEstacao().getCodigo());
            ResultSet rs = null;
            try {
                rs = Conexao.executeQuery(st, buf);
            }
            catch (SQLException e) {
                throw new Exception("N\u00e3o foi poss\u00edvel buscar requisi\u00e7\u00e3o associada ao lan\u00e7amento.\n" + e.getMessage());
            }
            try {
                String codigoRequisicao;
                if (rs.next() && (codigoRequisicao = rs.getString("codigo")) != null) {
                    buf.delete(0, buf.length());
                    buf.append("insert into requisicaolanctocaixa (fil_codigo, req_codigo, lcx_codigo, est_codigo) values (");
                    buf.append(bean.getFilial().getCodigo());
                    buf.append(", ");
                    buf.append(codigoRequisicao);
                    buf.append(", ");
                    buf.append(bean.getCodigo());
                    buf.append(", ");
                    buf.append(bean.getEstacao().getCodigo());
                    buf.append(")");
                    Conexao.executeUpdate(String.valueOf(original.getFilial().getCodigo()), st, buf);
                }
            }
            catch (SQLException e) {
                throw new Exception("N\u00e3o foi poss\u00edvel associar o lan\u00e7amento de estorno \u00e0 requisi\u00e7\u00e3o.\n" + e.getMessage());
            }
        }
        return true;
    }

    public LancamentoBean getLancamentoParTransferencia(LancamentoBean lanctoBean) throws Exception {
        if (lanctoBean == null) {
            return null;
        }
        if (lanctoBean.getTipoOrigem() == null || !lanctoBean.getTipoOrigem().equalsIgnoreCase("E")) {
            return null;
        }
        if (lanctoBean.getTipo() == null) {
            return null;
        }
        if (lanctoBean.getTipo().equalsIgnoreCase("D")) {
            LancamentoBean lanctoPar = null;
            try {
                lanctoPar = (LancamentoBean)new LancamentoDao().getComplementarBean(String.valueOf(lanctoBean.getFilial().getCodigo()), String.valueOf(lanctoBean.getCodigo()), String.valueOf(lanctoBean.getEstacao().getCodigo()));
            }
            catch (ThreadDaoException e) {
                throw new Exception("N\u00e3o foi poss\u00edvel buscar o lan\u00e7amento complementar da transfer\u00eancia.\n" + e.getMessage());
            }
            return lanctoPar;
        }
        if (lanctoBean.getComplementarCodigo() == null || lanctoBean.getComplementarEstacao() == null) {
            return null;
        }
        LancamentoBean lanctoPar = null;
        try {
            lanctoPar = (LancamentoBean)new LancamentoDao().getBean(String.valueOf(lanctoBean.getFilial().getCodigo()), String.valueOf(lanctoBean.getComplementarCodigo()), String.valueOf(lanctoBean.getComplementarEstacao().getCodigo()));
        }
        catch (ThreadDaoException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar o lan\u00e7amento complementar da transfer\u00eancia.\n" + e.getMessage());
        }
        return lanctoPar;
    }

    public boolean conciliarLancamentoConta(LancamentoBean lancamento, ContaCorrenteVO conta, Date dataConciliacao) throws Exception {
        if (lancamento == null || lancamento.getContaCorrente() == null || lancamento.getSituacao() == null || !lancamento.getSituacao().equalsIgnoreCase("A")) {
            return false;
        }
        if (conta == null) {
            return false;
        }
        if (lancamento.getContaCorrente().getReduzido().equals(conta.getReduzido())) {
            lancamento.setDataConciliacao(dataConciliacao);
            lancamento.setSituacao("O");
            this.gravaAutoCopiaSemCommit(lancamento, 1, Variaveis.filialPadrao, null);
        } else {
            if (!this.estornoCancelamento(lancamento, "O", false, null)) {
                return false;
            }
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            EstacaoVO estacao = new EstacaoVO();
            estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
            LancamentoBean novoLancto = (LancamentoBean)lancamento.clonar();
            novoLancto.setCodigo(null);
            novoLancto.setEstacao(estacao);
            novoLancto.setUsuario(usuario);
            novoLancto.setComplementarCodigo(lancamento.getCodigo());
            novoLancto.setComplementarEstacao(lancamento.getEstacao());
            novoLancto.setTipoOrigem("O");
            novoLancto.setContaCorrente(conta);
            this.gravaAutoCopiaSemCommit(novoLancto, 0, Variaveis.filialPadrao, null);
            novoLancto.setDataConciliacao(dataConciliacao);
            novoLancto.setSituacao("O");
            this.gravaAutoCopiaSemCommit(novoLancto, 1, Variaveis.filialPadrao, null);
        }
        return true;
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    public LancamentoBean getPagamentoDestino(LancamentoBean lanctoBean) throws Exception {
        if (lanctoBean == null) {
            return null;
        }
        LancamentoBean lanctoAux = null;
        try {
            while (true) {
                if ((lanctoBean = (LancamentoBean)new LancamentoDao().getBeanComplementar(lanctoBean.getFilial().getCodigo().toString(), lanctoBean.getCodigo().toString(), lanctoBean.getEstacao().getCodigo().toString(), true)) == null) {
                    return lanctoAux;
                }
                lanctoAux = lanctoBean;
            }
        }
        catch (ThreadDaoException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar o lan\u00e7amento de origem da transfer\u00eancia de pagamento.\n" + e.getMessage());
        }
    }

    public LancamentoBean getPagamentoDestinoNaoCancelado(LancamentoBean lanctoBean) throws Exception {
        if (lanctoBean == null) {
            return null;
        }
        LancamentoBean lanctoAux = null;
        try {
            while (true) {
                if ((lanctoBean = (LancamentoBean)new LancamentoDao().getBeanComplementar(lanctoBean.getFilial().getCodigo().toString(), lanctoBean.getCodigo().toString(), lanctoBean.getEstacao().getCodigo().toString(), false)) == null) {
                    return lanctoAux;
                }
                lanctoAux = lanctoBean;
            }
        }
        catch (ThreadDaoException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar o lan\u00e7amento de origem da transfer\u00eancia de pagamento.\n" + e.getMessage());
        }
    }

    public LancamentoBean getPagamentoOrigem(LancamentoBean lanctoBean) throws Exception {
        if (lanctoBean == null) {
            return null;
        }
        if (lanctoBean.getTipoOrigem() == null || !lanctoBean.getTipoOrigem().equalsIgnoreCase("P")) {
            return null;
        }
        if (lanctoBean.getTipo() == null) {
            return null;
        }
        if (lanctoBean.getComplementarCodigo() == null || lanctoBean.getComplementarEstacao() == null) {
            return null;
        }
        LancamentoBean lanctoOrigem = null;
        try {
            while ((lanctoOrigem = (LancamentoBean)new LancamentoDao().getBean(String.valueOf(lanctoBean.getFilial().getCodigo()), String.valueOf(lanctoBean.getComplementarCodigo()), String.valueOf(lanctoBean.getComplementarEstacao().getCodigo()))).getComplementarCodigo() != null && lanctoOrigem.getComplementarEstacao() != null) {
            }
            return lanctoOrigem;
        }
        catch (ThreadDaoException e) {
            throw new Exception("N\u00e3o foi poss\u00edvel buscar o lan\u00e7amento de origem da transfer\u00eancia de pagamento.\n" + e.getMessage());
        }
    }
}

