/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.financeiro.FaturaDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.service.AbstractThreadService;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public class FaturaService
extends AbstractThreadService {
    public FaturaService() {
        this.dao = new FaturaDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((FaturaDao)this.dao).getBean(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((FaturaDao)this.dao).getVO(filial, codigo);
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(FaturaBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(FaturaVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public Hashtable pesquisaFaturasConvenio(Object owner, String codigoConvenio, String fantasiaConvenio) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando faturas conferidas do conv\u00eanio " + fantasiaConvenio);
        String codigoFatura = "fat.fat_codigo";
        String fantasiaConvenioAux = "con.con_fantasia";
        String dataVencFatura = "fat.fat_dtvenc";
        String dataEmisFatura = "fat.fat_dtemis";
        String totalExames = "COALESCE(fat.fat_totalexames, 0)";
        String totalMateriais = "COALESCE(fat.fat_totalmateriais, 0)";
        String total = "fat_totalexames + fat_totalmateriais + fat_adicional + fat_despcobranca + ((fat_totalexames + fat_totalmateriais) * fat_percacrescimo / 100) - ((fat_totalexames + fat_totalmateriais) * fat_percdesconto / 100)";
        String totalRestante = "(fat_totalexames + fat_totalmateriais + fat_adicional + fat_despcobranca + ((fat_totalexames + fat_totalmateriais) * fat_percacrescimo / 100) - ((fat_totalexames + fat_totalmateriais) * fat_percdesconto / 100)) - SUM(COALESCE(fnf.fnf_valorfatura, 0))";
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("select ").append(codigoFatura).append(" as codigo ");
            buf.append(", ").append(fantasiaConvenioAux);
            buf.append(", ").append(dataVencFatura);
            buf.append(", ").append(dataEmisFatura);
            buf.append(", ").append(totalExames);
            buf.append(", ").append(totalMateriais);
            buf.append(", ").append(total);
            buf.append(", ").append(totalRestante).append(" as valorrestante");
            buf.append("  from fatura fat ");
            buf.append("  join convenios con on fat.fil_codigo = con.fil_codigo and fat.con_codigo = con.con_codigo ");
            buf.append("  left join faturanotafiscal fnf on fat.fil_codigo = fnf.fil_codigo and fat.fat_codigo = fnf.fat_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo(codigoFatura, "C\u00f3digo", 1, "", 3, 0);
            p.adicionaCampo(fantasiaConvenioAux, "Conv\u00eanio", 0, "", 2, 0);
            p.adicionaCampo(dataVencFatura, "Vencimento", 2, "", 0, 0);
            p.adicionaCampo(dataEmisFatura, "Emiss\u00e3o", 2, "", 0, 0);
            p.adicionaCampo(totalExames, "Total Exames", 1, "", 3, 0);
            p.adicionaCampo(totalMateriais, "Total Materiais", 1, "", 3, 0);
            p.adicionaCampo(total, "Total Fatura", 7, "", 3, 0);
            p.adicionaCampo(totalRestante, "Valor Restante", 7, "", 3, 0);
            p.setFiltroInicial("C\u00f3digo", 3);
            p.setOrdem("C\u00f3digo");
            buf.setLength(0);
            buf.append(" fat.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and fat.con_codigo = ").append(codigoConvenio);
            buf.append(" and fat.fat_dtconferencia IS NOT NULL ");
            buf.append(" and fat.fat_datacancelamento IS NULL ");
            p.setFiltro(buf.toString());
            buf.setLength(0);
            buf.append(" group by fat.fat_codigo ");
            buf.append(" ,con.con_fantasia ");
            buf.append(" ,fat.fat_dtemis ");
            buf.append(" ,fat.fat_dtvenc ");
            buf.append(" ,fat.fat_totalexames ");
            buf.append(" ,fat.fat_totalmateriais ");
            buf.append(" , ").append(total);
            buf.append(" having (COALESCE(fat.fat_totalexames, 0) + COALESCE(fat.fat_totalmateriais, 0)) - SUM(COALESCE(fnf.fnf_valorfatura, 0)) > 0 ");
            p.setGroupBy(buf.toString());
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof FaturaBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    public boolean isFaturaConferida(String filial, String codigoFatura) throws SQLException {
        return ((FaturaDao)this.dao).isFaturaConferida(filial, codigoFatura);
    }

    public boolean isComissaoGerada(String filial, String codigoFatura) throws SQLException {
        if (filial == null || codigoFatura == null) {
            return false;
        }
        return ((FaturaDao)this.dao).isComissaoGerada(filial, codigoFatura);
    }

    public ArrayList<ReceberPagarBean> getTitulosComissaoFatura(String codigoFilial, String codigoFatura) throws Exception {
        return ((FaturaDao)this.dao).getTitulosComissaoFatura(codigoFilial, codigoFatura);
    }

    public BigDecimal getValorRestanteFatura(String codigoFilial, String codigoFatura) throws SQLException {
        return ((FaturaDao)this.dao).getValorRestanteFatura(codigoFilial, codigoFatura);
    }
}

