/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.financeiro.contrassenha.Exames;
import jalis.laboratorio.financeiro.contrassenha.RequisicaoContrassenhaVO;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.ContrasSenhaBean;
import jalis.model.dao.financeiro.ContrasSenhaDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.financeiro.ContrasSenhaVO;
import jalis.model.vo.recepcao.ContrasSenhaRequisicaoVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.AbstractThreadService;
import jalis.service.recepcao.ContrasSenhaRequisicaoService;
import jalis.util.ExameUtil;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class ContrasSenhaService
extends AbstractThreadService {
    private ContrasSenhaDao dao = new ContrasSenhaDao();

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ContrasSenhaBean) {
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ContrasSenhaBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ContrasSenhaBean) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public Set load(String where) throws Exception {
        return ContrasSenhaDao.load(ContrasSenhaBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ContrasSenhaVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    public String retornaPacienteNome(String filial, String codPaciente) throws SQLException {
        return this.dao.retornaPacienteNome(filial, codPaciente);
    }

    public List<RequisicaoContrassenhaVO> getDadosRequisicaoContrassenha(String codigoPaciente) throws SQLException {
        return this.dao.getDadosRequisicaoContrassenha(codigoPaciente);
    }

    public Exames getDadosExameRequisicaoContrassenha(String filial, String codiogRequisicao) throws SQLException {
        Exames e = new Exames();
        List<ExameRequisicaoVO> listaContrassenhaExame = this.dao.getDadosExameRequisicaoContrassenha(filial, codiogRequisicao);
        for (ExameRequisicaoVO contrassenhaExameRequisicaoVO : listaContrassenhaExame) {
            DadosMaterial m = ExameUtil.getDadosMaterial(filial, contrassenhaExameRequisicaoVO.getMaterial().getCodigo());
            e.addExame(contrassenhaExameRequisicaoVO);
        }
        return e;
    }

    public void inserirContrassenha(String filial, String valorDesconto, String motivo) throws SQLException {
        this.dao.inserirContrassenha(filial, valorDesconto, motivo);
    }

    public ContrasSenhaRequisicaoVO retornaContrassenhaRequisicao(String filialPadrao, String senha) throws SQLException {
        return this.dao.retornaContrasSenhaRequisicao(filialPadrao, senha);
    }

    public void atualizarContrassenhaRequisicao(String filial, String senha, String usuario) throws SQLException {
        ContrasSenhaRequisicaoService contrasSenhaRequisicaoService = new ContrasSenhaRequisicaoService();
        contrasSenhaRequisicaoService.atualizarContrassenhaRequisicao(filial, senha, usuario);
    }
}

