/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.AlterarPlanoCustoPagamentos;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.recepcao.util.SolicitarMotivoCancelamento;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.financeiro.BaixaBean;
import jalis.model.bean.financeiro.BaixaLancamentoBean;
import jalis.model.bean.financeiro.BaixaReceberPagarBean;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.LancamentoCentroCustoBean;
import jalis.model.bean.financeiro.LancamentoPlanoContaBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarCentroCustoBean;
import jalis.model.bean.financeiro.ReceberPagarPlanoContaBean;
import jalis.model.bean.financeiro.ReceberPagarRPBean;
import jalis.model.dao.financeiro.BaixaDao;
import jalis.model.dao.financeiro.ReceberPagarDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioEntidadeBean;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.model.vo.financeiro.BaixaVO;
import jalis.model.vo.financeiro.LancamentoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.ConvenioEntidadeService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.financeiro.BaixaLancamentoService;
import jalis.service.financeiro.BaixaReceberPagarService;
import jalis.service.financeiro.FaturaService;
import jalis.service.financeiro.LancamentoService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.financeiro.ReceberPagarRPService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BaixaService
extends AbstractThreadService {
    private int CASAS = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    public static final String MENSAGEM_VALIDACAO_PLANO_CONTAS = "O valor total da baixa do t\u00edtulo deve ser apropriado nos planos de conta";
    public static final String MENSAGEM_VALIDACAO_CENTROS_CUSTO = "O valor total da baixa do titulo deve ser apropriado nos centros de custo";

    public BaixaService() {
        this.dao = new BaixaDao();
    }

    public Integer getCodigoBaixa(String filialTituloBaixa, String codigoTituloBaixa) throws SQLException {
        return ((BaixaDao)this.dao).getCodigoBaixa(filialTituloBaixa, codigoTituloBaixa);
    }

    public String estornarBaixa(BaixaBean bean) throws Exception {
        StringBuilder buf = new StringBuilder();
        ResultSet rs = null;
        if (bean == null || bean.getFilial() == null || bean.getCodigo() == null) {
            throw new NullPointerException("Erro ao estornar Baixa. ");
        }
        int codFilial = bean.getFilial().getCodigo();
        int codBaixa = bean.getCodigo();
        SolicitarMotivoCancelamento telaMotivoCancelamento = new SolicitarMotivoCancelamento(Laboratorio.getInstancia(), "Motivo de Estorno", false);
        telaMotivoCancelamento.setVisible(true);
        if (telaMotivoCancelamento != null && !telaMotivoCancelamento.getOK()) {
            return "Estorno cancelado";
        }
        if (telaMotivoCancelamento == null || telaMotivoCancelamento.getCodigoMotivo() == -1) {
            return "O Motivo de Estorno da Baixa n\u00e3o foi selecionado.\nO estorno ser\u00e1 abortado.";
        }
        buf = new StringBuilder();
        buf.append(" select brp.rpg_codigo as codigo");
        buf.append("   from baixareceberpagar brp ");
        buf.append("   join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo ");
        buf.append("  where brp.fil_codigo = ").append(codFilial);
        buf.append("    and brp.bxa_codigo = ").append(codBaixa);
        buf.append("    and rpg.rpg_situacao = '").append("Q").append("' ");
        rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        ArrayList<String> arrayCodRecPag = new ArrayList<String>();
        while (rs.next()) {
            ReceberPagarBean beanAux = (ReceberPagarBean)new ReceberPagarService().get(String.valueOf(codFilial), rs.getString("codigo"));
            arrayCodRecPag.add(rs.getString("codigo"));
            beanAux.setSituacao("A");
            new ReceberPagarService().update(beanAux, beanAux.getCodigo(), String.valueOf(codFilial), null);
        }
        if (arrayCodRecPag.size() == 0) {
            throw new SQLException("Nenhum Receber/Pagar associado \u00e0 Baixa encontrado. ");
        }
        String erroComissao = this.removerComissao(bean);
        if (erroComissao != null) {
            return erroComissao;
        }
        buf = new StringBuilder();
        buf.append(" update receberpagar ");
        buf.append("    set rpg_situacao = '").append("E").append("' ");
        buf.append("       ,rpg_obs = SUBSTR(rpg_obs || ' - Estornado pela baixa-> C\u00f3d.:" + codBaixa + " Fil.:" + codFilial + "', 1, 300) ");
        buf.append("  where fil_codigo = ").append(codFilial);
        buf.append("    and rpg_codigo IN ");
        buf.append(Funcoes.montaLista(arrayCodRecPag));
        int qtde = Conexao.executeUpdate(String.valueOf(codFilial), Conexao.getStatement(), buf.toString());
        if (qtde == 0) {
            throw new SQLException("Nenhum Receber/Pagar atualizado. ");
        }
        bean.setSituacao("E");
        bean.setDescricaoCancelamento(telaMotivoCancelamento.getMotivoCancelamento().getDescricao());
        bean.setMotivoCancelamento((MotivoCancelamentoVO)telaMotivoCancelamento.getMotivoCancelamento().toVO());
        this.gravaAutoCopiaSemCommit(bean, 1, Variaveis.filialPadrao, null);
        buf = new StringBuilder();
        buf.append(" select blc.lcx_codigo as codigo, ");
        buf.append("        lcx.lcx_tipo as tipo,");
        buf.append("        lcx.lcx_situacao as situacao, ");
        buf.append("        lcx.est_codigo as codigoEstacao ");
        buf.append("   from baixalanctocaixa blc");
        buf.append("   left join lanctocaixa lcx on (blc.fil_codigo = lcx.fil_codigo and blc.lcx_codigo = lcx.lcx_codigo)");
        buf.append("  where blc.fil_codigo = ").append(codFilial);
        buf.append("    and blc.bxa_codigo = ").append(codBaixa);
        ArrayList<String> arrayLcto = new ArrayList<String>();
        ArrayList<String> arrayEstacao = new ArrayList<String>();
        rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        while (rs.next()) {
            arrayLcto.add(rs.getString("codigo"));
            arrayEstacao.add(rs.getString("codigoEstacao"));
        }
        if (arrayLcto.size() == 0) {
            throw new SQLException("Nenhum Lan\u00e7amento associado \u00e0 Baixa encontrado. ");
        }
        for (int i = 0; i < arrayLcto.size(); ++i) {
            LancamentoService lanctoService = new LancamentoService();
            LancamentoBean lanctoBean = null;
            lanctoBean = (LancamentoBean)lanctoService.get(String.valueOf(codFilial), (String)arrayLcto.get(i), (String)arrayEstacao.get(i));
            new LancamentoService().estornoCancelamento(lanctoBean, "X", false, null);
        }
        return null;
    }

    private String removerComissao(BaixaBean baixaBean) throws Exception {
        ArrayList<ReceberPagarBean> listaRecPag = this.getReceberPagarBaixa(baixaBean.getFilial().getCodigo().toString(), baixaBean.getCodigo().toString());
        ReceberPagarService serviceRecPag = new ReceberPagarService();
        if (listaRecPag != null) {
            for (int i = 0; i < listaRecPag.size(); ++i) {
                ReceberPagarBean recPagAssoc = listaRecPag.get(i);
                recPagAssoc = (ReceberPagarBean)serviceRecPag.get(listaRecPag.get(i).getFilial().getCodigo().toString(), listaRecPag.get(i).getCodigo().toString());
                ArrayList<ReceberPagarBean> listaPagarComissao = serviceRecPag.getPagarComissaoAssociado(recPagAssoc);
                for (int j = 0; listaPagarComissao != null && j < listaPagarComissao.size(); ++j) {
                    ReceberPagarBean recPag = listaPagarComissao.get(j);
                    ReceberPagarVO recPagAux = serviceRecPag.getUltimoEstadoReceberPagar((ReceberPagarVO)recPag.toVO());
                    if ((recPag = (ReceberPagarBean)serviceRecPag.get(recPagAux.getFilial().getCodigo().toString(), recPagAux.getCodigo().toString())).getOrigem() != null && recPag.getOrigem().equalsIgnoreCase("C") && recPag.getSituacao() != null && !recPag.getSituacao().equalsIgnoreCase("A") && !recPag.getSituacao().equalsIgnoreCase("C") && !recPag.getSituacao().equalsIgnoreCase("X")) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("O pagar de comiss\u00e3o (c\u00f3d.: ").append(recPag.getCodigo()).append(") est\u00e1 com a situa\u00e7\u00e3o \"").append(Tipos.tipoSituacaoReceberPagar(recPag.getSituacao())).append("\".\n");
                        buf.append("N\u00e3o \u00e9 poss\u00edvel estornar/cancelar a baixa.\n");
                        if (recPag.getSituacao().equalsIgnoreCase("Q")) {
                            buf.append("Estorne as baixas");
                        } else if (recPag.getSituacao().equalsIgnoreCase("L")) {
                            buf.append("Desfa\u00e7a o parcelamento");
                        } else if (recPag.getSituacao().equalsIgnoreCase("G")) {
                            buf.append("Desfa\u00e7a o agrupamento");
                        }
                        buf.append(" do pagar para poder estornar/cancelar a nota fiscal.");
                        return buf.toString();
                    }
                    recPag.setSituacao("X");
                    serviceRecPag.gravaAutoCopiaSemCommit(recPag, 1, baixaBean.getFilial().getCodigo().toString(), null);
                    ReceberPagarRPBean auxLigacao = new ReceberPagarRPBean();
                    auxLigacao.setFilialOrigem(recPagAssoc.getFilial());
                    auxLigacao.setReceberPagarOrigem((ReceberPagarVO)recPagAssoc.toVO());
                    auxLigacao.setFilialDestino(recPag.getFilial());
                    auxLigacao.setReceberPagarDestino((ReceberPagarVO)recPag.toVO());
                    new ReceberPagarRPService().delete(auxLigacao, null, recPagAssoc.getFilial().getCodigo().toString(), null);
                }
                recPagAssoc.setUsuarioComissao(null);
                recPagAssoc.setDataComissao(null);
                serviceRecPag.gravaAutoCopiaSemCommit(recPagAssoc, 1, baixaBean.getFilial().getCodigo().toString(), null);
            }
            return null;
        }
        return null;
    }

    public ArrayList<ReceberPagarBean> getReceberPagarBaixa(String filial, String codigoBaixa) throws Exception {
        return ((BaixaDao)this.dao).getReceberPagarBaixa(filial, codigoBaixa);
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof BaixaBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        Set titulos = ((BaixaBean)bean).getTitulos();
        if (titulos != null) {
            Iterator it = titulos.iterator();
            ReceberPagarService tituloService = new ReceberPagarService();
            while (it.hasNext()) {
                ReceberPagarBean titulo = (ReceberPagarBean)it.next();
                tituloService.delete(titulo, 2, filial, filiais);
            }
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean getSomenteQuitados(String filial, String codigo) throws Exception {
        return ((BaixaDao)this.dao).getBeanSomenteQuitados(filial, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((BaixaDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((ReceberPagarDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        Set formas2;
        if (!(bean instanceof BaixaBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        if (((BaixaBean)bean).getCodigo() == null) {
            ((BaixaBean)bean).setCodigo((Integer)codigo);
        }
        this.dao.insert(bean, filial);
        Set titulos = ((BaixaBean)bean).getTitulos();
        if (titulos != null) {
            Iterator it = titulos.iterator();
            ReceberPagarService tituloService = new ReceberPagarService();
            BaixaReceberPagarService baixaRecPagService = new BaixaReceberPagarService();
            while (it.hasNext()) {
                ReceberPagarBean titulo = (ReceberPagarBean)it.next();
                if ((titulo = (ReceberPagarBean)tituloService.updateComRetorno(titulo, titulo.getCodigo(), filial, filiais, false)).getTipo().equalsIgnoreCase("R")) {
                    titulo = this.gerarComissaoReceberPagar(titulo);
                }
                BaixaReceberPagarBean bxaTitulo = new BaixaReceberPagarBean();
                bxaTitulo.setFilial(titulo.getFilial());
                bxaTitulo.setReceberPagar((ReceberPagarVO)titulo.toVO());
                bxaTitulo.setBaixa((BaixaVO)((BaixaBean)bean).toVO());
                baixaRecPagService.insert(bxaTitulo, null, filial, filiais);
            }
        }
        if ((formas2 = ((BaixaBean)bean).getFormasPagamento()) != null) {
            Iterator it = formas2.iterator();
            LancamentoService lanctoService = new LancamentoService();
            BaixaLancamentoService baixaLanctoService = new BaixaLancamentoService();
            EstacaoVO estacao = new EstacaoVO();
            estacao.setCodigo(Integer.parseInt(Variaveis.codigoEstacao));
            while (it.hasNext()) {
                LancamentoBean forma = (LancamentoBean)it.next();
                if (forma.getCodigo() == null) {
                    forma.setFilial(((BaixaBean)bean).getFilial());
                    forma.getContaCorrente().setFilial(((BaixaBean)bean).getFilial());
                    forma.setEstacao(estacao);
                    lanctoService.gravaAutoCopiaSemCommit(forma, 0, filial, filiais);
                }
                BaixaLancamentoBean bxaForma = new BaixaLancamentoBean();
                bxaForma.setFilial(forma.getFilial());
                bxaForma.setLancamento((LancamentoVO)forma.toVO());
                bxaForma.setBaixa((BaixaVO)((BaixaBean)bean).toVO());
                bxaForma.setEstacao(forma.getEstacao());
                baixaLanctoService.insert(bxaForma, null, filial, filiais);
            }
        }
    }

    private ReceberPagarBean gerarComissaoReceberPagar(ReceberPagarBean recPag) throws Exception {
        Set<ConvenioEntidadeBean> listaConvenioEntidade;
        if (recPag.getNotaFiscal() == null) {
            return recPag;
        }
        NotaFiscalBean beanNota = (NotaFiscalBean)new NotaFiscalService().get(recPag.getNotaFiscal().getFilial().getCodigo().toString(), recPag.getNotaFiscal().getCodigo().toString());
        if (beanNota != null && beanNota.getConvenio() != null && (listaConvenioEntidade = new ConvenioEntidadeService().getRepresentantesConvenio(Variaveis.filialPadrao, beanNota.getConvenio().getCodigo().toString())) != null) {
            Iterator<ConvenioEntidadeBean> it = listaConvenioEntidade.iterator();
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            while (it.hasNext()) {
                ConvenioEntidadeBean convenioEntidade = it.next();
                ReceberPagarRPService serviceRecPagRP = new ReceberPagarRPService();
                if (!convenioEntidade.getTipoParcela().equalsIgnoreCase("B")) continue;
                if (beanNota.getFaturasNotaFiscal() != null) {
                    Iterator<FaturaNotaFiscalBean> itFat = beanNota.getFaturasNotaFiscal().iterator();
                    FaturaService serviceFatura = new FaturaService();
                    boolean isComissaoGerada = false;
                    while (itFat.hasNext()) {
                        FaturaNotaFiscalBean fatRecPagBean = itFat.next();
                        FaturaBean fat = (FaturaBean)serviceFatura.get(fatRecPagBean.getFilial().getCodigo().toString(), fatRecPagBean.getFatura().getCodigo().toString());
                        if (fat.getCodigoUsuarioComissao() == null && fat.getDataComissao() == null && recPag.getDataComissao() == null && recPag.getUsuarioComissao() == null || recPag.getEntidade() == null || recPag.getEntidade().getCodigo().intValue() != convenioEntidade.getEntidade().getCodigo().intValue()) continue;
                        isComissaoGerada = true;
                        break;
                    }
                    if (isComissaoGerada) {
                        return recPag;
                    }
                }
                if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("D")) {
                    ReceberPagarBean aux = this.getReceberPagarBasicoComissao(null);
                    aux.setFilial(recPag.getFilial());
                    aux.setUsuario(usuario);
                    aux.setSerie(recPag.getSerie());
                    aux.setEntidade(convenioEntidade.getEntidade());
                    BigDecimal valor = new BigDecimal(recPag.getValorTotal().toString()).subtract(new BigDecimal(recPag.getIssValor().toString())).setScale(this.CASAS, this.ROUND).multiply(new BigDecimal(convenioEntidade.getPercentualComissao().toString()).setScale(this.CASAS, this.ROUND)).divide(new BigDecimal("100").setScale(this.CASAS, this.ROUND), this.ROUND);
                    aux.setValor(valor.setScale(this.CASAS, this.ROUND).doubleValue());
                    aux.setParcela(1);
                    aux.setObservacao("PAGAMENTO DE COMISS\u00c3O - RECEBER C\u00d3D.: " + recPag.getCodigo() + " - COMISS\u00c3O GERADA PELA BAIXA DO T\u00cdTULO A RECEBER.");
                    aux.setOrigem("C");
                    aux.setNotaFiscal((NotaFiscalVO)beanNota.toVO());
                    aux = FinanceiroUtil.atualizaTotalSemRecalculo(aux);
                    if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("D")) {
                        aux.setDataVencimento(new Date());
                        aux.setDataCompetencia(new Date());
                        aux.setDataDocumento(new Date());
                    }
                    new ReceberPagarService().gravaAutoCopiaSemCommit(aux, 0, Variaveis.filialPadrao, null);
                    ReceberPagarRPBean recPagRP = new ReceberPagarRPBean();
                    recPagRP.setFilialOrigem(recPag.getFilial());
                    recPagRP.setFilialDestino(recPag.getFilial());
                    recPagRP.setReceberPagarOrigem((ReceberPagarVO)recPag.toVO());
                    recPagRP.setReceberPagarDestino((ReceberPagarVO)aux.toVO());
                    recPagRP.setTipo("C");
                    serviceRecPagRP.insert(recPagRP, null, Variaveis.filialPadrao, null);
                    continue;
                }
                if (!convenioEntidade.getTipoPagamento().equalsIgnoreCase("G") && !convenioEntidade.getTipoPagamento().equalsIgnoreCase("X")) continue;
                Double valorComissao = new BigDecimal(recPag.getValorTotal().toString()).subtract(new BigDecimal(recPag.getIssValor().toString())).setScale(this.CASAS, this.ROUND).multiply(new BigDecimal(convenioEntidade.getPercentualComissao().toString()).setScale(this.CASAS, this.ROUND)).divide(new BigDecimal("100").setScale(this.CASAS, this.ROUND), this.ROUND).doubleValue();
                Set parcelamento = new FormaPagamentoParcelaService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and fpg_codigo = " + convenioEntidade.getFormaPagamento().getCodigo());
                Date dataInicial = null;
                if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("G")) {
                    dataInicial = new Date();
                } else {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(5, convenioEntidade.getDiaComissao());
                    calendar.add(2, 1);
                    dataInicial = calendar.getTime();
                }
                ArrayList<ReceberPagarBean> listaRecPag = FinanceiroUtil.gerarParcelas(valorComissao, valorComissao, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, dataInicial, "P", parcelamento);
                for (int i = 0; i < listaRecPag.size(); ++i) {
                    ReceberPagarBean beanRecpag = listaRecPag.get(i);
                    beanRecpag = this.getReceberPagarBasicoComissao(beanRecpag);
                    beanRecpag.setFilial(recPag.getFilial());
                    beanRecpag.setUsuario(usuario);
                    beanRecpag.setSerie(recPag.getSerie());
                    beanRecpag.setEntidade(convenioEntidade.getEntidade());
                    beanRecpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - PARCELA: " + beanRecpag.getParcela() + "  - RECEBER C\u00d3D.: " + recPag.getCodigo());
                    beanRecpag.setDataCompetencia(beanRecpag.getDataVencimento());
                    beanRecpag.setDataDocumento(beanRecpag.getDataVencimento());
                    beanRecpag.setOrigem("C");
                    beanRecpag.setNotaFiscal((NotaFiscalVO)beanNota.toVO());
                    new ReceberPagarService().gravaAutoCopiaSemCommit(beanRecpag, 0, Variaveis.filialPadrao, null);
                    ReceberPagarRPBean recPagRP = new ReceberPagarRPBean();
                    recPagRP.setFilialOrigem(recPag.getFilial());
                    recPagRP.setFilialDestino(recPag.getFilial());
                    recPagRP.setReceberPagarOrigem((ReceberPagarVO)recPag.toVO());
                    recPagRP.setReceberPagarDestino((ReceberPagarVO)beanRecpag.toVO());
                    recPagRP.setTipo("C");
                    serviceRecPagRP.insert(recPagRP, null, Variaveis.filialPadrao, null);
                }
            }
        }
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        recPag.setUsuarioComissao(usuario);
        recPag.setDataComissao(new Date());
        return recPag;
    }

    private ReceberPagarBean getReceberPagarBasicoComissao(ReceberPagarBean recpag) {
        if (recpag == null) {
            recpag = new ReceberPagarBean();
        }
        recpag.setSituacao("A");
        recpag.setDataHora(new Date());
        recpag.setTipo("P");
        recpag.setTipoDocumento("D");
        recpag.setTipoJuro("V");
        recpag.setPercentualMulta(0.0);
        recpag.setPercentualDesconto(0.0);
        recpag.setPercentualAcrescimo(0.0);
        recpag.setIrrfPercentual(0.0);
        recpag.setIssPercentual(0.0);
        recpag.setPisPercentual(0.0);
        recpag.setCsllPercentual(0.0);
        recpag.setCofinsPercentual(0.0);
        recpag.setInssPercentual(0.0);
        recpag.setValorMulta(0.0);
        recpag.setValorDesconto(0.0);
        recpag.setValorAcrescimo(0.0);
        recpag.setTaxa(0.0);
        recpag.setIrrfValor(0.0);
        recpag.setIssValor(0.0);
        recpag.setPisValor(0.0);
        recpag.setCsllValor(0.0);
        recpag.setCofinsValor(0.0);
        recpag.setInssValor(0.0);
        recpag.setPercentualJuro(0.0);
        recpag.setValorJuro(0.0);
        recpag.setNumeroDocumento(null);
        recpag.setCodigoDocumento(null);
        recpag.setDataProcessamento(new Date());
        recpag.setTipoCadastro("R");
        recpag.setOrigem("C");
        return recpag;
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(BaixaBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(BaixaVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("dataHora", "Data Hora", 4, "", 2, 0);
        tela.adicionaCampo("quantidadeTitulos", "Qtde T\u00edtulos", 1, "", 3, 80);
        tela.adicionaCampo("valorTotal", "Valor Total", 1, "", 3, 0);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and bxa_situacao <> '" + "E" + "' ");
        tela.setColunaOrdenacao("Data Hora");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaSomenteQuitadasVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("dataHora", "Data Hora", 4, "", 2, 0);
        tela.adicionaCampo("quantidadeTitulos", "Qtde T\u00edtulos", 1, "", 3, 80);
        tela.adicionaCampo("valorTotal", "Valor Total", 1, "", 3, 0);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and bxa_situacao = '" + "Q" + "' ");
        tela.setColunaOrdenacao("Data Hora");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.update(bean, filialPadrao);
    }

    public String validar(BaixaBean baixa) {
        if (baixa.getTitulos() == null || baixa.getTitulos().size() == 0) {
            return "N\u00e3o foi informado nenhum t\u00edtulo na baixa!";
        }
        if (baixa.getFormasPagamento() == null || baixa.getFormasPagamento().size() == 0) {
            return "N\u00e3o foi informado nenhum pagamento na baixa!";
        }
        for (ReceberPagarBean rp : baixa.getTitulos()) {
            if (!FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)rp)) continue;
            return "O t\u00edtulo: " + Integer.toString(rp.getCodigo()) + " est\u00e1 com valores incorretos no plano de contas/centro de custo.";
        }
        for (LancamentoBean l : baixa.getFormasPagamento()) {
            if (!FinanceiroUtil.validarPlanosContasCentrosCusto((AbstractThreadBean)l)) continue;
            return "O pagamento: " + Tipos.tipoPagamento(l.getTipoPagamento()) + " est\u00e1 com valores incorretos no plano de contas/centro de custo.";
        }
        return "";
    }

    public void atualizarValores(BaixaBean baixa) {
        int casas = this.getCasasPrecoExame();
        RoundingMode round = this.getArredondamentoPrecoExame();
        BigDecimal subTotal = BigDecimal.ZERO;
        BigDecimal taxa = BigDecimal.ZERO;
        BigDecimal multa = BigDecimal.ZERO;
        BigDecimal juro = BigDecimal.ZERO;
        BigDecimal acrescimo = BigDecimal.ZERO;
        BigDecimal desconto = BigDecimal.ZERO;
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal valorPago = BigDecimal.ZERO;
        BigDecimal saldoTroco = BigDecimal.ZERO;
        BigDecimal irrf = BigDecimal.ZERO;
        BigDecimal iss = BigDecimal.ZERO;
        BigDecimal pis = BigDecimal.ZERO;
        BigDecimal csll = BigDecimal.ZERO;
        BigDecimal cofins = BigDecimal.ZERO;
        BigDecimal inss = BigDecimal.ZERO;
        BigDecimal irrfRetido = BigDecimal.ZERO;
        BigDecimal issRetido = BigDecimal.ZERO;
        BigDecimal pisRetido = BigDecimal.ZERO;
        BigDecimal csllRetido = BigDecimal.ZERO;
        BigDecimal cofinsRetido = BigDecimal.ZERO;
        BigDecimal inssRetido = BigDecimal.ZERO;
        if (baixa.getTitulos() != null && baixa.getTitulos().size() > 0) {
            for (ReceberPagarBean receberPager : baixa.getTitulos()) {
                subTotal = subTotal.add(this.criarBigDecimal(receberPager.getValor()));
                taxa = taxa.add(this.criarBigDecimal(receberPager.getTaxa()));
                multa = multa.add(this.criarBigDecimal(receberPager.getValorMulta()));
                juro = juro.add(this.criarBigDecimal(receberPager.getValorJuro()));
                acrescimo = acrescimo.add(this.criarBigDecimal(receberPager.getValorAcrescimo()));
                desconto = desconto.add(this.criarBigDecimal(receberPager.getValorDesconto()));
                total = total.add(this.criarBigDecimal(receberPager.getValorTotal()));
                irrf = irrf.add(this.criarBigDecimal(receberPager.getIrrfValor()));
                iss = iss.add(this.criarBigDecimal(receberPager.getIssValor()));
                pis = pis.add(this.criarBigDecimal(receberPager.getPisValor()));
                csll = csll.add(this.criarBigDecimal(receberPager.getCsllValor()));
                cofins = cofins.add(this.criarBigDecimal(receberPager.getCofinsValor()));
                inss = inss.add(this.criarBigDecimal(receberPager.getInssValor()));
                irrfRetido = irrfRetido.add(this.criarBigDecimal(receberPager.getIrrfRetidoValor()));
                issRetido = issRetido.add(this.criarBigDecimal(receberPager.getIssRetidoValor()));
                pisRetido = pisRetido.add(this.criarBigDecimal(receberPager.getPisRetidoValor()));
                csllRetido = csllRetido.add(this.criarBigDecimal(receberPager.getCsllRetidoValor()));
                cofinsRetido = cofinsRetido.add(this.criarBigDecimal(receberPager.getCofinsRetidoValor()));
                inssRetido = inssRetido.add(this.criarBigDecimal(receberPager.getInssRetidoValor()));
            }
        }
        if (baixa.getFormasPagamento() != null) {
            for (LancamentoBean l : baixa.getFormasPagamento()) {
                valorPago = valorPago.add(new BigDecimal(l.getValor().toString()).setScale(casas, round));
            }
        }
        valorPago = valorPago.setScale(casas, round);
        saldoTroco = (total = total.setScale(casas, round)).compareTo(valorPago) > 0 ? valorPago.subtract(total) : total.subtract(valorPago);
        baixa.setSubTotal(subTotal.doubleValue());
        baixa.setValorTaxas(taxa.doubleValue());
        baixa.setValorMultas(multa.doubleValue());
        baixa.setValorJuros(juro.doubleValue());
        baixa.setValorAcrescimo(acrescimo.doubleValue());
        baixa.setValorDescontos(desconto.doubleValue());
        baixa.setValorTotal(total.doubleValue());
        baixa.setValorPago(valorPago.doubleValue());
        baixa.setSaldoTroco(saldoTroco.doubleValue());
        baixa.setIrrfValor(irrf.doubleValue());
        baixa.setIssValor(iss.doubleValue());
        baixa.setPisValor(pis.doubleValue());
        baixa.setCsllValor(csll.doubleValue());
        baixa.setCofinsValor(cofins.doubleValue());
        baixa.setInssValor(inss.doubleValue());
        baixa.setIrrfRetidoValor(irrfRetido.doubleValue());
        baixa.setIssRetidoValor(issRetido.doubleValue());
        baixa.setPisRetidoValor(pisRetido.doubleValue());
        baixa.setCsllRetidoValor(csllRetido.doubleValue());
        baixa.setCofinsRetidoValor(cofinsRetido.doubleValue());
        baixa.setInssRetidoValor(inssRetido.doubleValue());
    }

    public HashMap<Boolean, String> validarPlanosDeContasNosPagamentos(ModeloGridTable modelTitulos, ModeloGridTable modelFormasPagamento) {
        HashMap<Boolean, String> invalidos = new HashMap<Boolean, String>();
        boolean titulosPossuemPlanoDeContas = this.titulosPossuemPlanoDeContas(modelTitulos);
        boolean pagamentosPossuemPlanoDeContas = this.pagamentosPossuemPlanoDeContas(modelFormasPagamento);
        if (!titulosPossuemPlanoDeContas && !pagamentosPossuemPlanoDeContas) {
            invalidos.put(false, MENSAGEM_VALIDACAO_PLANO_CONTAS);
            return invalidos;
        }
        if (!pagamentosPossuemPlanoDeContas && titulosPossuemPlanoDeContas) {
            if (modelFormasPagamento.getRowCount() == 1) {
                invalidos.put(true, "O valor da baixa do t\u00edtulo deve ser apropriado nos planos de conta.\nDeseja copiar as informa\u00e7\u00f5es do(s) Planos(s) de Conta do t\u00edtulo para o pagamento?");
                return invalidos;
            }
            invalidos.put(true, "");
            return invalidos;
        }
        if (this.getValorTotalTitulos(modelTitulos) > this.getValorTotalPlanosConta(modelFormasPagamento)) {
            invalidos.put(false, MENSAGEM_VALIDACAO_PLANO_CONTAS);
            return invalidos;
        }
        return invalidos;
    }

    public HashMap<Boolean, String> validarCentrosDeCustosNosPagamentos(ModeloGridTable modelTitulos, ModeloGridTable modelFormasPagamento) {
        HashMap<Boolean, String> invalidos = new HashMap<Boolean, String>();
        boolean titulosPossuemCentrosDeCusto = this.titulosPossuemCentroDeCustos(modelTitulos);
        boolean pagamentosPossuemCentrosDeCusto = this.pagamentosPossuemCentrosDeCusto(modelFormasPagamento);
        if (!titulosPossuemCentrosDeCusto && !pagamentosPossuemCentrosDeCusto) {
            invalidos.put(false, MENSAGEM_VALIDACAO_CENTROS_CUSTO);
            return invalidos;
        }
        if (!pagamentosPossuemCentrosDeCusto && titulosPossuemCentrosDeCusto) {
            if (modelFormasPagamento.getRowCount() == 1) {
                invalidos.put(true, "O valor da baixa do t\u00edtulo deve ser apropriado nos centros de custo.\nDeseja copiar as informa\u00e7\u00f5es do(s) Centro(s) de Custo do t\u00edtulo para o pagamento?");
                return invalidos;
            }
            invalidos.put(true, "");
            return invalidos;
        }
        if (this.getValorTotalTitulos(modelTitulos) > this.getvalorTotalCentrosCusto(modelFormasPagamento)) {
            invalidos.put(false, MENSAGEM_VALIDACAO_CENTROS_CUSTO);
            return invalidos;
        }
        return invalidos;
    }

    public void copiarPlanosDeContasParaOsPagamentos(ModeloGridTable modelTitulos, ModeloGridTable modelFormasPagamento, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        ((LancamentoBean)modelFormasPagamento.getValueAt(0, 4)).removeTodosPlanosConta();
        pnlPlanoCustoPagamento.removerTodosPlanosContas();
        ArrayList<ReceberPagarBean> titulos = new ArrayList<ReceberPagarBean>();
        for (int j = 0; j < modelTitulos.getRowCount(); ++j) {
            ReceberPagarBean recPag = (ReceberPagarBean)modelTitulos.getValueAt(j, 6);
            FinanceiroUtil.copiaPlanoConta(recPag, (AbstractThreadBean)((LancamentoBean)modelFormasPagamento.getValueAt(0, 4)), pnlPlanoCustoPagamento);
            titulos.add(recPag);
        }
        AlterarPlanoCustoPagamentos.setPlanoContasRPAutomatico((LancamentoBean)modelFormasPagamento.getValueAt(0, 4), titulos);
    }

    public void copiarCentrosDeCustoParaOsPagamentos(ModeloGridTable modelTitulos, ModeloGridTable modelFormasPagamento, PanelPlanoContaCentroCusto pnlPlanoCustoPagamento) {
        ((LancamentoBean)modelFormasPagamento.getValueAt(0, 4)).removeTodosCentrosCusto();
        pnlPlanoCustoPagamento.removerTodosCentrosCusto();
        ArrayList<ReceberPagarBean> titulos = new ArrayList<ReceberPagarBean>();
        for (int j = 0; j < modelTitulos.getRowCount(); ++j) {
            ReceberPagarBean recPag = (ReceberPagarBean)modelTitulos.getValueAt(j, 6);
            FinanceiroUtil.copiaCentroCusto(recPag, (AbstractThreadBean)((LancamentoBean)modelFormasPagamento.getValueAt(0, 4)), pnlPlanoCustoPagamento);
            titulos.add(recPag);
        }
        AlterarPlanoCustoPagamentos.setCentrosCustoRPAutomatico((LancamentoBean)modelFormasPagamento.getValueAt(0, 4), titulos);
    }

    private Double getValorTotalPlanosConta(ModeloGridTable modelFormasPagamento) {
        Double valorTotalPlanosConta = 0.0;
        for (int l = 0; l < modelFormasPagamento.getRowCount(); ++l) {
            LancamentoBean lancto = (LancamentoBean)modelFormasPagamento.getValueAt(l, 4);
            Object[] planosConta = lancto.getPlanosContas().toArray();
            for (int p = 0; p < planosConta.length; ++p) {
                LancamentoPlanoContaBean lpc = (LancamentoPlanoContaBean)planosConta[p];
                valorTotalPlanosConta = valorTotalPlanosConta + lpc.getValor();
            }
        }
        return valorTotalPlanosConta;
    }

    private Double getvalorTotalCentrosCusto(ModeloGridTable modelFormasPagamento) {
        Double valorTotalCentrosCusto = 0.0;
        for (int l = 0; l < modelFormasPagamento.getRowCount(); ++l) {
            LancamentoBean lancto = (LancamentoBean)modelFormasPagamento.getValueAt(l, 4);
            Object[] centrosCusto = lancto.getCentrosCusto().toArray();
            for (int p = 0; p < centrosCusto.length; ++p) {
                LancamentoCentroCustoBean lpc = (LancamentoCentroCustoBean)centrosCusto[p];
                valorTotalCentrosCusto = valorTotalCentrosCusto + lpc.getValor();
            }
        }
        return valorTotalCentrosCusto;
    }

    private Double getValorTotalTitulos(ModeloGridTable modelTitulos) {
        Double valorTotalTitulos = 0.0;
        for (int t = 0; t < modelTitulos.getRowCount(); ++t) {
            ReceberPagarBean titulo = (ReceberPagarBean)modelTitulos.getValueAt(t, 6);
            valorTotalTitulos = valorTotalTitulos + titulo.getValorTotal();
        }
        return valorTotalTitulos;
    }

    private boolean pagamentosPossuemPlanoDeContas(ModeloGridTable modelFormasPagamento) {
        boolean possuiPlanoContas = false;
        if (modelFormasPagamento.getRowCount() > 0) {
            block0: for (int l = 0; l < modelFormasPagamento.getRowCount(); ++l) {
                LancamentoBean lancto = (LancamentoBean)modelFormasPagamento.getValueAt(l, 4);
                if (lancto == null || lancto.getPlanosContas() == null || lancto.getPlanosContas().size() <= 0) continue;
                Object[] planosConta = lancto.getPlanosContas().toArray();
                for (int p = 0; p < planosConta.length; ++p) {
                    LancamentoPlanoContaBean lpc = (LancamentoPlanoContaBean)planosConta[p];
                    if (lpc == null || lpc.isRemover()) continue;
                    possuiPlanoContas = true;
                    continue block0;
                }
            }
        }
        return possuiPlanoContas;
    }

    private boolean pagamentosPossuemCentrosDeCusto(ModeloGridTable modelFormasPagamento) {
        boolean possuiCentroCusto = false;
        if (modelFormasPagamento.getRowCount() > 0) {
            block0: for (int l = 0; l < modelFormasPagamento.getRowCount(); ++l) {
                LancamentoBean lancto = (LancamentoBean)modelFormasPagamento.getValueAt(l, 4);
                if (lancto == null || lancto.getCentrosCusto() == null || lancto.getCentrosCusto().size() <= 0) continue;
                Object[] centroCusto = lancto.getCentrosCusto().toArray();
                for (int p = 0; p < centroCusto.length; ++p) {
                    LancamentoCentroCustoBean lpc = (LancamentoCentroCustoBean)centroCusto[p];
                    if (lpc == null || lpc.isRemover()) continue;
                    possuiCentroCusto = true;
                    continue block0;
                }
            }
        }
        return possuiCentroCusto;
    }

    public boolean titulosPossuemPlanoDeContas(ModeloGridTable modelTitulos) {
        boolean possuiPlanoContas = false;
        if (modelTitulos.getRowCount() > 0) {
            block0: for (int j = 0; j < modelTitulos.getRowCount(); ++j) {
                ReceberPagarBean titulo = (ReceberPagarBean)modelTitulos.getValueAt(j, 6);
                if (titulo == null || titulo.getPlanosContas() == null || titulo.getPlanosContas().size() <= 0) continue;
                HashSet planos = (HashSet)titulo.getPlanosContas();
                for (ReceberPagarPlanoContaBean aux : planos) {
                    if (aux == null || aux.isRemover()) continue;
                    possuiPlanoContas = true;
                    continue block0;
                }
            }
        }
        return possuiPlanoContas;
    }

    public boolean titulosPossuemCentroDeCustos(ModeloGridTable modelTitulos) {
        boolean possuiCentroCusto = false;
        if (modelTitulos.getRowCount() > 0) {
            block0: for (int j = 0; j < modelTitulos.getRowCount(); ++j) {
                ReceberPagarBean titulo = (ReceberPagarBean)modelTitulos.getValueAt(j, 6);
                if (titulo == null || titulo.getCentrosCusto() == null || titulo.getCentrosCusto().size() <= 0) continue;
                HashSet centros = (HashSet)titulo.getCentrosCusto();
                for (ReceberPagarCentroCustoBean aux : centros) {
                    if (aux == null || aux.isRemover()) continue;
                    possuiCentroCusto = true;
                    continue block0;
                }
            }
        }
        return possuiCentroCusto;
    }

    private BigDecimal criarBigDecimal(Double valor) {
        if (valor == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal decimal = new BigDecimal(valor.toString()).setScale(this.getCasasPrecoExame(), this.getArredondamentoPrecoExame());
        return decimal;
    }

    private RoundingMode getArredondamentoPrecoExame() {
        return ParametrosGerais.getArredondamentoPrecoExame();
    }

    private int getCasasPrecoExame() {
        return ParametrosGerais.getCasasPrecoExame();
    }
}

