/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.AgrupamentoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarRPBean;
import jalis.model.dao.financeiro.AgrupamentoDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.AbstractThreadService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;

public class AgrupamentoService
extends AbstractThreadService {
    public AgrupamentoService() {
        this.dao = new AgrupamentoDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((AgrupamentoDao)this.dao).getBean(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((AgrupamentoDao)this.dao).getBean(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    public void insert(AbstractThreadBean bean, String filial, String filiais) throws Exception {
        boolean tituloAgrupadorNovo = false;
        ReceberPagarBean agrupadorBean = null;
        Set<ReceberPagarBean> titulosOriginaisSet = null;
        if (!(bean instanceof AgrupamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        agrupadorBean = ((AgrupamentoBean)bean).getAgrupador();
        if (agrupadorBean != null) {
            if (agrupadorBean.getCodigo() == null) {
                tituloAgrupadorNovo = true;
            }
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulo agrupador.", null);
            return;
        }
        titulosOriginaisSet = ((AgrupamentoBean)bean).getTitulosOriginais();
        if (titulosOriginaisSet != null) {
            if (titulosOriginaisSet.size() <= 0) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulos originais.", null);
                return;
            }
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulos originais.", null);
            return;
        }
        if (tituloAgrupadorNovo) {
            agrupadorBean.setDataHora(new Date());
            new ReceberPagarService().gravaAutoCopiaSemCommit(agrupadorBean, 0, filial, filiais);
        } else {
            agrupadorBean = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(agrupadorBean, agrupadorBean.getCodigo(), filial, filiais, true);
        }
        for (ReceberPagarBean aux : titulosOriginaisSet) {
            if (aux.isRemover()) continue;
            aux.setSituacao("G");
            aux.setObservacao((aux.getObservacao() == null || Funcoes.textoVazio(aux.getObservacao()) ? "" : aux.getObservacao() + " - ") + "Agrupado pelo t\u00edtulo -> Fil: " + agrupadorBean.getFilial().getCodigo() + ", C\u00f3d.: " + agrupadorBean.getCodigo());
            aux = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(aux, aux.getCodigo(), filial, filiais, true);
            ReceberPagarRPBean recPagRP = new ReceberPagarRPBean();
            recPagRP.setFilialDestino(agrupadorBean.getFilial());
            recPagRP.setReceberPagarDestino((ReceberPagarVO)agrupadorBean.toVO());
            recPagRP.setFilialOrigem(aux.getFilial());
            recPagRP.setReceberPagarOrigem((ReceberPagarVO)aux.toVO());
            recPagRP.setTipo("R");
            this.dao.insert(recPagRP, filial);
        }
        Conexao.arquivaSQL();
    }

    public boolean isTituloAgrupador(String filialAgrupador, String codigoAgrupador) throws SQLException {
        return ((AgrupamentoDao)this.dao).isTituloAgrupador(filialAgrupador, codigoAgrupador);
    }

    public Set getTitulosOriginais(String filialAgrupador, String codigoAgrupador) throws Exception {
        return ((AgrupamentoDao)this.dao).getTitulosOriginais(filialAgrupador, codigoAgrupador);
    }

    public ReceberPagarBean getTituloAgrupador(String filialTituloOriginal, String codigoTituloOriginal) throws Exception {
        return ((AgrupamentoDao)this.dao).getTituloAgrupador(filialTituloOriginal, codigoTituloOriginal);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public void update(AbstractThreadBean bean, String filial, String filiais) throws Exception {
        ReceberPagarBean agrupadorBean = null;
        Set<ReceberPagarBean> titulosOriginaisSet = null;
        if (!(bean instanceof AgrupamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        agrupadorBean = ((AgrupamentoBean)bean).getAgrupador();
        if (agrupadorBean == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulo agrupador.", null);
            return;
        }
        titulosOriginaisSet = ((AgrupamentoBean)bean).getTitulosOriginais();
        if (titulosOriginaisSet != null) {
            if (titulosOriginaisSet.size() <= 0) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulos originais.", null);
                return;
            }
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulos originais.", null);
            return;
        }
        agrupadorBean = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(agrupadorBean, agrupadorBean.getCodigo(), filial, filiais, true);
        for (ReceberPagarBean aux : titulosOriginaisSet) {
            if (aux.isInserir()) {
                aux.setSituacao("G");
                aux.setObservacao((aux.getObservacao() == null || Funcoes.textoVazio(aux.getObservacao()) ? "" : aux.getObservacao() + " - ") + "Agrupado pelo t\u00edtulo -> Fil: " + agrupadorBean.getFilial().getCodigo() + ", C\u00f3d.: " + agrupadorBean.getCodigo());
                aux = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(aux, aux.getCodigo(), filial, filiais, true);
                ReceberPagarRPBean recPagRP = new ReceberPagarRPBean();
                recPagRP.setFilialDestino(agrupadorBean.getFilial());
                recPagRP.setReceberPagarDestino((ReceberPagarVO)agrupadorBean.toVO());
                recPagRP.setFilialOrigem(aux.getFilial());
                recPagRP.setReceberPagarOrigem((ReceberPagarVO)aux.toVO());
                recPagRP.setTipo("R");
                this.dao.insert(recPagRP, filial);
                continue;
            }
            if (!aux.isRemover()) continue;
            aux.setSituacao("A");
            aux.setDataHora(new Date());
            aux.setObservacao("");
            new ReceberPagarService().update(aux, aux.getCodigo(), filial, filiais);
        }
        Conexao.arquivaSQL();
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public void delete(AbstractThreadBean bean, String filial, String filiais) throws Exception {
        ReceberPagarBean agrupadorBean = null;
        Set<ReceberPagarBean> titulosOriginaisSet = null;
        if (!(bean instanceof AgrupamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        agrupadorBean = ((AgrupamentoBean)bean).getAgrupador();
        if (agrupadorBean == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulo agrupador.", null);
            return;
        }
        titulosOriginaisSet = ((AgrupamentoBean)bean).getTitulosOriginais();
        if (titulosOriginaisSet != null) {
            if (titulosOriginaisSet.size() <= 0) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulos originais.", null);
                return;
            }
        } else {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel inserir Agrupamento. N\u00e3o h\u00e1 t\u00edtulos originais.", null);
            return;
        }
        agrupadorBean.setSituacao("C");
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        agrupadorBean.setUsuarioCancelado(usuario);
        agrupadorBean.setDataCancelado(new Date());
        agrupadorBean.setObservacao(agrupadorBean.getObservacao() == null ? "" : agrupadorBean.getObservacao() + " - Agrupador Cancelado por Desagrupamento.");
        new ReceberPagarService().update(agrupadorBean, agrupadorBean.getCodigo(), filial, filiais);
        for (ReceberPagarBean aux : titulosOriginaisSet) {
            aux.setSituacao("A");
            aux.setObservacao("");
            aux.setDataHora(new Date());
            aux = (ReceberPagarBean)new ReceberPagarService().updateComRetorno(aux, aux.getCodigo(), filial, filiais, true);
        }
        Conexao.arquivaSQL();
    }
}

