/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.exportadores;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.exportacao.thread.ExameWeb;
import jalis.laboratorio.resultados.ExamesImpressos;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.exportadores.ExportaWebBean;
import jalis.model.dao.exportadores.ExportaWebDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.exportadores.ExportaWebVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;

public class ExportaWebService
extends AbstractThreadService {
    public static final int PACIENTE = 1;
    public static final int MEDICO = 3;
    public static final int CONVENIO = 5;

    public ExportaWebService() {
        this.dao = new ExportaWebDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ExportaWebBean) {
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ExportaWebBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof ExportaWebBean) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ExportaWebBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ExportaWebVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    private Map<String, List<ExameWeb>> localizaExamesProntos(String filial, String requisicao, Statement st) throws SQLException {
        List<ExameWeb> exaWeb = ((ExportaWebDao)this.dao).localizaExamesProntos(filial, requisicao);
        return this.agruparExames(exaWeb);
    }

    private Map<String, List<ExameWeb>> agruparExames(List<ExameWeb> exames) {
        HashMap<String, List<ExameWeb>> grupo = new HashMap<String, List<ExameWeb>>();
        grupo.put("paciente", new ArrayList());
        grupo.put("medico", new ArrayList());
        grupo.put("convenio", new ArrayList());
        grupo.put("destino", new ArrayList());
        grupo.put("fiscal", new ArrayList());
        grupo.put("responsavel", new ArrayList());
        for (ExameWeb exameProibido : exames) {
            if (!exameProibido.isProibidoPaciente().booleanValue()) {
                ((List)grupo.get("paciente")).add(exameProibido);
            }
            if (!exameProibido.isProibidoMedico().booleanValue()) {
                ((List)grupo.get("medico")).add(exameProibido);
            }
            if (!exameProibido.isProibidoConvenio().booleanValue()) {
                ((List)grupo.get("convenio")).add(exameProibido);
            }
            if (!exameProibido.isProibidoDestino().booleanValue()) {
                ((List)grupo.get("destino")).add(exameProibido);
            }
            if (!exameProibido.isProibidoFiscal().booleanValue()) {
                ((List)grupo.get("fiscal")).add(exameProibido);
            }
            if (exameProibido.isProibidoResponsavel().booleanValue()) continue;
            ((List)grupo.get("responsavel")).add(exameProibido);
        }
        return grupo;
    }

    private Object[] pegarParametrosGeracao(Map<String, List<ExameWeb>> grupo, String grupoBusca) {
        Object[] parametro = new Object[2];
        String[] exames = new String[grupo.get(grupoBusca) == null ? 0 : grupo.get(grupoBusca).size()];
        String[] materiais = new String[grupo.get(grupoBusca) == null ? 0 : grupo.get(grupoBusca).size()];
        int pos = 0;
        if (grupo.get(grupoBusca) != null) {
            for (ExameWeb examesProibido : grupo.get(grupoBusca)) {
                exames[pos] = examesProibido.getCodigoExame();
                materiais[pos] = examesProibido.getCodigoMaterial().toString();
                ++pos;
            }
        }
        parametro[0] = exames;
        parametro[1] = materiais;
        return parametro;
    }

    private boolean localizaExamesProibidos(Map<String, List<ExameWeb>> grupo) {
        boolean retorno = false;
        for (String key : grupo.keySet()) {
            List<ExameWeb> exames = grupo.get(key);
            for (ExameWeb exame : exames) {
                if (!exame.isProibidoConvenio().booleanValue() && !exame.isProibidoMedico().booleanValue() && !exame.isProibidoPaciente().booleanValue() && !exame.isProibidoDestino().booleanValue() && !exame.isProibidoFiscal().booleanValue() && !exame.isProibidoResponsavel().booleanValue()) continue;
                retorno = true;
                break;
            }
            if (!retorno) continue;
            break;
        }
        return retorno;
    }

    public Map<String, String> gerarDadosWeb(String xmlExportaWeb, String codigoFilial, String codigoRequisicao, Statement st) throws SQLException {
        String codigoExame = StringUtil.getValor(xmlExportaWeb, "codigoExameRequisicao");
        String codigoMaterialExame = StringUtil.getValor(xmlExportaWeb, "materialExameRequisicao");
        Map<String, List<ExameWeb>> grupo = this.localizaExamesProntos(codigoFilial, codigoRequisicao, st);
        boolean temExameProibido = this.localizaExamesProibidos(grupo);
        boolean gerarPdfWeb = true;
        String arquivoPdf = "";
        HashMap<String, String> listaDados = new HashMap<String, String>();
        Object[] parametro = new Object[2];
        String[] exames = new String[]{codigoExame};
        String[] materiais = new String[]{codigoMaterialExame};
        if (this.contemValor(exames)) {
            parametro[0] = exames;
        }
        if (this.contemValor(materiais)) {
            parametro[1] = materiais;
        }
        String situacaoExameRequisicao = StringUtil.getValor(xmlExportaWeb, "situacaoExameRequisicao");
        RetornoImpressaoResultados resultadoExame = this.exportaPdfWeb(codigoFilial, codigoRequisicao, gerarPdfWeb, parametro, arquivoPdf);
        if (this.contemResultado(resultadoExame)) {
            String resultadoPdf = resultadoExame.getResultadoPdfWeb() != null ? new Base64().encodeAsString(resultadoExame.getResultadoPdfWeb()) : "";
            listaDados.put("pdfExame", this.getValor(resultadoPdf));
            listaDados.put("pdfPaciente", null);
            listaDados.put("pdfMedico", null);
            listaDados.put("pdfConvenio", null);
            listaDados.put("pdfDestino", null);
            listaDados.put("pdfFiscal", null);
            listaDados.put("pdfResponsavel", null);
            listaDados.put("codigoHash", "");
            listaDados.put("dataConferencia", "");
            listaDados.put("codigoUsuarioAssinatura", "");
            listaDados.put("resultadoTexto", "");
            for (ExamesImpressos examesImpressos : resultadoExame.getExames()) {
                if (!this.mesmoExameMaterial(codigoExame, codigoMaterialExame, examesImpressos)) continue;
                listaDados.put("codigoHash", this.getValor(examesImpressos.getRer_hash()));
                listaDados.put("dataConferencia", this.getValor(examesImpressos.getRer_dataconferencia()));
                listaDados.put("codigoUsuarioAssinatura", this.getValor(examesImpressos.getUsr_codconferencia()));
                listaDados.put("resultadoTexto", this.getValor(examesImpressos.getRer_resultadotexto()));
                break;
            }
            List<ExameWeb> examesConvenio = grupo.get("convenio");
            List<ExameWeb> examesMedico = grupo.get("medico");
            List<ExameWeb> examesPaciente = grupo.get("paciente");
            List<ExameWeb> examesDestino = grupo.get("destino");
            List<ExameWeb> examesFiscal = grupo.get("fiscal");
            List<ExameWeb> examesResponsavel = grupo.get("responsavel");
            if (!temExameProibido) {
                RetornoImpressaoResultados resultadoDestino = this.exportaPdfWeb(codigoFilial, codigoRequisicao, gerarPdfWeb, this.pegarParametrosGeracao(grupo, "destino"), arquivoPdf);
                String resultadoPdfSemBloqueio = resultadoDestino.getResultadoPdfWeb() != null ? new Base64().encodeAsString(resultadoDestino.getResultadoPdfWeb()) : "";
                listaDados.put("pdfPaciente", resultadoPdfSemBloqueio);
                listaDados.put("pdfMedico", resultadoPdfSemBloqueio);
                listaDados.put("pdfConvenio", resultadoPdfSemBloqueio);
                listaDados.put("pdfFiscal", resultadoPdfSemBloqueio);
                listaDados.put("pdfDestino", resultadoPdfSemBloqueio);
                listaDados.put("pdfResponsavel", resultadoPdfSemBloqueio);
            } else {
                for (String grupoExame : grupo.keySet()) {
                    if (!this.contemRegistros(grupo, grupoExame)) continue;
                    RetornoImpressaoResultados resultado = this.exportaPdfWeb(codigoFilial, codigoRequisicao, gerarPdfWeb, this.pegarParametrosGeracao(grupo, grupoExame), arquivoPdf);
                    resultadoPdf = resultado.getResultadoPdfWeb() != null ? new Base64().encodeAsString(resultado.getResultadoPdfWeb()) : "";
                    listaDados.put(this.getKey(grupoExame), resultadoPdf);
                }
            }
        }
        return listaDados;
    }

    private boolean mesmoExameMaterial(String codigoExame, String codigoMaterialExame, ExamesImpressos examesImpressos) {
        return examesImpressos.getCodigoExame().equalsIgnoreCase(codigoExame) && codigoMaterialExame.equalsIgnoreCase("" + examesImpressos.getCodigoMaterial());
    }

    private boolean contemRegistros(Map<String, List<ExameWeb>> grupo, String grupoExame) {
        return grupo.get(grupoExame) != null && !grupo.get(grupoExame).isEmpty();
    }

    private String getValor(String valor) {
        String retorno = "";
        if (!Funcoes.textoVazio(valor)) {
            retorno = valor;
        }
        return retorno;
    }

    private boolean contemResultado(RetornoImpressaoResultados resultadoExame) {
        return resultadoExame != null;
    }

    private boolean contemValor(String[] obj) {
        return obj != null && obj.length > 0 && (obj.length != 1 || !Funcoes.textoVazio(obj[0]));
    }

    private String getKey(String grupoExame) {
        return "pdf" + this.capitalize(grupoExame);
    }

    private String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private RetornoImpressaoResultados exportaPdfWeb(String codigoFilial, String codigoRequisicao, boolean gerarPdfWeb, Object[] parametros, String arquivoPdf) throws SQLException {
        if (parametros != null && parametros.length > 0) {
            return ImpressaoResultados.imprimirExames(null, null, codigoFilial, codigoRequisicao, true, ParametrosGerais.getConferencia(), null, (String[])parametros[0], (String[])parametros[1], true, arquivoPdf, gerarPdfWeb, true, null, false, "", true, false);
        }
        return null;
    }
}

