/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.exportadores;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.exportadores.InfoComplementar;
import jalis.laboratorio.util.parsers.alvaro.DadoAdicional;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.mercolabws.dto.DadosAdicionaisMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.ExameMercolabDTO;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.laboratorio.util.parsers.saomarcos.ExameSaoMarcos;
import jalis.laboratorio.util.parsers.softlab.dto.CampoDeColetaDTO;
import jalis.laboratorio.util.parsers.softlab.dto.TipoDeExameDTO;
import jalis.laboratorio.util.parsers.solucaov2.ExameSolucao;
import jalis.model.dao.exportadores.DadosAdicionaisDao;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaLabExternoVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class DadosAdicionaisService {
    private DadosAdicionaisDao dao = new DadosAdicionaisDao();
    private static final String SIM = "SIM";
    private static final String VOLUME = "vol";
    private static final String PESO = "peso";
    private static final String ALTURA = "altura";
    private static final String infoComplementar = "InformacaoComplementar";

    public String getXMLExame(Registro exa, String codLabExterno) throws SQLException {
        return this.dao.getXMLExame(this.montaVO(exa, codLabExterno));
    }

    public boolean contemValores(List<InfoComplementar> infoComplementares) {
        for (InfoComplementar info : infoComplementares) {
            if (!Boolean.TRUE.equals(info.getIsObrigatorio())) continue;
            if (!Funcoes.textoVazio(info.getValor().toString())) {
                String[] stringArray = new String[]{",", ".", "/", "-", ":"};
                if (!(Double.valueOf(StringUtil.limpaString(info.getValor().toString(), stringArray)) <= 0.0)) continue;
            }
            return false;
        }
        return true;
    }

    private ExameMatColetaLabExternoVO montaVO(Registro exa, String codLabExterno) {
        ExameMatColetaLabExternoVO exameMatColetaLabExternoVO = new ExameMatColetaLabExternoVO();
        FilialVO filialVO = new FilialVO();
        ExameVO exameVO = new ExameVO();
        MaterialColetaVO materialVO = new MaterialColetaVO();
        LabExternoVO labExternoVO = new LabExternoVO();
        filialVO.setCodigo(exa.getInt("fil_codigo"));
        exameVO.setCodigo(exa.getString("exa_codigo"));
        materialVO.setCodigo(exa.getInt("mco_codigo"));
        labExternoVO.setCodigo(Integer.parseInt(codLabExterno));
        exameMatColetaLabExternoVO.setFilial(filialVO);
        exameMatColetaLabExternoVO.setExame(exameVO);
        exameMatColetaLabExternoVO.setMatColeta(materialVO);
        exameMatColetaLabExternoVO.setLayout(labExternoVO);
        return exameMatColetaLabExternoVO;
    }

    public List<InfoComplementar> carregaInfoComplementar(ExameHPardini exHPardini, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        for (String infoComplementar : exHPardini.getInformacoesComplementares()) {
            InfoComplementar info = new InfoComplementar();
            if (exHPardini.contemInfoComp("VolumeDiurese") && infoComplementar.equalsIgnoreCase("VolumeDiurese")) {
                info.setNome("Volume diurese (ml) ");
                info.setIsObrigatorio(true);
                info.setTag("VolumeDiurese");
                info.setValor(this.getVolume(exa));
                info.setUnidade("ml");
                dados.add(info);
                continue;
            }
            if (exHPardini.contemInfoComp("TempoDiurese") && infoComplementar.equalsIgnoreCase("TempoDiurese")) {
                info.setNome("Tempo diurese ");
                info.setIsObrigatorio(true);
                info.setTag("TempoDiurese");
                info.setValor(exa.getString("exr_tempodiurese"));
                dados.add(info);
                continue;
            }
            if (exHPardini.contemInfoComp("TempoAmostra") && infoComplementar.equalsIgnoreCase("TempoAmostra")) {
                info.setNome("Tempo Amostra (Hora) ");
                info.setIsObrigatorio(true);
                info.setTag("TempoAmostra");
                info.setValor(exa.getString("exr_tempoamostra"));
                dados.add(info);
                continue;
            }
            if (exHPardini.contemInfoComp("PesoAmostra") && infoComplementar.equalsIgnoreCase("PesoAmostra")) {
                info.setNome("Peso Amostra (Gramas) ");
                info.setIsObrigatorio(true);
                info.setTag("PesoAmostra");
                info.setValor(exa.getString("exr_pesoamostra"));
                dados.add(info);
                continue;
            }
            if (exHPardini.contemInfoComp("LinfocitosAbsoluto") && infoComplementar.equalsIgnoreCase("LinfocitosAbsoluto")) {
                info.setNome("Contagem absoluta de linf\u00f3citos ");
                info.setIsObrigatorio(true);
                info.setTag("LinfocitosAbsoluto");
                info.setValor(exa.getString("exr_linfocitosabsoluto"));
                dados.add(info);
                continue;
            }
            if (exHPardini.contemInfoComp("Hematocrito") && infoComplementar.equalsIgnoreCase("Hematocrito")) {
                info.setNome(infoComplementar);
                info.setIsObrigatorio(true);
                info.setTag("Hematocrito");
                info.setValor(exa.getString("exr_hematocrito"));
                dados.add(info);
                continue;
            }
            if (infoComplementar.equalsIgnoreCase("Peso")) {
                info.setNome(infoComplementar);
                info.setIsObrigatorio(true);
                info.setTag("Peso");
                info.setValor(req.getString("req_peso").replace(".", ","));
                info.setUnidade("kg");
                dados.add(info);
                continue;
            }
            if (infoComplementar.equalsIgnoreCase("Altura")) {
                info.setNome(infoComplementar);
                info.setIsObrigatorio(true);
                info.setTag("Altura");
                info.setValor(req.getString("req_altura"));
                info.setUnidade("m");
                dados.add(info);
                continue;
            }
            if (infoComplementar.equalsIgnoreCase("Glicemia")) {
                info.setNome(infoComplementar);
                info.setIsObrigatorio(true);
                info.setTag("Glicemia");
                info.setValor(exa.getString("exr_glicemia"));
                dados.add(info);
                continue;
            }
            if (infoComplementar.equalsIgnoreCase("SemanaGestacao")) {
                info.setNome(infoComplementar);
                info.setIsObrigatorio(true);
                info.setTag("SemanaGestacao");
                info.setValor(req.getString("req_periodogestacional"));
                info.setUnidade("(semanas)");
                dados.add(info);
                continue;
            }
            if (infoComplementar.equalsIgnoreCase("DataSintoma")) {
                info.setNome("Data sintoma");
                info.setIsObrigatorio(true);
                info.setTag("DataSintoma");
                info.setValor(req.getString("req_datasintoma"));
                dados.add(info);
                continue;
            }
            if (infoComplementar.equalsIgnoreCase("MunicipioResidencia")) {
                info.setNome("Munic\u00edpio resid\u00eancia");
                info.setIsObrigatorio(true);
                info.setTag("MunicipioResidencia");
                info.setValor(req.getString("req_municipioresidencia"));
                dados.add(info);
                continue;
            }
            if (!infoComplementar.equalsIgnoreCase("Sintoma")) continue;
            info.setNome("Apresentou sintoma");
            info.setIsObrigatorio(true);
            info.setTag("Sintoma");
            info.setValor(req.getString("req_apresentousintoma"));
            dados.add(info);
        }
        return dados;
    }

    private Object getVolume(Registro exa) {
        Float valor = Float.valueOf(Funcoes.textoVazio(exa.getString("exr_volumediurese")) ? 0.0f : Float.valueOf(exa.getString("exr_volumediurese").replaceAll("\\,", ".")).floatValue());
        if (valor.floatValue() > 0.0f) {
            return Math.round(valor.floatValue());
        }
        return "";
    }

    public List<InfoComplementar> carregaInfoComplementarDB(Registro exameDB, Registro exa, Registro requisicao) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        List exames = exameDB.getValor("dadosAdicionais", List.class);
        if (this.isNotNull(exames)) {
            for (Registro exame : exames) {
                InfoComplementar info;
                if (exame.getValor("dadoAdicional").equals("Volume")) {
                    info = new InfoComplementar();
                    info.setIsObrigatorio(exame.getBoolean("selecionado"));
                    info.setTag("Volume");
                    info.setNome("Volume");
                    info.setValor(this.getVolume(exa));
                    info.setUnidade("ml");
                    dados.add(info);
                    continue;
                }
                if (exameDB.getValor("altura_obrigatorio").equals(SIM) && exame.getValor("dadoAdicional").equals("Altura")) {
                    info = new InfoComplementar();
                    info.setIsObrigatorio(exame.getBoolean("selecionado"));
                    info.setTag("Altura");
                    info.setNome("Altura");
                    info.setValor(requisicao.getString("req_altura").replace(".", ","));
                    info.setUnidade("m");
                    dados.add(info);
                    continue;
                }
                if (!exameDB.getValor("peso_obrigatorio").equals(SIM) || !exame.getValor("dadoAdicional").equals("Peso")) continue;
                info = new InfoComplementar();
                info.setIsObrigatorio(exame.getBoolean("selecionado"));
                info.setTag("Peso");
                info.setNome("Peso");
                info.setValor(requisicao.getString("req_peso").replace(".", ","));
                info.setUnidade("kg");
                dados.add(info);
            }
        }
        return dados;
    }

    public List<InfoComplementar> carregaInfoComplementarAlvaro(ExameAlvaro exAlvaro, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (exAlvaro.getDadosAdicionais().size() > 0) {
            for (DadoAdicional dado : exAlvaro.getDadosAdicionais()) {
                InfoComplementar info;
                String descricao = dado.getDescricao().toLowerCase();
                if (descricao.contains("volume")) {
                    info = new InfoComplementar();
                    info.setNome("Volume");
                    info.setTag("volume");
                    info.setValor(this.getVolume(exa));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase(PESO)) {
                    info = new InfoComplementar();
                    info.setNome("Peso");
                    info.setTag(PESO);
                    info.setValor(req.getString("req_peso").replace(".", ","));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase(ALTURA)) {
                    info = new InfoComplementar();
                    info.setNome("Altura");
                    info.setTag(ALTURA);
                    info.setValor(req.getString("req_altura").replace(".", ","));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("Data da \u00faltima menstrua\u00e7\u00e3o")) {
                    info = new InfoComplementar();
                    info.setNome("DUM");
                    info.setTag("dum");
                    try {
                        info.setValor(!Funcoes.textoVazio(req.getString("req_dum")) ? Funcoes.formataData("dd/MM/yyyy", req.getDate("req_dum")) : "");
                    }
                    catch (ParseException e) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Erro ao carregar DUM", 5);
                    }
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().equalsIgnoreCase("rg")) {
                    info = new InfoComplementar();
                    info.setNome("RG");
                    info.setTag("rg");
                    info.setValor(exa.getString("pac_rg"));
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().equalsIgnoreCase("cpf")) {
                    info = new InfoComplementar();
                    info.setNome("CPF");
                    info.setTag("cpf");
                    info.setValor(exa.getString("pac_cpf"));
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("leucocitos")) {
                    info = new InfoComplementar();
                    info.setNome("Leuc\u00f3citos");
                    info.setTag("leucocitos");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("n\u00famero de leuc\u00f3citos")) {
                    info = new InfoComplementar();
                    info.setNome("N\u00famero de Leuc\u00f3citos");
                    info.setTag("leucocitos");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("hemacias")) {
                    info = new InfoComplementar();
                    info.setNome("Hem\u00e1cias");
                    info.setTag("hemacias");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("hemoglobina")) {
                    info = new InfoComplementar();
                    info.setNome("Hemoglobina");
                    info.setTag("hemoglobina");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("hematocrito")) {
                    info = new InfoComplementar();
                    info.setNome("Hemat\u00f3crito");
                    info.setTag("hematocrito");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("plaquetas")) {
                    info = new InfoComplementar();
                    info.setNome("Plaquetas");
                    info.setTag("plaquetas");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (dado.toString().contains("IdadeGestacionalSemanas")) {
                    info = new InfoComplementar();
                    info.setNome("Idade gestacional (n\u00ba semanas)");
                    info.setTag("IdadeGestacionalSemanas");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (dado.toString().equalsIgnoreCase("IdadeGestacional")) {
                    info = new InfoComplementar();
                    info.setNome("Idade gestacional (meses)");
                    info.setTag("IdadeGestacional");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (dado.toString().contains("NorovirusRNA")) {
                    info = new InfoComplementar();
                    info.setNome("Norov\u00edrus RNA");
                    info.setTag("NorovirusRNA");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (dado.toString().contains("TipoAmostra")) {
                    info = new InfoComplementar();
                    info.setNome("Tipo de amostra");
                    info.setTag("TipoAmostra");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (descricao.contains("cadeia")) {
                    info = new InfoComplementar();
                    info.setNome("N\u00famero da cadeia de cust\u00f3dia");
                    info.setTag("NumeroCadeiaCustodia");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade("");
                    dados.add(info);
                    continue;
                }
                if (!dado.toString().contains("Idade Materna")) continue;
                info = new InfoComplementar();
                info.setNome(dado.toString());
                info.setTag("IdadeMaterna");
                info.setValor("");
                info.setIsObrigatorio(true);
                info.setUnidade("");
                dados.add(info);
            }
        }
        return dados;
    }

    public List<InfoComplementar> carregaInfoComplementarConcent(ExameAlvaro exAlvaro, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (exAlvaro.getDadosAdicionais().size() > 0) {
            for (DadoAdicional dado : exAlvaro.getDadosAdicionais()) {
                InfoComplementar info;
                String descricao = dado.getDescricao().replace("?", "").toLowerCase();
                if (descricao.contains("volume")) {
                    info = new InfoComplementar();
                    String nome = descricao + "(" + dado.getUnidade().trim() + ")";
                    info.setNome(nome);
                    info.setTag("volume");
                    info.setValor(this.getVolume(exa));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase(PESO) || descricao.equalsIgnoreCase("peso do paciente")) {
                    info = new InfoComplementar();
                    info.setNome(descricao);
                    info.setTag(PESO);
                    info.setValor(req.getString("req_peso").replace(".", ","));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase(ALTURA)) {
                    info = new InfoComplementar();
                    info.setNome(descricao);
                    info.setTag(ALTURA);
                    info.setValor(req.getString("req_altura").replace(".", ","));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().equalsIgnoreCase("rg")) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag("rg");
                    info.setValor(exa.getString("pac_rg"));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().equalsIgnoreCase("cpf")) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag("cpf");
                    info.setValor(exa.getString("pac_cpf"));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("leucocitos")) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag("leucocitos");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("hemacias")) {
                    info = new InfoComplementar();
                    info.setNome(descricao);
                    info.setTag("hemacias");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("hemoglobina")) {
                    info = new InfoComplementar();
                    info.setNome(descricao);
                    info.setTag("hemoglobina");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase("hematocrito")) {
                    info = new InfoComplementar();
                    info.setNome(descricao);
                    info.setTag("hematocrito");
                    info.setValor("");
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (!descricao.equalsIgnoreCase("plaquetas")) continue;
                info = new InfoComplementar();
                info.setNome(descricao);
                info.setTag("plaquetas");
                info.setValor("");
                info.setIsObrigatorio(true);
                info.setUnidade(dado.getUnidade());
                dados.add(info);
            }
        }
        return dados;
    }

    public List<InfoComplementar> carregaInfoComplementarJalisWS(ExameAlvaro exAlvaro, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (exAlvaro.getDadosAdicionais().size() > 0) {
            for (DadoAdicional dado : exAlvaro.getDadosAdicionais()) {
                InfoComplementar info;
                if (dado.getDescricao().contains("volume")) {
                    info = new InfoComplementar();
                    String nome = dado.getDescricao() + "(" + dado.getUnidade().trim() + ")";
                    info.setNome(nome);
                    info.setTag("volume");
                    info.setValor(this.getVolume(exa));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().contains(PESO)) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag(PESO);
                    info.setValor(req.getString("req_peso").replace(".", ","));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().contains(ALTURA)) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao() + "(cm)");
                    info.setTag(ALTURA);
                    info.setValor(req.getString("req_altura"));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().contains("dum")) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag("dum");
                    try {
                        info.setValor(Funcoes.formataData(req.getDate("req_dum")));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().contains("tempodiurese")) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag("tempodiurese");
                    info.setValor(exa.getString("exr_tempodiurese"));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().contains("tempojejum")) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag("tempojejum");
                    info.setValor(exa.getString("exr_intervalojejum"));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().contains("periodogestacional")) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag("periodogestacional");
                    info.setValor(req.getString("req_periodogestacional"));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (!dado.getDescricao().contains("medicamento")) continue;
                info = new InfoComplementar();
                info.setNome(dado.getDescricao());
                info.setTag("medicamento");
                info.setValor(req.getString("medicamentos"));
                info.setIsObrigatorio(true);
                dados.add(info);
            }
        }
        return dados;
    }

    public List<InfoComplementar> carregaInfoComplementarSolucao(ExameSolucao exAlvaro, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (exAlvaro.getDadosAdicionais().size() > 0) {
            for (DadoAdicional dado : exAlvaro.getDadosAdicionais()) {
                InfoComplementar info;
                if (dado.getDescricao().equalsIgnoreCase("volume")) {
                    info = new InfoComplementar();
                    String nome = dado.getDescricao() + "(" + dado.getUnidade().trim() + ")";
                    info.setNome(nome);
                    info.setTag("volume");
                    info.setValor(this.getVolume(exa));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().equalsIgnoreCase(PESO)) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag(PESO);
                    info.setValor(req.getString(PESO).replace(".", ","));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (dado.getDescricao().equalsIgnoreCase(ALTURA)) {
                    info = new InfoComplementar();
                    info.setNome(dado.getDescricao());
                    info.setTag(ALTURA);
                    info.setValor(req.getString("req_altura"));
                    info.setIsObrigatorio(true);
                    dados.add(info);
                    continue;
                }
                if (!dado.getDescricao().equalsIgnoreCase("data")) continue;
                info = new InfoComplementar();
                info.setNome(dado.getDescricao());
                info.setTag("data");
                info.setValor(req.getString("pac_dum").replace(".", ""));
                info.setIsObrigatorio(true);
                dados.add(info);
            }
        }
        return dados;
    }

    public List<InfoComplementar> carregaInfoComplementarCerba(Registro exameCerba, Registro exa, Registro requisicao) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        List dadosAd = exameCerba.getValor("dadosAdicionais", List.class);
        float volume = 0.0f;
        float peso = 0.0f;
        float altura = 0.0f;
        if (!Funcoes.textoVazio(exa.getString("exr_volumediurese"))) {
            volume = Float.valueOf(exa.getString("exr_volumediurese")).floatValue();
        }
        if (requisicao.getValor("req_peso") != null && !Funcoes.textoVazio(requisicao.getString("req_peso"))) {
            peso = Float.valueOf(requisicao.getString("req_peso")).floatValue();
        }
        if (requisicao.getValor("req_peso") != null && !Funcoes.textoVazio(requisicao.getString("req_altura"))) {
            altura = Float.valueOf(requisicao.getString("req_altura")).floatValue();
        }
        if (null != dadosAd && !dadosAd.isEmpty()) {
            for (Registro dado : dadosAd) {
                InfoComplementar info;
                if (dado.getString("dadoAdicional").equalsIgnoreCase("Volume") && volume > 0.0f) {
                    info = new InfoComplementar();
                    info.setIsObrigatorio(dado.getBoolean("selecionado"));
                    info.setTag("Volume");
                    info.setNome("Volume");
                    info.setValor(this.getVolume(exa));
                    info.setUnidade("ml");
                    dados.add(info);
                } else if (dado.getString("dadoAdicional").equalsIgnoreCase("Peso") && peso > 0.0f) {
                    info = new InfoComplementar();
                    info.setIsObrigatorio(dado.getValor("altura_obrigatorio").equals(SIM));
                    info.setTag("Peso");
                    info.setNome("Peso");
                    info.setValor(requisicao.getString("req_peso").replace(".", ","));
                    info.setUnidade("kg");
                    dados.add(info);
                }
                if (!dado.getString("dadoAdicional").equalsIgnoreCase("Altura") || !(altura > 0.0f)) continue;
                info = new InfoComplementar();
                info.setIsObrigatorio(dado.getValor("peso_obrigatorio").equals(SIM));
                info.setTag("Altura");
                info.setNome("Altura");
                info.setValor(requisicao.getString("req_altura").replace(".", ","));
                info.setUnidade("m");
                dados.add(info);
            }
        }
        return dados;
    }

    private boolean isNotNull(List<Registro> list) {
        return list != null;
    }

    public List<InfoComplementar> carregaInfoComplementarSaoMarcos(ExameSaoMarcos exSaoMarcos, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (this.contemDadosAdicionais(exSaoMarcos)) {
            for (DadoAdicional dado : exSaoMarcos.getDadosAdicionais()) {
                String nome;
                InfoComplementar info;
                String descricao = dado.getDescricao().replace("?", "").toLowerCase();
                if (descricao.contains(VOLUME)) {
                    info = new InfoComplementar();
                    nome = descricao;
                    info.setNome(nome);
                    info.setTag(VOLUME);
                    info.setValor(this.getVolume(exa));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (descricao.equalsIgnoreCase(PESO)) {
                    info = new InfoComplementar();
                    nome = descricao;
                    info.setNome(nome);
                    info.setTag(PESO);
                    info.setValor(req.getString("req_peso").replace(".", ","));
                    info.setIsObrigatorio(true);
                    info.setUnidade(dado.getUnidade());
                    dados.add(info);
                    continue;
                }
                if (!descricao.equalsIgnoreCase(ALTURA)) continue;
                info = new InfoComplementar();
                nome = descricao;
                info.setNome(nome);
                info.setTag(ALTURA);
                info.setValor(req.getString("req_altura").replace(".", ","));
                info.setIsObrigatorio(true);
                info.setUnidade(dado.getUnidade());
                dados.add(info);
            }
        }
        return dados;
    }

    private boolean contemDadosAdicionais(ExameSaoMarcos exSaoMarcos) {
        return exSaoMarcos.getDadosAdicionais().size() > 0;
    }

    private boolean contemDadosAdicionais(ExameMercolabDTO exMercolab) {
        return exMercolab.getDadosAdicionaisMercolab().size() > 0;
    }

    private boolean contemDadosAdicionais(TipoDeExameDTO exSoftLab) {
        return !exSoftLab.getCamposDeColeta().isEmpty();
    }

    public List<InfoComplementar> carregaInfoComplementarMercolab(ExameMercolabDTO exMercolab, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (this.contemDadosAdicionais(exMercolab)) {
            for (DadosAdicionaisMercolabDTO dado : exMercolab.getDadosAdicionaisMercolab()) {
                String descricao = dado.getInformacao().replace("?", "").toLowerCase();
                InfoComplementar info = new InfoComplementar();
                String nome = descricao;
                info.setNome(nome);
                info.setTag(infoComplementar);
                info.setValor("");
                info.setIsObrigatorio(true);
                info.setRespostas(dado.getRespostas());
                dados.add(info);
            }
        }
        return dados;
    }

    public List<InfoComplementar> carregaInfoComplementarSoftLab(TipoDeExameDTO exameSoftlab, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (!Funcoes.textoVazio(exameSoftlab.getCodigo()) && this.contemDadosAdicionais(exameSoftlab)) {
            for (CampoDeColetaDTO campo : exameSoftlab.getCamposDeColeta()) {
                String descricao = campo.getDescricao();
                String mascara = !Funcoes.textoVazio(campo.getMascara()) ? " ( " + campo.getMascara() + " )" : "";
                InfoComplementar info = new InfoComplementar();
                info.setNome(descricao + mascara);
                info.setTag(infoComplementar);
                info.setValor("");
                info.setIsObrigatorio(true);
                info.setUnidade(campo.getUnidade());
                dados.add(info);
            }
        }
        return dados;
    }

    public List<InfoComplementar> carregaJejumSoftLab(TipoDeExameDTO exameSoftlab, Registro exa, Registro req) {
        ArrayList<InfoComplementar> dados = new ArrayList<InfoComplementar>();
        if (exameSoftlab.isExigeJejum()) {
            InfoComplementar info = new InfoComplementar();
            info.setNome("Jejum");
            info.setTag("JejumSoftLab");
            info.setValor("");
            info.setIsObrigatorio(true);
            dados.add(info);
        }
        return dados;
    }
}

