/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueLanctoEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.dao.estoque.TransfEstoqueDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.RequisicaoEstoqueVO;
import jalis.model.vo.estoque.TransfEstoqueVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.RequisicaoEstoqueService;
import jalis.service.estoque.TransfEstoqueLanctoEstoqueService;
import jalis.service.estoque.TransfEstoqueMaterialService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;

public class TransfEstoqueService
extends AbstractThreadService {
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public TransfEstoqueService() {
        this.dao = new TransfEstoqueDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.get(Variaveis.filialPadrao, codigo, false);
    }

    public AbstractThreadBean get(String filial, String codigo, boolean trazerEstornados) throws Exception {
        return ((TransfEstoqueDao)this.dao).getBean(filial, codigo, trazerEstornados);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((TransfEstoqueDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        RequisicaoEstoqueService reqService;
        RequisicaoEstoqueBean reqBean;
        RequisicaoEstoqueVO reqVo;
        TransfEstoqueBean beanEstoque = (TransfEstoqueBean)bean;
        beanEstoque.setCodigo((Integer)codigo);
        ((TransfEstoqueDao)this.dao).insert(beanEstoque, filialPadrao);
        ArrayList<TransfEstoqueMaterialBean> materiais = beanEstoque.getMateriais();
        if (materiais != null && materiais.size() > 0) {
            TransfEstoqueMaterialService serviceMaterial = new TransfEstoqueMaterialService();
            LancamentoEstoqueService serviceLancto = new LancamentoEstoqueService();
            TransfEstoqueLanctoEstoqueService serviceEstoqueLancto = new TransfEstoqueLanctoEstoqueService();
            ArrayList<LancamentoEstoqueBean> listaLanctos = new ArrayList<LancamentoEstoqueBean>();
            for (int i = 0; i < materiais.size(); ++i) {
                TransfEstoqueMaterialBean materialBean = materiais.get(i);
                materialBean.setTransfEstoque((TransfEstoqueVO)beanEstoque.toVO());
                serviceMaterial.insert(materialBean, null, filialPadrao, filiais);
                LancamentoEstoqueBean lanctoBean = new LancamentoEstoqueBean();
                lanctoBean.setCelulaEstoque(beanEstoque.getCelulaOrigem());
                lanctoBean.setDataConciliacao(beanEstoque.getDataHora());
                lanctoBean.setDataHora(beanEstoque.getDataHora());
                lanctoBean.setFilial(materialBean.getFilial());
                lanctoBean.setMaterial(materialBean.getMaterial());
                lanctoBean.setQuantidade(materialBean.getQuantidade());
                lanctoBean.setSituacao("O");
                lanctoBean.setTipoOrigem("T");
                lanctoBean.setUsuario(beanEstoque.getUsuario());
                lanctoBean.setUsuarioConciliacao(beanEstoque.getUsuario());
                lanctoBean.setTipo("S");
                listaLanctos.add(lanctoBean);
                BigDecimal valorTotal = new BigDecimal(materialBean.getMaterial().getValorUnit() == null ? "0" : materialBean.getMaterial().getValorUnit().toString()).setScale(4, this.ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, this.ROUND));
                valorTotal = valorTotal.setScale(4, this.ROUND);
                serviceLancto.gravaAutoCopiaSemCommit(lanctoBean, 0, filialPadrao, true, null);
                if (materialBean.getMaterial().getSolicitarLote().booleanValue()) {
                    for (MaterialLoteBean materialLoteBean : lanctoBean.getMaterial().getLotes()) {
                        if (materialLoteBean.getRemovido().booleanValue() || materialLoteBean.isLoteEntrada() || !materialLoteBean.getAlterar()) continue;
                        new MaterialService().gerarMaterialLoteLancEstoqueAlteradoTransferencia(materialLoteBean.getMaterial().getFilial(), (LancamentoEstoqueVO)lanctoBean.toVO(), materialLoteBean);
                    }
                }
                Integer codigoLancamentoSaida = lanctoBean.getCodigo();
                TransfEstoqueLanctoEstoqueBean estoqueLanctoBean = new TransfEstoqueLanctoEstoqueBean();
                estoqueLanctoBean.setFilial(materialBean.getFilial());
                estoqueLanctoBean.setTransfEstoque((TransfEstoqueVO)beanEstoque.toVO());
                estoqueLanctoBean.setLancamentoEstoque((LancamentoEstoqueVO)lanctoBean.toVO());
                serviceEstoqueLancto.insert(estoqueLanctoBean, null, filialPadrao, filiais);
                lanctoBean = new LancamentoEstoqueBean();
                lanctoBean.setCelulaEstoque(beanEstoque.getCelulaDestino());
                lanctoBean.setDataConciliacao(null);
                lanctoBean.setDataHora(beanEstoque.getDataHora());
                lanctoBean.setFilial(materialBean.getFilial());
                lanctoBean.setMaterial(materialBean.getMaterial());
                lanctoBean.setQuantidade(materialBean.getQuantidade());
                lanctoBean.setSituacao("A");
                lanctoBean.setTipoOrigem("T");
                lanctoBean.setUsuario(beanEstoque.getUsuario());
                lanctoBean.setUsuarioConciliacao(null);
                lanctoBean.setTipo("E");
                listaLanctos.add(lanctoBean);
                serviceLancto.gravaAutoCopiaSemCommit(lanctoBean, 0, filialPadrao, true, null);
                if (materialBean.getMaterial().getSolicitarLote().booleanValue()) {
                    for (MaterialLoteBean materialLoteBean : lanctoBean.getMaterial().getLotes()) {
                        if (materialLoteBean.getRemovido().booleanValue() || !materialLoteBean.isLoteEntrada()) continue;
                        new MaterialService().gerarMaterialLoteLancEstoque(materialLoteBean.getMaterial().getFilial(), (LancamentoEstoqueVO)lanctoBean.toVO(), materialLoteBean);
                    }
                }
                estoqueLanctoBean = new TransfEstoqueLanctoEstoqueBean();
                estoqueLanctoBean.setFilial(materialBean.getFilial());
                estoqueLanctoBean.setTransfEstoque((TransfEstoqueVO)beanEstoque.toVO());
                estoqueLanctoBean.setLancamentoEstoque((LancamentoEstoqueVO)lanctoBean.toVO());
                serviceEstoqueLancto.insert(estoqueLanctoBean, null, filialPadrao, filiais);
            }
            beanEstoque.setLancamentos(listaLanctos);
        }
        if ((reqVo = beanEstoque.getRequisicao()) != null && (reqBean = (RequisicaoEstoqueBean)(reqService = new RequisicaoEstoqueService()).get(reqVo.getFilial().getCodigo().toString(), reqVo.getCodigo().toString())) != null) {
            reqBean.setSituacao("O");
            reqService.update(reqBean, null, filialPadrao, filiais);
        }
    }

    public void conciliaTransferencia(TransfEstoqueBean bean) throws Exception {
        if (bean == null) {
            return;
        }
        ArrayList<LancamentoEstoqueBean> lanctos = null;
        lanctos = bean.getLancamentos();
        if (lanctos == null) {
            throw new Exception("Nenhum lan\u00e7amento localizado.");
        }
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        for (int i = 0; i < lanctos.size(); ++i) {
            LancamentoEstoqueBean lancto = lanctos.get(i);
            if (lancto.getTipo().equalsIgnoreCase("S")) continue;
            lancto.setDataConciliacao(new Date());
            lancto.setUsuarioConciliacao(usuario);
            lancto.setSituacao("O");
            new LancamentoEstoqueService().gravaAutoCopiaSemCommit(lancto, 1, Variaveis.filialPadrao, true, null);
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return ((TransfEstoqueDao)this.dao).loadVO(TransfEstoqueBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return ((TransfEstoqueDao)this.dao).loadVO(TransfEstoqueVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("usuario", "Usu\u00e1rio", 0, "", 2, 0);
        tela.adicionaCampo("datahora", "Data/hora", 4, "", 2, 100);
        tela.setFiltroInicial("codigo", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao).append(" and tra_origem = '").append("T").append("'");
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public Hashtable pesquisaTransfEstoqueNaoConciliadaVO(Object owner, boolean trazerEstornadas) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando Transfer\u00eancias de Estoque n\u00e3o conferidas");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct tra.tra_codigo as tra_codigo, ");
            buf.append("                 tra.usr_codigo as usr_codigo, ");
            buf.append("                 tra.tra_datahora as tra_datahora, ");
            buf.append("                 celori.cel_descricao as cel_descricaoori, ");
            buf.append("                 celdest.cel_descricao as cel_descricaodest, ");
            buf.append("                 ree.ree_codigo as ree_codigo, ");
            buf.append("                 ree.ree_observacao as ree_observacao ");
            buf.append("   from transfestoque tra ");
            buf.append("   join transfestoquelanctoestoque tel on (tra.fil_codigo = tel.fil_codigo and tra.tra_codigo = tel.tra_codigo) ");
            buf.append("   join lanctoestoque lce on (tel.fil_codigo = lce.fil_codigo and tel.lce_codigo = lce.lce_codigo and lce.lce_situacao = UPPER('").append("A").append("')) ");
            buf.append("   join celulaestoque celori on (tra.cel_codorigem = celori.cel_codigo and tra.fil_codigo = celori.fil_codigo) ");
            buf.append("   join celulaestoque celdest on (tra.cel_coddestino = celdest.cel_codigo and tra.fil_codigo = celdest.fil_codigo) ");
            buf.append("   left join requisicaoestoque ree on (tra.fil_codigo = ree.fil_codigo and tra.ree_codigo = ree.ree_codigo) ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("tra.tra_codigo", "C\u00f3d.", 1, "", 3, 35);
            p.adicionaCampo("tra.usr_codigo", "Usu\u00e1rio", 0, "", 2, 0);
            p.adicionaCampo("tra.tra_datahora", "Data/Hora", 4, "", 3, 75);
            p.adicionaCampo("celori.cel_descricao", "C\u00e9l. Origem", 0, "", 3, 0);
            p.adicionaCampo("celdest.cel_descricao", "C\u00e9l. Destino", 0, "", 3, 0);
            p.adicionaCampo("ree.ree_codigo", "Req.", 1, "", 3, 40);
            p.adicionaCampo("ree.ree_observacao", "Observa\u00e7\u00e3o Req.", 0, "", 2, 0);
            p.setFiltroInicial("C\u00f3digo", 3);
            String filtro = "tra.fil_codigo = " + Variaveis.filialPadrao;
            if (!trazerEstornadas) {
                filtro = filtro + " and tra.tra_datacancelamento IS NULL ";
            }
            p.setFiltro(filtro);
            p.setOrdem("C\u00f3d.");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public Hashtable pesquisaTransfEstoqueConciliadaVO(Object owner, boolean trazerEstornadas) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando Transfer\u00eancias de Estoque conferidas");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct tra.tra_codigo as tra_codigo, ");
            buf.append("        tra.usr_codigo as usr_codigo, ");
            buf.append("        tra.tra_datahora as tra_datahora, ");
            buf.append("        celori.cel_descricao as cel_descricaoori, ");
            buf.append("        celdest.cel_descricao as cel_descricaodest, ");
            buf.append("        ree.ree_codigo as ree_codigo, ");
            buf.append("        ree.ree_observacao as ree_observacao ");
            buf.append("   from transfestoque tra ");
            buf.append("   join celulaestoque celori on (tra.cel_codorigem = celori.cel_codigo and tra.fil_codigo = celori.fil_codigo) ");
            buf.append("   join celulaestoque celdest on (tra.cel_coddestino = celdest.cel_codigo and tra.fil_codigo = celdest.fil_codigo) ");
            buf.append("   left join requisicaoestoque ree on (tra.fil_codigo = ree.fil_codigo and tra.ree_codigo = ree.ree_codigo) ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("tra.tra_codigo", "C\u00f3d.", 1, "", 3, 35);
            p.adicionaCampo("tra.usr_codigo", "Usu\u00e1rio", 0, "", 2, 0);
            p.adicionaCampo("tra.tra_datahora", "Data/Hora", 4, "", 3, 75);
            p.adicionaCampo("celori.cel_descricao", "C\u00e9l. Origem", 0, "", 3, 0);
            p.adicionaCampo("celdest.cel_descricao", "C\u00e9l. Destino", 0, "", 3, 0);
            p.adicionaCampo("ree.ree_codigo", "Req.", 1, "", 3, 40);
            p.adicionaCampo("ree.ree_observacao", "Observa\u00e7\u00e3o Req.", 0, "", 2, 0);
            p.setFiltroInicial("C\u00f3digo", 3);
            buf.setLength(0);
            buf.append("     tra.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and (select count(1) ");
            buf.append("        from transfestoquelanctoestoque b ");
            buf.append("        join lanctoestoque c on (b.fil_codigo = c.fil_codigo and b.lce_codigo = c.lce_codigo and c.lce_situacao = UPPER('").append("O").append("') and c.lce_tipo = UPPER('").append("E").append("')) ");
            buf.append("       where b.fil_codigo = tra.fil_codigo ");
            buf.append("         and b.tra_codigo = tra.tra_codigo ");
            buf.append("     ) > 0 ");
            if (!trazerEstornadas) {
                buf.append(" and tra.tra_datacancelamento IS NULL ");
            }
            p.setFiltro(buf.toString());
            p.setOrdem("C\u00f3d.");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((TransfEstoqueDao)this.dao).update(bean, filialPadrao);
    }
}

