/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueLanctoEstoqueBean;
import jalis.model.bean.estoque.TransfEstoqueMaterialBean;
import jalis.model.dao.estoque.TransfEstoqueMaterialDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteLanctoEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.TransfEstoqueLanctoEstoqueService;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class TransfEstoqueMaterialService
extends AbstractThreadService {
    private TransfEstoqueLanctoEstoqueService transfEstoqueLanctoEstoqueService = new TransfEstoqueLanctoEstoqueService();

    public TransfEstoqueMaterialService() {
        this.dao = new TransfEstoqueMaterialDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((TransfEstoqueMaterialDao)this.dao).delete(bean, filialPadrao);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    public AbstractThreadBean get(String filial, String codigoTransfEstoque, String codigoMaterial, boolean trazerEstornados) throws Exception {
        return ((TransfEstoqueMaterialDao)this.dao).getBean(filial, codigoTransfEstoque, codigoMaterial, trazerEstornados);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((TransfEstoqueMaterialDao)this.dao).insert(bean, filialPadrao);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        TransfEstoqueMaterialDao cfr_ignored_0 = (TransfEstoqueMaterialDao)this.dao;
        return TransfEstoqueMaterialDao.load(TransfEstoqueMaterialBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((TransfEstoqueMaterialDao)this.dao).update(bean, filialPadrao);
    }

    public ArrayList<TransfEstoqueMaterialBean> getMateriaisTransferenciaEstoque(String filial, String transferencia, boolean trazerEstornados) throws ThreadDaoException {
        return ((TransfEstoqueMaterialDao)this.dao).getMateriaisTransferenciaEstoque(filial, transferencia, trazerEstornados);
    }

    public void estornar(TransfEstoqueMaterialBean beanMat, LancamentoEstoqueBean lanctoSaida, Date dataEstorno, UsuarioVO usuarioEstorno, ArrayList<MaterialLoteLanctoEstoqueVO> listaMatLoteLanctoEntrada) throws Exception {
        if (listaMatLoteLanctoEntrada != null && listaMatLoteLanctoEntrada.size() > 0) {
            for (MaterialLoteLanctoEstoqueVO matLoteLanctoEntrada : listaMatLoteLanctoEntrada) {
                LancamentoEstoqueBean lanctoEntradaBean = new LancamentoEstoqueService().get(matLoteLanctoEntrada.getLancamento().getFilial().getCodigo().toString(), matLoteLanctoEntrada.getLancamento().getCodigo().toString());
                LancamentoEstoqueBean novoLanctoBean = new LancamentoEstoqueBean();
                novoLanctoBean.setCelulaEstoque(lanctoSaida.getCelulaEstoque());
                novoLanctoBean.setDataConciliacao(dataEstorno);
                novoLanctoBean.setDataHora(dataEstorno);
                novoLanctoBean.setDataHoraCancelamento(null);
                novoLanctoBean.setFilial(lanctoSaida.getFilial());
                novoLanctoBean.setLancamentoBaixaAutomatica(null);
                novoLanctoBean.setMaterial(lanctoSaida.getMaterial());
                novoLanctoBean.setQuantidade(matLoteLanctoEntrada.getQuantidadeAuxiliar());
                novoLanctoBean.setSituacao("O");
                novoLanctoBean.setTipo("E");
                novoLanctoBean.setTipoOrigem("X");
                novoLanctoBean.setUsuario(usuarioEstorno);
                novoLanctoBean.setUsuarioCancelamento(null);
                novoLanctoBean.setUsuarioConciliacao(usuarioEstorno);
                novoLanctoBean.setValorUnitario(lanctoEntradaBean.getValorUnitario());
                BigDecimal valorTotal = new BigDecimal(lanctoEntradaBean.getValorUnitario().toString()).multiply(new BigDecimal(matLoteLanctoEntrada.getQuantidadeAuxiliar().toString()));
                novoLanctoBean.setValorTotal(valorTotal.doubleValue());
                new LancamentoEstoqueService().gravaAutoCopiaSemCommit(novoLanctoBean, 0, beanMat.getFilial().getCodigo().toString(), false, null);
                String observacao = matLoteLanctoEntrada.getMaterialLote().getObservacao();
                observacao = !Funcoes.textoVazio(observacao) ? observacao + " - GERADO AUTOMATICAMENTE PELO ESTORNO DE TRANSF. ENTRE ESTOQUES" : "GERADO AUTOMATICAMENTE PELO ESTORNO DE TRANSF. ENTRE ESTOQUES";
                MaterialLoteBean matLote = new MaterialLoteBean();
                matLote.setAlterar(false);
                matLote.setCodigo(null);
                matLote.setDataHoraCriacao(dataEstorno);
                matLote.setDataHoraRemovido(null);
                matLote.setDataLote(matLoteLanctoEntrada.getMaterialLote().getDataLote());
                matLote.setFilial(matLoteLanctoEntrada.getFilial());
                matLote.setInserir(true);
                matLote.setLote(matLoteLanctoEntrada.getMaterialLote().getLote());
                matLote.setMaterial(matLoteLanctoEntrada.getMaterialLote().getMaterial());
                matLote.setObservacao(observacao);
                matLote.setQuantidade(matLoteLanctoEntrada.getQuantidadeAuxiliar());
                matLote.setQuantidadeConsumida(0.0);
                matLote.setQuantidadeConsumidaOriginal(0.0);
                matLote.setRemovido(false);
                matLote.setUsuarioCriacao(usuarioEstorno);
                matLote.setUsuarioRemocao(null);
                matLote.setValidadeLote(matLoteLanctoEntrada.getMaterialLote().getValidadeLote());
                MaterialLoteLanctoEstoqueBean matLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
                matLoteLanctoEstoque.setFilial(matLoteLanctoEntrada.getFilial());
                matLoteLanctoEstoque.setInserir(true);
                matLoteLanctoEstoque.setLancamento((LancamentoEstoqueVO)novoLanctoBean.toVO());
                matLoteLanctoEstoque.setQuantidade(matLoteLanctoEntrada.getQuantidadeAuxiliar());
                matLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)matLote.toVO());
                HashSet<MaterialLoteLanctoEstoqueBean> listaLanctosLote = new HashSet<MaterialLoteLanctoEstoqueBean>();
                listaLanctosLote.add(matLoteLanctoEstoque);
                matLote.setLancamentosEstoque(listaLanctosLote);
                new MaterialLoteService().gravaAutoCopiaSemCommit(matLote, 0, lanctoSaida.getFilial().getCodigo().toString(), null);
                TransfEstoqueLanctoEstoqueBean transfEstoqueLanctoEstoqueBean = new TransfEstoqueLanctoEstoqueBean();
                transfEstoqueLanctoEstoqueBean.setFilial(beanMat.getFilial());
                transfEstoqueLanctoEstoqueBean.setLancamentoEstoque((LancamentoEstoqueVO)novoLanctoBean.toVO());
                transfEstoqueLanctoEstoqueBean.setTransfEstoque(beanMat.getTransfEstoque());
                this.transfEstoqueLanctoEstoqueService.insert(transfEstoqueLanctoEstoqueBean, null, beanMat.getFilial().getCodigo().toString(), null);
            }
        } else {
            LancamentoEstoqueBean novoLanctoBean = new LancamentoEstoqueBean();
            novoLanctoBean.setCelulaEstoque(lanctoSaida.getCelulaEstoque());
            novoLanctoBean.setDataConciliacao(dataEstorno);
            novoLanctoBean.setDataHora(dataEstorno);
            novoLanctoBean.setDataHoraCancelamento(null);
            novoLanctoBean.setFilial(lanctoSaida.getFilial());
            novoLanctoBean.setLancamentoBaixaAutomatica(null);
            novoLanctoBean.setMaterial(lanctoSaida.getMaterial());
            novoLanctoBean.setQuantidade(lanctoSaida.getQuantidade());
            novoLanctoBean.setSituacao("O");
            novoLanctoBean.setTipo("E");
            novoLanctoBean.setTipoOrigem("X");
            novoLanctoBean.setUsuario(usuarioEstorno);
            novoLanctoBean.setUsuarioCancelamento(null);
            novoLanctoBean.setUsuarioConciliacao(usuarioEstorno);
            novoLanctoBean.setValorUnitario(lanctoSaida.getValorUnitario());
            BigDecimal valorTotal = new BigDecimal(lanctoSaida.getValorUnitario().toString()).multiply(new BigDecimal(lanctoSaida.getQuantidade().toString()));
            novoLanctoBean.setValorTotal(valorTotal.doubleValue());
            new LancamentoEstoqueService().gravaAutoCopiaSemCommit(novoLanctoBean, 0, beanMat.getFilial().getCodigo().toString(), false, null);
            TransfEstoqueLanctoEstoqueBean transfEstoqueLanctoEstoqueBean = new TransfEstoqueLanctoEstoqueBean();
            transfEstoqueLanctoEstoqueBean.setFilial(beanMat.getFilial());
            transfEstoqueLanctoEstoqueBean.setLancamentoEstoque((LancamentoEstoqueVO)novoLanctoBean.toVO());
            transfEstoqueLanctoEstoqueBean.setTransfEstoque(beanMat.getTransfEstoque());
            this.transfEstoqueLanctoEstoqueService.insert(transfEstoqueLanctoEstoqueBean, null, beanMat.getFilial().getCodigo().toString(), null);
        }
        beanMat.setDataEstorno(dataEstorno);
        beanMat.setUsuarioEstorno(usuarioEstorno);
        new TransfEstoqueMaterialService().gravaAutoCopiaSemCommit(beanMat, 1, beanMat.getFilial().getCodigo().toString(), null);
    }
}

