/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.Acesso;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.comum.pesquisa.CamposPesquisaService;
import jalis.comum.pesquisa.DialogoCadastroService;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.Material;
import jalis.laboratorio.estoque.pedido.ImportacaoNotaFiscalEntradaService;
import jalis.laboratorio.estoque.pedido.ItemNotaFiscalEntradaDTO;
import jalis.laboratorio.estoque.pedido.MaterialImportacaoDTO;
import jalis.model.vo.AbstractThreadVO;
import jalis.service.estoque.ListenerHierarquiaPesquisaMaterial;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TableUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class TelaPesquisaMateriais
extends JDialog
implements ActionListener,
DisposeListener {
    private static final int COL_CODIGO = 0;
    private static final int COL_DESCRICAO = 1;
    private static final int COL_TIPO = 2;
    private static final int COL_UNIDADE = 3;
    JPanel painelCabecalho = new JPanel(new GridBagLayout());
    JPanel painelLocalizar = new JPanel(new GridBagLayout());
    JLabel labelNF = new JLabel("NF: ");
    JLabel lblCodigoNF = new JLabel();
    JLabel labelSerie = new JLabel("S\u00e9rie: ");
    JLabel lblSerie = new JLabel();
    JLabel labelFornecedor = new JLabel("Fornecedor: ");
    JLabel lblForncedor = new JLabel();
    JLabel labelCodProduto = new JLabel("C\u00f3d. Prod.:");
    JLabel lblCodProduto = new JLabel();
    JLabel labelDescProduto = new JLabel("Desc. Prod.:");
    JLabel lblDescProduto = new JLabel();
    JLabel lblLocalizar = new JLabel("Localizar:");
    JTextField txtLocalizar = new JTextField();
    DefaultTableModel modelo;
    JTable table;
    JScrollPane scroll;
    JButton btnSelecionar = new JButton("Selecionar");
    JButton btnCancelar = new JButton("Cancelar");
    JButton btnCadastrar = new JButton("Cadastrar");
    private String tituloTela = "Pesquisando materiais";
    private String filial = Variaveis.filialPadrao;
    private long moduloCadPadrao = Material.getModuloAcesso();
    private AbstractThreadVO bean = null;
    private boolean selecionou = false;
    private boolean cancelada = false;
    ItemNotaFiscalEntradaDTO produto;
    private List<String> codigosJaInseridos = new ArrayList<String>();

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.btnSelecionar || o == this.btnCancelar) {
                boolean bl = this.selecionou = o == this.btnSelecionar;
                if (this.selecionou) {
                    if (this.table.getSelectedRow() < 0) {
                        Funcoes.mensagem(this, "\u00c9 necess\u00e1rio selecionar um material", 2);
                    } else {
                        String codigoMat = (String)this.table.getValueAt(this.table.getSelectedRow(), 0);
                        if (this.codigosJaInseridos.contains(codigoMat)) {
                            Funcoes.mensagem(this, "Esse material j\u00e1 foi inserido na nota fiscal.", 2);
                        } else {
                            this.codigosJaInseridos.add(codigoMat);
                            this.cancelada = false;
                            this.dispose();
                        }
                    }
                } else {
                    this.cancelada = true;
                    this.dispose();
                }
            } else if (o == this.btnCadastrar) {
                this.abrirTelaCadastro();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "TelaPesquisaMateriais (112)");
        }
    }

    public static TelaPesquisaMateriais novaInstancia(Object pai, String titulo, AbstractThreadVO bean, String codigoNF, String serie, String fornecedor, ItemNotaFiscalEntradaDTO produto, List<String> codigosJaInseridos) {
        if (pai instanceof Frame) {
            return new TelaPesquisaMateriais((Frame)pai, titulo, bean, codigoNF, serie, fornecedor, produto, codigosJaInseridos);
        }
        if (pai instanceof Dialog) {
            return new TelaPesquisaMateriais((Dialog)pai, titulo, bean, codigoNF, serie, fornecedor, produto, codigosJaInseridos);
        }
        return null;
    }

    public TelaPesquisaMateriais(Dialog dialog, String titulo, AbstractThreadVO bean, String codigoNF, String serie, String fornecedor, ItemNotaFiscalEntradaDTO produto, List<String> codigosJaInseridos) {
        super(dialog, titulo, true);
        this.bean = bean;
        this.codigosJaInseridos = codigosJaInseridos;
        this.produto = produto;
        this.iniciar();
        this.ajustarCamposFonte(codigoNF, serie, fornecedor);
        this.setLocationRelativeTo(dialog);
    }

    public TelaPesquisaMateriais(Frame frame, String titulo, AbstractThreadVO bean, String codigoNF, String serie, String fornecedor, ItemNotaFiscalEntradaDTO produto, List<String> codigosJaInseridos) {
        super(frame, titulo, true);
        this.bean = bean;
        this.produto = produto;
        this.codigosJaInseridos = codigosJaInseridos;
        if (frame instanceof Laboratorio) {
            ((Laboratorio)frame).addDisposeListener(this);
        }
        this.ajustarCamposFonte(codigoNF, serie, fornecedor);
        this.iniciar();
        this.setLocationRelativeTo(frame);
    }

    public boolean isCancelada() {
        return this.cancelada;
    }

    private void ajustarCamposFonte(String codigoNF, String serie, String fornecedor) {
        Font f = this.labelNF.getFont();
        f = new Font(f.getFontName(), 1, f.getSize());
        this.lblCodigoNF.setText(this.labelNF.getText() + " " + codigoNF);
        this.lblSerie.setText(this.labelSerie.getText() + " " + serie);
        this.lblForncedor.setText(this.labelFornecedor.getText() + " " + fornecedor);
        this.lblCodProduto.setText(this.labelCodProduto.getText() + " " + this.produto.getcProd());
        this.lblDescProduto.setText(this.labelDescProduto.getText() + " " + this.produto.getDescricaoProduto());
        this.lblCodigoNF.setFont(f);
        this.lblSerie.setFont(f);
        this.lblForncedor.setFont(f);
        this.lblCodProduto.setFont(f);
        this.lblDescProduto.setFont(f);
    }

    private void iniciar() {
        this.txtLocalizar.addHierarchyListener(new ListenerHierarquiaPesquisaMaterial());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        c.gridx = 0;
        this.painelCabecalho.add((Component)this.lblCodProduto, c);
        c.weightx = 1.0;
        c.gridx = 1;
        this.painelCabecalho.add((Component)this.lblDescProduto, c);
        c.gridy = 1;
        c.gridx = 0;
        this.painelCabecalho.add((Component)this.lblCodigoNF, c);
        c.weightx = 1.0;
        c.gridx = 1;
        this.painelCabecalho.add((Component)this.lblForncedor, c);
        c.gridx = 2;
        this.painelCabecalho.add((Component)this.lblSerie, c);
        this.scroll = new JScrollPane();
        JPanel pane = new JPanel(new BorderLayout());
        this.setContentPane(pane);
        this.btnCadastrar.setVisible(false);
        pane.setLayout(new BorderLayout());
        pane.setBorder(ScreenUtil.criarBordaVazia());
        pane.add((Component)this.painelCabecalho, "North");
        pane.add((Component)this.scroll, "Center");
        pane.add((Component)this.painelLocalizar, "South");
        pane.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0, true), "F3_PRESSIONADO");
        pane.getActionMap().put("F3_PRESSIONADO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaPesquisaMateriais.this.abrirTelaCadastro();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TelaPesquisaMateriais.this.reposicionar();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                TelaPesquisaMateriais.this.btnCadastrar.setVisible(Acesso.getAcesso(TelaPesquisaMateriais.this.moduloCadPadrao));
                if (TelaPesquisaMateriais.this.moduloCadPadrao != -1L) {
                    TelaPesquisaMateriais.this.table.setToolTipText("F3 - Abrir tela de cadastro");
                }
            }
        });
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        cons.anchor = 17;
        this.painelLocalizar.add((Component)this.lblLocalizar, cons);
        cons.gridx = 1;
        cons.fill = 2;
        cons.weightx = 2.0;
        this.txtLocalizar.setPreferredSize(new Dimension(100, 22));
        this.txtLocalizar.setMinimumSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.txtLocalizar, cons);
        cons.gridx = 2;
        this.btnSelecionar.setPreferredSize(new Dimension(100, 22));
        this.btnSelecionar.setMinimumSize(new Dimension(100, 22));
        this.btnSelecionar.setName("btnSelecionar");
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.insets = new Insets(1, 1, 1, 1);
        this.painelLocalizar.add((Component)this.btnSelecionar, cons);
        cons.gridx = 3;
        this.btnCancelar.setPreferredSize(new Dimension(100, 22));
        this.btnCancelar.setMinimumSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.btnCancelar, cons);
        cons.gridx = 4;
        this.btnCadastrar.setPreferredSize(new Dimension(100, 22));
        this.btnCadastrar.setPreferredSize(new Dimension(100, 22));
        this.painelLocalizar.add((Component)this.btnCadastrar, cons);
        this.lblLocalizar.setDisplayedMnemonic('L');
        this.lblLocalizar.setLabelFor(this.txtLocalizar);
        this.btnSelecionar.addActionListener(this);
        this.btnSelecionar.setMnemonic('n');
        this.btnCancelar.addActionListener(this);
        this.btnCancelar.setMnemonic('C');
        this.btnCadastrar.setMnemonic('t');
        this.btnCadastrar.addActionListener(this);
        Funcoes.montaEnter((JComponent)this.painelLocalizar);
        this.txtLocalizar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TelaPesquisaMateriais.this.localizar(TelaPesquisaMateriais.this.txtLocalizar.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TelaPesquisaMateriais.this.localizar(TelaPesquisaMateriais.this.txtLocalizar.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.txtLocalizar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (TelaPesquisaMateriais.this.table.getRowCount() > 0) {
                    int row = TelaPesquisaMateriais.this.table.getSelectedRow();
                    if (row < 0) {
                        TelaPesquisaMateriais.this.table.setRowSelectionInterval(0, 0);
                    } else if (row < TelaPesquisaMateriais.this.table.getRowCount() - 1 && e.getKeyCode() == 40) {
                        TelaPesquisaMateriais.this.table.setRowSelectionInterval(row + 1, row + 1);
                        TelaPesquisaMateriais.this.table.grabFocus();
                        TableUtil.scrollToVisible(TelaPesquisaMateriais.this.table, row);
                    } else if (row > 0 && e.getKeyCode() == 38) {
                        TelaPesquisaMateriais.this.table.setRowSelectionInterval(row - 1, row - 1);
                        TelaPesquisaMateriais.this.table.grabFocus();
                        TableUtil.scrollToVisible(TelaPesquisaMateriais.this.table, row);
                    }
                }
            }
        });
        this.setName("TelaPesquisaMaterial");
        this.txtLocalizar.setName("txtLocalizar");
        this.btnCadastrar.setName("btnCadastrar");
        this.btnCancelar.setName("btnCancelar");
        this.configTable();
        this.setSize(new Dimension(700, 300));
        this.setModal(true);
        this.reposicionar();
        this.preencheLocalizados();
    }

    private void preencheLocalizados() {
        List<MaterialImportacaoDTO> materiais = ImportacaoNotaFiscalEntradaService.getTodosMateriaisComAlternativo(Variaveis.filialPadrao, this.produto.getcProd());
        this.configTable();
        for (MaterialImportacaoDTO mat : materiais) {
            this.modelo.addRow(new String[]{mat.getCodigo(), mat.getDescricao(), mat.getDescricaoTipo(), mat.getUnidadeMedida()});
        }
    }

    private void localizar(String valor) {
        if (Funcoes.textoVazio(valor)) {
            ((TableRowSorter)this.table.getRowSorter()).setRowFilter(null);
        } else {
            ((TableRowSorter)this.table.getRowSorter()).setRowFilter(RowFilter.regexFilter("(?i)" + valor, new int[0]));
        }
    }

    public String getRegistroSelecionado() {
        if (this.selecionou && this.table.getSelectedRow() > -1) {
            return (String)this.modelo.getValueAt(this.table.getSelectedRow(), 0);
        }
        return null;
    }

    private void reposicionar() {
        Dimension d = this.getContentPane().getSize();
        this.painelCabecalho.setPreferredSize(new Dimension(100, 33));
        this.painelLocalizar.setPreferredSize(new Dimension(100, 33));
    }

    private boolean temAcesso() {
        return Acesso.getAcesso(Material.getModuloAcesso());
    }

    private void abrirTelaCadastro() {
        Material cadPadrao;
        if (this.temAcesso() && (cadPadrao = new Material(this.produto.getcProd())) != null) {
            try {
                CamposPesquisaService campo = new CamposPesquisaService("codigo", "mat_codigo");
                campo.setTipo(1);
                DialogoCadastroService dc = new DialogoCadastroService(this, this.tituloTela, (FrmCadPadrao)cadPadrao, campo, "");
                dc.setVisible(true);
                if (!StringUtil.isEmpty(cadPadrao.getRetornoParaPesquisa()) && !this.contemMaterial(cadPadrao.getRetornoParaPesquisa())) {
                    this.preencheLocalizados();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "TelaPesquisaMaterial (203)");
            }
        }
    }

    private boolean contemMaterial(String codigo) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!this.modelo.getValueAt(i, 0).equals(codigo)) continue;
            return true;
        }
        return false;
    }

    private void configTable() {
        Object[] colunas = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Tipo", "Unid. Medida"};
        this.modelo = new DefaultTableModel(new Object[0][], colunas){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount()) {
                    if (this.getValueAt(0, column) != null) {
                        returnValue = this.getValueAt(0, column).getClass();
                    } else {
                        for (int i = 0; i < this.getRowCount(); ++i) {
                            if (this.getValueAt(i, column) == null) continue;
                            returnValue = this.getValueAt(i, column).getClass();
                            break;
                        }
                    }
                }
                return returnValue;
            }
        };
        this.table = new JTable(this.modelo);
        this.table.setName("table");
        TableRowSorter<TableModel> sorterTable = new TableRowSorter<TableModel>(this.table.getModel()){

            @Override
            public void setSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
                TelaPesquisaMateriais.this.setCursor(Cursor.getPredefinedCursor(3));
                super.setSortKeys(sortKeys);
                TelaPesquisaMateriais.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        this.table.setRowSorter((RowSorter<? extends TableModel>)sorterTable);
        this.scroll.setViewportView(this.table);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(400);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TelaPesquisaMateriais.this.btnSelecionar.doClick();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    TelaPesquisaMateriais.this.btnSelecionar.doClick();
                } else if (e.getKeyCode() == 9) {
                    TelaPesquisaMateriais.this.txtLocalizar.requestFocus();
                }
            }
        });
        InputMap tableInputMap = this.table.getInputMap(1);
        tableInputMap.put(KeyStroke.getKeyStroke(10, 0, false), "none");
    }
}

