/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.configuracao.UsuarioMensagemBean;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.RequisicaoEstoqueMaterialBean;
import jalis.model.bean.estoque.TransfEstoqueBean;
import jalis.model.dao.estoque.RequisicaoEstoqueDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.RequisicaoEstoqueVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.estoque.RequisicaoEstoqueMaterialService;
import jalis.util.Funcoes;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;

public class RequisicaoEstoqueService
extends AbstractThreadService {
    public RequisicaoEstoqueService() {
        this.dao = new RequisicaoEstoqueDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.get(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((RequisicaoEstoqueDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((RequisicaoEstoqueDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            RequisicaoEstoqueBean reqBean = (RequisicaoEstoqueBean)bean;
            reqBean.setCodigo((Integer)codigo);
            ((RequisicaoEstoqueDao)this.dao).insert(reqBean, filialPadrao);
            if (reqBean.getMateriais() != null) {
                RequisicaoEstoqueMaterialService serviceMaterial = new RequisicaoEstoqueMaterialService();
                for (int i = 0; i < reqBean.getMateriais().size(); ++i) {
                    RequisicaoEstoqueMaterialBean material = reqBean.getMateriais().get(i);
                    material.setRequisicao((RequisicaoEstoqueVO)reqBean.toVO());
                    serviceMaterial.insert(material, null, filialPadrao, filiais);
                }
            }
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        RequisicaoEstoqueDao cfr_ignored_0 = (RequisicaoEstoqueDao)this.dao;
        return RequisicaoEstoqueDao.load(RequisicaoEstoqueBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return ((RequisicaoEstoqueDao)this.dao).loadVO(RequisicaoEstoqueVO.class, where);
    }

    public Hashtable pesquisaRequisicaoEstoqueNaoConciliadaVO(Object owner) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando Requisi\u00e7\u00f5es de Transfer\u00eancias de Estoque n\u00e3o conclu\u00eddas");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            StringBuilder bufWhere = new StringBuilder();
            buf.append(" select ree_codigo, ");
            buf.append("        ree_datahora, ");
            buf.append("        usr_codigo, ");
            buf.append("        ree_observacao ");
            buf.append("   from requisicaoestoque ");
            bufWhere.append("  (fil_codigo, ree_codigo) IN ");
            bufWhere.append("  (select tra.fil_codigo, ");
            bufWhere.append("          tra.ree_codigo ");
            bufWhere.append("     from transfestoque tra ");
            bufWhere.append("     join transfestoquelanctoestoque tel on (tra.fil_codigo = tel.fil_codigo and tra.tra_codigo = tel.tra_codigo) ");
            bufWhere.append("     join lanctoestoque lce on (tel.fil_codigo = lce.fil_codigo and tel.lce_codigo = lce.lce_codigo and lce.lce_situacao = UPPER('").append("A").append("')) ");
            bufWhere.append("  )");
            bufWhere.append(" and fil_codigo = ").append(Variaveis.filialPadrao);
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("ree_codigo", "C\u00f3digo", 1, "", 3, 75);
            p.adicionaCampo("ree_datahora", "Data/Hora", 4, "", 3, 75);
            p.adicionaCampo("usr_codigo", "Usu\u00e1rio", 0, "", 2, 75);
            p.adicionaCampo("ree_observacao", "Observa\u00e7\u00e3o", 0, "", 2, 0);
            p.setFiltroInicial("C\u00f3digo", 3);
            p.setFiltro(bufWhere.toString());
            p.setOrdem("C\u00f3digo");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("usuario", "Usu\u00e1rio", 0, "", 2, 0);
        tela.adicionaCampo("dataHora", "Data/hora", 4, "", 2, 100);
        tela.adicionaCampo("situacao", "Situa\u00e7\u00e3o", 0, "", 3, 80);
        tela.setFiltroInicial("codigo", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao);
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaRequisicaoAbertaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("usuario", "Usu\u00e1rio", 0, "", 2, 90);
        tela.adicionaCampo("dataHora", "Data/hora", 4, "", 2, 80);
        tela.adicionaCampo("celulaEstoque.descricao", "C\u00e9lula Destino", 0, "", 2, 0);
        tela.adicionaCampo("observacao", "Observa\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("codigo", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append(" fil_codigo = ").append(Variaveis.filialPadrao);
        filtro.append(" and ree_situacao = '").append("A").append("' ");
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public void update(AbstractThreadBean bean, String filialPadrao, String filiais) throws Exception {
        ((RequisicaoEstoqueDao)this.dao).update(bean, filialPadrao);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            RequisicaoEstoqueBean beanRequisicao = (RequisicaoEstoqueBean)bean;
            ((RequisicaoEstoqueDao)this.dao).update(beanRequisicao, filialPadrao);
            RequisicaoEstoqueMaterialService serviceMaterial = new RequisicaoEstoqueMaterialService();
            serviceMaterial.removeTodosMateriaisRequisicaoEstoque(filialPadrao, beanRequisicao.getCodigo().toString());
            for (int i = 0; i < beanRequisicao.getMateriais().size(); ++i) {
                RequisicaoEstoqueMaterialBean material = beanRequisicao.getMateriais().get(i);
                material.setRequisicao((RequisicaoEstoqueVO)beanRequisicao.toVO());
                serviceMaterial.insert(material, null, filialPadrao, filiais);
            }
        }
    }

    public TransfEstoqueBean getTransfEstoqueRequisicao(String filial, String codigoRequisicao) throws ThreadDaoException {
        return ((RequisicaoEstoqueDao)this.dao).getTransfEstoqueRequisicao(filial, codigoRequisicao);
    }

    public void enviaMensagemResponsavel(RequisicaoEstoqueBean bean, boolean isEdicao) throws Exception {
        String codigoUsuario = new FilialService().getCodigoResponsavelEstoque(Variaveis.filialPadrao);
        if (codigoUsuario == null || bean == null) {
            return;
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO remetente = (UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, Variaveis.login);
        UsuarioVO destinatario = new UsuarioVO();
        destinatario.setFilial(filial);
        destinatario.setCodigo(codigoUsuario);
        UsuarioMensagemBean mensagem = new UsuarioMensagemBean();
        mensagem.setConfirmarLeitura(false);
        mensagem.setAvisada(false);
        mensagem.setDataHora(new Date());
        mensagem.setDestino(destinatario);
        mensagem.setOrigem(remetente);
        if (isEdicao) {
            mensagem.setAssunto("Requisi\u00e7\u00e3o de material - *EDI\u00c7\u00c3O* - C\u00f3d.: " + bean.getCodigo());
        } else {
            mensagem.setAssunto("Requisi\u00e7\u00e3o de material - *NOVA* - C\u00f3d.: " + bean.getCodigo());
        }
        StringBuilder buf = new StringBuilder();
        buf.append("O usu\u00e1rio \"").append(remetente.getCodigo()).append(" - ").append(remetente.getDescricao()).append("\" ");
        if (isEdicao) {
            buf.append(" editou uma ");
        } else {
            buf.append(" criou uma nova ");
        }
        buf.append("requisi\u00e7\u00e3o de material").append(bean.getOrigem().equalsIgnoreCase("R") ? " " : " PARA KIT ").append("em ").append(Funcoes.formataData("dd/MM/yyyy '\u00e0s' HH:mm", bean.getDataHora())).append("h.\n");
        buf.append("\n");
        buf.append("C\u00f3digo da requisi\u00e7\u00e3o de material: ").append(bean.getCodigo()).append(".\n");
        buf.append("Destino: \"").append(bean.getCelulaEstoque().getDescricao()).append("\".");
        buf.append("\n\n");
        buf.append("Detalhamento da requisi\u00e7\u00e3o de material:\n");
        for (int i = 0; i < bean.getMateriais().size(); ++i) {
            RequisicaoEstoqueMaterialBean aux = bean.getMateriais().get(i);
            buf.append("\"").append(aux.getMaterial().getDescricao()).append("\" - ").append(Funcoes.formataDecimal(aux.getQuantidade())).append(aux.getMaterial().getUnidadeMedida() != null ? aux.getMaterial().getUnidadeMedida().getCodigo() : "");
            if (i >= bean.getMateriais().size() - 1) continue;
            buf.append("\n");
        }
        mensagem.setMensagem(buf.toString());
        new UsuarioMensagemService().insert(mensagem, null, null, null);
    }
}

