/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.bean.estoque.PedidoParcelaBean;
import jalis.model.dao.estoque.PedidoDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.PedidoLanctoEstoqueService;
import jalis.service.estoque.PedidoMaterialService;
import jalis.service.estoque.PedidoParcelaService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class PedidoService
extends AbstractThreadService {
    private LancamentoEstoqueService serviceLanctoEstoque = new LancamentoEstoqueService();
    private MaterialLoteService serviceMaterialLote = new MaterialLoteService();

    public PedidoService() {
        this.dao = new PedidoDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean == null) {
            return;
        }
        PedidoMaterialService servicePedidoMaterial = new PedidoMaterialService();
        PedidoBean pedBean = (PedidoBean)bean;
        ArrayList<PedidoMaterialBean> listaMateriaisPedido = servicePedidoMaterial.getMateriaisPedido(filialPadrao, pedBean.getCodigo().toString());
        if (listaMateriaisPedido != null) {
            ArrayList<PedidoLanctoEstoqueBean> lanctos = null;
            if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P") && bean != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", ((PedidoBean)bean).getFilial().getCodigo());
                chaves.put("ped_codigo", ((PedidoBean)bean).getCodigo());
                lanctos = new PedidoLanctoEstoqueService().getBeans(chaves);
            }
            Date dataCancelamento = new Date();
            UsuarioVO usuarioVO = new UsuarioVO();
            usuarioVO.setFilial(((PedidoBean)bean).getFilial());
            usuarioVO.setCodigo(Variaveis.login);
            LancamentoEstoqueService serviceLanctoEstoque = new LancamentoEstoqueService();
            MaterialLoteService serviceMaterialLote = new MaterialLoteService();
            for (int i = 0; i < listaMateriaisPedido.size(); ++i) {
                PedidoMaterialBean pedidoMaterial = listaMateriaisPedido.get(i);
                pedidoMaterial.setPedido(pedBean);
                servicePedidoMaterial.delete(pedidoMaterial, null, filialPadrao, filiais);
                if (lanctos == null) continue;
                for (int j = 0; j < lanctos.size(); ++j) {
                    LancamentoEstoqueBean lanctoBean;
                    PedidoLanctoEstoqueBean auxPedidoLancto = lanctos.get(j);
                    if (auxPedidoLancto == null || auxPedidoLancto.getLancamentoEstoque().getMaterial().getCodigo().intValue() != pedidoMaterial.getMaterial().getCodigo().intValue() || (lanctoBean = serviceLanctoEstoque.get(auxPedidoLancto.getFilial().getCodigo().toString(), auxPedidoLancto.getLancamentoEstoque().getCodigo().toString())) == null) continue;
                    lanctoBean.setDataHoraCancelamento(dataCancelamento);
                    lanctoBean.setUsuarioCancelamento(usuarioVO);
                    serviceLanctoEstoque.gravaAutoCopiaSemCommit(lanctoBean, 1, filialPadrao, true, null);
                    serviceMaterialLote.removerLoteLancamentoEstoque(lanctoBean.getFilial().getCodigo().toString(), lanctoBean.getCodigo().toString(), dataCancelamento);
                }
            }
        }
        pedBean.setDataExclusao(new Date());
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        pedBean.setUsuarioExclusao(usuario);
        ((PedidoDao)this.dao).update(bean, filialPadrao);
        for (PedidoMaterialBean pedidoMaterialBean : listaMateriaisPedido) {
            new MaterialService().alteraCodigoPED(pedidoMaterialBean.getMaterial().getFilial().getCodigo(), pedidoMaterialBean.getMaterial().getCodigo());
        }
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((PedidoDao)this.dao).getBean(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return ((PedidoDao)this.dao).getVO(Variaveis.filialPadrao, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean == null) {
            return;
        }
        PedidoBean pedBean = (PedidoBean)bean;
        pedBean.setCodigo((Integer)codigo);
        ((PedidoDao)this.dao).insert(pedBean, filialPadrao);
        if (pedBean.getParcelas() != null) {
            PedidoParcelaService parcelaService = new PedidoParcelaService();
            for (int i = 0; i < pedBean.getParcelas().size(); ++i) {
                PedidoParcelaBean parcela = pedBean.getParcelas().get(i);
                parcela.setPedido((PedidoVO)pedBean.toVO());
                parcelaService.insert(parcela, null, String.valueOf(pedBean.getFilial().getCodigo()), null);
            }
        }
        MaterialService serviceMaterial = new MaterialService();
        PedidoMaterialService servicePedidoMaterial = new PedidoMaterialService();
        Double quantidade = 0.0;
        for (PedidoMaterialBean mat : pedBean.getMateriais()) {
            quantidade = quantidade + mat.getQuantidade();
        }
        Double valorFrete = pedBean.getValorFrete();
        if (valorFrete > 0.0) {
            valorFrete = valorFrete / quantidade;
        }
        for (PedidoMaterialBean pedMaterial : pedBean.getMateriais()) {
            pedMaterial.setPedido(pedBean);
            LancamentoEstoqueBean lanctoEstoqueBean = servicePedidoMaterial.insertRetornaLancamento(pedMaterial, null, filialPadrao, filiais, valorFrete);
            LancamentoEstoqueVO lanctoEstoqueVO = lanctoEstoqueBean != null ? (LancamentoEstoqueVO)lanctoEstoqueBean.toVO() : null;
            MaterialBean material = pedMaterial.getMaterial();
            if (pedMaterial != null && pedMaterial.getMaterial() != null && pedMaterial.getMaterial().getLotes() != null) {
                for (MaterialLoteBean materialLoteAux : pedMaterial.getMaterial().getLotes()) {
                    if (materialLoteAux.getCodigo() != null) continue;
                    MaterialLoteLanctoEstoqueBean matLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
                    matLoteLanctoEstoque.setFilial(pedMaterial.getFilial());
                    matLoteLanctoEstoque.setInserir(true);
                    matLoteLanctoEstoque.setLancamento(lanctoEstoqueVO);
                    matLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)materialLoteAux.toVO());
                    if (lanctoEstoqueVO.getTipo().equalsIgnoreCase("S")) {
                        matLoteLanctoEstoque.setQuantidade(Math.abs(materialLoteAux.getQuantidadeConsumida() - materialLoteAux.getQuantidadeConsumidaOriginal()));
                    } else {
                        matLoteLanctoEstoque.setQuantidade(materialLoteAux.getQuantidade());
                    }
                    HashSet<MaterialLoteLanctoEstoqueBean> lotes = new HashSet<MaterialLoteLanctoEstoqueBean>();
                    lotes.add(matLoteLanctoEstoque);
                    materialLoteAux.setLancamentosEstoque(lotes);
                }
            }
            serviceMaterial.gravaAutoCopiaSemCommit(pedMaterial.getMaterial(), 1, Variaveis.filialPadrao, null);
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return ((PedidoDao)this.dao).loadVO(PedidoBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return ((PedidoDao)this.dao).loadVO(PedidoVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public String pesquisaVO(Object owner, AbstractThreadVO vo) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando pedidos de compra");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("select distinct ped.ped_codigo ");
            buf.append("      ,ped.ped_datahora ");
            buf.append("      ,ped.ped_dataautorizacao ");
            buf.append("      ,ped.ped_total ");
            buf.append("      ,ent.ent_fantasia ");
            buf.append("      ,ped.ped_observacao ");
            buf.append("      ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("          from (select mataux.mat_descricao ");
            buf.append("                  from pedidomaterial pmaaux ");
            buf.append("                  join material mataux on pmaaux.fil_codigo = mataux.fil_codigo and pmaaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                 where pmaaux.fil_codigo = pma.fil_codigo ");
            buf.append("                   and pmaaux.ped_codigo = pma.ped_codigo ");
            buf.append("                 order by mataux.mat_descricao) as mataux) as materiais ");
            buf.append("  from pedido ped ");
            buf.append("  left join entidade ent on ped.fil_codigo = ent.fil_codigo and ped.ent_codigo = ent.ent_codigo ");
            buf.append("  join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo ");
            buf.append("  join material mat on pma.fil_codigo = mat.fil_codigo and pma.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("ped.ped_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ped_datahora", "Data Hora", 4, "", 0);
            p.adicionaCampo("ped_dataautorizacao", "Dt. Autoriza\u00e7\u00e3o", 4, "", 3);
            p.adicionaCampo("ped_total", "Total", 1, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("ped_observacao", "Observa\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("C\u00f3digo", 0);
            p.setFiltro(" ped.fil_codigo = " + Variaveis.filialPadrao + " and ped.usr_codexclusao IS NULL and ped.ped_dataexclusao IS NULL ");
            p.setOrdem("ped_codigo");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Hashtable result = p.getRegistroSelecionado();
                if (result != null) {
                    return String.valueOf(result.get("ped_codigo"));
                }
                return null;
            }
        }
        return null;
    }

    public String pesquisaPedidoAutorizadoNaoConferidoVO(Object owner, AbstractThreadVO bean) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando pedidos de compra");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("select distinct ped.ped_codigo ");
            buf.append("      ,ped.ped_datahora ");
            buf.append("      ,ped.ped_total ");
            buf.append("      ,ent.ent_fantasia ");
            buf.append("      ,ped.ped_observacao ");
            buf.append("      ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("          from (select mataux.mat_descricao ");
            buf.append("                  from pedidomaterial pmaaux ");
            buf.append("                  join material mataux on pmaaux.fil_codigo = mataux.fil_codigo and pmaaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                 where pmaaux.fil_codigo = pma.fil_codigo ");
            buf.append("                   and pmaaux.ped_codigo = pma.ped_codigo ");
            buf.append("                 order by mataux.mat_descricao) as mataux) as materiais ");
            buf.append("  from pedido ped ");
            buf.append("  left join entidade ent on ped.fil_codigo = ent.fil_codigo and ped.ent_codigo = ent.ent_codigo ");
            buf.append("  join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo ");
            buf.append("  join material mat on pma.fil_codigo = mat.fil_codigo and pma.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("ped_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ped_datahora", "Data Hora", 4, "", 0);
            p.adicionaCampo("ped_total", "Total", 1, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("ped_observacao", "Observa\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("C\u00f3digo", 0);
            String filtro = " ped.fil_codigo = " + Variaveis.filialPadrao + " and ped.usr_codexclusao IS NULL and ped.ped_dataexclusao IS NULL ";
            filtro = filtro + " and (ped.fil_codigo, ped.ped_codigo) NOT IN (select fil_codigo, ped_codigo from notafiscal where fil_codigo = " + Variaveis.filialPadrao;
            filtro = filtro + " and ped_codigo IS NOT NULL ";
            filtro = filtro + " and ((nfi_numerorps IS NULL and nfi_situacao IN ('A', 'I')) ";
            filtro = filtro + "   or (nfi_numerorps IS NOT NULL and nfi_situacao = 'A') ) ) ";
            filtro = filtro + " and (ped.fil_codigo, ped.ped_codigo) NOT IN (select fil_codigo, ped_codigo from conferenciaentrada where usr_codcancelamento IS NULL and ped_codigo IS NOT NULL) ";
            filtro = filtro + " and (select count(1) ";
            filtro = filtro + "        from pedidolanctoestoque ple ";
            filtro = filtro + "        join lanctoestoque lce on ple.fil_codigo = lce.fil_codigo and ple.lce_codigo = lce.lce_codigo";
            filtro = filtro + "       where ple.fil_codigo = ped.fil_codigo ";
            filtro = filtro + "         and ple.ped_codigo = ped.ped_codigo ";
            filtro = filtro + "     ) = 0 ";
            p.setFiltro(filtro);
            p.setOrdem("ped_codigo");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Hashtable result = p.getRegistroSelecionado();
                if (result != null) {
                    return String.valueOf(result.get("ped_codigo"));
                }
                return null;
            }
        }
        return null;
    }

    public String pesquisaPedidoAutorizadoVO(Object owner, AbstractThreadVO bean) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando pedidos de compra");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("select distinct ped.ped_codigo ");
            buf.append("      ,ped.ped_datahora ");
            buf.append("      ,ped.ped_total ");
            buf.append("      ,ent.ent_fantasia ");
            buf.append("      ,ped.ped_observacao ");
            buf.append("      ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("          from (select mataux.mat_descricao ");
            buf.append("                  from pedidomaterial pmaaux ");
            buf.append("                  join material mataux on pmaaux.fil_codigo = mataux.fil_codigo and pmaaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                 where pmaaux.fil_codigo = pma.fil_codigo ");
            buf.append("                   and pmaaux.ped_codigo = pma.ped_codigo ");
            buf.append("                 order by mataux.mat_descricao) as mataux) as materiais ");
            buf.append("  from pedido ped ");
            buf.append("  left join entidade ent on ped.fil_codigo = ent.fil_codigo and ped.ent_codigo = ent.ent_codigo ");
            buf.append("  join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo ");
            buf.append("  join material mat on pma.fil_codigo = mat.fil_codigo and pma.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("ped.ped_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ped.ped_datahora", "Data Hora", 4, "", 0);
            p.adicionaCampo("ped.ped_total", "Total", 1, "", 3);
            p.adicionaCampo("ent.ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("ped.ped_observacao", "Observa\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mat.mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("C\u00f3digo", 0);
            String filtro = " ped.fil_codigo = " + Variaveis.filialPadrao + " and ped.usr_codexclusao IS NULL and ped.ped_dataexclusao IS NULL ";
            filtro = filtro + " and (ped.fil_codigo, ped.ped_codigo) NOT IN (select fil_codigo, ped_codigo from notafiscal where fil_codigo = " + Variaveis.filialPadrao;
            filtro = filtro + " and ped_codigo IS NOT NULL ";
            filtro = filtro + " and ((nfi_numerorps IS NULL and nfi_situacao IN ('A', 'I')) ";
            filtro = filtro + "   or (nfi_numerorps IS NOT NULL and nfi_situacao = 'A') ) ) ";
            filtro = filtro + " and ped.ped_dataautorizacao IS NOT NULL and ped.usr_codautorizacao IS NOT NULL ";
            p.setFiltro(filtro);
            p.setOrdem("ped_codigo");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Hashtable result = p.getRegistroSelecionado();
                if (result != null) {
                    return String.valueOf(result.get("ped_codigo"));
                }
                return null;
            }
        }
        return null;
    }

    public String pesquisaPedidoDisponivelVO(Object owner, AbstractThreadVO bean) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando pedidos de compra");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("select distinct ped.ped_codigo ");
            buf.append("      ,ped.ped_datahora ");
            buf.append("      ,ped.ped_total ");
            buf.append("      ,ent.ent_fantasia ");
            buf.append("      ,ped.ped_observacao ");
            buf.append("      ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("          from (select mataux.mat_descricao ");
            buf.append("                  from pedidomaterial pmaaux ");
            buf.append("                  join material mataux on pmaaux.fil_codigo = mataux.fil_codigo and pmaaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                 where pmaaux.fil_codigo = pma.fil_codigo ");
            buf.append("                   and pmaaux.ped_codigo = pma.ped_codigo ");
            buf.append("                 order by mataux.mat_descricao) as mataux) as materiais ");
            buf.append("  from pedido ped ");
            buf.append("  left join entidade ent on ped.fil_codigo = ent.fil_codigo and ped.ent_codigo = ent.ent_codigo ");
            buf.append("  join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo ");
            buf.append("  join material mat on pma.fil_codigo = mat.fil_codigo and pma.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("ped.ped_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ped.ped_datahora", "Data Hora", 4, "", 0);
            p.adicionaCampo("ped.ped_total", "Total", 1, "", 3);
            p.adicionaCampo("ent.ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("ped.ped_observacao", "Observa\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mat.mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("C\u00f3digo", 0);
            String filtro = " ped.fil_codigo = " + Variaveis.filialPadrao + " and ped.usr_codexclusao IS NULL and ped.ped_dataexclusao IS NULL ";
            filtro = filtro + " and (ped.fil_codigo, ped.ped_codigo) NOT IN (select fil_codigo, ped_codigo from notafiscal where fil_codigo = " + Variaveis.filialPadrao;
            filtro = filtro + " and ped_codigo IS NOT NULL ";
            filtro = filtro + " and ((nfi_numerorps IS NULL and nfi_situacao IN ('A', 'I')) ";
            filtro = filtro + "   or (nfi_numerorps IS NOT NULL and nfi_situacao = 'A') ) ) ";
            p.setFiltro(filtro);
            p.setOrdem("ped_codigo");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Hashtable result = p.getRegistroSelecionado();
                if (result != null) {
                    return String.valueOf(result.get("ped_codigo"));
                }
                return null;
            }
        }
        return null;
    }

    public String pesquisaPedidoDisponivelNaoConferidoVO(Object owner, AbstractThreadVO bean) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando pedidos de compra");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("select distinct ped.ped_codigo ");
            buf.append("      ,ped.ped_datahora ");
            buf.append("      ,ped.ped_total ");
            buf.append("      ,ent.ent_fantasia ");
            buf.append("      ,ped.ped_observacao ");
            buf.append("      ,(select array_to_string(array_agg(mataux.mat_descricao), ', ') ");
            buf.append("          from (select mataux.mat_descricao ");
            buf.append("                  from pedidomaterial pmaaux ");
            buf.append("                  join material mataux on pmaaux.fil_codigo = mataux.fil_codigo and pmaaux.mat_codigo = mataux.mat_codigo ");
            buf.append("                 where pmaaux.fil_codigo = pma.fil_codigo ");
            buf.append("                   and pmaaux.ped_codigo = pma.ped_codigo ");
            buf.append("                 order by mataux.mat_descricao) as mataux) as materiais ");
            buf.append("  from pedido ped ");
            buf.append("  left join entidade ent on ped.fil_codigo = ent.fil_codigo and ped.ent_codigo = ent.ent_codigo ");
            buf.append("  join pedidomaterial pma on ped.fil_codigo = pma.fil_codigo and ped.ped_codigo = pma.ped_codigo ");
            buf.append("  join material mat on pma.fil_codigo = mat.fil_codigo and pma.mat_codigo = mat.mat_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("ped.ped_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ped_datahora", "Data Hora", 4, "", 0);
            p.adicionaCampo("ped_total", "Total", 1, "", 3);
            p.adicionaCampo("ent_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("ped_observacao", "Observa\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mat_descricao", "Materiais", 0, "", 2);
            p.setFiltroInicial("C\u00f3digo", 0);
            String filtro = " ped.fil_codigo = " + Variaveis.filialPadrao + " and ped.usr_codexclusao IS NULL and ped.ped_dataexclusao IS NULL ";
            filtro = filtro + " and (ped.fil_codigo, ped.ped_codigo) NOT IN (select fil_codigo, ped_codigo from notafiscal where fil_codigo = " + Variaveis.filialPadrao;
            filtro = filtro + " and ped_codigo IS NOT NULL ";
            filtro = filtro + " and ((nfi_numerorps IS NULL and nfi_situacao IN ('A', 'I')) ";
            filtro = filtro + "   or (nfi_numerorps IS NOT NULL and nfi_situacao = 'A') ) ) ";
            filtro = filtro + " and (ped.fil_codigo, ped.ped_codigo) NOT IN (select fil_codigo, ped_codigo from conferenciaentrada where usr_codcancelamento IS NULL and ped_codigo is not null) ";
            filtro = filtro + " and (select count(1) ";
            filtro = filtro + "        from pedidolanctoestoque ple ";
            filtro = filtro + "        join lanctoestoque lce on ple.fil_codigo = lce.fil_codigo and ple.lce_codigo = lce.lce_codigo";
            filtro = filtro + "       where ple.fil_codigo = ped.fil_codigo ";
            filtro = filtro + "         and ple.ped_codigo = ped.ped_codigo ";
            filtro = filtro + "     ) = 0 ";
            p.setFiltro(filtro);
            p.setOrdem("ped.ped_codigo");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Hashtable result = p.getRegistroSelecionado();
                if (result != null) {
                    return String.valueOf(result.get("ped_codigo"));
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ArrayList<PedidoMaterialBean> listaMateriais;
        if (bean == null) {
            return;
        }
        ((PedidoDao)this.dao).update(bean, filialPadrao);
        PedidoBean pedBean = (PedidoBean)bean;
        PedidoMaterialService servicePedidoMaterial = new PedidoMaterialService();
        ArrayList<PedidoMaterialBean> listaMateriaisPedido = servicePedidoMaterial.getMateriaisPedido(filialPadrao, pedBean.getCodigo().toString());
        if (listaMateriaisPedido != null) {
            ArrayList<PedidoLanctoEstoqueBean> lanctos = null;
            if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P") && pedBean != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", pedBean.getFilial().getCodigo());
                chaves.put("ped_codigo", pedBean.getCodigo());
                lanctos = new PedidoLanctoEstoqueService().getBeans(chaves);
            }
            Date dataCancelamento = new Date();
            UsuarioVO usuarioVO = new UsuarioVO();
            usuarioVO.setFilial(pedBean.getFilial());
            usuarioVO.setCodigo(Variaveis.login);
            for (int i = 0; i < listaMateriaisPedido.size(); ++i) {
                PedidoMaterialBean pedidoMaterial = listaMateriaisPedido.get(i);
                pedidoMaterial.setPedido(pedBean);
                servicePedidoMaterial.delete(pedidoMaterial, null, filialPadrao, filiais);
                if (lanctos == null || lanctos.isEmpty()) continue;
                for (int j = 0; j < lanctos.size(); ++j) {
                    LancamentoEstoqueBean lanctoBean;
                    PedidoLanctoEstoqueBean auxPedidoLancto = lanctos.get(j);
                    if (auxPedidoLancto == null || auxPedidoLancto.getLancamentoEstoque().getMaterial().getCodigo().intValue() != pedidoMaterial.getMaterial().getCodigo().intValue() || (lanctoBean = this.serviceLanctoEstoque.get(auxPedidoLancto.getFilial().getCodigo().toString(), auxPedidoLancto.getLancamentoEstoque().getCodigo().toString())) == null) continue;
                    lanctoBean.setDataHoraCancelamento(dataCancelamento);
                    lanctoBean.setUsuarioCancelamento(usuarioVO);
                    this.serviceLanctoEstoque.gravaAutoCopiaSemCommit(lanctoBean, 1, filialPadrao, true, null);
                    this.serviceMaterialLote.removerLoteLancamentoEstoque(lanctoBean.getFilial().getCodigo().toString(), lanctoBean.getCodigo().toString(), dataCancelamento);
                }
            }
        }
        if (pedBean.getDataExclusao() == null && (listaMateriais = pedBean.getMateriais()) != null) {
            MaterialService serviceMaterial = new MaterialService();
            PedidoMaterialService serviceMateriais = new PedidoMaterialService();
            Double quantidade = 0.0;
            for (PedidoMaterialBean mat : listaMateriais) {
                quantidade = quantidade + mat.getQuantidade();
            }
            Double valorFrete = pedBean.getValorFrete();
            if (valorFrete > 0.0) {
                valorFrete = valorFrete / quantidade;
            }
            for (int i = 0; i < listaMateriais.size(); ++i) {
                LancamentoEstoqueVO lanctoEstoqueVO;
                PedidoMaterialBean material = listaMateriais.get(i);
                if (material == null) continue;
                material.setPedido(pedBean);
                LancamentoEstoqueBean lanctoEstoqueBean = serviceMateriais.insertRetornaLancamento(material, null, filialPadrao, filiais, valorFrete);
                LancamentoEstoqueVO lancamentoEstoqueVO = lanctoEstoqueVO = lanctoEstoqueBean != null ? (LancamentoEstoqueVO)lanctoEstoqueBean.toVO() : null;
                if (lanctoEstoqueVO != null) {
                    for (MaterialLoteBean matLoteAux : material.getMaterial().getLotes()) {
                        if (!matLoteAux.getAlterar() && !matLoteAux.getInserir() || matLoteAux.getRemovido().booleanValue()) continue;
                        FilialVO filialVO = new FilialVO();
                        filialVO.setCodigo(Integer.parseInt(filialPadrao));
                        matLoteAux.setCodigo(null);
                        matLoteAux.setInserir(true);
                        matLoteAux.setAlterar(false);
                        matLoteAux.setDataHoraRemovido(null);
                        matLoteAux.setUsuarioRemocao(null);
                        serviceMaterial.gerarMaterialLoteLancEstoque(filialVO, lanctoEstoqueVO, matLoteAux);
                        this.serviceMaterialLote.gravaAutoCopiaSemCommit(matLoteAux, 0, filialPadrao, filiais);
                    }
                }
                if (material.getMaterial().getLotes() != null && !material.getMaterial().getLotes().isEmpty()) {
                    material.getMaterial().getLotes().clear();
                }
                serviceMaterial.gravaAutoCopiaSemCommit(material.getMaterial(), 1, Variaveis.filialPadrao, null);
            }
        }
    }

    public void removerAutorizacaoCompra(PedidoVO pedidoVO) throws SQLException {
        PedidoDao dao = new PedidoDao();
        dao.removerAutorizacaoCompra(pedidoVO);
    }
}

