/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.PedidoLanctoEstoqueBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.dao.estoque.PedidoMaterialDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.PedidoLanctoEstoqueService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PedidoMaterialService
extends AbstractThreadService {
    private static final int CASAS_MAIOR = 4;
    private static final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public PedidoMaterialService() {
        this.dao = new PedidoMaterialDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((PedidoMaterialDao)this.dao).delete(bean, filialPadrao);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    public AbstractThreadBean get(String filial, String codigo, String codigoMaterial) throws Exception {
        PedidoMaterialDao cfr_ignored_0 = (PedidoMaterialDao)this.dao;
        Set lista = PedidoMaterialDao.load(PedidoMaterialBean.class, " where fil_codigo = " + filial + " and ped_codigo = " + codigo + " and mat_codigo = " + codigoMaterial);
        if (lista != null) {
            Iterator it = lista.iterator();
            return (AbstractThreadBean)it.next();
        }
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public LancamentoEstoqueBean insertRetornaLancamento(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais, Double valorFrete) throws Exception {
        LancamentoEstoqueBean lanctoBean = null;
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P")) {
            PedidoMaterialBean beanPedMat = (PedidoMaterialBean)bean;
            beanPedMat.setEstoqueAlterado(true);
            beanPedMat.getMaterial().setCodigoUltimaCompraPed(beanPedMat.getPedido().getCodigo());
            beanPedMat.getMaterial().setCalculoRateioFreteUltimaCompra(valorFrete);
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            LancamentoEstoqueBean lanctoEstoque = new LancamentoEstoqueBean();
            lanctoEstoque.setCelulaEstoque(new CelulaEstoqueService().getCelulaPadraoVO(filialPadrao));
            lanctoEstoque.setDataConciliacao(new Date());
            lanctoEstoque.setDataHora(new Date());
            lanctoEstoque.setFilial(filial);
            lanctoEstoque.setMaterial((MaterialVO)beanPedMat.getMaterial().toVO());
            lanctoEstoque.setQuantidade(beanPedMat.getQuantidade());
            lanctoEstoque.setSituacao("O");
            lanctoEstoque.setTipo("E");
            lanctoEstoque.setTipoOrigem("D");
            lanctoEstoque.setUsuario(usuario);
            lanctoEstoque.setUsuarioConciliacao(usuario);
            lanctoEstoque.setValorUnitario(beanPedMat.getValorUnitario());
            BigDecimal valorTotal = new BigDecimal(beanPedMat.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(beanPedMat.getQuantidade()).setScale(4, ROUND));
            valorTotal = valorTotal.setScale(4, ROUND);
            lanctoEstoque.setValorTotal(valorTotal.doubleValue());
            new LancamentoEstoqueService().gravaAutoCopiaSemCommit(lanctoEstoque, 0, filialPadrao, true, null);
            lanctoBean = lanctoEstoque;
            PedidoLanctoEstoqueBean pedidoLanctoBean = new PedidoLanctoEstoqueBean();
            pedidoLanctoBean.setFilial(filial);
            pedidoLanctoBean.setPedido((PedidoVO)beanPedMat.getPedido().toVO());
            pedidoLanctoBean.setLancamentoEstoque((LancamentoEstoqueVO)lanctoEstoque.toVO());
            new PedidoLanctoEstoqueService().insert(pedidoLanctoBean, null, filialPadrao, null);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("filial", filial.getCodigo().toString());
            params.put("codigoMaterial", lanctoEstoque.getMaterial().getCodigo().toString());
            params.put("dataHora", new Date());
            params.put("valoUnitario", beanPedMat.getValorUnitario());
            params.put("quantidade", lanctoEstoque.getQuantidade());
            params.put("codigoPedido", beanPedMat.getMaterial().getCodigoUltimaCompraPed());
            params.put("rateioFrete", beanPedMat.getMaterial().getCalculoRateioFreteUltimaCompra());
            new MaterialService().atualizarDadoUltimaCompra(params);
        } else {
            ((PedidoMaterialBean)bean).setEstoqueAlterado(false);
        }
        ((PedidoMaterialDao)this.dao).insert(bean, filialPadrao);
        return lanctoBean;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        PedidoMaterialDao cfr_ignored_0 = (PedidoMaterialDao)this.dao;
        return PedidoMaterialDao.load(PedidoMaterialBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((PedidoMaterialDao)this.dao).update(bean, filialPadrao);
    }

    public ArrayList<PedidoMaterialBean> getMateriaisPedido(String filial, String codigoPedido) throws Exception {
        return ((PedidoMaterialDao)this.dao).getMateriaisPedido(filial, codigoPedido);
    }
}

