/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.NotaFiscalLanctoEstoqueBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.dao.estoque.NotaFiscalMaterialDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.NotaFiscalLanctoEstoqueService;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;

public class NotaFiscalMaterialService
extends AbstractThreadService {
    private static final int CASAS_MAIOR = 4;
    private static final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public NotaFiscalMaterialService() {
        this.dao = new NotaFiscalMaterialDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.delete(bean, filialPadrao);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    public AbstractThreadBean get(String codigoNotaFiscal, String codigoMaterial) throws Exception {
        return this.get(Variaveis.filialPadrao, codigoNotaFiscal, codigoMaterial);
    }

    public AbstractThreadBean get(String filial, String codigoNotaFiscal, String codigoMaterial) throws Exception {
        return ((NotaFiscalMaterialDao)this.dao).getBean(filial, codigoNotaFiscal, codigoMaterial);
    }

    public ArrayList<NotaFiscalMaterialBean> getMateriaisNotaFiscal(String filial, String codigoNotaFiscal) throws Exception {
        return ((NotaFiscalMaterialDao)this.dao).getMateriaisNotaFiscal(filial, codigoNotaFiscal);
    }

    public void removeTodosMateriaisNotaFiscal(String filial, String codigoNotaFiscal) throws Exception {
        ((NotaFiscalMaterialDao)this.dao).removeTodosMateriaisNotaFiscal(filial, codigoNotaFiscal);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    public AbstractThreadBean getVO(String codigoNotaFiscal, String codigoMaterial) throws Exception {
        return this.getVO(Variaveis.filialPadrao, codigoNotaFiscal, codigoMaterial);
    }

    public AbstractThreadBean getVO(String filial, String codigoNotaFiscal, String codigoMaterial) throws Exception {
        return ((NotaFiscalMaterialDao)this.dao).getVO(filial, codigoNotaFiscal, codigoMaterial);
    }

    public LancamentoEstoqueBean insertRetornaLancamento(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        LancamentoEstoqueBean lanctoBean = null;
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) {
            NotaFiscalMaterialBean beanNotaMat = (NotaFiscalMaterialBean)bean;
            beanNotaMat.setEstoqueAlterado(true);
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            CelulaEstoqueVO codigoCelula = new CelulaEstoqueService().getCelulaPadraoVO(filialPadrao);
            if (codigoCelula == null) {
                Funcoes.mensagem(null, "Necess\u00e1rio definir uma c\u00e9lula de estoque como padr\u00e3o.", 2, false);
                return null;
            }
            LancamentoEstoqueBean lanctoEstoque = new LancamentoEstoqueBean();
            lanctoEstoque.setCelulaEstoque(codigoCelula);
            lanctoEstoque.setDataConciliacao(new Date());
            lanctoEstoque.setDataHora(new Date());
            lanctoEstoque.setFilial(filial);
            lanctoEstoque.setMaterial(beanNotaMat.getMaterial());
            lanctoEstoque.setQuantidade(beanNotaMat.getQuantidade());
            lanctoEstoque.setSituacao("O");
            lanctoEstoque.setTipo("E");
            lanctoEstoque.setTipoOrigem("N");
            lanctoEstoque.setUsuario(usuario);
            lanctoEstoque.setUsuarioConciliacao(usuario);
            lanctoEstoque.setValorUnitario(beanNotaMat.getValorUnitario());
            BigDecimal valorTotal = new BigDecimal(beanNotaMat.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(beanNotaMat.getQuantidade()).setScale(4, ROUND));
            valorTotal = valorTotal.setScale(4, ROUND);
            lanctoEstoque.setValorTotal(valorTotal.doubleValue());
            new LancamentoEstoqueService().gravaAutoCopiaSemCommit(lanctoEstoque, 0, filialPadrao, true, null);
            lanctoBean = lanctoEstoque;
            NotaFiscalLanctoEstoqueBean notaLanctoBean = new NotaFiscalLanctoEstoqueBean();
            notaLanctoBean.setFilial(filial);
            notaLanctoBean.setNotaFiscal(beanNotaMat.getNotaFiscal());
            notaLanctoBean.setLancamentoEstoque((LancamentoEstoqueVO)lanctoEstoque.toVO());
            new NotaFiscalLanctoEstoqueService().insert(notaLanctoBean, null, filialPadrao, null);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("filial", filial.getCodigo().toString());
            params.put("codigoMaterial", lanctoEstoque.getMaterial().getCodigo().toString());
            params.put("dataHora", new Date());
            params.put("valoUnitario", beanNotaMat.getValorUnitario());
            params.put("quantidade", lanctoEstoque.getQuantidade());
            new MaterialService().atualizarDadoUltimaCompra(params);
        } else {
            ((NotaFiscalMaterialBean)bean).setEstoqueAlterado(false);
        }
        ((NotaFiscalMaterialDao)this.dao).insert(bean, filialPadrao);
        return lanctoBean;
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((NotaFiscalMaterialDao)this.dao).update(bean, filialPadrao);
    }
}

