/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.LancamentoEstoqueCmcBean;
import jalis.model.bean.estoque.LancamentoEstoquePepsBean;
import jalis.model.bean.estoque.LancamentoEstoqueUepsBean;
import jalis.model.bean.estoque.MontagemKitBean;
import jalis.model.bean.estoque.MontagemKitConsumidoBean;
import jalis.model.bean.estoque.MontagemKitLanctoEstoqueBean;
import jalis.model.bean.estoque.MontagemKitMaterialBean;
import jalis.model.dao.estoque.MontagemKitDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.MontagemKitVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.LancamentoEstoqueCmcService;
import jalis.service.estoque.LancamentoEstoquePepsService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.LancamentoEstoqueUepsService;
import jalis.service.estoque.MontagemKitConsumidoService;
import jalis.service.estoque.MontagemKitLanctoEstoqueService;
import jalis.service.estoque.MontagemKitMaterialService;
import jalis.util.Funcoes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class MontagemKitService
extends AbstractThreadService {
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public MontagemKitService() {
        this.dao = new MontagemKitDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.get(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return this.get(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            ArrayList<MontagemKitMaterialBean> materiais = ((MontagemKitBean)bean).getMateriais();
            if (materiais == null || materiais.size() <= 0) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 materiais no kit.", 2);
                return;
            }
            ((MontagemKitBean)bean).setCodigo((Integer)codigo);
            this.dao.insert(bean, filialPadrao);
            for (MontagemKitMaterialBean material : materiais) {
                material.setMontagemKit((MontagemKitVO)bean.toVO());
                new MontagemKitMaterialService().insert(material, null, filialPadrao, filiais);
                LancamentoEstoqueBean beanLancto = new LancamentoEstoqueBean();
                beanLancto.setCelulaEstoque(material.getCelulaDestino());
                beanLancto.setDataConciliacao(new Date());
                beanLancto.setDataHora(new Date());
                beanLancto.setFilial(((MontagemKitBean)bean).getFilial());
                beanLancto.setMaterial(material.getMaterial());
                beanLancto.setQuantidade(material.getQuantidade());
                beanLancto.setSituacao("O");
                beanLancto.setTipo("E");
                beanLancto.setTipoOrigem("K");
                beanLancto.setUsuario(((MontagemKitBean)bean).getUsuario());
                beanLancto.setUsuarioConciliacao(((MontagemKitBean)bean).getUsuario());
                BigDecimal valorTotalAux = new BigDecimal("0").setScale(4, this.ROUND);
                for (MontagemKitConsumidoBean materialCon : material.getMateriaisConsumidos()) {
                    LancamentoEstoqueCmcBean lancamento;
                    BigDecimal quantidade;
                    BigDecimal valorUnitario;
                    Double qtde;
                    int i;
                    ArrayList<AbstractThreadBean> lancamentos;
                    if (ParametrosGerais.getPerguntarValorEstoque().equals("N")) continue;
                    if (ParametrosGerais.getPerguntarValorEstoque().equals("P")) {
                        lancamentos = new LancamentoEstoquePepsService().getLancamentosOrigem(filialPadrao, materialCon.getQuantidade(), materialCon.getMaterialConsumido().getCodigo().toString());
                        if (lancamentos == null) continue;
                        double auxqtde = materialCon.getQuantidade();
                        for (i = 0; i < lancamentos.size() && auxqtde > 0.0; ++i) {
                            qtde = auxqtde > ((LancamentoEstoquePepsBean)lancamentos.get(i)).getSaldoRestante() ? ((LancamentoEstoquePepsBean)lancamentos.get(i)).getSaldoRestante() : auxqtde;
                            auxqtde -= qtde.doubleValue();
                            valorUnitario = new BigDecimal(((LancamentoEstoquePepsBean)lancamentos.get(i)).getValorUnitario()).setScale(4, this.ROUND);
                            quantidade = new BigDecimal(qtde.toString()).setScale(4, this.ROUND);
                            valorTotalAux = valorTotalAux.add(valorUnitario.multiply(quantidade).setScale(4, this.ROUND));
                        }
                        continue;
                    }
                    if (ParametrosGerais.getPerguntarValorEstoque().equals("U")) {
                        lancamentos = new LancamentoEstoqueUepsService().getLancamentosOrigem(filialPadrao, materialCon.getQuantidade(), materialCon.getMaterialConsumido().getCodigo().toString());
                        if (lancamentos == null) continue;
                        double auxqtde = materialCon.getQuantidade();
                        for (i = 0; i < lancamentos.size() && auxqtde > 0.0; ++i) {
                            qtde = auxqtde > ((LancamentoEstoqueUepsBean)lancamentos.get(i)).getSaldoRestante() ? ((LancamentoEstoqueUepsBean)lancamentos.get(i)).getSaldoRestante() : auxqtde;
                            auxqtde -= qtde.doubleValue();
                            valorUnitario = new BigDecimal(((LancamentoEstoqueUepsBean)lancamentos.get(i)).getValorUnitario().toString()).setScale(4, this.ROUND);
                            quantidade = new BigDecimal(qtde.toString()).setScale(4, this.ROUND);
                            valorTotalAux = valorTotalAux.add(valorUnitario.multiply(quantidade).setScale(4, this.ROUND));
                        }
                        continue;
                    }
                    if (!ParametrosGerais.getPerguntarValorEstoque().equals("C") || (lancamento = new LancamentoEstoqueCmcService().getCmcAtual(filialPadrao, materialCon.getMaterialConsumido().getCodigo().toString())) == null) continue;
                    BigDecimal valorUnitario2 = new BigDecimal(lancamento.getValorUnitario().toString()).setScale(4, this.ROUND);
                    BigDecimal quantidade2 = new BigDecimal(materialCon.getQuantidade().toString()).setScale(4, this.ROUND);
                    valorTotalAux = valorTotalAux.add(valorUnitario2.multiply(quantidade2).setScale(4, this.ROUND));
                }
                beanLancto.setValorUnitario(valorTotalAux.doubleValue());
                new LancamentoEstoqueService().gravaAutoCopiaSemCommit(beanLancto, 0, filialPadrao, true, null);
                CelulaEstoqueVO celulaEntrada = material.getCelulaDestino();
                MaterialVO materialEntrada = material.getMaterial();
                MontagemKitLanctoEstoqueBean montagemLancto = new MontagemKitLanctoEstoqueBean();
                montagemLancto.setFilial(((MontagemKitBean)bean).getFilial());
                montagemLancto.setLancamentoEstoque((LancamentoEstoqueVO)beanLancto.toVO());
                montagemLancto.setMontagemKit((MontagemKitVO)bean.toVO());
                new MontagemKitLanctoEstoqueService().insert(montagemLancto, null, filialPadrao, filiais);
                ArrayList<LancamentoEstoqueBean> listaLancamentos = new ArrayList<LancamentoEstoqueBean>();
                for (MontagemKitConsumidoBean materialCon : material.getMateriaisConsumidos()) {
                    materialCon.setMontagemKit((MontagemKitVO)bean.toVO());
                    new MontagemKitConsumidoService().insert(materialCon, null, filialPadrao, filiais);
                    LancamentoEstoqueBean beanLanctoCons = new LancamentoEstoqueBean();
                    beanLanctoCons.setCelulaEstoque(material.getCelulaOrigem());
                    beanLanctoCons.setDataConciliacao(new Date());
                    beanLanctoCons.setDataHora(new Date());
                    beanLanctoCons.setFilial(((MontagemKitBean)bean).getFilial());
                    beanLanctoCons.setMaterial(materialCon.getMaterialConsumido());
                    beanLanctoCons.setQuantidade(materialCon.getQuantidade());
                    beanLanctoCons.setSituacao("O");
                    beanLanctoCons.setTipo("S");
                    beanLanctoCons.setTipoOrigem("K");
                    beanLanctoCons.setUsuario(((MontagemKitBean)bean).getUsuario());
                    beanLanctoCons.setUsuarioConciliacao(((MontagemKitBean)bean).getUsuario());
                    new LancamentoEstoqueService().gravaAutoCopiaSemCommit(beanLanctoCons, 0, filialPadrao, true, null);
                    listaLancamentos.add(beanLanctoCons);
                    montagemLancto = new MontagemKitLanctoEstoqueBean();
                    montagemLancto.setFilial(((MontagemKitBean)bean).getFilial());
                    montagemLancto.setLancamentoEstoque((LancamentoEstoqueVO)beanLanctoCons.toVO());
                    montagemLancto.setMontagemKit((MontagemKitVO)bean.toVO());
                    new MontagemKitLanctoEstoqueService().insert(montagemLancto, null, filialPadrao, filiais);
                }
            }
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        MontagemKitDao cfr_ignored_0 = (MontagemKitDao)this.dao;
        return MontagemKitDao.load(MontagemKitBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("datahora", "Data/hora", 4, "", 2, 100);
        tela.adicionaCampo("usuario", "Usu\u00e1rio", 0, "", 2, 70);
        tela.adicionaCampo("observacao", "Observa\u00e7\u00e3o", 0, "", 3, 0);
        tela.setFiltroInicial("codigo", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao);
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }
}

