/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Material;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.material.FichaTecnicaBean;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialAlternativoBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.dao.cadastro.material.FichaTecnicaDao;
import jalis.model.dao.estoque.MaterialDao;
import jalis.model.dao.estoque.MaterialLoteLanctoEstoqueDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.material.MaterialUsuarioVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.PedidoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialAlternativoService;
import jalis.service.estoque.MaterialLoteLanctoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MaterialService
extends AbstractThreadService {
    private MaterialLoteService matLoteService = new MaterialLoteService();
    private MaterialLoteLanctoEstoqueService matLoteLanctoEstoqueService = new MaterialLoteLanctoEstoqueService();
    private MaterialLoteLanctoEstoqueDao materialLoteLanctoEstoqueDao = new MaterialLoteLanctoEstoqueDao();

    public MaterialService() {
        this.dao = new MaterialDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((MaterialDao)this.dao).getBean(Variaveis.filialPadrao, codigo, false, null, null, true, true);
    }

    public AbstractThreadBean getAtivo(String filial, String codigo, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote) throws Exception {
        return ((MaterialDao)this.dao).getBean(filial, codigo, true, notaEntradaLote, pedidoLote, true, true);
    }

    public AbstractThreadBean getAtivo(String filial, String codigo, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote, boolean carregarDadosLotes, boolean carregarDadosAlternativos) throws Exception {
        return ((MaterialDao)this.dao).getBean(filial, codigo, true, notaEntradaLote, pedidoLote, carregarDadosLotes, carregarDadosAlternativos, true);
    }

    public AbstractThreadBean getAtivo(String filial, String codigo, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote, boolean carregarDadosLotes, boolean carregarDadosAlternativos, boolean carregarLotesConsumidos) throws Exception {
        return ((MaterialDao)this.dao).getBean(filial, codigo, true, notaEntradaLote, pedidoLote, carregarDadosLotes, carregarDadosAlternativos, carregarLotesConsumidos);
    }

    public AbstractThreadBean getTodos(String filial, String codigo, boolean carregarLotesConsumidos) throws Exception {
        return ((MaterialDao)this.dao).getBean(filial, codigo, false, null, null, true, true, carregarLotesConsumidos);
    }

    public AbstractThreadBean getTodos(String filial, String codigo, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote) throws Exception {
        return ((MaterialDao)this.dao).getBean(filial, codigo, false, notaEntradaLote, pedidoLote, true, true);
    }

    public AbstractThreadBean getTodosSemLote(String filial, String codigo, NotaFiscalVO notaEntradaLote, PedidoVO pedidoLote) throws Exception {
        return ((MaterialDao)this.dao).getBean(filial, codigo, false, notaEntradaLote, pedidoLote, false, true);
    }

    public ArrayList<MaterialAlternativoBean> getTodosMateriaisAlternativo(String filial, String codigo) throws Exception {
        return ((MaterialDao)this.dao).getBeanPorAlternativo(filial, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return ((MaterialDao)this.dao).getVO(Variaveis.filialPadrao, codigo, false);
    }

    public AbstractThreadBean getAtivoVO(String filial, String codigo) throws Exception {
        return ((MaterialDao)this.dao).getVO(filial, codigo, true);
    }

    public AbstractThreadBean getTodosVO(String filial, String codigo) throws Exception {
        return ((MaterialDao)this.dao).getVO(filial, codigo, false);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        int j;
        if (bean == null || !(bean instanceof MaterialBean)) {
            return;
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        FichaTecnicaDao daoFicha = new FichaTecnicaDao();
        MaterialBean material = (MaterialBean)bean;
        material.setCodigo((Integer)codigo);
        if (material.getMateriaisComposicao() != null && material.getMateriaisComposicao().size() > 0) {
            material.setFichaTecnica(true);
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(filialPadrao));
        material.setFilial(filial);
        this.dao.insert(material, filialPadrao);
        daoFicha.removerMateriaisFilhos(filialPadrao, String.valueOf(material.getCodigo()));
        if (material.getFichaTecnica() != null && material.getFichaTecnica().booleanValue()) {
            ArrayList<FichaTecnicaBean> materiais = material.getMateriaisComposicao();
            for (j = 0; j < materiais.size(); ++j) {
                daoFicha.insert(materiais.get(j), filialPadrao);
            }
        }
        if (Integer.parseInt(filialPadrao) == Integer.parseInt(Variaveis.filialPadrao)) {
            MaterialPatrimonioService servicePatrimonio = new MaterialPatrimonioService();
            servicePatrimonio.removerPatrimoniosMaterial(filialPadrao, material.getCodigo().toString());
            if (material.getPatrimonios() != null) {
                for (j = 0; j < material.getPatrimonios().size(); ++j) {
                    MaterialPatrimonioBean patrimonio = material.getPatrimonios().get(j);
                    patrimonio.setFilial(material.getFilial());
                    patrimonio.setMaterial((MaterialVO)material.toVO());
                    Set setPatrimonio = servicePatrimonio.load(" where fil_codigo = " + filialPadrao + " and mat_codigo = " + material.getCodigo() + " and mtp_patrimonio = " + StringUtil.textoDBEscape(patrimonio.getPatrimonio()));
                    if (setPatrimonio != null && setPatrimonio.size() > 0) {
                        servicePatrimonio.update(patrimonio, null, filialPadrao, null);
                        continue;
                    }
                    servicePatrimonio.insert(patrimonio, null, filialPadrao, null);
                }
            }
        }
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        LancamentoEstoqueVO lanctoVO = null;
        if (Integer.parseInt(filialPadrao) == Integer.parseInt(Variaveis.filialPadrao) && material.getQuantidadeUltimaCompra() != null && material.getQuantidadeUltimaCompra() > 0.0) {
            CelulaEstoqueBean celulaPadrao = new CelulaEstoqueService().getCelulaPadrao(Variaveis.filialPadrao);
            LancamentoEstoqueBean lancto = new LancamentoEstoqueBean();
            if (celulaPadrao == null) {
                throw new Exception("C\u00e9lula de estoque padr\u00e3o n\u00e3o definida, ou, nenhuma c\u00e9lula de estoque definida.");
            }
            lancto.setCelulaEstoque((CelulaEstoqueVO)celulaPadrao.toVO());
            lancto.setDataConciliacao(material.getDataUltimaCompra());
            lancto.setDataHora(new Date());
            lancto.setFilial(filial);
            lancto.setMaterial((MaterialVO)material.toVO());
            lancto.setQuantidade(material.getQuantidadeUltimaCompra());
            lancto.setSituacao("O");
            lancto.setTipo("E");
            lancto.setTipoOrigem("I");
            lancto.setUsuario(usuario);
            lancto.setUsuarioConciliacao(usuario);
            lancto.setValorUnitario(material.getValorUltimaCompra());
            lancto.setValorTotal(material.getValorTotalUltimaCompra());
            new LancamentoEstoqueService().gravaAutoCopiaSemCommit(lancto, 0, filialPadrao, true, material);
            lanctoVO = (LancamentoEstoqueVO)lancto.toVO();
        }
        if (material.getLotes() != null && Integer.parseInt(filialPadrao) == Integer.parseInt(Variaveis.filialPadrao)) {
            ArrayList<MaterialLoteBean> lotes = material.getLotes();
            for (int i = 0; i < lotes.size(); ++i) {
                MaterialLoteBean aux = lotes.get(i);
                if (aux.getCodigo() == null && aux.getRemovido().booleanValue()) continue;
                aux.setMaterial((MaterialVO)material.toVO());
                MaterialLoteLanctoEstoqueBean materialLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
                materialLoteLanctoEstoque.setFilial(aux.getFilial());
                materialLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)aux.toVO());
                materialLoteLanctoEstoque.setLancamento(lanctoVO);
                if (lanctoVO.getTipo().equalsIgnoreCase("S")) {
                    materialLoteLanctoEstoque.setQuantidade(Math.abs(aux.getQuantidadeConsumida() - aux.getQuantidadeConsumidaOriginal()));
                } else {
                    materialLoteLanctoEstoque.setQuantidade(aux.getQuantidade());
                }
                if (aux.getInserir()) {
                    this.matLoteService.gravaAutoCopiaSemCommit(aux, 0, filialPadrao, null);
                    this.matLoteLanctoEstoqueService.insert(materialLoteLanctoEstoque, null, filialPadrao, null);
                    continue;
                }
                if (aux.getAlterar()) {
                    this.matLoteService.gravaAutoCopiaSemCommit(aux, 1, filialPadrao, null);
                    this.matLoteLanctoEstoqueService.insert(materialLoteLanctoEstoque, null, filialPadrao, null);
                    continue;
                }
                if (!aux.getRemovido().booleanValue()) continue;
                this.matLoteService.gravaAutoCopiaSemCommit(aux, 2, filialPadrao, null);
            }
        }
        if (material.getMateriaisAlternativos() != null && Integer.parseInt(filialPadrao) == Integer.parseInt(Variaveis.filialPadrao)) {
            MaterialAlternativoService matAlternativoService = new MaterialAlternativoService();
            ArrayList<MaterialAlternativoBean> alternativos = material.getMateriaisAlternativos();
            for (int i = 0; i < alternativos.size(); ++i) {
                MaterialAlternativoBean alt = alternativos.get(i);
                alt.setMaterial((MaterialVO)material.toVO());
                matAlternativoService.insert(alt, alt.getCodigo().toString(), filialPadrao, null);
            }
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(MaterialBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(MaterialVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public AbstractThreadVO pesquisaAtivosVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de Materiais");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("imobilizado", "Imobilizado?", 5, "", 3, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and not mat_inativo ");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaTodosVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de Materiais");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("imobilizado", "Imobilizado?", 5, "", 3, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaMaterialImobilizadoComPatrimonioVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de Materiais");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and mat_imobilizado = true and mat_solicitarpatrimonio = true ");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        int j;
        ArrayList<FichaTecnicaBean> materiais;
        if (bean == null || !(bean instanceof MaterialBean)) {
            return;
        }
        FichaTecnicaDao daoFicha = new FichaTecnicaDao();
        MaterialBean material = (MaterialBean)bean;
        if (material.getMateriaisComposicao() != null && material.getMateriaisComposicao().size() > 0) {
            material.setFichaTecnica(true);
        } else {
            material.setFichaTecnica(false);
        }
        this.dao.update(material, filialPadrao);
        daoFicha.removerMateriaisFilhos(filialPadrao, String.valueOf(material.getCodigo()));
        if (material.getFichaTecnica() != null && material.getFichaTecnica().booleanValue() && filialPadrao.equalsIgnoreCase(Variaveis.filialPadrao) && (materiais = material.getMateriaisComposicao()) != null) {
            for (j = 0; j < materiais.size(); ++j) {
                daoFicha.insert(materiais.get(j), filialPadrao);
            }
        }
        if (Integer.parseInt(filialPadrao) == Integer.parseInt(Variaveis.filialPadrao)) {
            MaterialPatrimonioService servicePatrimonio = new MaterialPatrimonioService();
            servicePatrimonio.removerPatrimoniosMaterial(filialPadrao, material.getCodigo().toString());
            if (material.getPatrimonios() != null) {
                for (j = 0; j < material.getPatrimonios().size(); ++j) {
                    MaterialPatrimonioBean patrimonio = material.getPatrimonios().get(j);
                    patrimonio.setFilial(material.getFilial());
                    patrimonio.setMaterial((MaterialVO)material.toVO());
                    Set setPatrimonio = servicePatrimonio.load(" where fil_codigo = " + filialPadrao + " and mat_codigo = " + material.getCodigo() + " and mtp_patrimonio = " + StringUtil.textoDBEscape(patrimonio.getPatrimonio()));
                    if (setPatrimonio != null && setPatrimonio.size() > 0) {
                        if (patrimonio.getCamposAlterados().size() <= 0) continue;
                        servicePatrimonio.update(patrimonio, null, filialPadrao, null);
                        continue;
                    }
                    servicePatrimonio.insert(patrimonio, null, filialPadrao, null);
                }
            }
        }
        if (material.getLotes() != null && Integer.parseInt(filialPadrao) == Integer.parseInt(Variaveis.filialPadrao)) {
            MaterialLoteService matLoteService = new MaterialLoteService();
            ArrayList<MaterialLoteBean> lotes = material.getLotes();
            for (int i = 0; i < lotes.size(); ++i) {
                MaterialLoteBean aux = lotes.get(i);
                if (aux.getCodigo() == null && aux.getRemovido().booleanValue()) continue;
                if (aux.getInserir()) {
                    matLoteService.gravaAutoCopiaSemCommit(aux, 0, filialPadrao, null);
                    continue;
                }
                if (aux.getAlterar()) {
                    matLoteService.gravaAutoCopiaSemCommit(aux, 1, filialPadrao, null);
                    continue;
                }
                if (!aux.getRemovido().booleanValue()) continue;
                matLoteService.gravaAutoCopiaSemCommit(aux, 2, filialPadrao, null);
            }
        }
        if (((MaterialBean)bean).getAtualizarAlternativos() && Integer.parseInt(filialPadrao) == Integer.parseInt(Variaveis.filialPadrao)) {
            MaterialAlternativoService matAlternativoService = new MaterialAlternativoService();
            matAlternativoService.removerTodosAlternativos(filialPadrao, material.getCodigo().toString());
            if (material.getMateriaisAlternativos() != null) {
                ArrayList<MaterialAlternativoBean> alternativos = material.getMateriaisAlternativos();
                for (int i = 0; i < alternativos.size(); ++i) {
                    MaterialAlternativoBean alt = alternativos.get(i);
                    alt.setFilial(material.getFilial());
                    alt.setMaterial((MaterialVO)material.toVO());
                    matAlternativoService.insert(alt, alt.getCodigo().toString(), filialPadrao, null);
                }
            }
        }
    }

    public EntidadeVO getUltimoFornecedorCompra(String filial, String codigoMaterial) throws Exception {
        return ((MaterialDao)this.dao).getUltimoFornecedorCompra(filial, codigoMaterial);
    }

    public MaterialBean getBean(String filial, String codigo) throws Exception {
        return (MaterialBean)((MaterialDao)this.dao).getBean(filial, codigo, false, null, null, true, true);
    }

    public void gerarMaterialLoteLancEstoqueBaixa(FilialVO filialVO, LancamentoEstoqueVO lancamentoEstoqueVO, MaterialLoteBean lote) {
        if (lote.getCodigo() != null) {
            MaterialLoteLanctoEstoqueBean matLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
            matLoteLanctoEstoque.setFilial(filialVO);
            matLoteLanctoEstoque.setInserir(true);
            matLoteLanctoEstoque.setLancamento(lancamentoEstoqueVO);
            matLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)lote.toVO());
            if (lancamentoEstoqueVO.getTipo().equalsIgnoreCase("S")) {
                matLoteLanctoEstoque.setQuantidade(Math.abs(lote.getQuantidadeConsumida() - lote.getQuantidadeConsumidaOriginal()));
            } else {
                matLoteLanctoEstoque.setQuantidade(lote.getQuantidade());
            }
            HashSet<MaterialLoteLanctoEstoqueBean> lancamentos = new HashSet<MaterialLoteLanctoEstoqueBean>();
            lancamentos.add(matLoteLanctoEstoque);
            lote.setLancamentosEstoque(lancamentos);
        }
    }

    public void gerarMaterialLoteLancEstoque(FilialVO filialVO, LancamentoEstoqueVO lancamentoEstoqueVO, MaterialLoteBean lote) {
        if (lote.getCodigo() == null) {
            MaterialLoteLanctoEstoqueBean matLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
            matLoteLanctoEstoque.setFilial(filialVO);
            matLoteLanctoEstoque.setInserir(true);
            matLoteLanctoEstoque.setLancamento(lancamentoEstoqueVO);
            matLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)lote.toVO());
            if (lancamentoEstoqueVO.getTipo().equalsIgnoreCase("S")) {
                matLoteLanctoEstoque.setQuantidade(Math.abs(lote.getQuantidadeConsumida() - lote.getQuantidadeConsumidaOriginal()));
            } else {
                matLoteLanctoEstoque.setQuantidade(lote.getQuantidade());
            }
            HashSet<MaterialLoteLanctoEstoqueBean> lancamentos = new HashSet<MaterialLoteLanctoEstoqueBean>();
            lancamentos.add(matLoteLanctoEstoque);
            lote.setLancamentosEstoque(lancamentos);
        }
    }

    public void gerarMaterialLoteLancEstoqueKit(FilialVO filialVO, LancamentoEstoqueVO lancamentoEstoqueVO, MaterialLoteBean lote) {
        if (lote.getAlterar()) {
            MaterialLoteLanctoEstoqueBean matLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
            matLoteLanctoEstoque.setFilial(filialVO);
            matLoteLanctoEstoque.setInserir(true);
            matLoteLanctoEstoque.setLancamento(lancamentoEstoqueVO);
            matLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)lote.toVO());
            if (lancamentoEstoqueVO.getTipo().equalsIgnoreCase("S")) {
                matLoteLanctoEstoque.setQuantidade(Math.abs(lote.getQuantidadeConsumida() - lote.getQuantidadeConsumidaOriginal()));
            } else {
                matLoteLanctoEstoque.setQuantidade(lote.getQuantidade());
            }
            HashSet<MaterialLoteLanctoEstoqueBean> lancamentos = new HashSet<MaterialLoteLanctoEstoqueBean>();
            lancamentos.add(matLoteLanctoEstoque);
            lote.setLancamentosEstoque(lancamentos);
        }
    }

    public void gerarMaterialLoteLancEstoqueAlterado(FilialVO filialVO, LancamentoEstoqueVO lancamentoEstoqueVO, MaterialLoteBean lote) throws Exception {
        if (lote.getCodigo() != null) {
            MaterialLoteLanctoEstoqueBean matLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
            matLoteLanctoEstoque.setFilial(filialVO);
            matLoteLanctoEstoque.setInserir(true);
            matLoteLanctoEstoque.setLancamento(lancamentoEstoqueVO);
            matLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)lote.toVO());
            if (lancamentoEstoqueVO.getTipo().equalsIgnoreCase("S")) {
                matLoteLanctoEstoque.setQuantidade(Math.abs(lote.getQuantidadeConsumida() - lote.getQuantidadeConsumidaOriginal()));
            } else {
                matLoteLanctoEstoque.setQuantidade(lote.getQuantidade());
            }
            this.materialLoteLanctoEstoqueDao.insert(matLoteLanctoEstoque, Variaveis.filialPadrao);
        } else {
            this.gerarMaterialLoteLancEstoque(filialVO, lancamentoEstoqueVO, lote);
        }
    }

    public void gerarMaterialLoteLancEstoqueAlteradoTransferencia(FilialVO filialVO, LancamentoEstoqueVO lancamentoEstoqueVO, MaterialLoteBean lote) throws Exception {
        if (lote.getCodigo() != null) {
            MaterialLoteLanctoEstoqueBean matLoteLanctoEstoque = new MaterialLoteLanctoEstoqueBean();
            matLoteLanctoEstoque.setFilial(filialVO);
            matLoteLanctoEstoque.setInserir(true);
            matLoteLanctoEstoque.setLancamento(lancamentoEstoqueVO);
            matLoteLanctoEstoque.setMaterialLote((MaterialLoteVO)lote.toVO());
            if (lancamentoEstoqueVO.getTipo().equalsIgnoreCase("S")) {
                matLoteLanctoEstoque.setQuantidade(Math.abs(lote.getQuantidadeConsumida() - lote.getQuantidadeConsumidaOriginal()));
            } else {
                matLoteLanctoEstoque.setQuantidade(lote.getQuantidade());
            }
            this.materialLoteLanctoEstoqueDao.insert(matLoteLanctoEstoque, Variaveis.filialPadrao);
        }
    }

    public void atualizarDadoUltimaCompra(HashMap<String, Object> params) throws Exception {
        MaterialBean auxMaterial = (MaterialBean)new MaterialService().getTodos(params.get("filial").toString(), params.get("codigoMaterial").toString(), null, null);
        auxMaterial.setDataUltimaCompra((Date)params.get("dataHora"));
        auxMaterial.setValorUltimaCompra((Double)params.get("valoUnitario"));
        auxMaterial.setQuantidadeUltimaCompra((Double)params.get("quantidade"));
        auxMaterial.setDataUltimaEntrega((Date)params.get("dataHora"));
        auxMaterial.setCalculoRateioFreteUltimaCompra((Double)params.get("rateioFrete"));
        if (params.containsKey("codigoPedido")) {
            auxMaterial.setCodigoUltimaCompraPed((Integer)params.get("codigoPedido"));
        }
        if (params.containsKey("codigoUltimaCompraCen")) {
            auxMaterial.setCodigoUltimaCompraCen((Integer)params.get("codigoUltimaCompraCen"));
        }
        this.update(auxMaterial, null, Variaveis.filialPadrao, null);
    }

    public static void carregarLotesMaterial(MaterialBean material, boolean carregaLotesConsumidos) throws ThreadDaoException {
        if (material != null) {
            new MaterialDao().carregarDadosLotes(material, null, null, carregaLotesConsumidos);
        }
    }

    public static void carregarLotesMaterial(MaterialBean material) throws ThreadDaoException {
        if (material != null) {
            new MaterialDao().carregarDadosLotes(material, null, null, false);
        }
    }

    public static void carregarLotesMaterial(MaterialVO material) throws ThreadDaoException {
        if (material != null) {
            new MaterialDao().carregarDadosLotes(material, null, null, true);
        }
    }

    public void carregarDadosLotesNotaEntrada(MaterialVO material, NotaFiscalVO notaEntradaLote) throws ThreadDaoException {
        ((MaterialDao)this.dao).carregarDadosLotesNotaEntrada(material, notaEntradaLote);
    }

    public void inserirMaterialUsuario(MaterialUsuarioVO materialUsuarioVO) throws SQLException {
        List<MaterialUsuarioVO> listaUsuarios = ((MaterialDao)this.dao).buscaUsuarioMaterial(materialUsuarioVO);
        if (listaUsuarios.isEmpty()) {
            ((MaterialDao)this.dao).inserirMaterialUsuario(materialUsuarioVO);
        }
    }

    public List<MaterialUsuarioVO> buscaUsuarioMaterial(String filialPadrao, String codigoMaterial) throws SQLException {
        MaterialUsuarioVO materialUsuarioVO = new MaterialUsuarioVO();
        materialUsuarioVO.setCodigoFilial(Integer.valueOf(filialPadrao));
        materialUsuarioVO.setCodigoMaterial(Integer.valueOf(codigoMaterial));
        List<MaterialUsuarioVO> listaUsuarios = ((MaterialDao)this.dao).buscaUsuarioMaterial(materialUsuarioVO);
        return listaUsuarios;
    }

    public List<MaterialUsuarioVO> buscaMaterialUsuario(String filialPadrao, String codigoUsuario) throws SQLException {
        MaterialUsuarioVO materialUsuarioVO = new MaterialUsuarioVO();
        materialUsuarioVO.setCodigoFilial(Integer.valueOf(filialPadrao));
        materialUsuarioVO.setCodigoUsuario(codigoUsuario);
        List<MaterialUsuarioVO> listaUsuarios = ((MaterialDao)this.dao).buscaUsuarioMaterial(materialUsuarioVO);
        return listaUsuarios;
    }

    public List<MaterialVO> buscaMaterial(String filialPadrao, String codigoMaterial) throws SQLException {
        MaterialUsuarioVO materialUsuarioVO = new MaterialUsuarioVO();
        materialUsuarioVO.setCodigoFilial(Integer.valueOf(filialPadrao));
        materialUsuarioVO.setCodigoMaterial(Integer.valueOf(codigoMaterial));
        List<MaterialVO> listaMateriais = ((MaterialDao)this.dao).buscaMaterial(materialUsuarioVO);
        return listaMateriais;
    }

    public void removeUsuarios(List<MaterialUsuarioVO> listaUsuarios, MaterialUsuarioVO materialUsuario) throws SQLException {
        List<MaterialUsuarioVO> listaBanco = ((MaterialDao)this.dao).buscaUsuarioMaterial(materialUsuario);
        for (MaterialUsuarioVO materialUsuarioVO : listaBanco) {
            boolean encontrado = false;
            for (MaterialUsuarioVO matUsuarioVO : listaUsuarios) {
                if (!this.validarMaterialCadastrado(materialUsuarioVO, matUsuarioVO)) continue;
                encontrado = true;
            }
            if (encontrado) continue;
            ((MaterialDao)this.dao).deletar(materialUsuarioVO);
        }
    }

    private boolean validarMaterialCadastrado(MaterialUsuarioVO materialUsuarioVO, MaterialUsuarioVO matUsuarioVO) {
        return matUsuarioVO.getCodigoUsuario() != null && matUsuarioVO.getCodigoMaterial() == materialUsuarioVO.getCodigoMaterial() && matUsuarioVO.getCodigoUsuario().equals(materialUsuarioVO.getCodigoUsuario()) && matUsuarioVO.getTipoMaterialUsuario().equals(materialUsuarioVO.getTipoMaterialUsuario());
    }

    public void alteraCodigoNFI(Integer codigoFilial, Integer codigoMaterial) throws Exception {
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("N")) {
            MaterialBean materialBean = (MaterialBean)((MaterialDao)this.dao).getBeanNFI(codigoFilial, codigoMaterial);
            if (Funcoes.objectIsNull(materialBean)) {
                materialBean = this.getBean(String.valueOf(codigoFilial), String.valueOf(codigoMaterial));
                materialBean.setCalculoRateioFreteUltimaCompra(0.0);
                materialBean.setCodigoUltimaCompraNfi(null);
            }
            this.update(materialBean, null, String.valueOf(codigoFilial), null);
        }
    }

    public void alteraCodigoPED(Integer codigoFilial, Integer codigoMaterial) throws Exception {
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("P")) {
            MaterialBean materialBean = (MaterialBean)((MaterialDao)this.dao).getBeanPED(codigoFilial, codigoMaterial);
            if (Funcoes.objectIsNull(materialBean)) {
                materialBean = this.getBean(String.valueOf(codigoFilial), String.valueOf(codigoMaterial));
                materialBean.setCalculoRateioFreteUltimaCompra(0.0);
                materialBean.setCodigoUltimaCompraPed(null);
            }
            this.update(materialBean, null, String.valueOf(codigoFilial), null);
        }
    }

    public void alteraCodigoConf(Integer codigoFilial, Integer codigoMaterial, Integer nota, Integer pedido) throws Exception {
        if (ParametrosGerais.getTipoMovimentarEstoque().equalsIgnoreCase("C")) {
            MaterialBean materialBean = (MaterialBean)((MaterialDao)this.dao).getBeanConf(codigoFilial, codigoMaterial, nota, pedido);
            if (Funcoes.objectIsNull(materialBean)) {
                materialBean = this.getBean(String.valueOf(codigoFilial), String.valueOf(codigoMaterial));
                materialBean.setCalculoRateioFreteUltimaCompra(0.0);
                materialBean.setCodigoUltimaCompraCen(null);
            }
            this.update(materialBean, null, String.valueOf(codigoFilial), null);
        }
    }
}

