/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Material;
import jalis.laboratorio.relatorios.estoque.almoxarifado.aberturalotesmaterial.AberturaLotesMaterial;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.ConferenciaEntradaBean;
import jalis.model.bean.estoque.ConferenciaEntradaLanctoEstoqueBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteHistoricoBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.dao.estoque.MaterialLoteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.ConferenciaEntradaVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.ConferenciaEntradaLanctoEstoqueService;
import jalis.service.estoque.ConferenciaEntradaService;
import jalis.service.estoque.MaterialLoteHistoricoService;
import jalis.service.estoque.MaterialLoteLanctoEstoqueService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaterialLoteService
extends AbstractThreadService {
    public MaterialLoteService() {
        this.dao = new MaterialLoteDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean == null) {
            throw new Exception("Bean NULL");
        }
        if (!(bean instanceof MaterialLoteBean)) {
            throw new Exception("Bean n\u00e3o \u00e9 um MaterialLoteBean - " + bean.getClass());
        }
        if (codigo == null) {
            throw new Exception("C\u00f3digo NULL");
        }
        Set<MaterialLoteLanctoEstoqueBean> lancamentos = ((MaterialLoteBean)bean).getLancamentosEstoque();
        if (lancamentos == null || lancamentos.size() == 0) {
            throw new Exception("O lan\u00e7amento de entrada do lote n\u00e3o foi informado.");
        }
        MaterialLoteBean matLote = (MaterialLoteBean)bean;
        matLote.setCodigo((Integer)codigo);
        ((MaterialLoteDao)this.dao).insert(matLote, filialPadrao);
        for (MaterialLoteLanctoEstoqueBean aux : lancamentos) {
            if (!aux.isInserir()) continue;
            aux.getMaterialLote().setCodigo((Integer)codigo);
            new MaterialLoteLanctoEstoqueService().insert(aux, null, filialPadrao, filiais);
        }
        if (ParametrosGerais.isExigirAberturaLote() && matLote.getUsuarioAberturaInicial() != null) {
            MaterialLoteHistoricoBean beanHist = new MaterialLoteHistoricoBean();
            beanHist.setFilial(matLote.getFilial());
            beanHist.setUsuarioCriacao(matLote.getUsuarioCriacao());
            beanHist.setMaterialLote((MaterialLoteVO)matLote.toVO());
            beanHist.setDataHora(matLote.getDataHoraCriacao());
            beanHist.setOperacao("A");
            new MaterialLoteHistoricoService().gravaAutoCopiaSemCommit(beanHist, 0, filialPadrao, filiais);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean == null) {
            throw new Exception("Bean NULL");
        }
        if (!(bean instanceof MaterialLoteBean)) {
            throw new Exception("Bean n\u00e3o \u00e9 um MaterialLoteBean - " + bean.getClass());
        }
        MaterialLoteBean matLote = (MaterialLoteBean)bean;
        UsuarioVO usuario = new UsuarioVO();
        usuario.setFilial(matLote.getFilial());
        usuario.setCodigo(Variaveis.login);
        boolean encerrarLote = false;
        if (ParametrosGerais.isExigirAberturaLote() && matLote.getUsuarioAberturaInicial() != null && matLote.getQuantidade().equals(matLote.getQuantidadeConsumida()) && matLote.getDataHoraFechado() == null && matLote.getUsuarioFechamento() == null) {
            matLote.setUsuarioFechamento(matLote.getUsuarioCriacao());
            matLote.setDataHoraFechado(Funcoes.getDataHoraServidor());
            matLote.setUsuarioAberto(null);
            matLote.setDataHoraAberto(null);
            encerrarLote = true;
        }
        if (ParametrosGerais.isExigirAberturaLote() && matLote.getUsuarioAberturaInicial() == null && matLote.getDataHoraAberturaInicial() == null) {
            matLote.setDataHoraAberturaInicial(Funcoes.getDataHoraServidor());
            matLote.setUsuarioAberturaInicial(usuario);
        }
        ((MaterialLoteDao)this.dao).update(bean, filialPadrao);
        for (MaterialLoteLanctoEstoqueBean aux : ((MaterialLoteBean)bean).getLancamentosEstoque()) {
            if (aux.isInserir()) {
                new MaterialLoteLanctoEstoqueService().insert(aux, null, filialPadrao, filiais);
                continue;
            }
            new MaterialLoteLanctoEstoqueService().update(aux, null, filialPadrao, filiais);
        }
        if (ParametrosGerais.isExigirAberturaLote() && matLote.getQuantidade().equals(matLote.getQuantidadeConsumida()) && encerrarLote) {
            MaterialLoteHistoricoBean beanHist = new MaterialLoteHistoricoBean();
            beanHist.setFilial(matLote.getFilial());
            beanHist.setUsuarioCriacao(usuario);
            beanHist.setMaterialLote((MaterialLoteVO)matLote.toVO());
            beanHist.setDataHora(Funcoes.getDataHoraServidor());
            beanHist.setOperacao("E");
            MaterialLoteHistoricoService matLotHistService = new MaterialLoteHistoricoService();
            matLotHistService.gravaAutoCopiaSemCommit(beanHist, 0, filialPadrao, filiais);
        }
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        MaterialLoteDao cfr_ignored_0 = (MaterialLoteDao)this.dao;
        return MaterialLoteDao.load(MaterialLoteBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return AbstractThreadDao.load(MaterialLoteVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de Lote");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.setFiltroInicial("C\u00f3digo", 3);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and not mll_removido ");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String codMaterial, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        StringBuilder filtro = new StringBuilder();
        filtro.append(" fil_codigo =  ");
        filtro.append(Variaveis.filialPadrao);
        filtro.append(" and mat_codigo = ");
        filtro.append(codMaterial);
        filtro.append(" and not mll_removido  ");
        if (mostrarCadastro) {
            tela.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de Lote");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("lote", "Lote", 0, "", 2, 75);
        tela.adicionaCampo("dataLote", "Data do lote", 2, "", 3, 75);
        tela.setFiltroInicial("Lote", 2);
        tela.setColunaOrdenacao("Lote");
        tela.setFiltro(filtro.toString());
        tela.setExecutarAoAbrir(true);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((MaterialLoteDao)this.dao).getBean(chaves);
    }

    public AbstractThreadVO getVO(Map<String, Object> chaves) throws Exception {
        return ((MaterialLoteDao)this.dao).getVO(chaves);
    }

    public static String criarNumeracaoLoteInterno() {
        Calendar cal = Calendar.getInstance();
        char mes = (char)(65 + cal.get(2));
        char hora = (char)(65 + cal.get(11));
        StringBuilder buf = new StringBuilder();
        buf.append(Funcoes.preencheVazio(String.valueOf(cal.get(1)), "0", 4, 1));
        buf.append(String.valueOf(mes));
        buf.append(Funcoes.preencheVazio(String.valueOf(cal.get(5)), "0", 2, 1));
        buf.append(String.valueOf(hora));
        buf.append(Funcoes.preencheVazio(String.valueOf(cal.get(12)), "0", 2, 1));
        buf.append(Funcoes.preencheVazio(String.valueOf(cal.get(13)), "0", 2, 1));
        return buf.toString();
    }

    public String podeModificarExcluirLote(MaterialLoteBean lote, boolean isExclusao) throws Exception {
        String operacao = isExclusao ? "remover" : "modificar";
        Iterator<MaterialLoteLanctoEstoqueBean> iterator = lote.getLancamentosEstoque().iterator();
        if (iterator.hasNext()) {
            MaterialLoteLanctoEstoqueBean loteLancto = iterator.next();
            LancamentoEstoqueVO lancto = loteLancto.getLancamento();
            if (lancto != null) {
                if (lancto.getTipoOrigem().equalsIgnoreCase("C")) {
                    ConferenciaEntradaLanctoEstoqueBean confLancto = null;
                    try {
                        confLancto = new ConferenciaEntradaLanctoEstoqueService().getConferenciaEntradaLanctoEstoque(lancto.getFilial().getCodigo().toString(), lancto.getCodigo().toString());
                    }
                    catch (ThreadDaoException e) {
                        throw new Exception("N\u00e3o foi poss\u00edvel buscar origem do lan\u00e7amento de estoque.\n" + e.getMessage());
                    }
                    if (confLancto != null && confLancto.getConferenciaEntrada() != null) {
                        ConferenciaEntradaVO confVO = confLancto.getConferenciaEntrada();
                        ConferenciaEntradaBean conferencia = null;
                        try {
                            conferencia = (ConferenciaEntradaBean)new ConferenciaEntradaService().get(confVO.getFilial().getCodigo().toString(), confVO.getCodigo().toString());
                        }
                        catch (Exception e) {
                            throw new Exception("N\u00e3o foi poss\u00edvel buscar a confer\u00eancia de entrada de origem do lan\u00e7amento de estoque.\n" + e.getMessage());
                        }
                        if (conferencia != null) {
                            if (conferencia.getNotaFiscal() != null) {
                                return "N\u00e3o \u00e9 poss\u00edvel " + operacao + " o lote, pois, a origem \u00e9 nota fiscal. N\u00famero nota: " + conferencia.getNotaFiscal().getNumero() + ".\n\u00c9 necess\u00e1rio estornar a confer\u00eancia de entrada para " + operacao + " o lote.";
                            }
                            if (conferencia.getPedido() != null) {
                                return "N\u00e3o \u00e9 poss\u00edvel " + operacao + " o lote, pois, a origem \u00e9 pedido de compra. C\u00f3digo do pedido: " + conferencia.getPedido().getCodigo() + ".\n\u00c9 necess\u00e1rio estornar a confer\u00eancia de entrada para " + operacao + " o lote.";
                            }
                            throw new Exception("Origem do lan\u00e7amento n\u00e3o localizada.");
                        }
                    }
                } else {
                    if (lancto.getTipoOrigem().equalsIgnoreCase("M")) {
                        return "N\u00e3o \u00e9 poss\u00edvel " + operacao + " o lote, pois, a origem \u00e9 manuten\u00e7\u00e3o de estoque.";
                    }
                    if (lancto.getTipoOrigem().equalsIgnoreCase("O")) {
                        return "N\u00e3o \u00e9 poss\u00edvel " + operacao + " o lote, pois, a origem \u00e9 confer\u00eancia de estoque.";
                    }
                    throw new Exception("Origem incorreta.");
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public void removerLoteLancamentoEstoque(String filial, String codigoLancamentoEstoque, Date dataHoraRemocao) throws SQLException {
        new MaterialLoteDao().removerLoteLancamentoEstoque(filial, codigoLancamentoEstoque, dataHoraRemocao);
    }

    public ArrayList<MaterialLoteBean> getBeans(Map<String, Object> chaves, boolean isNaoMostrarConsumidos) throws ThreadDaoException {
        return ((MaterialLoteDao)this.dao).getBeans(chaves, isNaoMostrarConsumidos);
    }

    public ArrayList<MaterialLoteBean> getBeans(Map<String, Object> chaves) throws ThreadDaoException {
        return ((MaterialLoteDao)this.dao).getBeans(chaves, false);
    }

    public void removerLoteLancamentoEstoque(String filialPadrao, MaterialLoteLanctoEstoqueBean materialLoteLanctoEstoqueBean, Date dataHoraRemocao) throws SQLException {
        new MaterialLoteDao().removerLoteLancamentoEstoque(filialPadrao, materialLoteLanctoEstoqueBean, dataHoraRemocao);
    }

    public List<AberturaLotesMaterial> dadosLote(String filial, String materialLote, String material, String codigoLote) throws SQLException {
        return this.gerarSqlDadosLote(filial, materialLote, material, codigoLote);
    }

    public List<Map<String, Object>> aberturaFechamentoLote(String filial, String materialLote) throws SQLException {
        ArrayList<Map<String, Object>> map = new ArrayList<Map<String, Object>>();
        String sql = this.geraSqlAberturaBaixaEstoque(filial, materialLote);
        Statement st = Conexao.getStatement();
        ResultSet resultSet = st.executeQuery(sql);
        while (resultSet.next()) {
            HashMap<String, Object> dados = new HashMap<String, Object>();
            String tipo = resultSet.getString("tipo");
            String usuario = resultSet.getString("usr_codigo");
            Timestamp data = resultSet.getTimestamp("lce_datahora");
            Timestamp dataAberturaLote = null;
            Timestamp dataFechamentoLote = null;
            String usuarioAberturaLote = null;
            String usuarioFechamentoLote = null;
            if (tipo.equals("ABERTURA")) {
                dataAberturaLote = resultSet.getTimestamp("mll_datahora");
                usuarioAberturaLote = resultSet.getString("mll_usuario");
            } else {
                dataFechamentoLote = resultSet.getTimestamp("mll_datahora");
                usuarioFechamentoLote = resultSet.getString("mll_usuario");
            }
            dados.put("tipo", tipo);
            dados.put("usr_codigo", usuario);
            dados.put("lce_datahora", data);
            dados.put("dataAberturaLote", dataAberturaLote);
            dados.put("dataFechamentoLote", dataFechamentoLote);
            dados.put("usuarioAberturaLote", usuarioAberturaLote);
            dados.put("usuarioFechamentoLote", usuarioFechamentoLote);
            map.add(dados);
        }
        resultSet.close();
        st.close();
        return map;
    }

    public String processaValorDataFechamentoLote(String campo, List<Map<String, Object>> lista) {
        String retorno = "";
        for (Map<String, Object> map : lista) {
            if (map.get("tipo").equals("ABERTURA")) {
                if (campo.equals("usuarioAberturaLote")) {
                    retorno = (String)map.get("usuarioAberturaLote");
                    continue;
                }
                if (!campo.equals("dataAberturaLote")) continue;
                retorno = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", (Date)map.get("dataAberturaLote"));
                continue;
            }
            if (!map.get("tipo").equals("FECHAMENTO")) continue;
            if (campo.equals("usuarioFechamentoLote")) {
                retorno = (String)map.get("usuarioFechamentoLote");
                continue;
            }
            if (!campo.equals("dataFechamentoLote")) continue;
            retorno = Funcoes.formataData("dd/MM/yyyy HH:mm:ss", (Date)map.get("dataFechamentoLote"));
        }
        return retorno;
    }

    public List<AberturaLotesMaterial> gerarSqlDadosLote(String filial, String materialLote, String material, String codigoLote) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT lce.fil_codigo as filial, ");
        sql.append("mll.mll_aberturainicial as dataAbertura, ");
        sql.append("mll.usr_codaberturainicial as usuarioAbertura, ");
        sql.append("mll.mll_fechado  as dataFechamento, ");
        sql.append("mll.usr_codfechado  as usuarioFechamento, ");
        sql.append("lce.lce_datahora as dataLancamento, ");
        sql.append("lce.usr_codigo as usuarioLancamento ");
        sql.append("FROM lanctoestoque lce ");
        sql.append("INNER JOIN materiallotelanctoestoque mle ON mle.fil_Codigo = lce.fil_codigo AND mle.lce_Codigo = lce.lce_codigo AND mle.mll_quantidade > 0 ");
        sql.append("INNER JOIN materiallote mll ON mll.fil_codigo = lce.fil_codigo AND mll.mat_codigo = lce.mat_codigo AND mll.mll_Codigo = mle.mll_codigo AND mle.mll_quantidade > 0 AND NOT mll.mll_removido");
        sql.append(" WHERE lce.fil_codigo = ").append(filial);
        sql.append(" and mll.mll_codigo = ").append(materialLote);
        sql.append(" and mll.mat_codigo = ").append(material);
        sql.append(" and mll.mll_lote = ").append(StringUtil.textoDBEscape(codigoLote));
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        ArrayList<AberturaLotesMaterial> listaAbertura = new ArrayList<AberturaLotesMaterial>();
        while (rs.next()) {
            AberturaLotesMaterial abm = new AberturaLotesMaterial();
            abm.setFilial(rs.getString("filial"));
            abm.setDataAbertura(rs.getTimestamp("dataAbertura"));
            abm.setUsuarioAbertura(rs.getString("usuarioAbertura"));
            abm.setDataFechamento(rs.getTimestamp("dataFechamento"));
            abm.setUsuarioFechamento(rs.getString("usuarioFechamento"));
            abm.setDataLancamento(rs.getString("dataLancamento"));
            abm.setUsuarioLancamento(rs.getString("usuarioLancamento"));
            listaAbertura.add(abm);
        }
        return listaAbertura;
    }

    public String geraSqlAberturaBaixaEstoque(String filial, String materialLote) {
        StringBuilder sql = new StringBuilder();
        sql.append("select lce.fil_codigo, mll.mll_aberturainicial as mll_datahora, mll.usr_codaberturainicial as mll_usuario, lce.lce_datahora, lce.usr_codigo, 'ABERTURA' AS tipo from  lanctoestoque lce ");
        sql.append("join materiallotelanctoestoque mle on mle.fil_Codigo = lce.fil_codigo and mle.lce_Codigo = lce.lce_codigo and mle.mll_quantidade > 0 join materiallote mll on mll.fil_codigo = lce.fil_codigo and mll.mat_codigo = lce.mat_codigo and mll.mll_Codigo = mle.mll_codigo and mle.mll_quantidade > 0 and not mll.mll_removido ");
        sql.append("where lce.lce_codigo = ( ");
        sql.append("select MIN(lce.lce_codigo) as lanctoAbertura                                                               ");
        sql.append("from materiallotelanctoestoque mle                                                                         ");
        sql.append("join lanctoestoque lce on mle.fil_codigo = lce.fil_codigo and mle.lce_codigo = lce.lce_codigo              ");
        sql.append("join materiallote mll on mll.fil_codigo = lce.fil_codigo and mll.mll_codigo = mle.mll_codigo and mll.mll_aberto is not null ");
        sql.append("where mle.fil_codigo =                                                                                     ");
        sql.append(filial);
        sql.append(" and mle.mll_codigo =                                                                                       ");
        sql.append(materialLote);
        sql.append(" and lce.lce_tipo = '");
        sql.append("E").append("' ");
        sql.append("and lce.lce_conciliacao IS NOT NULL                                                                        ");
        sql.append(" and mle.mll_quantidade > 0 ");
        sql.append("and lce.lce_datahoracancelamento IS NULL) and lce.fil_codigo =                                                 ");
        sql.append(filial);
        sql.append("                                                                                                           ");
        sql.append(" UNION                                                                                                      ");
        sql.append("                                                                                      ");
        sql.append("select lce.fil_codigo, mll.mll_fechado as mll_datahora, mll.usr_codfechado as mll_usuario, lce.lce_datahora, lce.usr_codigo, 'FECHAMENTO' AS tipo from lanctoestoque lce ");
        sql.append("join materiallotelanctoestoque mle on mle.fil_Codigo = lce.fil_codigo and mle.lce_Codigo = lce.lce_codigo and mle.mll_quantidade > 0 join materiallote mll on mll.fil_codigo = lce.fil_codigo and mll.mat_codigo = lce.mat_codigo and mll.mll_Codigo = mle.mll_codigo and mle.mll_quantidade > 0 and not mll.mll_removido ");
        sql.append("where lce.lce_codigo = ( ");
        sql.append("select MAX(lce.lce_codigo) as lanctoFechamento                                                             ");
        sql.append("from materiallotelanctoestoque mle                                                                         ");
        sql.append("join lanctoestoque lce on mle.fil_codigo = lce.fil_codigo and mle.lce_codigo = lce.lce_codigo              ");
        sql.append("join materiallote mll on mll.fil_codigo = lce.fil_codigo and mll.mll_codigo = mle.mll_codigo and mll.mll_fechado is not null ");
        sql.append("where mle.fil_codigo =                                                                                     ");
        sql.append(filial);
        sql.append(" and mle.mll_codigo =                                                                                       ");
        sql.append(materialLote);
        sql.append(" and lce.lce_tipo = '");
        sql.append("E").append("' ");
        sql.append("and lce.lce_conciliacao IS NOT NULL                                                                        ");
        sql.append(" and mle.mll_quantidade > 0 ");
        sql.append("and lce.lce_datahoracancelamento IS NULL) and lce.fil_codigo =                                                 ");
        sql.append(filial);
        return sql.toString();
    }
}

