/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.configuracao.UsuarioMensagemBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialLoteBean;
import jalis.model.bean.estoque.MaterialLoteLanctoEstoqueBean;
import jalis.model.bean.estoque.SaldoEstoqueBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.dao.estoque.LancamentoEstoqueDao;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.material.MaterialUsuarioVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import jalis.service.estoque.MaterialLoteLanctoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.service.estoque.SaldoEstoqueService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class LancamentoEstoqueService
extends AbstractThreadService {
    public LancamentoEstoqueService() {
        this.dao = new LancamentoEstoqueDao();
    }

    @Override
    @Deprecated
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
    }

    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, boolean verificaPontoReposicao, MaterialBean material) throws Exception {
        String[] codigos = new String[0];
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (LancamentoEstoqueService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        FilialVO filialVO = null;
        Field fieldFilial = null;
        for (Field f : fields) {
            if (f.getType() != FilialVO.class) continue;
            fieldFilial = f;
            fieldFilial.setAccessible(true);
            filialVO = (FilialVO)fieldFilial.get(bean);
            break;
        }
        if (filialVO == null) {
            throw new Exception("Classe " + bean.getClass() + " n\u00e3o possui campo filial definido!");
        }
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        int valor = 1;
        String tabela = "";
        if (tipo == 0) {
            tabela = bean.getClass().getAnnotation(DataBaseTable.class).value();
            String[] stringArray = codigos;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                int v = this.dao.ultimoValorSequence(tabela + "_" + s + "_sequence");
                if (v <= valor) continue;
                valor = v;
            }
        }
        for (String filial : codigos) {
            filialVO.setCodigo(Integer.parseInt(filial));
            filialVO.setDescricao("");
            if (fieldFilial == null) {
                throw new Exception("Campo filial nulo.");
            }
            fieldFilial.set(bean, filialVO);
            if (tipo == 0) {
                this.insert(bean, valor, filial, verificaPontoReposicao, material);
                continue;
            }
            if (tipo != 1) continue;
            this.update(bean, valor, filial);
        }
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((LancamentoEstoqueDao)this.dao).getBean(Variaveis.filialPadrao, codigo);
    }

    public LancamentoEstoqueBean get(String filial, String codigo) throws Exception {
        return ((LancamentoEstoqueDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return ((LancamentoEstoqueDao)this.dao).getBean(Variaveis.filialPadrao, codigo);
    }

    public LancamentoEstoqueVO getVO(String filial, String codigo) throws Exception {
        return (LancamentoEstoqueVO)((LancamentoEstoqueDao)this.dao).getVO(filial, codigo);
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, boolean verificaPontoReposicao, MaterialBean material) throws Exception {
        LancamentoEstoqueBean lanctoBean = (LancamentoEstoqueBean)bean;
        lanctoBean.setCodigo((Integer)codigo);
        ((LancamentoEstoqueDao)this.dao).insert(lanctoBean, filialPadrao);
        if (material != null) {
            MaterialService serviceMaterial = new MaterialService();
            ArrayList<MaterialLoteBean> lotes = material.getLotes();
            if (lotes != null) {
                for (int j = 0; j < lotes.size(); ++j) {
                    MaterialLoteBean lote = lotes.get(j);
                    if (lote.getRemovido().booleanValue()) continue;
                    if (lote.getInserir() || lanctoBean.getTipo().equalsIgnoreCase("S")) {
                        serviceMaterial.gerarMaterialLoteLancEstoqueAlterado(lanctoBean.getFilial(), (LancamentoEstoqueVO)lanctoBean.toVO(), lote);
                        continue;
                    }
                    if (!lote.getAlterar()) continue;
                    serviceMaterial.gerarMaterialLoteLancEstoque(lanctoBean.getFilial(), (LancamentoEstoqueVO)lanctoBean.toVO(), lote);
                }
            }
            serviceMaterial.gravaAutoCopiaSemCommit(material, 1, Variaveis.filialPadrao, null);
        }
        if (lanctoBean.getTipo().equalsIgnoreCase("E") && lanctoBean.getSituacao().equalsIgnoreCase("O") && lanctoBean.getCelulaEstoque() != null && lanctoBean.getCelulaEstoque().getBaixarAutomatico() != null && lanctoBean.getCelulaEstoque().getBaixarAutomatico().booleanValue()) {
            this.geraBaixaAutomatica(filialPadrao, lanctoBean);
        }
        if (verificaPontoReposicao && lanctoBean.getTipo().equalsIgnoreCase("S")) {
            Date dataAux = lanctoBean.getDataConciliacao() == null ? lanctoBean.getDataHora() : lanctoBean.getDataConciliacao();
            SaldoEstoqueBean saldoEstoqueBean = (SaldoEstoqueBean)new SaldoEstoqueService().getSaldoEstoqueMaterial(String.valueOf(lanctoBean.getFilial().getCodigo()), String.valueOf(lanctoBean.getMaterial().getCodigo()), dataAux);
            if (saldoEstoqueBean != null) {
                this.verificaPontoReposicaoAtingido(lanctoBean.getMaterial(), saldoEstoqueBean.getSaldo());
            }
        }
    }

    private void geraBaixaAutomatica(String filialPadrao, LancamentoEstoqueBean lancto) throws Exception {
        LancamentoEstoqueBean lanctoBaixa = new LancamentoEstoqueBean();
        lanctoBaixa.setFilial(lancto.getFilial());
        lanctoBaixa.setCelulaEstoque(lancto.getCelulaEstoque());
        lanctoBaixa.setDataConciliacao(lancto.getDataConciliacao());
        lanctoBaixa.setDataHora(lancto.getDataHora());
        lanctoBaixa.setMaterial(lancto.getMaterial());
        lanctoBaixa.setQuantidade(lancto.getQuantidade());
        lanctoBaixa.setSituacao("O");
        lanctoBaixa.setTipo("S");
        lanctoBaixa.setTipoOrigem("A");
        lanctoBaixa.setUsuario(lancto.getUsuario());
        lanctoBaixa.setUsuarioConciliacao(lancto.getUsuarioConciliacao());
        this.gravaAutoCopiaSemCommit(lanctoBaixa, 0, filialPadrao, false, null);
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", lancto.getFilial().getCodigo());
        chaves.put("lce_codigo", lancto.getCodigo());
        Set<MaterialLoteLanctoEstoqueBean> listaLoteLancto = new MaterialLoteLanctoEstoqueService().getBeans(chaves);
        if (listaLoteLancto != null) {
            for (MaterialLoteLanctoEstoqueBean loteLancto : listaLoteLancto) {
                HashMap<String, Object> chavesLote = new HashMap<String, Object>();
                chavesLote.put("fil_codigo", loteLancto.getMaterialLote().getFilial().getCodigo());
                chavesLote.put("mll_codigo", loteLancto.getMaterialLote().getCodigo());
                ArrayList<MaterialLoteBean> listaLotes = new MaterialLoteService().getBeans(chavesLote);
                if (listaLotes == null) continue;
                for (MaterialLoteBean matLote : listaLotes) {
                    matLote.setQuantidadeConsumida(matLote.getQuantidade());
                    matLote.setQuantidadeConsumidaOriginal(0.0);
                    new MaterialService().gerarMaterialLoteLancEstoqueAlterado(lanctoBaixa.getFilial(), (LancamentoEstoqueVO)lanctoBaixa.toVO(), matLote);
                    new MaterialLoteService().gravaAutoCopiaSemCommit(matLote, 1, filialPadrao, null);
                }
            }
        }
        lancto.setLancamentoBaixaAutomatica((LancamentoEstoqueVO)lanctoBaixa.toVO());
        this.dao.update(lancto, filialPadrao);
    }

    private void verificaPontoReposicaoAtingido(MaterialVO material, Double estoqueAtual) throws Exception {
        if (material == null || estoqueAtual == null) {
            return;
        }
        MaterialBean matBean = (MaterialBean)new MaterialService().getTodos(material.getFilial().getCodigo().toString(), material.getCodigo().toString(), null, null);
        if (matBean != null && matBean.getPontoReposicao() != null) {
            String codigoResponsavel = new FilialService().getCodigoResponsavelEstoque(matBean.getFilial().getCodigo().toString());
            if (matBean.getUsuario() == null && (codigoResponsavel == null || Funcoes.textoVazio(codigoResponsavel))) {
                return;
            }
            if (estoqueAtual <= matBean.getPontoReposicao()) {
                MaterialService serviceMaterial = new MaterialService();
                List<MaterialUsuarioVO> listaMaterial = serviceMaterial.buscaUsuarioMaterial(matBean.getFilial().getCodigo().toString(), matBean.getCodigo().toString());
                for (MaterialUsuarioVO materialUsuarioVO : listaMaterial) {
                    if (materialUsuarioVO.getCodigoUsuario().equalsIgnoreCase(codigoResponsavel)) continue;
                    this.gravarMensagem(materialUsuarioVO, matBean, estoqueAtual, codigoResponsavel);
                }
                this.enviarMensagemResponsavel(matBean, codigoResponsavel, estoqueAtual);
            }
        }
    }

    private void gravarMensagem(MaterialUsuarioVO materialUsuarioVO, MaterialBean matBean, Double estoqueAtual, String codigoResponsavel) throws Exception {
        UsuarioVO remetente = new UsuarioVO();
        remetente.setFilial(matBean.getFilial());
        remetente.setCodigo(codigoResponsavel);
        UsuarioMensagemBean mensagem = this.getMensagem(matBean, estoqueAtual, remetente);
        if (materialUsuarioVO != null && matBean.getReposicaoAutomatica() != null && matBean.getReposicaoAutomatica().booleanValue() && materialUsuarioVO.getTipoMaterialUsuario().equals("R")) {
            UsuarioVO usuarioDestino = new UsuarioVO();
            usuarioDestino.setFilial(matBean.getFilial());
            usuarioDestino.setCodigo(materialUsuarioVO.getCodigoUsuario());
            mensagem.setDestino(usuarioDestino);
            if (!this.validaOrigemEDestino(mensagem)) {
                return;
            }
            new UsuarioMensagemService().insert(mensagem, null, null, null);
        }
    }

    private void enviarMensagemResponsavel(MaterialBean matBean, String codigoResponsavel, Double estoqueAtual) throws Exception {
        UsuarioVO usuarioMsg = new UsuarioVO();
        usuarioMsg.setFilial(matBean.getFilial());
        usuarioMsg.setCodigo(codigoResponsavel);
        UsuarioMensagemBean mensagem = this.getMensagem(matBean, estoqueAtual, usuarioMsg);
        mensagem.setDestino(usuarioMsg);
        if (!this.validaOrigemEDestino(mensagem)) {
            return;
        }
        new UsuarioMensagemService().insert(mensagem, null, null, null);
    }

    private boolean validaOrigemEDestino(UsuarioMensagemBean mensagem) {
        return mensagem.getDestino() != null && !Funcoes.textoVazio(mensagem.getDestino().getCodigo()) || mensagem.getOrigem() != null && !Funcoes.textoVazio(mensagem.getOrigem().getCodigo());
    }

    private UsuarioMensagemBean getMensagem(MaterialBean matBean, Double estoqueAtual, UsuarioVO remetente) throws SQLException, ThreadDaoException {
        UsuarioMensagemBean mensagem = new UsuarioMensagemBean();
        mensagem.setConfirmarLeitura(false);
        mensagem.setAvisada(false);
        mensagem.setDataHora(new Date());
        mensagem.setOrigem(remetente);
        String msg = "Ponto de reposi\u00e7\u00e3o atingido - " + matBean.getDescricao();
        mensagem.setAssunto(msg.length() > 100 ? msg.substring(0, 100) : msg.substring(0, msg.length()));
        StringBuilder buf = new StringBuilder();
        buf.append("O material \"").append(matBean.getDescricao()).append("\" (c\u00f3d.: ").append(matBean.getCodigo()).append(") ");
        buf.append("atingiu o ponto de reposi\u00e7\u00e3o em ").append(Funcoes.formataData("dd/MM/yyyy '\u00e0s' HH:mm", new Date())).append("h.\n");
        buf.append("A quantidade total atual em estoque \u00e9 ").append(Funcoes.formataDecimal(estoqueAtual)).append(matBean.getUnidadeMedida() == null ? "" : matBean.getUnidadeMedida().getCodigo()).append(".\n");
        buf.append("O ponto de reposi\u00e7\u00e3o est\u00e1 definido em ").append(Funcoes.formataDecimal(matBean.getPontoReposicao())).append(matBean.getUnidadeMedida() == null ? "" : matBean.getUnidadeMedida().getCodigo()).append(".");
        ArrayList<SaldoEstoqueCelulaBean> saldosCelula = new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterial(matBean.getFilial().getCodigo().toString(), matBean.getCodigo().toString());
        if (saldosCelula != null) {
            buf.append("\n\n");
            buf.append("Detalhamento do estoque atual por c\u00e9lula:\n");
            for (int i = 0; i < saldosCelula.size(); ++i) {
                SaldoEstoqueCelulaBean aux = saldosCelula.get(i);
                buf.append("\"").append(aux.getCelula().getDescricao()).append("\" - ").append(Funcoes.formataDecimal(aux.getSaldo())).append(aux.getMaterial().getUnidadeMedida().getCodigo());
                if (i >= saldosCelula.size() - 1) continue;
                buf.append("\n");
            }
        }
        mensagem.setMensagem(buf.toString());
        return mensagem;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(LancamentoEstoqueBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    private String getSituacaoLancamento(String filial, String codigoLancamentoEstoque) throws SQLException {
        return ((LancamentoEstoqueDao)this.dao).getSituacaoLancamento(filial, codigoLancamentoEstoque);
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) {
    }

    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao) throws Exception {
        LancamentoEstoqueBean lanctoBean = (LancamentoEstoqueBean)bean;
        if (lanctoBean.getTipo().equalsIgnoreCase("E") && lanctoBean.getSituacao().equalsIgnoreCase("O") && lanctoBean.getCelulaEstoque() != null && lanctoBean.getCelulaEstoque().getBaixarAutomatico() != null && lanctoBean.getCelulaEstoque().getBaixarAutomatico().booleanValue()) {
            if (lanctoBean.getDataHoraCancelamento() == null) {
                ((LancamentoEstoqueDao)this.dao).update(bean, filialPadrao);
                this.geraBaixaAutomatica(filialPadrao, lanctoBean);
            } else {
                LancamentoEstoqueBean lanctoAuto;
                if (lanctoBean.getLancamentoBaixaAutomatica() != null && (lanctoAuto = this.get(lanctoBean.getLancamentoBaixaAutomatica().getFilial().getCodigo().toString(), lanctoBean.getLancamentoBaixaAutomatica().getCodigo().toString())) != null) {
                    lanctoAuto.setDataHoraCancelamento(lanctoBean.getDataHoraCancelamento());
                    lanctoAuto.setUsuarioCancelamento(lanctoBean.getUsuarioCancelamento());
                    ((LancamentoEstoqueDao)this.dao).update(lanctoAuto, filialPadrao);
                }
                ((LancamentoEstoqueDao)this.dao).update(bean, filialPadrao);
            }
        } else {
            ((LancamentoEstoqueDao)this.dao).update(bean, filialPadrao);
        }
    }

    public ArrayList<LancamentoEstoqueBean> getLancamentosMaterial(String codigoFilial, String codigoMaterial, Integer limite) throws ThreadDaoException {
        return ((LancamentoEstoqueDao)this.dao).getLancamentosMaterial(codigoFilial, codigoMaterial, limite);
    }

    public LancamentoEstoqueVO getLancamentoOrigem(LancamentoEstoqueVO lancto) throws ThreadDaoException {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", lancto.getFilial().getCodigo());
        chaves.put("lce_kodigo", lancto.getCodigo());
        return (LancamentoEstoqueVO)((LancamentoEstoqueDao)this.dao).getVO(chaves);
    }
}

