/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.estoque.almoxarifado.DadosUltimosCustos;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoquePepsBean;
import jalis.model.dao.estoque.LancamentoEstoquePepsDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.service.AbstractThreadService;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Set;

public class LancamentoEstoquePepsService
extends AbstractThreadService {
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public LancamentoEstoquePepsService() {
        this.dao = new LancamentoEstoquePepsDao();
    }

    public ArrayList<LancamentoEstoquePepsBean> getLancamentosOrigem(String codigoFilial, Double quantidade, String codigoMaterial) throws ThreadDaoException {
        return ((LancamentoEstoquePepsDao)this.dao).getLancamentosOrigem(codigoFilial, quantidade, codigoMaterial);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.update(bean, filialPadrao);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof LancamentoEstoquePepsBean) {
            ((LancamentoEstoquePepsBean)bean).setCodigo(Integer.parseInt(codigo.toString()));
        }
        this.dao.insert(bean, filialPadrao);
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    public Set get(String filial, String codigo) throws Exception {
        return ((LancamentoEstoquePepsDao)this.dao).getBean(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    @Deprecated
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
    }

    public Integer getProximaCelula(String codigoFilial, String codigoMaterial) throws SQLException {
        return ((LancamentoEstoquePepsDao)this.dao).getProximaCelula(codigoFilial, codigoMaterial);
    }

    public ArrayList<DadosUltimosCustos> getUltimosCustos(String filial, String material, int quantidade) throws SQLException {
        return ((LancamentoEstoquePepsDao)this.dao).getUltimosCustos(filial, material, quantidade);
    }
}

