/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.estoque.almoxarifado.DadosUltimosCustos;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.LancamentoEstoqueCmcBean;
import jalis.model.dao.estoque.LancamentoEstoqueCmcDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.service.AbstractThreadService;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public class LancamentoEstoqueCmcService
extends AbstractThreadService {
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public LancamentoEstoqueCmcService() {
        this.dao = new LancamentoEstoqueCmcDao();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.update(bean, filialPadrao);
    }

    public Double getQuantidadeEntradas(String codigoFilial, String codigoMaterial) throws SQLException {
        return ((LancamentoEstoqueCmcDao)this.dao).getQuantidadeEntradas(codigoFilial, codigoMaterial);
    }

    public Double getValorTotalEntradas(String codigoFilial, String codigoMaterial) throws SQLException {
        return ((LancamentoEstoqueCmcDao)this.dao).getValorTotalEntradas(codigoFilial, codigoMaterial);
    }

    public LancamentoEstoqueCmcBean getCmcAtual(String codigoFilial, String codigoMaterial) throws ThreadDaoException {
        return ((LancamentoEstoqueCmcDao)this.dao).getCmcAtual(codigoFilial, codigoMaterial);
    }

    public int atualizaSaldoTotalCMC(String codigoFilial, String codigoMaterial, Date data, Double valorUnitario) throws SQLException {
        return ((LancamentoEstoqueCmcDao)this.dao).atualizaSaldoTotalCMC(codigoFilial, codigoMaterial, data, valorUnitario);
    }

    public int atualizaTodasCelulasCMC(String codigoFilial, String codigoMaterial, Date data, Double valorUnitario) throws SQLException {
        return ((LancamentoEstoqueCmcDao)this.dao).atualizaTodasCelulasCMC(codigoFilial, codigoMaterial, data, valorUnitario);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof LancamentoEstoqueCmcBean) {
            ((LancamentoEstoqueCmcBean)bean).setCodigo(Integer.parseInt(codigo.toString()));
        }
        this.dao.insert(bean, filialPadrao);
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    public Set get(String filial, String codigo) throws Exception {
        return ((LancamentoEstoqueCmcDao)this.dao).getBean(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    @Deprecated
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
    }

    public ArrayList<DadosUltimosCustos> getUltimosCustos(String filial, String material, int quantidade) throws SQLException {
        return ((LancamentoEstoqueCmcDao)this.dao).getUltimosCustos(filial, material, quantidade);
    }
}

