/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.cadastro.DadosPatrimonio;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.EstoqueManualBean;
import jalis.model.bean.estoque.EstoqueManualLanctoEstoqueBean;
import jalis.model.bean.estoque.EstoqueManualMaterialBean;
import jalis.model.bean.estoque.EstoqueManualMaterialPatrimonioBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.MaterialBean;
import jalis.model.bean.estoque.MaterialPatrimonioBean;
import jalis.model.bean.estoque.RequisicaoEstoqueBean;
import jalis.model.bean.estoque.SaldoEstoqueCelulaBean;
import jalis.model.dao.estoque.EstoqueManualDao;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.estoque.EstoqueManualVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialPatrimonioVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.estoque.RequisicaoEstoqueVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.EstoqueManualLanctoEstoqueService;
import jalis.service.estoque.EstoqueManualMaterialPatrimonioService;
import jalis.service.estoque.EstoqueManualMaterialService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialPatrimonioService;
import jalis.service.estoque.RequisicaoEstoqueService;
import jalis.service.estoque.SaldoEstoqueCelulaService;
import jalis.util.Funcoes;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Set;

public class EstoqueManualService
extends AbstractThreadService {
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private MaterialPatrimonioService materialPatrimonioService = new MaterialPatrimonioService();

    public EstoqueManualService() {
        this.dao = new EstoqueManualDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.get(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((EstoqueManualDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((EstoqueManualDao)this.dao).getVO(Variaveis.filialPadrao, codigo);
    }

    @Override
    @Deprecated
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
    }

    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, ArrayList<MaterialBean> materiais, ArrayList<DadosPatrimonio> patrimonios) throws Exception {
        String[] codigos = new String[]{filialPadrao};
        Field[] fields = bean.getClass().getDeclaredFields();
        FilialVO filialVO = null;
        Field fieldFilial = null;
        for (Field f : fields) {
            if (f.getType() != FilialVO.class) continue;
            fieldFilial = f;
            fieldFilial.setAccessible(true);
            filialVO = (FilialVO)fieldFilial.get(bean);
            break;
        }
        if (filialVO == null) {
            throw new Exception("Classe " + bean.getClass() + " n\u00e3o possui campo filial definido!");
        }
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        int valor = 1;
        if (tipo == 0) {
            valor = this.getSequenceAutoCopia(bean.getClass().getAnnotation(DataBaseTable.class).value(), codigos, bean);
        }
        for (String filial : codigos) {
            filialVO.setCodigo(Integer.parseInt(filial));
            filialVO.setDescricao("");
            if (fieldFilial == null) {
                throw new Exception("Campo filial nulo.");
            }
            fieldFilial.set(bean, filialVO);
            if (tipo != 0) continue;
            this.insert(bean, valor, filial, materiais, patrimonios);
        }
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, ArrayList<MaterialBean> listaMateriais, ArrayList<DadosPatrimonio> listaPatrimonios) throws Exception {
        RequisicaoEstoqueService reqService;
        RequisicaoEstoqueBean reqBean;
        RequisicaoEstoqueVO reqVo;
        EstoqueManualBean beanEstoque = (EstoqueManualBean)bean;
        beanEstoque.setCodigo((Integer)codigo);
        ((EstoqueManualDao)this.dao).insert(beanEstoque, filialPadrao);
        ArrayList<EstoqueManualMaterialBean> materiais = beanEstoque.getMateriais();
        if (materiais != null && materiais.size() > 0) {
            EstoqueManualMaterialService serviceMaterial = new EstoqueManualMaterialService();
            LancamentoEstoqueService serviceLancto = new LancamentoEstoqueService();
            EstoqueManualLanctoEstoqueService serviceEstoqueLancto = new EstoqueManualLanctoEstoqueService();
            for (int i = 0; i < materiais.size(); ++i) {
                EstoqueManualMaterialBean materialBean = materiais.get(i);
                materialBean.setEstoqueManual((EstoqueManualVO)beanEstoque.toVO());
                serviceMaterial.insert(materialBean, null, filialPadrao, null);
                LancamentoEstoqueBean lanctoBean = new LancamentoEstoqueBean();
                lanctoBean.setCelulaEstoque(materialBean.getCelula());
                lanctoBean.setDataConciliacao(beanEstoque.getDataHora());
                lanctoBean.setDataHora(beanEstoque.getDataHora());
                lanctoBean.setFilial(materialBean.getFilial());
                lanctoBean.setMaterial(materialBean.getMaterial());
                lanctoBean.setQuantidade(materialBean.getQuantidade());
                lanctoBean.setSituacao("O");
                lanctoBean.setTipoOrigem("M");
                lanctoBean.setUsuario(beanEstoque.getUsuario());
                lanctoBean.setUsuarioConciliacao(beanEstoque.getUsuario());
                lanctoBean.setAnaliseCritica(materialBean.getMaterial().getAnaliseCritica());
                BigDecimal valorTotal = BigDecimal.ZERO;
                if (materialBean.getValorUnitario() != null) {
                    lanctoBean.setValorUnitario(materialBean.getValorUnitario());
                    valorTotal = new BigDecimal(materialBean.getValorUnitario().toString()).setScale(4, this.ROUND).multiply(new BigDecimal(materialBean.getQuantidade().toString()).setScale(4, this.ROUND));
                    valorTotal = valorTotal.setScale(4, this.ROUND);
                    lanctoBean.setValorTotal(valorTotal.doubleValue());
                }
                if (materialBean.getTipoOperacao().equalsIgnoreCase("B") || materialBean.getTipoOperacao().equalsIgnoreCase("N")) {
                    lanctoBean.setTipo("S");
                } else if (materialBean.getTipoOperacao().equalsIgnoreCase("I")) {
                    lanctoBean.setTipo("E");
                } else {
                    SaldoEstoqueCelulaBean qtdeAtual = (SaldoEstoqueCelulaBean)new SaldoEstoqueCelulaService().getSaldoAtualEstoqueMaterialCelula(materialBean.getFilial().getCodigo().toString(), materialBean.getMaterial().getCodigo().toString(), materialBean.getCelula().getCodigo().toString());
                    double valorAtual = 0.0;
                    if (qtdeAtual != null && qtdeAtual.getSaldo() != null) {
                        valorAtual = qtdeAtual.getSaldo();
                    }
                    Double dif = valorAtual - (materialBean.getQuantidade() == null ? 0.0 : materialBean.getQuantidade());
                    lanctoBean.setQuantidade(dif < 0.0 ? dif * -1.0 : dif);
                    if (dif > 0.0) {
                        lanctoBean.setTipo("S");
                    } else {
                        lanctoBean.setTipo("E");
                    }
                }
                MaterialBean materialAux = null;
                if (listaMateriais != null) {
                    for (MaterialBean aux : listaMateriais) {
                        if (aux.getCodigo().intValue() != materialBean.getMaterial().getCodigo().intValue()) continue;
                        materialAux = aux;
                        break;
                    }
                }
                for (DadosPatrimonio patrimonio : listaPatrimonios) {
                    if (!patrimonio.isSelecionado() || patrimonio.getMaterial().getCodigo() != materialBean.getMaterial().getCodigo()) continue;
                    EstoqueManualMaterialPatrimonioBean beanEstMatPatr = new EstoqueManualMaterialPatrimonioBean();
                    FilialVO filial = new FilialVO();
                    filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                    beanEstMatPatr.setFilial(filial);
                    beanEstMatPatr.setCelulaEstoque(materialBean.getCelula());
                    beanEstMatPatr.setEstoqueManual((EstoqueManualVO)bean.toVO());
                    beanEstMatPatr.setMaterial((MaterialVO)patrimonio.getMaterial().toVO());
                    MaterialPatrimonioBean materialPatrimonioBean = new MaterialPatrimonioBean();
                    materialPatrimonioBean.setFilial(filial);
                    materialPatrimonioBean.setMaterial((MaterialVO)patrimonio.getMaterial().toVO());
                    materialPatrimonioBean.setPatrimonio(patrimonio.getPatrimonio());
                    materialPatrimonioBean.setNumeroNotaFiscal(!Funcoes.textoVazio(patrimonio.getNotaFiscal()) ? Integer.valueOf(Integer.parseInt(patrimonio.getNotaFiscal())) : null);
                    materialPatrimonioBean.setSerie(patrimonio.getSerie());
                    materialPatrimonioBean.setSetor(patrimonio.getSetor());
                    MaterialPatrimonioVO matPatrimonioVO = (MaterialPatrimonioVO)materialPatrimonioBean.toVO();
                    if (lanctoBean.getTipo().equalsIgnoreCase("E") || materialBean.getTipoOperacao().equalsIgnoreCase("I")) {
                        this.materialPatrimonioService.insert(materialPatrimonioBean, 0, filialPadrao, null);
                    }
                    beanEstMatPatr.setMaterialPatrimonio(matPatrimonioVO);
                    beanEstMatPatr.setSetor(patrimonio.getSetor());
                    new EstoqueManualMaterialPatrimonioService().insert(beanEstMatPatr, null, Variaveis.filialPadrao, null);
                }
                serviceLancto.gravaAutoCopiaSemCommit(lanctoBean, 0, filialPadrao, true, materialAux);
                EstoqueManualLanctoEstoqueBean estoqueLanctoBean = new EstoqueManualLanctoEstoqueBean();
                estoqueLanctoBean.setFilial(materialBean.getFilial());
                estoqueLanctoBean.setEstoqueManual((EstoqueManualVO)beanEstoque.toVO());
                estoqueLanctoBean.setLancamentoEstoque((LancamentoEstoqueVO)lanctoBean.toVO());
                serviceEstoqueLancto.insert(estoqueLanctoBean, null, filialPadrao, null);
            }
        }
        if ((reqVo = beanEstoque.getRequisicaoEstoque()) != null && (reqBean = (RequisicaoEstoqueBean)(reqService = new RequisicaoEstoqueService()).get(reqVo.getFilial().getCodigo().toString(), reqVo.getCodigo().toString())) != null) {
            reqBean.setSituacao("O");
            reqService.update(reqBean, null, filialPadrao, null);
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        EstoqueManualDao cfr_ignored_0 = (EstoqueManualDao)this.dao;
        return EstoqueManualDao.load(EstoqueManualBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return ((EstoqueManualDao)this.dao).loadVO(EstoqueManualVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((EstoqueManualDao)this.dao).update(bean, filialPadrao);
    }
}

