/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.Laboratorio;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.configuracao.UsuarioMensagemBean;
import jalis.model.bean.estoque.CotacaoBean;
import jalis.model.bean.estoque.CotacaoEntidadeBean;
import jalis.model.bean.estoque.CotacaoEntidadeParcelaBean;
import jalis.model.bean.estoque.CotacaoMaterialBean;
import jalis.model.bean.estoque.CotacaoMaterialEntidadeBean;
import jalis.model.dao.estoque.CotacaoDao;
import jalis.model.dao.estoque.CotacaoEntidadeDao;
import jalis.model.dao.estoque.CotacaoMaterialDao;
import jalis.model.dao.estoque.CotacaoMaterialEntidadeDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.CotacaoVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import jalis.service.configuracao.UsuarioService;
import jalis.service.estoque.CotacaoEntidadeParcelaService;
import jalis.service.estoque.CotacaoEntidadeService;
import jalis.service.estoque.CotacaoMaterialService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class CotacaoService
extends AbstractThreadService {
    public CotacaoService() {
        this.dao = new CotacaoDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((CotacaoDao)this.dao).getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((CotacaoDao)this.dao).getBean(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            Set<CotacaoMaterialEntidadeBean> matEntidades;
            Set<CotacaoMaterialBean> materiais = ((CotacaoBean)bean).getMateriaisCotacao();
            if (materiais == null || materiais.size() <= 0) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 materiais na cota\u00e7\u00e3o.", 2);
                return;
            }
            Set<CotacaoEntidadeBean> entidades = ((CotacaoBean)bean).getEntidadesCotacao();
            if (!(entidades != null && entidades.size() > 0 || ((CotacaoBean)bean).getSituacao().equalsIgnoreCase("S"))) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o h\u00e1 fornecedores na cota\u00e7\u00e3o.", 2);
                return;
            }
            ((CotacaoBean)bean).setCodigo((Integer)codigo);
            this.dao.insert(bean, filialPadrao);
            for (CotacaoMaterialBean material : materiais) {
                material.setCotacao((CotacaoVO)bean.toVO());
                new CotacaoMaterialService().insert(material, null, filialPadrao, filiais);
            }
            if (entidades != null) {
                Iterator<CotacaoEntidadeBean> itForn = entidades.iterator();
                CotacaoEntidadeParcelaService serviceParcela = new CotacaoEntidadeParcelaService();
                while (itForn.hasNext()) {
                    CotacaoEntidadeBean entidade = itForn.next();
                    entidade.setCotacao((CotacaoVO)bean.toVO());
                    new CotacaoEntidadeService().insert(entidade, null, filialPadrao, filiais);
                    serviceParcela.removeTodasParcelasCotacaoFornecedor(filialPadrao, ((CotacaoBean)bean).getCodigo().toString(), entidade.getEntidade().getCodigo().toString());
                    if (entidade.getParcelas() == null) continue;
                    ArrayList<CotacaoEntidadeParcelaBean> parcelas = entidade.getParcelas();
                    for (int i = 0; i < parcelas.size(); ++i) {
                        CotacaoEntidadeParcelaBean beanParcela = parcelas.get(i);
                        beanParcela.setFilial(((CotacaoBean)bean).getFilial());
                        beanParcela.setCotacao((CotacaoVO)((CotacaoBean)bean).toVO());
                        beanParcela.setEntidade(entidade.getEntidade());
                        serviceParcela.insert(beanParcela, null, filialPadrao, filiais);
                    }
                }
            }
            if ((matEntidades = ((CotacaoBean)bean).getMaterialEntidadeCotacao()) != null) {
                Iterator<CotacaoMaterialEntidadeBean> itMatForn = matEntidades.iterator();
                CotacaoMaterialEntidadeDao daoCotacaoMaterialEntidade = new CotacaoMaterialEntidadeDao();
                while (itMatForn.hasNext()) {
                    CotacaoMaterialEntidadeBean matEntidade = itMatForn.next();
                    if (matEntidade.getTipoDesconto() == null) {
                        matEntidade.setTipoDesconto("P");
                    } else if (matEntidade.getTipoDesconto().equalsIgnoreCase("%") || matEntidade.getTipoDesconto().equalsIgnoreCase("P")) {
                        matEntidade.setTipoDesconto("P");
                    } else {
                        matEntidade.setTipoDesconto("M");
                    }
                    matEntidade.setCotacao((CotacaoVO)((CotacaoBean)bean).toVO());
                    matEntidade.getCotacaoMaterial().setCotacao((CotacaoVO)((CotacaoBean)bean).toVO());
                    matEntidade.getCotacaoEntidade().setCotacao((CotacaoVO)((CotacaoBean)bean).toVO());
                    daoCotacaoMaterialEntidade.insert(matEntidade, filialPadrao);
                }
            }
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(CotacaoBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(CotacaoVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String[] situacao) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("usuario", "Usu\u00e1rio", 0, "", 2, 80);
        tela.adicionaCampo("dataHora", "Data", 4, "", 3, 10);
        tela.adicionaCampo("situacao", "Situa\u00e7\u00e3o", 0, "", 3, 70);
        tela.adicionaCampo("observacao", "Observa\u00e7\u00e3o", 0, "", 3, 0);
        tela.setFiltroInicial("codigo", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao);
        if (situacao.length > 0) {
            filtro.append(" and cot_situacao IN ('");
            for (int i = 0; i < situacao.length; ++i) {
                filtro.append(situacao[i]).append("'");
                if (i < situacao.length - 1) {
                    filtro.append(", '");
                    continue;
                }
                filtro.append(") ");
            }
        }
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaCotacaoDisponivelVO(Object owner, AbstractThreadVO bean, String titulo) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("usuario", "Usu\u00e1rio", 0, "", 2, 80);
        tela.adicionaCampo("dataHora", "Data/hora", 4, "", 2, 100);
        tela.adicionaCampo("situacao", "Situa\u00e7\u00e3o", 0, "", 3, 70);
        tela.adicionaCampo("observacao", "Observa\u00e7\u00e3o", 0, "", 3, 0);
        tela.setFiltroInicial("codigo", 2);
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(Variaveis.filialPadrao);
        filtro.append(" and cot_situacao = upper('").append("F").append("') ");
        filtro.append(" and (fil_codigo, cot_codigo) NOT IN (select fil_codigo, cot_codigo from pedido where cot_codigo is not null) ");
        tela.setFiltro(filtro.toString());
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setExecutarAoAbrir(false);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean != null) {
            try {
                Set<CotacaoMaterialEntidadeBean> matEntidades;
                Set<CotacaoEntidadeBean> entidades;
                CotacaoBean cotacao = (CotacaoBean)bean;
                this.dao.update(cotacao, filialPadrao);
                new CotacaoMaterialEntidadeDao().removeTodosMateriaisFornecedoresCotacao(filialPadrao, String.valueOf(((CotacaoBean)bean).getCodigo()));
                new CotacaoMaterialDao().removeTodosMateriaisCotacao(filialPadrao, String.valueOf(((CotacaoBean)bean).getCodigo()));
                new CotacaoEntidadeDao().removeTodosFornecedoresCotacao(filialPadrao, String.valueOf(((CotacaoBean)bean).getCodigo()));
                Set<CotacaoMaterialBean> materiais = cotacao.getMateriaisCotacao();
                if (materiais != null) {
                    Iterator<CotacaoMaterialBean> it = materiais.iterator();
                    CotacaoMaterialDao daoCotacaoMaterial = new CotacaoMaterialDao();
                    while (it.hasNext()) {
                        CotacaoMaterialBean material = it.next();
                        material.setCotacao((CotacaoVO)cotacao.toVO());
                        daoCotacaoMaterial.insert(material, filialPadrao);
                    }
                }
                if ((entidades = cotacao.getEntidadesCotacao()) != null) {
                    Iterator<CotacaoEntidadeBean> itForn = entidades.iterator();
                    CotacaoEntidadeDao daoCotacaoEntidade = new CotacaoEntidadeDao();
                    CotacaoEntidadeParcelaService serviceParcela = new CotacaoEntidadeParcelaService();
                    while (itForn.hasNext()) {
                        CotacaoEntidadeBean entidade = itForn.next();
                        if (entidade.getTipoDesconto() == null) {
                            entidade.setTipoDesconto("P");
                        } else if (entidade.getTipoDesconto().equalsIgnoreCase("%") || entidade.getTipoDesconto().equalsIgnoreCase("P")) {
                            entidade.setTipoDesconto("P");
                        } else {
                            entidade.setTipoDesconto("M");
                        }
                        entidade.setCotacao((CotacaoVO)cotacao.toVO());
                        daoCotacaoEntidade.insert(entidade, filialPadrao);
                        serviceParcela.removeTodasParcelasCotacaoFornecedor(filialPadrao, ((CotacaoBean)bean).getCodigo().toString(), entidade.getEntidade().getCodigo().toString());
                        if (entidade.getParcelas() == null) continue;
                        ArrayList<CotacaoEntidadeParcelaBean> parcelas = entidade.getParcelas();
                        for (int i = 0; i < parcelas.size(); ++i) {
                            CotacaoEntidadeParcelaBean beanParcela = parcelas.get(i);
                            beanParcela.setFilial(((CotacaoBean)bean).getFilial());
                            beanParcela.setCotacao((CotacaoVO)((CotacaoBean)bean).toVO());
                            beanParcela.setEntidade(entidade.getEntidade());
                            serviceParcela.insert(beanParcela, null, filialPadrao, filiais);
                        }
                    }
                }
                if ((matEntidades = cotacao.getMaterialEntidadeCotacao()) != null) {
                    Iterator<CotacaoMaterialEntidadeBean> itMatForn = matEntidades.iterator();
                    CotacaoMaterialEntidadeDao daoCotacaoMaterialEntidade = new CotacaoMaterialEntidadeDao();
                    while (itMatForn.hasNext()) {
                        CotacaoMaterialEntidadeBean matEntidade = itMatForn.next();
                        if (matEntidade.getTipoDesconto() == null) {
                            matEntidade.setTipoDesconto("P");
                        } else if (matEntidade.getTipoDesconto().equalsIgnoreCase("%") || matEntidade.getTipoDesconto().equalsIgnoreCase("P")) {
                            matEntidade.setTipoDesconto("P");
                        } else {
                            matEntidade.setTipoDesconto("M");
                        }
                        matEntidade.setCotacao((CotacaoVO)cotacao.toVO());
                        matEntidade.getCotacaoMaterial().setCotacao((CotacaoVO)cotacao.toVO());
                        matEntidade.getCotacaoEntidade().setCotacao((CotacaoVO)cotacao.toVO());
                        daoCotacaoMaterialEntidade.insert(matEntidade, filialPadrao);
                    }
                }
            }
            catch (Exception e) {
                Conexao.anulaSQL();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "CotacaoService:update");
                return;
            }
            Conexao.arquivaSQL();
        }
    }

    public void enviaMensagemResponsavel(CotacaoBean bean, boolean isEdicao) throws Exception {
        String codigoUsuario = new FilialService().getCodigoResponsavelCompras(Variaveis.filialPadrao);
        if (codigoUsuario == null || bean == null) {
            return;
        }
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO remetente = (UsuarioVO)new UsuarioService().getVO(Variaveis.filialPadrao, Variaveis.login);
        UsuarioVO destinatario = new UsuarioVO();
        destinatario.setFilial(filial);
        destinatario.setCodigo(codigoUsuario);
        UsuarioMensagemBean mensagem = new UsuarioMensagemBean();
        mensagem.setConfirmarLeitura(false);
        mensagem.setAvisada(false);
        mensagem.setDataHora(new Date());
        mensagem.setDestino(destinatario);
        mensagem.setOrigem(remetente);
        if (isEdicao) {
            mensagem.setAssunto("Solicita\u00e7\u00e3o de cota\u00e7\u00e3o - *EDI\u00c7\u00c3O* - C\u00f3d.: " + bean.getCodigo());
        } else {
            mensagem.setAssunto("Solicita\u00e7\u00e3o de cota\u00e7\u00e3o - *NOVA* - C\u00f3d.: " + bean.getCodigo());
        }
        StringBuilder buf = new StringBuilder();
        buf.append("O usu\u00e1rio \"").append(remetente.getCodigo()).append(" - ").append(remetente.getDescricao()).append("\" ");
        if (isEdicao) {
            buf.append(" editou uma ");
        } else {
            buf.append(" criou uma nova ");
        }
        buf.append("solicita\u00e7\u00e3o de cota\u00e7\u00e3o em ").append(Funcoes.formataData("dd/MM/yyyy '\u00e0s' HH:mm", bean.getDataHora())).append("h.\n");
        buf.append("\n");
        buf.append("C\u00f3digo da solicita\u00e7\u00e3o de cota\u00e7\u00e3o: ").append(bean.getCodigo());
        buf.append("\n\n");
        buf.append("Detalhamento da solicita\u00e7\u00e3o de cota\u00e7\u00e3o:\n");
        Iterator<CotacaoMaterialBean> it = bean.getMateriaisCotacao().iterator();
        while (it.hasNext()) {
            CotacaoMaterialBean aux = it.next();
            buf.append("\"").append(aux.getMaterial().getDescricao()).append("\" - ").append(Funcoes.formataDecimal(aux.getQuantidade())).append(aux.getMaterial().getUnidadeMedida() != null ? aux.getMaterial().getUnidadeMedida().getCodigo() : "");
            if (!it.hasNext()) continue;
            buf.append("\n");
        }
        mensagem.setMensagem(buf.toString());
        new UsuarioMensagemService().insert(mensagem, null, null, null);
    }
}

