/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.ConferenciaEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEstoqueLanctoEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEstoqueMaterialBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.dao.estoque.ConferenciaEstoqueDao;
import jalis.model.dao.estoque.ConferenciaEstoqueMaterialDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.estoque.ConferenciaEstoqueVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.ConferenciaEstoqueLanctoEstoqueService;
import jalis.service.estoque.LancamentoEstoqueService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;

public class ConferenciaEstoqueService
extends AbstractThreadService {
    private final int CASAS_MAIOR = 4;
    private final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();

    public ConferenciaEstoqueService() {
        this.dao = new ConferenciaEstoqueDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean == null) {
            return;
        }
        ConferenciaEstoqueBean beanConf = (ConferenciaEstoqueBean)bean;
        beanConf.setCodigo((Integer)codigo);
        this.dao.insert(beanConf, filialPadrao);
        ConferenciaEstoqueMaterialDao materialDao = new ConferenciaEstoqueMaterialDao();
        LancamentoEstoqueService serviceLancto = new LancamentoEstoqueService();
        ConferenciaEstoqueLanctoEstoqueService serviceConferenciaLancto = new ConferenciaEstoqueLanctoEstoqueService();
        for (int i = 0; i < beanConf.getMateriais().size(); ++i) {
            ConferenciaEstoqueMaterialBean material = beanConf.getMateriais().get(i);
            material.setConferenciaEstoque((ConferenciaEstoqueVO)beanConf.toVO());
            materialDao.insert(material, filialPadrao);
            LancamentoEstoqueBean lanctoBean = new LancamentoEstoqueBean();
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            lanctoBean.setFilial(filial);
            lanctoBean.setCelulaEstoque(beanConf.getCelulaEstoque());
            lanctoBean.setDataConciliacao(beanConf.getDataHora());
            lanctoBean.setDataHora(beanConf.getDataHora());
            lanctoBean.setMaterial(material.getMaterial());
            lanctoBean.setAnaliseCritica(material.getMaterial().getAnaliseCritica());
            Double qtde = material.getQuantidadeNova() - material.getQuantidadeAtual();
            if (qtde < 0.0) {
                lanctoBean.setTipo("S");
            } else {
                lanctoBean.setTipo("E");
            }
            lanctoBean.setQuantidade(qtde < 0.0 ? qtde * -1.0 : qtde);
            lanctoBean.setSituacao("O");
            lanctoBean.setTipoOrigem("O");
            lanctoBean.setUsuario(beanConf.getUsuario());
            lanctoBean.setUsuarioConciliacao(beanConf.getUsuario());
            BigDecimal valorTotal = BigDecimal.ZERO;
            if (material.getValorUnitario() != null) {
                lanctoBean.setValorUnitario(material.getValorUnitario());
                valorTotal = new BigDecimal(material.getValorUnitario().toString()).setScale(4, this.ROUND).multiply(new BigDecimal(lanctoBean.getQuantidade().toString()).setScale(4, this.ROUND));
                valorTotal = valorTotal.setScale(4, this.ROUND);
                lanctoBean.setValorTotal(valorTotal.doubleValue());
            }
            serviceLancto.gravaAutoCopiaSemCommit(lanctoBean, 0, filialPadrao, true, null);
            ConferenciaEstoqueLanctoEstoqueBean conferenciaLanctoBean = new ConferenciaEstoqueLanctoEstoqueBean();
            conferenciaLanctoBean.setConferenciaEstoque((ConferenciaEstoqueVO)beanConf.toVO());
            conferenciaLanctoBean.setFilial(material.getFilial());
            conferenciaLanctoBean.setLancamentoEstoque((LancamentoEstoqueVO)lanctoBean.toVO());
            serviceConferenciaLancto.insert(conferenciaLanctoBean, null, filialPadrao, filiais);
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }
}

