/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.estoque.ConferenciaEntradaBean;
import jalis.model.bean.estoque.ConferenciaEntradaLanctoEstoqueBean;
import jalis.model.bean.estoque.ConferenciaEntradaMaterialBean;
import jalis.model.bean.estoque.LancamentoEstoqueBean;
import jalis.model.bean.estoque.NotaFiscalMaterialBean;
import jalis.model.bean.estoque.PedidoBean;
import jalis.model.bean.estoque.PedidoMaterialBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.dao.estoque.ConferenciaEntradaDao;
import jalis.model.dao.estoque.ConferenciaEntradaMaterialDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.estoque.ConferenciaEntradaVO;
import jalis.model.vo.estoque.LancamentoEstoqueVO;
import jalis.model.vo.estoque.MaterialVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.AbstractThreadService;
import jalis.service.estoque.CelulaEstoqueService;
import jalis.service.estoque.ConferenciaEntradaLanctoEstoqueService;
import jalis.service.estoque.LancamentoEstoqueService;
import jalis.service.estoque.MaterialLoteService;
import jalis.service.estoque.MaterialService;
import jalis.service.estoque.PedidoService;
import jalis.service.financeiro.NotaFiscalService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;

public class ConferenciaEntradaService
extends AbstractThreadService {
    private static final int CASAS_MAIOR = 4;
    private static final RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private MaterialLoteService materialLoteService = new MaterialLoteService();

    public ConferenciaEntradaService() {
        this.dao = new ConferenciaEntradaDao();
    }

    public boolean estornaConferencia(ConferenciaEntradaBean bean) throws Exception {
        if (bean == null) {
            return false;
        }
        ConferenciaEntradaBean confBean = bean;
        this.dao.update(confBean, Variaveis.filialPadrao);
        LancamentoEstoqueService serviceLancto = new LancamentoEstoqueService();
        for (int i = 0; i < confBean.getMateriais().size(); ++i) {
            LancamentoEstoqueBean aux;
            ConferenciaEntradaMaterialBean material = confBean.getMateriais().get(i);
            Integer codigoNota = confBean.getNotaFiscal() != null ? confBean.getNotaFiscal().getCodigo() : 0;
            Integer codigoPedido = confBean.getPedido() != null ? confBean.getPedido().getCodigo() : 0;
            new MaterialService().alteraCodigoConf(Integer.valueOf(Variaveis.filialPadrao), material.getMaterial().getCodigo(), codigoNota, codigoPedido);
            ConferenciaEntradaLanctoEstoqueBean beanLancto = new ConferenciaEntradaLanctoEstoqueService().getConferenciaEntradaLanctoEstoque(material.getFilial().getCodigo().toString(), material.getConferenciaEntrada().getCodigo().toString(), material.getMaterial().getCodigo().toString());
            if (beanLancto == null || beanLancto.getLancamentoEstoque() == null || (aux = serviceLancto.get(beanLancto.getLancamentoEstoque().getFilial().getCodigo().toString(), beanLancto.getLancamentoEstoque().getCodigo().toString())) == null) continue;
            aux.setDataHoraCancelamento(confBean.getDataHoraCancelamento());
            aux.setUsuarioCancelamento(confBean.getUsuarioCancelamento());
            serviceLancto.gravaAutoCopiaSemCommit(aux, 1, Variaveis.filialPadrao, true, null);
            this.materialLoteService.removerLoteLancamentoEstoque(Variaveis.filialPadrao, aux.getCodigo().toString(), new Date());
        }
        return true;
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((ConferenciaEntradaDao)this.dao).getBean(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((ConferenciaEntradaDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return ((ConferenciaEntradaDao)this.dao).getVO(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((ConferenciaEntradaDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        FilialVO filial;
        if (bean == null) {
            return;
        }
        ConferenciaEntradaBean confBean = (ConferenciaEntradaBean)bean;
        confBean.setCodigo((Integer)codigo);
        this.dao.insert(confBean, filialPadrao);
        Double valorFrete = 0.0;
        ConferenciaEntradaMaterialDao daoMaterial = new ConferenciaEntradaMaterialDao();
        LancamentoEstoqueService serviceLancto = new LancamentoEstoqueService();
        ConferenciaEntradaLanctoEstoqueService serviceConferenciaLancto = new ConferenciaEntradaLanctoEstoqueService();
        if (confBean.getPedido() != null) {
            PedidoBean pedido = (PedidoBean)new PedidoService().get(confBean.getPedido().getCodigo().toString());
            valorFrete = pedido.getValorFrete();
            for (int i = 0; i < pedido.getMateriais().size(); ++i) {
                PedidoMaterialBean beanPedMat = pedido.getMateriais().get(i);
                if (beanPedMat.getEstoqueAlterado() == null || !beanPedMat.getEstoqueAlterado().booleanValue()) continue;
                FilialVO filial2 = new FilialVO();
                filial2.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(Variaveis.login);
                LancamentoEstoqueBean lanctoEstoque = new LancamentoEstoqueBean();
                lanctoEstoque.setCelulaEstoque(new CelulaEstoqueService().getCelulaPadraoVO(filialPadrao));
                lanctoEstoque.setDataConciliacao(new Date());
                lanctoEstoque.setDataHora(new Date());
                lanctoEstoque.setFilial(filial2);
                lanctoEstoque.setMaterial((MaterialVO)beanPedMat.getMaterial().toVO());
                lanctoEstoque.setQuantidade(beanPedMat.getQuantidade());
                lanctoEstoque.setSituacao("O");
                lanctoEstoque.setTipo("S");
                lanctoEstoque.setTipoOrigem("C");
                lanctoEstoque.setUsuario(usuario);
                lanctoEstoque.setUsuarioConciliacao(usuario);
                lanctoEstoque.setValorUnitario(beanPedMat.getValorUnitario());
                lanctoEstoque.setValorTotal(beanPedMat.getValorTotal());
                serviceLancto.gravaAutoCopiaSemCommit(lanctoEstoque, 0, filialPadrao, true, null);
            }
        }
        if (confBean.getNotaFiscal() != null) {
            NotaFiscalVO notaVO = confBean.getNotaFiscal();
            NotaFiscalBean nota = (NotaFiscalBean)new NotaFiscalService().get(notaVO.getFilial().getCodigo().toString(), notaVO.getCodigo().toString());
            valorFrete = nota.getValorFrete();
            for (int i = 0; i < nota.getMateriais().size(); ++i) {
                NotaFiscalMaterialBean material = nota.getMateriais().get(i);
                if (material.getEstoqueAlterado() == null || !material.getEstoqueAlterado().booleanValue()) continue;
                filial = new FilialVO();
                filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
                UsuarioVO usuario = new UsuarioVO();
                usuario.setCodigo(Variaveis.login);
                LancamentoEstoqueBean lanctoEstoque = new LancamentoEstoqueBean();
                lanctoEstoque.setCelulaEstoque(new CelulaEstoqueService().getCelulaPadraoVO(Variaveis.filialPadrao));
                lanctoEstoque.setDataConciliacao(new Date());
                lanctoEstoque.setDataHora(new Date());
                lanctoEstoque.setFilial(filial);
                lanctoEstoque.setMaterial(material.getMaterial());
                lanctoEstoque.setQuantidade(material.getQuantidade());
                lanctoEstoque.setSituacao("O");
                lanctoEstoque.setTipo("S");
                lanctoEstoque.setTipoOrigem("C");
                lanctoEstoque.setUsuario(usuario);
                lanctoEstoque.setUsuarioConciliacao(usuario);
                serviceLancto.gravaAutoCopiaSemCommit(lanctoEstoque, 0, Variaveis.filialPadrao, true, null);
            }
        }
        Double quantidade = 0.0;
        for (ConferenciaEntradaMaterialBean material : confBean.getMateriais()) {
            quantidade = quantidade + material.getQuantidadeRecebida();
        }
        for (int i = 0; i < confBean.getMateriais().size(); ++i) {
            ConferenciaEntradaMaterialBean material = confBean.getMateriais().get(i);
            material.setConferenciaEntrada((ConferenciaEntradaVO)confBean.toVO());
            daoMaterial.insert(material, String.valueOf(confBean.getFilial().getCodigo()));
            LancamentoEstoqueBean lanctoEstoqueBean = new LancamentoEstoqueBean();
            filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
            lanctoEstoqueBean.setFilial(filial);
            lanctoEstoqueBean.setCelulaEstoque(material.getCelulaEstoque());
            lanctoEstoqueBean.setDataConciliacao(confBean.getDataHora());
            lanctoEstoqueBean.setDataHora(confBean.getDataHora());
            lanctoEstoqueBean.setMaterial(material.getMaterial());
            lanctoEstoqueBean.setQuantidade(material.getQuantidadeRecebida());
            lanctoEstoqueBean.setSituacao("O");
            lanctoEstoqueBean.setTipo("E");
            lanctoEstoqueBean.setTipoOrigem("C");
            lanctoEstoqueBean.setUsuario(confBean.getUsuario());
            lanctoEstoqueBean.setUsuarioConciliacao(confBean.getUsuario());
            lanctoEstoqueBean.setValorUnitario(material.getValorUnitario());
            BigDecimal valorTotal = new BigDecimal(material.getValorUnitario().toString()).setScale(4, ROUND).multiply(new BigDecimal(material.getQuantidadeRecebida()).setScale(4, ROUND));
            valorTotal = valorTotal.setScale(4, ROUND);
            lanctoEstoqueBean.setValorTotal(valorTotal.doubleValue());
            serviceLancto.gravaAutoCopiaSemCommit(lanctoEstoqueBean, 0, filialPadrao, true, null);
            ConferenciaEntradaLanctoEstoqueBean conferenciaLanctoBean = new ConferenciaEntradaLanctoEstoqueBean();
            conferenciaLanctoBean.setConferenciaEntrada((ConferenciaEntradaVO)confBean.toVO());
            conferenciaLanctoBean.setFilial(confBean.getFilial());
            conferenciaLanctoBean.setLancamentoEstoque((LancamentoEstoqueVO)lanctoEstoqueBean.toVO());
            serviceConferenciaLancto.insert(conferenciaLanctoBean, null, filialPadrao, filiais);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("filial", filial.getCodigo().toString());
            params.put("codigoMaterial", lanctoEstoqueBean.getMaterial().getCodigo().toString());
            params.put("dataHora", confBean.getNotaFiscal() != null ? confBean.getNotaFiscal().getDataEmissao() : confBean.getDataHora());
            params.put("valoUnitario", material.getValorUnitario());
            params.put("quantidade", lanctoEstoqueBean.getQuantidade());
            params.put("codigoUltimaCompraCen", confBean.getCodigo());
            params.put("rateioFrete", valorFrete / quantidade);
            new MaterialService().atualizarDadoUltimaCompra(params);
        }
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return ((ConferenciaEntradaDao)this.dao).loadVO(ConferenciaEntradaBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return ((ConferenciaEntradaDao)this.dao).loadVO(ConferenciaEntradaVO.class, where);
    }

    @Override
    @Deprecated
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public String pesquisaVO(Object owner, AbstractThreadVO bean) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(owner, "Pesquisando Confer\u00eancias de Entrada");
        if (p != null) {
            p.setSql("select cen_codigo, cen_datahora, cen_observacao from conferenciaentrada ");
            p.removerCampos();
            p.adicionaCampo("cen_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cen_datahora", "Data Hora", 4, "", 0);
            p.adicionaCampo("cen_observacao", "Observa\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("C\u00f3digo", 0);
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and cen_datahoracancelamento IS NULL and usr_codcancelamento IS NULL ");
            p.setOrdem("cen_codigo");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Hashtable result = p.getRegistroSelecionado();
                if (result != null) {
                    return String.valueOf(result.get("cen_codigo"));
                }
                return null;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
    }

    public ConferenciaEntradaVO getConferenciaEntradaNotaFiscal(String filial, String codigoNota) throws ThreadDaoException {
        return ((ConferenciaEntradaDao)this.dao).getConferenciaEntradaNotaFiscal(filial, codigoNota);
    }
}

