/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.estoque;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.CelulaEstoque;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.estoque.CelulaEstoqueBean;
import jalis.model.dao.estoque.CelulaEstoqueDao;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.estoque.CelulaEstoqueVO;
import jalis.service.AbstractThreadService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;

public class CelulaEstoqueService
extends AbstractThreadService {
    public CelulaEstoqueService() {
        this.dao = new CelulaEstoqueDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof CelulaEstoqueBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.delete(bean, filial);
    }

    public ArrayList<CelulaEstoqueBean> getTodasCelulasFilial(String filial) throws ThreadDaoException {
        return ((CelulaEstoqueDao)this.dao).getTodasCelulasFilial(filial);
    }

    public ArrayList<CelulaEstoqueVO> getTodasCelulasFilialVO(String filial) throws ThreadDaoException {
        return ((CelulaEstoqueDao)this.dao).getTodasCelulasFilialVO(filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((CelulaEstoqueDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        StringBuilder where = new StringBuilder();
        where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        where.append("   and cel_codigo = ").append(codigo);
        Set celulas = this.loadVO(where.toString());
        if (celulas == null || celulas.size() == 0 || celulas.size() > 1) {
            return null;
        }
        return (CelulaEstoqueVO)celulas.toArray()[0];
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof CelulaEstoqueBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        ((CelulaEstoqueBean)bean).setCodigo((Integer)codigo);
        this.dao.insert(bean, filial);
    }

    @Override
    public Set load() throws Exception {
        return this.load(" where fil_codigo = " + Variaveis.filialPadrao);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(CelulaEstoqueBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(" where fil_codigo = " + Variaveis.filialPadrao);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(CelulaEstoqueVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(CelulaEstoque.getModuloAcesso(), "Cadastro de C\u00e9lulas de estoque");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("padrao", "Padr\u00e3o", 5, "", 3, 50);
        tela.adicionaCampo("inativa", "Inativa", 5, "", 3, 50);
        tela.adicionaCampo("baixarAutomatico", "Baixa Autom\u00e1tica", 5, "", 3, 100);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaCelulasAtivasVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(CelulaEstoque.getModuloAcesso(), "Cadastro de C\u00e9lulas de estoque");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("padrao", "Padr\u00e3o", 5, "", 3, 50);
        tela.adicionaCampo("baixarAutomatico", "Baixa Autom\u00e1tica", 5, "", 3, 100);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and cel_inativa = false ");
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof CelulaEstoqueBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    @Override
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
        CelulaEstoqueBean b;
        String[] codigos;
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (CelulaEstoqueService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        FilialVO filialVO = null;
        Field fieldFilial = null;
        for (Field f : fields) {
            if (f.getType() != FilialVO.class) continue;
            fieldFilial = f;
            fieldFilial.setAccessible(true);
            filialVO = (FilialVO)fieldFilial.get(bean);
            break;
        }
        if (filialVO == null) {
            throw new Exception("Classe " + bean.getClass() + " n\u00e3o possui campo filial definido!");
        }
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        int valor = 1;
        String tabela = "";
        if (tipo == 0) {
            tabela = bean.getClass().getAnnotation(DataBaseTable.class).value();
            String[] stringArray2 = codigos;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray2[i];
                int v = this.dao.ultimoValorSequence(tabela + "_" + s + "_sequence");
                if (v <= valor) continue;
                valor = v;
            }
        }
        if ((tipo == 0 || tipo == 1) && (b = (CelulaEstoqueBean)bean).getPadrao().booleanValue() && this.verificaOutraCelulaPadrao(b)) {
            this.removeCelulaPadrao(filialPadrao);
        }
        for (String filial : codigos) {
            filialVO.setCodigo(Integer.parseInt(filial));
            filialVO.setDescricao("");
            if (fieldFilial != null) {
                fieldFilial.set(bean, filialVO);
            }
            if (tipo == 0) {
                this.insert(bean, valor, filial, filiais);
                continue;
            }
            if (tipo == 1) {
                this.update(bean, valor, filial, filiais);
                continue;
            }
            if (tipo != 2) continue;
            this.delete(bean, valor, filial, filiais);
        }
    }

    public boolean verificaOutraCelulaPadrao(CelulaEstoqueBean bean) throws ThreadDaoException {
        if (bean == null) {
            return false;
        }
        return ((CelulaEstoqueDao)this.dao).haCelulaPadrao(Variaveis.filialPadrao, bean.getCodigo());
    }

    public CelulaEstoqueBean getCelulaPadrao(String filial) throws ThreadDaoException {
        return ((CelulaEstoqueDao)this.dao).getCelulaPadrao(filial);
    }

    public CelulaEstoqueVO getCelulaPadraoVO(String filial) throws ThreadDaoException {
        return (CelulaEstoqueVO)((CelulaEstoqueDao)this.dao).getCelulaPadraoVO(filial);
    }

    public CelulaEstoqueBean getCelulaPadraoEstacao(String filial) throws Exception {
        if (Funcoes.textoVazio(ParametrosLocais.getParametro("celulaEstoque"))) {
            return this.getCelulaPadrao(filial);
        }
        return (CelulaEstoqueBean)new CelulaEstoqueService().get(filial, ParametrosLocais.getParametro("celulaEstoque"));
    }

    private void removeCelulaPadrao(String filial) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        CelulaEstoqueBean bean = ((CelulaEstoqueDao)this.dao).getCelulaPadrao(filial);
        if (bean != null) {
            bean.setPadrao(false);
            this.dao.update(bean, filial);
        }
    }
}

