/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.triagem;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Geladeira;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.triagem.GeladeiraBean;
import jalis.model.bean.cadastro.triagem.GeladeiraPrateleiraBean;
import jalis.model.bean.triagem.GeladeiraTemperaturaBean;
import jalis.model.dao.cadastro.triagem.GeladeiraDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.triagem.GeladeiraVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.triagem.GeladeiraPrateleiraService;
import jalis.service.triagem.GeladeiraTemperaturaService;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class GeladeiraService
extends AbstractThreadService {
    public GeladeiraService() {
        this.dao = new GeladeiraDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof GeladeiraBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        if (!((GeladeiraDao)this.dao).podeDesativarRemoverGeladeira(filial, ((GeladeiraBean)bean).getCodigo().toString())) {
            throw new Exception("N\u00e3o \u00e9 poss\u00edvel remover a geladeira.\nH\u00e1 estantes/pacotes com tubos na mesma.");
        }
        ArrayList<GeladeiraPrateleiraBean> prateleiras = ((GeladeiraBean)bean).getPrateleiras();
        Iterator<GeladeiraPrateleiraBean> it = prateleiras.iterator();
        GeladeiraPrateleiraService prateleiraService = new GeladeiraPrateleiraService();
        while (it.hasNext()) {
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            GeladeiraPrateleiraBean gpb = it.next();
            gpb.setFilial(filialVO);
            prateleiraService.delete(gpb, 2, filial, filiais);
        }
        ArrayList temperaturas = new ArrayList(((GeladeiraBean)bean).getTemperaturas());
        it = temperaturas.iterator();
        GeladeiraTemperaturaService temperaturaService = new GeladeiraTemperaturaService();
        while (it.hasNext()) {
            GeladeiraTemperaturaBean gtb = (GeladeiraTemperaturaBean)((Object)it.next());
            gtb.setFilial(((GeladeiraBean)bean).getFilial());
            temperaturaService.delete(gtb, 2, filial, filiais);
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo, boolean carregarTemperaturas) throws Exception {
        return ((GeladeiraDao)this.dao).getBean(filial, codigo, carregarTemperaturas);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof GeladeiraBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        ((GeladeiraBean)bean).setCodigo((Integer)codigo);
        this.dao.insert(bean, filial);
        ArrayList<GeladeiraPrateleiraBean> prateleiras = ((GeladeiraBean)bean).getPrateleiras();
        Iterator<GeladeiraPrateleiraBean> it = prateleiras.iterator();
        GeladeiraPrateleiraService prateleiraService = new GeladeiraPrateleiraService();
        while (it.hasNext()) {
            GeladeiraPrateleiraBean gpb = it.next();
            gpb.setFilial(((GeladeiraBean)bean).getFilial());
            gpb.setGeladeira((GeladeiraVO)((GeladeiraBean)bean).toVO());
            if (gpb.isRemover()) {
                prateleiraService.delete(gpb, 2, filial, filiais);
                continue;
            }
            if (gpb.isInserir()) {
                prateleiraService.insert(gpb, 0, filial, filiais);
                continue;
            }
            if (!gpb.isAlterar()) continue;
            prateleiraService.update(gpb, 1, filial, filiais);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof GeladeiraBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        if (((GeladeiraBean)bean).getInativa().booleanValue() && !((GeladeiraDao)this.dao).podeDesativarRemoverGeladeira(filial, ((GeladeiraBean)bean).getCodigo().toString())) {
            throw new Exception("N\u00e3o \u00e9 poss\u00edvel desativar a geladeira.\nH\u00e1 estantes/pacotes com tubos na mesma.");
        }
        this.dao.update(bean, filial);
        ArrayList<GeladeiraPrateleiraBean> prateleiras = ((GeladeiraBean)bean).getPrateleiras();
        Iterator<GeladeiraPrateleiraBean> it = prateleiras.iterator();
        GeladeiraPrateleiraService prateleiraService = new GeladeiraPrateleiraService();
        while (it.hasNext()) {
            GeladeiraPrateleiraBean gpb = it.next();
            gpb.setFilial(((GeladeiraBean)bean).getFilial());
            gpb.setGeladeira((GeladeiraVO)((GeladeiraBean)bean).toVO());
            if (gpb.isRemover()) {
                prateleiraService.delete(gpb, 2, filial, filiais);
                continue;
            }
            if (gpb.isInserir()) {
                prateleiraService.insert(gpb, 0, filial, filiais);
                continue;
            }
            if (!gpb.isAlterar()) continue;
            prateleiraService.update(gpb, 1, filial, filiais);
        }
        Set temperaturas = ((GeladeiraBean)bean).getTemperaturas();
        it = temperaturas.iterator();
        GeladeiraTemperaturaService temperaturaService = new GeladeiraTemperaturaService();
        while (it.hasNext()) {
            GeladeiraTemperaturaBean gtb = (GeladeiraTemperaturaBean)((Object)it.next());
            gtb.setFilial(((GeladeiraBean)bean).getFilial());
            gtb.setGeladeira((GeladeiraVO)((GeladeiraBean)bean).toVO());
            if (gtb.isRemover()) {
                temperaturaService.gravaAutoCopiaSemCommit(gtb, 2, filial, filiais);
                continue;
            }
            if (gtb.isInserir()) {
                temperaturaService.gravaAutoCopiaSemCommit(gtb, 0, filial, filiais);
                continue;
            }
            if (!gtb.isAlterar()) continue;
            temperaturaService.gravaAutoCopiaSemCommit(gtb, 1, filial, filiais);
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        Statement st = Conexao.getStatement();
        Set s = AbstractThreadDao.load(GeladeiraBean.class, where);
        Conexao.fecharStatement(st);
        return s;
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        Statement st = Conexao.getStatement();
        Set s = this.dao.loadVO(GeladeiraVO.class, where);
        Conexao.fecharStatement(st);
        return s;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((GeladeiraDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Geladeira.getModuloAcesso(), "Cadastro de Geladeiras");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("inativa", "Inativa?", 5, "", 3, 50);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaAtivasVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Geladeira.getModuloAcesso(), "Cadastro de Geladeiras");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao + " and gel_inativa = false ");
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public void loadTemperaturas(GeladeiraBean bean) throws Exception {
        ((GeladeiraDao)this.dao).loadTemperaturas(bean);
    }

    public void loadPrateleiras(GeladeiraBean bean) throws Exception {
        ((GeladeiraDao)this.dao).loadPrateleiras(bean);
    }
}

