/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.triagem;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Estante;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.triagem.EstanteBean;
import jalis.model.dao.cadastro.triagem.EstanteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.triagem.EstanteVO;
import jalis.service.AbstractThreadService;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class EstanteService
extends AbstractThreadService {
    public EstanteService() {
        this.dao = new EstanteDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EstanteBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        if (!((EstanteDao)this.dao).podeAlterarRemoverEstante(filial, ((EstanteBean)bean).getCodigo().toString())) {
            throw new Exception("N\u00e3o foi poss\u00edvel excluir a estante/pacote.\nH\u00e1 tubos na mesma.");
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((EstanteDao)this.dao).getBean(filial, codigo);
    }

    public AbstractThreadBean getIncluirDescartadas(String filial, String codigo) throws Exception {
        return ((EstanteDao)this.dao).getBeanIncluirDescartadas(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((EstanteDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EstanteBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        try {
            ((EstanteBean)bean).setCodigo((Integer)codigo);
            this.dao.insert(bean, filial);
        }
        catch (ThreadDaoException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(EstanteBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(EstanteVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Estante.getModuloAcesso(), "Cadastro de Estantes");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("identificador", "Identificador", 0, "", 2, 0);
        tela.setFiltroInicial("Identificador", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and ett_datadescarte is null ");
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, List<String> filtros) {
        filtros.add("fil_codigo = " + Variaveis.filialPadrao);
        filtros.add("ett_datadescarte is null");
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Estante.getModuloAcesso(), "Cadastro de Estantes");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("identificador", "Identificador", 0, "", 2, 0);
        tela.setFiltroInicial("Identificador", 2);
        tela.setFiltro(StringUtil.implode(filtros, " and "));
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EstanteBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    public boolean podeAlterarRemoverEstante(String filial, String codigoEstante) throws SQLException {
        return ((EstanteDao)this.dao).podeAlterarRemoverEstante(filial, codigoEstante);
    }

    public void descartarEstante(EstanteBean estante, String filial, String identificador) throws Exception {
        estante.setDataDescarte(new Date());
        this.dao.update(estante, filial);
        ((EstanteDao)this.dao).descartarEstante(filial, estante.getCodigo().toString());
        if (estante.getReutilizar().booleanValue()) {
            this.reutilizarEstante(estante, filial, identificador);
        }
    }

    public void reutilizarEstante(EstanteBean estante, String filial, String identificador) throws Exception {
        if (estante == null) {
            return;
        }
        EstanteBean novaEstante = new EstanteBean();
        novaEstante.setFilial(estante.getFilial());
        novaEstante.setIdentificador(identificador);
        novaEstante.setPacote(estante.isPacote());
        novaEstante.setReutilizar(estante.getReutilizar());
        novaEstante.setLinhas(estante.getLinhas());
        novaEstante.setColunas(estante.getColunas());
        this.gravaAutoCopiaSemCommit(novaEstante, 0, filial, null);
    }
}

