/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.triagem;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.BanhoMaria;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.triagem.BanhoMariaBean;
import jalis.model.bean.triagem.BanhoMariaTemperaturaBean;
import jalis.model.dao.cadastro.triagem.BanhoMariaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.triagem.BanhoMariaVO;
import jalis.service.AbstractThreadService;
import jalis.service.triagem.BanhoMariaTemperaturaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BanhoMariaService
extends AbstractThreadService {
    public BanhoMariaService() {
        this.dao = new BanhoMariaDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean == null) {
            throw new Exception("Bean NULL.");
        }
        if (!(bean instanceof BanhoMariaBean)) {
            throw new Exception("Tipo incorreto.");
        }
        ((BanhoMariaBean)bean).setCodigo((Integer)codigo);
        this.dao.insert(bean, filialPadrao);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof BanhoMariaBean)) {
            throw new Exception("Tipo incorreto.");
        }
        this.dao.update(bean, filialPadrao);
        Set temperaturas = ((BanhoMariaBean)bean).getTemperaturas();
        Iterator it = temperaturas.iterator();
        BanhoMariaTemperaturaService temperaturaService = new BanhoMariaTemperaturaService();
        while (it.hasNext()) {
            BanhoMariaTemperaturaBean banhoMariaTemp = (BanhoMariaTemperaturaBean)it.next();
            banhoMariaTemp.setFilial(((BanhoMariaBean)bean).getFilial());
            banhoMariaTemp.setBanhoMaria((BanhoMariaVO)((BanhoMariaBean)bean).toVO());
            if (banhoMariaTemp.isRemover()) {
                temperaturaService.gravaAutoCopiaSemCommit(banhoMariaTemp, 2, filialPadrao, filiais);
                continue;
            }
            if (banhoMariaTemp.isInserir()) {
                temperaturaService.gravaAutoCopiaSemCommit(banhoMariaTemp, 0, filialPadrao, filiais);
                continue;
            }
            if (!banhoMariaTemp.isAlterar()) continue;
            temperaturaService.gravaAutoCopiaSemCommit(banhoMariaTemp, 1, filialPadrao, filiais);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof BanhoMariaBean)) {
            throw new Exception("Tipo incorreto.");
        }
        ArrayList temperaturas = new ArrayList(((BanhoMariaBean)bean).getTemperaturas());
        Iterator it = temperaturas.iterator();
        BanhoMariaTemperaturaService temperaturaService = new BanhoMariaTemperaturaService();
        while (it.hasNext()) {
            BanhoMariaTemperaturaBean gtb = (BanhoMariaTemperaturaBean)it.next();
            gtb.setFilial(((BanhoMariaBean)bean).getFilial());
            temperaturaService.delete(gtb, 2, filialPadrao, filiais);
        }
        this.dao.delete(bean, filialPadrao);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return ((BanhoMariaDao)this.dao).getBean(codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return ((BanhoMariaDao)this.dao).getVO(codigo);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(BanhoMariaBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return AbstractThreadDao.load(BanhoMariaVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(BanhoMaria.getModuloAcesso(), "Cadastro de Banho-Maria");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 0);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setService(this);
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaAtivosVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(BanhoMaria.getModuloAcesso(), "Cadastro de Banho-Maria");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 0);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and not ban_inativo ");
        tela.setService(this);
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves, boolean carregarTemperaturas) throws ThreadDaoException {
        return ((BanhoMariaDao)this.dao).getBean(chaves, carregarTemperaturas);
    }

    public AbstractThreadBean getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((BanhoMariaDao)this.dao).getVO(chaves);
    }
}

