/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.financeiro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Servico;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.cadastro.financeiro.ServicoImpostoBean;
import jalis.model.dao.cadastro.financeiro.ServicoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.financeiro.ServicoImpostoService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ServicoService
extends AbstractThreadService {
    public ServicoService() {
        this.dao = new ServicoDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof ServicoBean)) {
            throw new Exception("Tipo inv\u00e1lido");
        }
        if (!this.podeExcluir(filial, String.valueOf(((ServicoBean)bean).getCodigo()))) {
            throw new Exception("O servi\u00e7o j\u00e1 foi utilizado e n\u00e3o pode ser exclu\u00eddo.");
        }
        this.removerImpostos((ServicoBean)bean, filial, filiais);
        this.dao.delete(bean, filial);
    }

    private void removerImpostos(ServicoBean servico, String filial, String filiais) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fil_codigo", servico.getFilial().getCodigo());
        map.put("svc_codigo", servico.getCodigo());
        ArrayList<ServicoImpostoBean> impostos = new ServicoImpostoService().getImpostosServico(map);
        if (impostos != null) {
            ServicoImpostoService impostoService = new ServicoImpostoService();
            for (int i = 0; i < impostos.size(); ++i) {
                ServicoImpostoBean aux = impostos.get(i);
                aux.setServico((ServicoVO)servico.toVO());
                impostoService.gravaAutoCopiaSemCommit(aux, 2, filial, filiais);
            }
        }
    }

    private boolean podeExcluir(String filial, String codigo) throws SQLException {
        return ((ServicoDao)this.dao).podeExcluir(filial, codigo);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof ServicoBean)) {
            throw new Exception("Tipo inv\u00e1lido");
        }
        ((ServicoBean)bean).setCodigo((Integer)codigo);
        this.dao.insert(bean, filial);
        ArrayList<ServicoImpostoBean> impostos = ((ServicoBean)bean).getImpostos();
        if (impostos != null) {
            ServicoImpostoService impostoService = new ServicoImpostoService();
            for (int i = 0; i < impostos.size(); ++i) {
                impostos.get(i).setServico((ServicoVO)bean.toVO());
                impostoService.insert(impostos.get(i), 0, filial, filiais);
            }
        }
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        ServicoDao cfr_ignored_0 = (ServicoDao)this.dao;
        return ServicoDao.load(ServicoBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO(String where) throws Exception {
        ServicoDao cfr_ignored_0 = (ServicoDao)this.dao;
        return ServicoDao.load(ServicoVO.class, where);
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ServicoDao)this.dao).getBean(chaves);
    }

    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ServicoDao)this.dao).getVO(chaves);
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof ServicoBean)) {
            throw new Exception("Tipo inv\u00e1lido");
        }
        this.removerImpostos((ServicoBean)bean, filial, filiais);
        ArrayList<ServicoImpostoBean> impostos = ((ServicoBean)bean).getImpostos();
        if (impostos != null) {
            ServicoImpostoService impostoService = new ServicoImpostoService();
            for (int i = 0; i < impostos.size(); ++i) {
                impostos.get(i).setServico((ServicoVO)bean.toVO());
                impostoService.insert(impostos.get(i), codigo, filial, filiais);
            }
        }
        this.dao.update(bean, filial);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Servico.getModuloAcesso(), "Cadastro de Servi\u00e7os");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String filial, String tipoServico) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Servico.getModuloAcesso(), "Cadastro de Servi\u00e7os");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        StringBuilder filtro = new StringBuilder();
        filtro.append("fil_codigo = ").append(filial);
        filtro.append(" and svc_tipo in ('A','").append(tipoServico).append("')");
        tela.setFiltro(filtro.toString());
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }
}

