/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.financeiro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Series;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.SeriesBean;
import jalis.model.dao.cadastro.financeiro.SeriesDao;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.service.AbstractThreadService;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;

public class SeriesService
extends AbstractThreadService {
    public SeriesService() {
        this.dao = new SeriesDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof SeriesBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((SeriesDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((SeriesDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof SeriesBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.insert(bean, filial);
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(SeriesBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return ((SeriesDao)this.dao).loadVO(where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, "Pesquisando s\u00e9ries", bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Series.getModuloAcesso(), "Cadastro de S\u00e9ries");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 0, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String filial) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, "Pesquisando s\u00e9ries", bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Series.getModuloAcesso(), "Cadastro de S\u00e9ries");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 0, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + filial);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof SeriesBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    @Override
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (SeriesService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        FilialVO filialVO = null;
        Field fieldFilial = null;
        for (Field f : fields) {
            if (f.getType() != FilialVO.class) continue;
            fieldFilial = f;
            fieldFilial.setAccessible(true);
            filialVO = (FilialVO)fieldFilial.get(bean);
            break;
        }
        if (filialVO == null) {
            throw new Exception("Classe " + bean.getClass() + " n\u00e3o possui campo filial definido!");
        }
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        SeriesBean sb = (SeriesBean)bean;
        String valor = sb.getCodigo();
        for (String s : codigos) {
            filialVO.setCodigo(Integer.parseInt(s));
            filialVO.setDescricao("");
            if (fieldFilial == null) {
                throw new Exception("Campo filial nulo.");
            }
            fieldFilial.set(bean, filialVO);
            if (tipo == 0) {
                this.insert(bean, valor, s, filiais);
                continue;
            }
            if (tipo == 1) {
                this.update(bean, valor, s, filiais);
                continue;
            }
            if (tipo != 2) continue;
            this.delete(bean, valor, s, filiais);
        }
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean podeGerarNotaFiscalEletronica(Integer codigoFilial, String codigoSerie) {
        boolean campoExiste = SeriesService.getExisteCampoRelacionarNfse();
        if (campoExiste) {
            boolean bl;
            Statement st;
            block6: {
                st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder();
                buf.append(" select COALESCE(ser_relacionarnfse, false) as gerarManual ");
                buf.append("   from series ");
                buf.append("  where fil_codigo = ").append(codigoFilial);
                buf.append("    and ser_codigo = ").append(StringUtil.textoDBEscape(codigoSerie));
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block6;
                boolean bl2 = !rs.getBoolean("gerarManual");
                Conexao.fecharStatement(st);
                return bl2;
            }
            try {
                bl = false;
            }
            catch (Exception e) {
                boolean bl3;
                try {
                    bl3 = false;
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                return bl3;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getExisteCampoRelacionarNfse() {
        boolean bl;
        Statement st;
        block5: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select column_name ");
            buf.append("   from information_schema.columns ");
            buf.append("  where table_name = 'series' ");
            buf.append("    and upper(column_name) = 'SER_RELACIONARNFSE' ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (!rs.next()) break block5;
            boolean bl2 = true;
            Conexao.fecharStatement(st);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                bl3 = false;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl3;
        }
        Conexao.fecharStatement(st);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void atualizaRelacionarNfseSemCommit(String[] codigosFiliais, String filialPadrao, String codigoSerie, boolean isRelacionarNfse) throws Exception {
        if (!SeriesService.getExisteCampoRelacionarNfse()) {
            return;
        }
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" update series ");
            buf.append("    set ser_relacionarnfse = '").append(isRelacionarNfse ? "true" : "false").append("' ");
            buf.append("  where fil_codigo IN (").append(StringUtil.implode(codigosFiliais, ", ")).append(") ");
            buf.append("    and ser_codigo = ").append(StringUtil.textoDBEscape(codigoSerie));
            Conexao.executeUpdate(filialPadrao, st, buf.toString());
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
    }
}

