/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.financeiro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.financeiro.lancamentos.cadastro.PlanoContas;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.CentroCustoPlanoContaBean;
import jalis.model.bean.cadastro.financeiro.PlanoContaBean;
import jalis.model.dao.cadastro.financeiro.PlanoContaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.financeiro.CentroCustoPlanoContaService;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Set;

public class PlanoContaService
extends AbstractThreadService {
    public PlanoContaService() {
        this.dao = new PlanoContaDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof PlanoContaBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        Set centros = ((PlanoContaBean)bean).getCentrosCusto();
        Iterator it = centros.iterator();
        CentroCustoPlanoContaService centroService = new CentroCustoPlanoContaService();
        while (it.hasNext()) {
            CentroCustoPlanoContaBean centro = (CentroCustoPlanoContaBean)it.next();
            centroService.delete(centro, 2, filial, filiais);
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((PlanoContaDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((PlanoContaDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof PlanoContaBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        try {
            ((PlanoContaBean)bean).setReduzido((Integer)codigo);
            this.dao.insert(bean, filial);
            Set centros = ((PlanoContaBean)bean).getCentrosCusto();
            Iterator it = centros.iterator();
            CentroCustoPlanoContaService centroService = new CentroCustoPlanoContaService();
            while (it.hasNext()) {
                CentroCustoPlanoContaBean centro = (CentroCustoPlanoContaBean)it.next();
                centro.setPlanoConta((PlanoContaVO)((PlanoContaBean)bean).toVO());
                centro.setFilial(((PlanoContaBean)bean).getFilial());
                if (centro.isRemover()) {
                    centroService.delete(centro, 2, filial, filiais);
                    continue;
                }
                if (centro.isInserir()) {
                    centroService.insert(centro, 0, filial, filiais);
                    continue;
                }
                if (!centro.isAlterar()) continue;
                centroService.update(centro, 1, filial, filiais);
            }
        }
        catch (ThreadDaoException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(PlanoContaBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(PlanoContaVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(PlanoContas.getModuloAcesso(), "Cadastro de Planos de Contas");
        }
        tela.adicionaCampo("reduzido", "Reduzido", 1, "", 3, 75);
        tela.adicionaCampo("conta", "Conta", 0, "", 3, 120);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setColunaOrdenacao("Conta");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String filial) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(PlanoContas.getModuloAcesso(), "Cadastro de Planos de Contas");
        }
        tela.adicionaCampo("reduzido", "Reduzido", 1, "", 3, 75);
        tela.adicionaCampo("conta", "Conta", 0, "", 3, 120);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + filial);
        tela.setColunaOrdenacao("Conta");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof PlanoContaBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
        Set centros = ((PlanoContaBean)bean).getCentrosCusto();
        Iterator it = centros.iterator();
        CentroCustoPlanoContaService centroService = new CentroCustoPlanoContaService();
        while (it.hasNext()) {
            CentroCustoPlanoContaBean centro = (CentroCustoPlanoContaBean)it.next();
            centro.setPlanoConta((PlanoContaVO)((PlanoContaBean)bean).toVO());
            centro.setFilial(((PlanoContaBean)bean).getFilial());
            if (centro.isRemover()) {
                centroService.delete(centro, 2, filial, filiais);
                continue;
            }
            if (centro.isInserir()) {
                centroService.insert(centro, 0, filial, filiais);
                continue;
            }
            if (!centro.isAlterar()) continue;
            centroService.update(centro, 1, filial, filiais);
        }
        PlanoContaBean pc = (PlanoContaBean)bean;
        int sP = pc.getConta().split("\\.").length;
        if (sP == 1) {
            ((PlanoContaDao)this.dao).updateTipoContasFilhas(Integer.toString(pc.getFilial().getCodigo()), pc.getConta(), pc.getTipo());
        }
    }

    public PlanoContaVO getMaiorConta(String contaPai, String tamanhoNivel) throws Exception {
        return ((PlanoContaDao)this.dao).getMaiorConta(contaPai, tamanhoNivel);
    }

    public boolean contaExiste(String conta) throws Exception {
        return ((PlanoContaDao)this.dao).contaExiste(conta);
    }

    public boolean contaExisteFilhos(String contaPai) throws Exception {
        return ((PlanoContaDao)this.dao).contaExisteFilhos(contaPai);
    }

    public boolean haPlanosContas(String codigoFilial) throws SQLException {
        return ((PlanoContaDao)this.dao).haPlanosContas(codigoFilial);
    }
}

