/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.financeiro;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Origem;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.OrigemBean;
import jalis.model.dao.cadastro.financeiro.OrigemDao;
import jalis.model.utils.DataBaseTable;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.OrigemVO;
import jalis.service.AbstractThreadService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;

public class OrigemService
extends AbstractThreadService {
    public OrigemService() {
        this.dao = new OrigemDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof OrigemBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((OrigemDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((OrigemDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof OrigemBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        try {
            this.dao.insert(bean, filial);
        }
        catch (ThreadDaoException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(" where fil_codigo = " + Variaveis.filialPadrao);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(OrigemBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append(" order by ");
        if (ParametrosLocais.getParametro("origemFinanceira") != null) {
            buf.append(" opc_codigo != '").append(ParametrosLocais.getParametro("origemFinanceira")).append("', ");
        }
        buf.append(" not opc_padrao, opc_codigo ");
        return this.loadVO(buf.toString());
    }

    public Set loadVOTransferencia(String filialDestino) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append(" where fil_codigo = ").append(filialDestino);
        buf.append(" order by ");
        if (ParametrosLocais.getParametro("origemFinanceira") != null) {
            buf.append(" opc_codigo != '").append(ParametrosLocais.getParametro("origemFinanceira")).append("', ");
        }
        buf.append(" not opc_padrao, opc_codigo ");
        return this.loadVO(buf.toString());
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return ((OrigemDao)this.dao).loadVO(where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Origem.getModuloAcesso(), "Cadastro de Origens");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("padrao", "Padr\u00e3o", 5, "", 3, 50);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String codigoOrigemRemover) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Origem.getModuloAcesso(), "Cadastro de Origens");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("padrao", "Padr\u00e3o", 5, "", 3, 50);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        String filtro = "fil_codigo = " + Variaveis.filialPadrao;
        if (!Funcoes.textoVazio(codigoOrigemRemover)) {
            filtro = filtro + " and not opc_codigo = '" + codigoOrigemRemover + "' ";
        }
        tela.setFiltro(filtro);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof OrigemBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    @Override
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (OrigemService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        Field[] fields = bean.getClass().getDeclaredFields();
        FilialVO filialVO = null;
        Field fieldFilial = null;
        for (Field f : fields) {
            if (f.getType() != FilialVO.class) continue;
            fieldFilial = f;
            fieldFilial.setAccessible(true);
            filialVO = (FilialVO)fieldFilial.get(bean);
            break;
        }
        if (filialVO == null) {
            throw new Exception("Classe " + bean.getClass() + " n\u00e3o possui campo filial definido!");
        }
        if (!bean.getClass().isAnnotationPresent(DataBaseTable.class)) {
            throw new ThreadDaoException("Tabela n\u00e3o definida para a classe: " + bean.getClass());
        }
        OrigemBean sb = (OrigemBean)bean;
        String valor = sb.getCodigo();
        if ((tipo == 0 || tipo == 1) && sb.getPadrao().booleanValue() && this.verificaOutraOrigemPadrao(sb)) {
            this.removeOrigemPadrao(filialPadrao);
        }
        for (String s : codigos) {
            filialVO.setCodigo(Integer.parseInt(s));
            filialVO.setDescricao("");
            if (fieldFilial != null) {
                fieldFilial.set(bean, filialVO);
            }
            if (tipo == 0) {
                this.insert(bean, valor, s, filiais);
                continue;
            }
            if (tipo == 1) {
                this.update(bean, valor, s, filiais);
                continue;
            }
            if (tipo != 2) continue;
            this.delete(bean, valor, s, filiais);
        }
    }

    public boolean verificaOutraOrigemPadrao(OrigemBean bean) {
        Set beans = ((OrigemDao)this.dao).getOrigemPadrao(bean.getFilial().getCodigo().toString(), bean.getCodigo());
        return beans != null && beans.size() > 0;
    }

    private void removeOrigemPadrao(String filial) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        Iterator it;
        Set bean = ((OrigemDao)this.dao).getOrigemPadrao(filial);
        if (bean != null && bean.size() > 0 && (it = bean.iterator()).hasNext()) {
            OrigemBean origem = (OrigemBean)it.next();
            origem.setPadrao(false);
            this.dao.update(origem, filial);
        }
    }

    public OrigemVO getOrigemPadraoEstacao(FilialVO filial) throws Exception {
        String origem = ParametrosLocais.getParametro("origemFinanceira");
        if (Funcoes.textoVazio(origem)) {
            return this.getOrigemPadrao(filial);
        }
        OrigemVO aux = (OrigemVO)this.getVO(Integer.toString(filial.getCodigo()), origem);
        if (aux == null) {
            return this.getOrigemPadrao(filial);
        }
        return aux;
    }

    private OrigemVO getOrigemPadrao(FilialVO filial) throws ThreadDaoException {
        return (OrigemVO)((OrigemDao)this.dao).getOrigemPadrao(filial);
    }
}

