/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.financeiro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.FormaPagamento;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.FormaPagamentoBean;
import jalis.model.bean.cadastro.financeiro.FormaPagamentoParcelaBean;
import jalis.model.dao.cadastro.financeiro.FormaPagamentoDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.util.ArraysUtil;
import jalis.util.StringUtil;
import java.util.Iterator;
import java.util.Set;

public class FormaPagamentoService
extends AbstractThreadService {
    public FormaPagamentoService() {
        this.dao = new FormaPagamentoDao();
    }

    @Override
    public void gravaAutoCopiaSemCommit(AbstractThreadBean bean, int tipo, String filialPadrao, String filiais) throws Exception {
        if (tipo == 1 || tipo == 2) {
            this.removeTodasParcelas(bean, Variaveis.filialPadrao, filiais);
        }
        super.gravaAutoCopiaSemCommit(bean, tipo, filialPadrao, filiais);
    }

    public void removeTodasParcelas(AbstractThreadBean bean, String filialPadrao, String filiais) throws Exception {
        String[] codigos;
        String[] stringArray = codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        if (codigos == null || codigos.length == 0) {
            codigos = new String[]{filialPadrao};
        } else if (FormaPagamentoService.localizaFilialCopia(codigos, filialPadrao) < 0) {
            codigos = ArraysUtil.concatenar(codigos, new String[]{filialPadrao});
        }
        if (!(bean instanceof FormaPagamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        new FormaPagamentoDao().removeTodasParcelas(bean, codigos);
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof FormaPagamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        Set parcelas = ((FormaPagamentoBean)bean).getParcelas();
        Iterator it = parcelas.iterator();
        FormaPagamentoParcelaService parcelaService = new FormaPagamentoParcelaService();
        while (it.hasNext()) {
            FormaPagamentoParcelaBean parcela = (FormaPagamentoParcelaBean)it.next();
            parcelaService.delete(parcela, 2, filial, filiais);
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof FormaPagamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        ((FormaPagamentoBean)bean).setCodigo((Integer)codigo);
        this.dao.insert(bean, filial);
        Set parcelas = ((FormaPagamentoBean)bean).getParcelas();
        Iterator it = parcelas.iterator();
        FormaPagamentoParcelaService parcelaService = new FormaPagamentoParcelaService();
        while (it.hasNext()) {
            FormaPagamentoParcelaBean parcela = (FormaPagamentoParcelaBean)it.next();
            parcela.setFormaPagamento((FormaPagamentoVO)((FormaPagamentoBean)bean).toVO());
            parcela.setFilialVO(((FormaPagamentoBean)bean).getFilial());
            if (parcela.isRemover()) {
                parcelaService.delete(parcela, 2, filial, filiais);
                continue;
            }
            if (parcela.isInserir()) {
                parcelaService.insert(parcela, 0, filial, filiais);
                continue;
            }
            if (!parcela.isAlterar()) continue;
            parcelaService.update(parcela, 1, filial, filiais);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof FormaPagamentoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(filial));
        Set parcelas = ((FormaPagamentoBean)bean).getParcelas();
        Iterator it = parcelas.iterator();
        FormaPagamentoParcelaService parcelaService = new FormaPagamentoParcelaService();
        while (it.hasNext()) {
            FormaPagamentoParcelaBean parcela = (FormaPagamentoParcelaBean)it.next();
            parcela.setFormaPagamento((FormaPagamentoVO)((FormaPagamentoBean)bean).toVO());
            parcela.setFilialVO(filialVO);
            if (parcela.isRemover()) {
                parcelaService.delete(parcela, 2, filial, filiais);
                continue;
            }
            if (parcela.isInserir()) {
                parcelaService.insert(parcela, 0, filial, filiais);
                continue;
            }
            if (!parcela.isAlterar()) continue;
            parcelaService.update(parcela, 1, filial, filiais);
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(FormaPagamentoBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(FormaPagamentoVO.class, where);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((FormaPagamentoDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.getVO(Variaveis.filialPadrao, codigo);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(FormaPagamento.getModuloAcesso(), "Cadastro de Formas de Pagamento");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String filial) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(FormaPagamento.getModuloAcesso(), "Cadastro de Formas de Pagamento");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + filial);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }
}

