/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.financeiro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.financeiro.contas.Conta;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.service.AbstractThreadService;
import java.util.ArrayList;
import java.util.Set;

public class ContaCorrenteService
extends AbstractThreadService {
    public ContaCorrenteService() {
        this.dao = new ContaCorrenteDao();
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.get(Variaveis.filialPadrao, codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((ContaCorrenteDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((ContaCorrenteDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    @Deprecated
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ContaCorrenteBean.class, where);
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ContaCorrenteVO.class, where);
    }

    public ArrayList<ContaCorrenteVO> getContasAtivas(String filial) throws ThreadDaoException {
        return ((ContaCorrenteDao)this.dao).getContasAtivas(filial);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.setTelaCadastro(Conta.getModuloAcesso(), "Cadastro de Contas Correntes");
        tela.adicionaCampo("reduzido", "Reduzido", 1, "", 3, 75);
        tela.adicionaCampo("conta", "Conta", 0, "", 2, 0);
        tela.setFiltroInicial("Conta", 2);
        tela.setColunaOrdenacao("Conta");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVOTransferencia(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String filialDestino) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Conta.getModuloAcesso(), "Cadastro de Contas Correntes");
        }
        tela.adicionaCampo("reduzido", "Reduzido", 1, "", 3, 75);
        tela.adicionaCampo("conta", "Conta", 0, "", 2, 0);
        tela.setFiltroInicial("Conta", 2);
        tela.setColunaOrdenacao("Conta");
        tela.setFiltro("fil_codigo = " + filialDestino);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public HistoricoPadraoVO getHistoricoPadrao(ContaCorrenteVO contaCorrente) throws Exception {
        ContaCorrenteBean bean;
        if (contaCorrente != null && contaCorrente.getFilial() != null && contaCorrente.getReduzido() != null && (bean = (ContaCorrenteBean)this.get(contaCorrente.getFilial().getCodigo().toString(), contaCorrente.getReduzido().toString())) != null) {
            return bean.getHistoricoPadrao();
        }
        return null;
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.delete(bean, filialPadrao);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        ((ContaCorrenteBean)bean).setReduzido((Integer)codigo);
        this.dao.insert(bean, filialPadrao);
        ContaCorrenteBean b = (ContaCorrenteBean)bean;
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.update(bean, filialPadrao);
    }
}

