/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.financeiro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.CentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.financeiro.CentroCustoBean;
import jalis.model.dao.cadastro.financeiro.CentroCustoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.financeiro.CentroCustoVO;
import jalis.service.AbstractThreadService;
import java.sql.SQLException;
import java.util.Set;

public class CentroCustoService
extends AbstractThreadService {
    public CentroCustoService() {
        this.dao = new CentroCustoDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof CentroCustoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((CentroCustoDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadBean getVO(String filial, String codigo) throws Exception {
        return ((CentroCustoDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiai) throws Exception {
        if (!(bean instanceof CentroCustoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        try {
            if (Integer.parseInt(codigo.toString()) <= 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel gerar o c\u00f3digo para a tabela Centro de Custo");
            }
            ((CentroCustoBean)bean).setReduzido(Integer.parseInt(codigo.toString()));
            this.dao.insert(bean, filial);
        }
        catch (ThreadDaoException e) {
            throw new Exception(e.getMessage());
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(CentroCustoBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(CentroCustoVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(CentroCusto.getModuloAcesso(), "Cadastro de Centros de Custo");
        }
        tela.adicionaCampo("reduzido", "Reduzido", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("conta", "Conta", 0, "", 3, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setColunaOrdenacao("Conta");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String filial) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(CentroCusto.getModuloAcesso(), "Cadastro de Centros de Custo");
        }
        tela.adicionaCampo("reduzido", "Reduzido", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("conta", "Conta", 0, "", 3, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + filial);
        tela.setColunaOrdenacao("Conta");
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiai) throws Exception {
        if (!(bean instanceof CentroCustoBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    public CentroCustoVO getMaiorConta(String contaPai, String tamanhoNivel) throws Exception {
        return ((CentroCustoDao)this.dao).getMaiorConta(contaPai, tamanhoNivel);
    }

    public boolean contaExiste(String conta) throws Exception {
        return ((CentroCustoDao)this.dao).contaExiste(conta);
    }

    public boolean contaExisteFilhos(String contaPai) throws Exception {
        return ((CentroCustoDao)this.dao).contaExisteFilhos(contaPai);
    }

    public boolean haCentrosCusto(String codigoFilial) throws SQLException {
        return ((CentroCustoDao)this.dao).haCentrosCusto(codigoFilial);
    }
}

