/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.exame;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Setor;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.SetorBean;
import jalis.model.dao.cadastro.exame.SetorDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.exame.SetorUsuarioVO;
import jalis.model.vo.cadastro.exame.SetorVO;
import jalis.service.AbstractThreadService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SetorService
extends AbstractThreadService {
    public SetorService() {
        this.dao = new SetorDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof SetorBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.delete(bean, filial);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((SetorDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((SetorDao)this.dao).getVO(filial, codigo);
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof SetorBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        Integer i = this.dao.getProximoCodigo(bean);
        if (i <= 0) {
            throw new Exception("N\u00e3o foi poss\u00edvel gerar o c\u00f3digo para a tabela setor");
        }
        ((SetorBean)bean).setCodigo(i);
        this.dao.insert(bean, filial);
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(SetorBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(SetorVO.class, where);
    }

    public SetorVO loadVO(String filial, String codigoSetor) throws SQLException {
        return ((SetorDao)this.dao).loadVO(filial, codigoSetor);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof SetorBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Setor.getModuloAcesso(), "Cadastro de Setores");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.adicionaCampo("sigla", "Sigla", 0, "", 2, 75);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public ArrayList<SetorBean> getSetoresExame(String codigoFilial, String codigoExame) throws ThreadDaoException {
        return ((SetorDao)this.dao).getSetoresExame(codigoFilial, codigoExame);
    }

    public List<SetorUsuarioVO> buscaUsuarioSetor(String filialPadrao, String codigoSetor) throws SQLException {
        SetorUsuarioVO setorUsuarioVO = new SetorUsuarioVO();
        setorUsuarioVO.setCodigoFilial(Integer.valueOf(filialPadrao));
        setorUsuarioVO.setCodigoSetor(Integer.valueOf(codigoSetor));
        List<SetorUsuarioVO> listaUsuarios = ((SetorDao)this.dao).buscaUsuarioSetor(setorUsuarioVO);
        return listaUsuarios;
    }

    public void inserirSetorUsuario(SetorUsuarioVO setorUsuarioVO) throws SQLException {
        List<SetorUsuarioVO> listaUsuarios = ((SetorDao)this.dao).buscaUsuarioSetor(setorUsuarioVO);
        if (listaUsuarios.isEmpty()) {
            ((SetorDao)this.dao).inserirSetorUsuario(setorUsuarioVO);
        }
    }

    public void removeUsuarios(List<SetorUsuarioVO> listaUsuarios, SetorUsuarioVO setorUsuario) throws SQLException {
        List<SetorUsuarioVO> listaBanco = ((SetorDao)this.dao).buscaUsuarioSetor(setorUsuario);
        for (SetorUsuarioVO setorUsuarioVO : listaBanco) {
            boolean encontrado = false;
            for (SetorUsuarioVO matUsuarioVO : listaUsuarios) {
                if (!this.validarSetorCadastrado(setorUsuarioVO, matUsuarioVO)) continue;
                encontrado = true;
            }
            if (encontrado) continue;
            ((SetorDao)this.dao).deletar(setorUsuarioVO);
        }
    }

    private boolean validarSetorCadastrado(SetorUsuarioVO setorUsuarioVO, SetorUsuarioVO setUsuarioVO) {
        return setUsuarioVO.getCodigoUsuario() != null && setUsuarioVO.getCodigoSetor() == setorUsuarioVO.getCodigoSetor() && setUsuarioVO.getCodigoUsuario().equals(setorUsuarioVO.getCodigoUsuario());
    }
}

