/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.exame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.LabExterno;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.exame.LabExternoBean;
import jalis.model.dao.cadastro.exame.LabExternoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Set;

public class LabExternoService
extends AbstractThreadService {
    private final LabExternoDao dao = new LabExternoDao();

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof LabExternoBean) {
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof LabExternoBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof LabExternoBean) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(LabExterno.getModuloAcesso(), "Cadastro de laborat\u00f3rio externo");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 0, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao);
        tela.setExecutarAoAbrir(true);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public Set load(String where, Statement st, String filialPadrao) throws Exception {
        return LabExternoDao.load2(LabExternoBean.class, where, st, filialPadrao);
    }

    public Set loadBean(String where, Statement st) throws ThreadDaoException, SQLException {
        return LabExternoDao.getBeans(LabExternoBean.class, where, st);
    }

    @Override
    public Set load(String where) throws Exception {
        return LabExternoDao.load(LabExternoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(LabExternoVO.class, where);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    public AbstractThreadBean getVO(String filCodigo, String codigo) throws Exception {
        return this.dao.getVO(filCodigo, codigo);
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    public boolean permiteEnviarEtiquetaHpDirect(String filial, String codigoLabExterno) throws Exception {
        String enviarEtiquetaHpDirect;
        String xmlConfig;
        boolean retorno = false;
        if (!(Funcoes.textoVazio(filial) || Funcoes.textoVazio(codigoLabExterno) || (xmlConfig = this.xmlConfigEtiquetaHpDirect(filial, codigoLabExterno)) == null || Funcoes.textoVazio(enviarEtiquetaHpDirect = StringUtil.getValor(xmlConfig, "enviarEtiquetaHpDirect")))) {
            retorno = new Boolean(enviarEtiquetaHpDirect);
        }
        return retorno;
    }

    public String xmlConfigEtiquetaHpDirect(String filial, String codigoLabExterno) throws Exception {
        String xmlConfig = null;
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder();
        sql.append("select lae_configuracao from labexterno where fil_codigo = ");
        sql.append(filial);
        sql.append(" and lae_codigo = ");
        sql.append(codigoLabExterno);
        ResultSet rs = st.executeQuery(sql.toString());
        if (rs.next()) {
            xmlConfig = rs.getString("lae_configuracao");
        }
        rs.close();
        st.close();
        return xmlConfig;
    }

    public void atualizaDataUltimaImportacaoExames(String filial, int codigoLabExterno) throws Exception {
        LabExternoBean bean = new LabExternoBean();
        bean.setCodigo(codigoLabExterno);
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(filial));
        bean.setFilial(filialVO);
        bean.setUltimaImportacaoExames(Funcoes.getDataHoraServidor());
        this.update(bean, null, filial, ParametrosGerais.getCopiaLabExterno());
    }

    public void atualizaDataUltimaImportacaoExamesAutomatico(String filial, int codigoLabExterno) throws Exception {
        LabExternoBean bean = new LabExternoBean();
        bean.setCodigo(codigoLabExterno);
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(filial));
        bean.setFilial(filialVO);
        Date dataHora = Funcoes.getDataSemErrorLogger("dd/MM/yyyy HH:mm:ss", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", new Date()));
        bean.setUltimaImportacaoExames(dataHora);
        this.update(bean, null, filial, ParametrosGerais.getCopiaLabExterno());
    }

    public boolean isAgruparMultiguia(Integer codFilial, Integer codigoLabExterno, Statement st) {
        return this.dao.isAgruparMultiguia(codFilial, codigoLabExterno, st);
    }
}

