/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.exame;

import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.ExameSetorBean;
import jalis.model.dao.cadastro.exame.ExameSetorDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.exame.ExameSetorVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class ExameSetorService
extends AbstractThreadService {
    public ExameSetorService() {
        this.dao = new ExameSetorDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameSetorBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameSetorBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameSetorBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameSetorBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameSetorBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameSetorBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ExameSetorBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ExameSetorVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    public ArrayList<ExameSetorVO> getSetoresExameVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameSetorDao)this.dao).getSetoresExameVO(chaves);
    }

    public void removeSetorPadraoExame(String filialPadrao, String codigoExame, String filiaisAutoCopia) throws SQLException {
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiaisAutoCopia != null ? StringUtil.getValor(filiaisAutoCopia, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameSetorDao)this.dao).removeSetorPadraoExame(filial, codigoExame);
        }
    }
}

