/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.exame;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Exame;
import jalis.laboratorio.util.faturamento.ConvenioCotaExameBeanAux;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.ExameBean;
import jalis.model.dao.cadastro.exame.ExameDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.service.AbstractThreadService;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ExameService
extends AbstractThreadService {
    public ExameService() {
        this.dao = new ExameDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof ExameBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    @Deprecated
    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((ExameDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((ExameDao)this.dao).getVO(filial, codigo);
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof ExameBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ExameVO.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ExameVO.class, where);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof ExameBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, false, mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean pesquisarProibidos, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.setTelaCadastro(Exame.getModuloAcesso(), "Cadastro de Exames");
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + (!pesquisarProibidos ? " and exa_proibido = false " : ""));
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public List<ConvenioCotaExameBeanAux> obterCotaExame(ConvenioCotaExameBeanAux convenioCotaExameBeanAux) throws SQLException {
        Statement st;
        ResultSet rs;
        ArrayList<ConvenioCotaExameBeanAux> list = new ArrayList<ConvenioCotaExameBeanAux>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select *, met_codigo as met_codigo_original from conveniocotaexame where fil_codigo = " + Variaveis.filialPadrao);
        sql.append(" and con_codigo = ").append(convenioCotaExameBeanAux.getCon_codigo());
        sql.append(" and exa_codigo = '").append(convenioCotaExameBeanAux.getExa_codigo()).append("'");
        sql.append(" and mco_codigo = ").append(convenioCotaExameBeanAux.getMco_codigo());
        if (ParametrosGerais.getPrecoMetodologia()) {
            sql.append(" and met_codigo = ").append(convenioCotaExameBeanAux.getMet_codigo()).append(";");
        }
        if ((rs = Conexao.executeQuery(st = Conexao.getStatement(), sql.toString())).next()) {
            do {
                ConvenioCotaExameBeanAux map = new ConvenioCotaExameBeanAux();
                map.setCon_codigo(rs.getInt("con_codigo"));
                map.setExa_codigo(rs.getString("exa_codigo"));
                map.setMco_codigo(rs.getInt("mco_codigo"));
                if (ParametrosGerais.getPrecoMetodologia()) {
                    map.setMet_codigo(rs.getInt("met_codigo"));
                } else {
                    map.setMet_codigo(0);
                }
                map.setMet_codigo_orginal(rs.getInt("met_codigo_original"));
                map.setCct_quantidade(rs.getInt("cct_quantidade"));
                list.add(map);
            } while (rs.next());
        }
        st.close();
        rs.close();
        return list;
    }

    public List<ConvenioCotaExameBeanAux> getAcordados(String convenio) throws SQLException {
        ArrayList<ConvenioCotaExameBeanAux> list = new ArrayList<ConvenioCotaExameBeanAux>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select *, met_codigo as met_codigo_original  from conveniocotaexame where fil_codigo = " + Variaveis.filialPadrao);
        sql.append(" and con_codigo = ").append(convenio);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ConvenioCotaExameBeanAux map = new ConvenioCotaExameBeanAux();
            map.setFil_codigo(rs.getInt("fil_codigo"));
            map.setCon_codigo(rs.getInt("con_codigo"));
            map.setExa_codigo(rs.getString("exa_codigo"));
            map.setMco_codigo(rs.getInt("mco_codigo"));
            if (ParametrosGerais.getPrecoMetodologia()) {
                map.setMet_codigo(rs.getInt("met_codigo"));
            } else {
                map.setMet_codigo(0);
            }
            map.setMet_codigo_orginal(rs.getInt("met_codigo_original"));
            map.setCct_quantidade(rs.getInt("cct_quantidade"));
            list.add(map);
        }
        st.close();
        rs.close();
        return list;
    }

    public String verificaVersaoModeloXML(String xml) {
        if (xml != null && StringUtil.getValor(xml, "versaoExame") != null) {
            return "Vers\u00e3o: " + (StringUtil.getValor(xml, "versaoExame") != "" ? StringUtil.getValor(xml, "versaoExame") : "1");
        }
        return "Vers\u00e3o: 1";
    }

    public ExameVO buscaDadosExame(String filCodigo, String exaCodigo) throws SQLException {
        return ((ExameDao)this.dao).buscaDadosExames(filCodigo, exaCodigo);
    }

    public String getCodigoRecipiente(String filial, String exame, int mco, String tabela) throws SQLException {
        return ((ExameDao)this.dao).getCodigoRecipiente(filial, exame, mco, tabela);
    }

    public List<Registro> buscarExameAMB(String codigoFilial, String codigoConvenio, String codigoAMB) throws Exception {
        return ((ExameDao)this.dao).buscarExameAMB(codigoFilial, codigoConvenio, codigoAMB);
    }

    public void atualizarInterfaceExameRequisicao(String codExame, Integer codMatCol, String filialPadrao) throws SQLException {
        ((ExameDao)this.dao).atualizarInterfaceExameRequisicao(filialPadrao, codExame, codMatCol);
    }

    public String verificaVersaoNotificao(String notificacaoCabecalho) {
        if (notificacaoCabecalho != null && StringUtil.getValor(notificacaoCabecalho, "versaoExame") != null) {
            return "Vers\u00e3o: " + (StringUtil.getValor(notificacaoCabecalho, "versaoExame") != "" ? StringUtil.getValor(notificacaoCabecalho, "versaoExame") : "1");
        }
        return "Vers\u00e3o: 0";
    }

    public String getCabecalhoModeloNotificacao() throws SQLException {
        return ((ExameDao)this.dao).getCabecalhoModeloNotificacao();
    }
}

