/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.exame;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Exame;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.ExameMatColetaBean;
import jalis.model.dao.cadastro.exame.ExameMatColetaDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

public class ExameMatColetaService
extends AbstractThreadService {
    public ExameMatColetaService() {
        this.dao = new ExameMatColetaDao();
    }

    @Override
    @Deprecated
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return null;
    }

    public AbstractThreadVO getVO(String filial, String codigo, String codigoMaterial) throws Exception {
        return ((ExameMatColetaDao)this.dao).getVO(filial, codigo, codigoMaterial);
    }

    public AbstractThreadBean getBean(String filial, String codigo, String codigoMaterial) throws Exception {
        return ((ExameMatColetaDao)this.dao).getBean(filial, codigo, codigoMaterial);
    }

    @Override
    @Deprecated
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ExameVO.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ExameVO.class, where);
    }

    @Override
    @Deprecated
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, false, mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean pesquisarProibidos, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        tela.setTelaCadastro(Exame.getModuloAcesso(), "Cadastro de Exames");
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("Descri\u00e7\u00e3o");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao + (!pesquisarProibidos ? " and exa_proibido = false " : ""));
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVOAMBExame(Object owner, AbstractThreadVO bean, String titulo, boolean pesquisarProibidos, boolean mostrarCadastro) throws Exception {
        Hashtable resultado = Pesquisas.exameAMB(owner, false, true);
        if (resultado != null) {
            String exame = resultado.get("exa_codigo").toString();
            String codMaterial = resultado.get("mco_codigo").toString();
            return new ExameMatColetaDao().getVO(Variaveis.filialPadrao, exame, codMaterial);
        }
        return null;
    }

    public List getMateriaisColeta(String filial, String exame) throws Exception {
        ArrayList materiais = new ArrayList(new ExameMatColetaDao().getMateriaisColeta(filial, exame));
        Collections.sort(materiais, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null && o1 instanceof MaterialColetaVO && o2 instanceof MaterialColetaVO) {
                    return ((MaterialColetaVO)o1).getDescricao().compareTo(((MaterialColetaVO)o2).getDescricao());
                }
                return 0;
            }
        });
        return materiais;
    }

    public MaterialColetaVO getMaterialPadrao(String filial, String exame) throws Exception {
        Set materiais = new ExameMatColetaDao().loadVO(ExameMatColetaVO.class, " where fil_codigo = " + filial + " and exa_codigo = '" + exame + "'");
        for (Object o : materiais) {
            if (!(o instanceof ExameMatColetaVO) || !((ExameMatColetaVO)o).getPadrao().booleanValue()) continue;
            return ((ExameMatColetaVO)o).getMaterial();
        }
        return null;
    }

    public void alteraPrazoExameMaterial(ExameMatColetaVO exameMaterial, Integer codigoPrazo, String filiaisAutoCopia) throws SQLException {
        String filialPadrao = exameMaterial.getFilial().getCodigo().toString();
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiaisAutoCopia != null ? StringUtil.getValor(filiaisAutoCopia, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            exameMaterial.getFilial().setCodigo(Integer.parseInt(filial));
            ((ExameMatColetaDao)this.dao).alteraPrazoExameMaterial(exameMaterial, codigoPrazo);
        }
    }

    public void alteraMetodoPadraoExameMaterial(ExameMatColetaVO exameMaterial, Integer codigoMetodologia, String filiaisAutoCopia) throws SQLException {
        String filialPadrao = exameMaterial.getFilial().getCodigo().toString();
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiaisAutoCopia != null ? StringUtil.getValor(filiaisAutoCopia, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            exameMaterial.getFilial().setCodigo(Integer.parseInt(filial));
            ((ExameMatColetaDao)this.dao).alteraMetodoPadraoExameMaterial(exameMaterial, codigoMetodologia);
        }
    }

    public void atualizaCamposObrigatoriosExameMaterial(ExameMatColetaBean bean, String filiaisAutoCopia, boolean obrigaAltura, boolean obrigaPeso, boolean obrigaTempoDiurese, boolean solicitarJejum, boolean obrigaDUM, boolean obrigaMedicamento) throws SQLException {
        String filialPadrao = bean.getFilial().getCodigo().toString();
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiaisAutoCopia != null ? StringUtil.getValor(filiaisAutoCopia, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            bean.getFilial().setCodigo(Integer.parseInt(filial));
            ((ExameMatColetaDao)this.dao).atualizaCamposObrigatoriosExameMaterial(bean, obrigaAltura, obrigaPeso, obrigaTempoDiurese, solicitarJejum, obrigaDUM, obrigaMedicamento);
        }
    }
}

