/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.exame;

import jalis.laboratorio.util.ExameMatColetaLabExtDesm;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.ExameMatColetaBean;
import jalis.model.bean.cadastro.exame.ExameMatColetaLabExternoBean;
import jalis.model.dao.cadastro.exame.ExameMatColetaLabExternoDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.exame.ExameMatColetaVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class ExameMatColetaLabExternoService
extends AbstractThreadService {
    public ExameMatColetaLabExternoService() {
        this.dao = new ExameMatColetaLabExternoDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameMatColetaLabExternoBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameMatColetaLabExternoBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.insert(bean, filial);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameMatColetaLabExternoBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameMatColetaLabExternoBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.update(bean, filial);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameMatColetaLabExternoBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameMatColetaLabExternoBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.delete(bean, filial);
        }
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ExameMatColetaLabExternoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ExameMatColetaLabExternoBean.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    public void setLaboratorioExternoPadraoExameMaterial(ExameMatColetaVO exameMaterial, Integer codigoLabExterno, String filialPadrao, String filiais) throws SQLException {
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            exameMaterial.getFilial().setCodigo(Integer.parseInt(filial));
            ((ExameMatColetaLabExternoDao)this.dao).setLaboratorioExternoPadraoExameMaterial(exameMaterial, codigoLabExterno);
        }
    }

    public boolean verificaExameMaterialTemLabExternoPadrao(ExameMatColetaVO exameMaterial, int codigoLabExterno, String filialPadrao, String filiais) throws SQLException {
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        boolean retorno = false;
        for (String filial : listaFiliais) {
            exameMaterial.getFilial().setCodigo(Integer.parseInt(filial));
            boolean aux = ((ExameMatColetaLabExternoDao)this.dao).verificaExameMaterialTemLabExternoPadrao(exameMaterial, codigoLabExterno);
            if (!filial.equalsIgnoreCase(filialPadrao)) continue;
            retorno = aux;
        }
        return retorno;
    }

    public String verificaHaAssociacaoExameMaterialLabExternoMetodologia(ExameMatColetaBean exameMaterial, int codigoMetodologia, int codigoLabExterno) throws SQLException {
        return ((ExameMatColetaLabExternoDao)this.dao).verificaHaAssociacaoExameMaterialLabExternoMetodologia(exameMaterial, codigoMetodologia, codigoLabExterno);
    }

    public boolean verificaHaAssociacaoExameMaterialLabExterno(String filial, String exame, String material, String codigoLabExterno) throws SQLException {
        return ((ExameMatColetaLabExternoDao)this.dao).verificaHaAssociacaoExameMaterialLabExterno(filial, exame, material, codigoLabExterno);
    }

    public ArrayList obterExameDesmembradoLabExterno(Map<String, String> params) throws SQLException {
        return ((ExameMatColetaLabExternoDao)this.dao).obterExameDesmembradoLabExterno(params);
    }

    public boolean verificaIsExibirCondicaoAmostra(String filial, String exa, String mat, String codigoLabExterno) throws SQLException {
        String ehpXML = ((ExameMatColetaLabExternoDao)this.dao).verificaIsExibirCondicaoAmostra(filial, exa, mat, codigoLabExterno);
        String condicaoAmostra = StringUtil.getValor(ehpXML, "condicao-selecionada");
        return Boolean.valueOf(condicaoAmostra);
    }

    public ArrayList<ExameMatColetaLabExtDesm> buscaExamesDesm(String filial, String examePai, String matExaPai, String codigoLabExterno) throws SQLException {
        return ((ExameMatColetaLabExternoDao)this.dao).buscaExamesDesm(filial, examePai, matExaPai, codigoLabExterno);
    }

    public void setMudarSituacaoBloqueadoLaboratorioExterno(ExameMatColetaVO exameMaterial, Integer codigoLabExterno, boolean situacao, String filialPadrao, String filiais) throws SQLException {
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            exameMaterial.getFilial().setCodigo(Integer.parseInt(filial));
            ((ExameMatColetaLabExternoDao)this.dao).setMudarSituacaoBloqueadoLaboratorioExterno(exameMaterial, codigoLabExterno, situacao);
        }
    }

    public boolean verificaExamePossuiAlgumaConfiguracaoLabExterno(String filial, String exame, String material) throws SQLException {
        return ((ExameMatColetaLabExternoDao)this.dao).verificaExamePossuiAlgumaConfiguracaoLabExterno(filial, exame, material);
    }
}

