/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.exame;

import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.exame.ExameLayoutMetodoBean;
import jalis.model.dao.cadastro.exame.ExameLayoutMetodoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.exame.ExameLayoutMetodoVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;

public class ExameLayoutMetodoService
extends AbstractThreadService {
    public ExameLayoutMetodoService() {
        this.dao = new ExameLayoutMetodoDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameLayoutMetodoBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameLayoutMetodoBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.insert(bean, filial);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameLayoutMetodoBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameLayoutMetodoBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.update(bean, filial);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (!(bean instanceof ExameLayoutMetodoBean)) {
            throw new Exception("Objeto inv\u00e1lido.");
        }
        ArrayList<String> listaFiliais = new ArrayList<String>();
        listaFiliais.add(filialPadrao);
        String[] codigos = filiais != null ? StringUtil.getValor(filiais, "filiais").split(",") : new String[]{};
        for (int i = 0; i < codigos.length; ++i) {
            if (codigos[i].equalsIgnoreCase(filialPadrao) || !Funcoes.isNumeric(codigos[i])) continue;
            listaFiliais.add(codigos[i]);
        }
        for (String filial : listaFiliais) {
            ((ExameLayoutMetodoBean)bean).getFilial().setCodigo(Integer.parseInt(filial));
            this.dao.delete(bean, filial);
        }
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(ExameLayoutMetodoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(ExameLayoutMetodoVO.class, where);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public ArrayList getMetodologias(String filial, String exame, String material) throws Exception {
        ArrayList metodos = new ArrayList(new ExameLayoutMetodoDao().getMetodologias(filial, exame, material));
        Collections.sort(metodos, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null && o1 instanceof MetodologiaVO && o2 instanceof MetodologiaVO) {
                    return ((MetodologiaVO)o1).getCodigo().compareTo(((MetodologiaVO)o2).getCodigo());
                }
                return 0;
            }
        });
        return metodos;
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameLayoutMetodoDao)this.dao).getBean(chaves);
    }

    public ArrayList<ExameLayoutMetodoBean> getBeans(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameLayoutMetodoDao)this.dao).getBeans(chaves);
    }

    public AbstractThreadBean getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((ExameLayoutMetodoDao)this.dao).getVO(chaves);
    }
}

