/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.auxiliares;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.model.dao.cadastro.auxiliares.TermoConsentimentoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.ModeloTermoConsentimentoVO;
import jalis.model.vo.cadastro.auxiliares.TermoConsentimentoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class TermoConsentimentoService {
    private final TermoConsentimentoDao dao = new TermoConsentimentoDao();

    public List<TermoConsentimentoVO> getTermosAtivos() throws SQLException {
        return this.dao.getTermos(Variaveis.filialPadrao);
    }

    public List<String> getDescricaoTermos() {
        ArrayList<Object> listaTermos = new ArrayList();
        try {
            listaTermos = this.dao.getTermos(Variaveis.filialPadrao);
        }
        catch (SQLException e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e1.getMessage(), e1.getStackTrace());
        }
        return listaTermos.stream().map(termo -> termo.getDescricao()).collect(Collectors.toList());
    }

    private RequisicaoVO getRequisicaoVO(String filial, String codigoReq) {
        RequisicaoService requisicaoService = new RequisicaoService();
        RequisicaoVO requisicao = null;
        try {
            HashMap<String, Object> chave = new HashMap<String, Object>();
            chave.put("fil_codigo", filial);
            chave.put("req_codigo", codigoReq);
            requisicao = (RequisicaoVO)requisicaoService.getVO(chave);
        }
        catch (ThreadDaoException e) {
            e.printStackTrace();
        }
        return requisicao;
    }

    public TermoConsentimentoVO getTermoConsentimento(String filial, int codigo) throws SQLException {
        return this.dao.getTermoConsentimento(filial, codigo);
    }

    public ArrayList<ModeloTermoConsentimentoVO> buscarModelosTermo(String filial, String codigo) throws Exception {
        return this.dao.buscarModelosTermo(filial, codigo);
    }

    public ModeloTermoConsentimentoVO copiaModeloSelecionado(String filial, String codigoModelo, String codigo) throws SQLException {
        return this.dao.pesquisarModeloSelecionado(filial, codigoModelo, codigo);
    }

    public String getTipoTermo(String filial, String codigoModelo, String codigo) {
        return this.dao.getTipoTermo(filial, codigoModelo, codigo);
    }

    public ArrayList<Integer> getQtdTermosDisponiveis(String filial) throws Exception {
        return this.dao.getQtdTermosDisponiveis(filial);
    }
}

