/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro.animal;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Especie;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.animal.EspecieBean;
import jalis.model.bean.cadastro.animal.RacaBean;
import jalis.model.dao.cadastro.animal.EspecieDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.animal.EspecieVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.animal.RacaService;
import java.util.Iterator;
import java.util.Set;

public class EspecieService
extends AbstractThreadService {
    public EspecieService() {
        this.dao = new EspecieDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EspecieBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        Set racas = ((EspecieBean)bean).getRacas();
        Iterator it = racas.iterator();
        RacaService racaService = new RacaService();
        while (it.hasNext()) {
            RacaBean raca = (RacaBean)it.next();
            raca.setEspecie((EspecieVO)((EspecieBean)bean).toVO());
            racaService.gravaAutoCopiaSemCommit(raca, 2, filial, null);
        }
        this.dao.delete(bean, filial);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EspecieBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        ((EspecieBean)bean).setCodigo((Integer)codigo);
        this.dao.insert(bean, filial);
        Set racas = ((EspecieBean)bean).getRacas();
        Iterator it = racas.iterator();
        RacaService racaService = new RacaService();
        while (it.hasNext()) {
            RacaBean raca = (RacaBean)it.next();
            raca.setEspecie((EspecieVO)((EspecieBean)bean).toVO());
            if (raca.isRemover()) {
                racaService.gravaAutoCopiaSemCommit(raca, 2, filial, null);
                continue;
            }
            if (raca.isAlterar()) {
                racaService.gravaAutoCopiaSemCommit(raca, 1, filial, null);
                continue;
            }
            if (!raca.isInserir()) continue;
            racaService.gravaAutoCopiaSemCommit(raca, 0, filial, null);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filial, String filiais) throws Exception {
        if (!(bean instanceof EspecieBean)) {
            throw new Exception("Tipo recebido \u00e9 inv\u00e1lido");
        }
        this.dao.update(bean, filial);
        Set racas = ((EspecieBean)bean).getRacas();
        Iterator it = racas.iterator();
        RacaService racaService = new RacaService();
        while (it.hasNext()) {
            RacaBean raca = (RacaBean)it.next();
            raca.setEspecie((EspecieVO)((EspecieBean)bean).toVO());
            if (raca.isRemover()) {
                racaService.gravaAutoCopiaSemCommit(raca, 2, filial, null);
                continue;
            }
            if (raca.isAlterar()) {
                racaService.gravaAutoCopiaSemCommit(raca, 1, filial, null);
                continue;
            }
            if (!raca.isInserir()) continue;
            racaService.gravaAutoCopiaSemCommit(raca, 0, filial, null);
        }
    }

    @Override
    public Set load() throws Exception {
        return this.load(null);
    }

    @Override
    public Set load(String where) throws Exception {
        Set s = AbstractThreadDao.load(EspecieBean.class, where);
        return s;
    }

    @Override
    public Set loadVO() throws Exception {
        return this.loadVO(null);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        Set s = this.dao.loadVO(EspecieVO.class, where);
        return s;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Especie.getModuloAcesso(), "Cadastro de Esp\u00e9cies");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }
}

