/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Taxa;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.TaxaBean;
import jalis.model.dao.cadastro.auxiliares.TaxaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.TaxaVO;
import jalis.service.AbstractThreadService;
import java.util.Map;
import java.util.Set;

public class TaxaService
extends AbstractThreadService {
    public TaxaService() {
        this.dao = new TaxaDao();
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof TaxaBean || bean instanceof TaxaVO) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return this.dao.getBean(codigo);
    }

    public AbstractThreadBean get(String filial, String codigo) throws Exception {
        return ((TaxaDao)this.dao).getBean(filial, codigo);
    }

    @Override
    public AbstractThreadVO getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    public AbstractThreadVO getVO(String filial, String codigo) throws Exception {
        return ((TaxaDao)this.dao).getVO(filial, codigo);
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof TaxaBean) {
            ((TaxaBean)bean).setCodigo((Integer)codigo);
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public Set load() throws Exception {
        return this.dao.load(TaxaBean.class);
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(TaxaBean.class, where);
    }

    @Override
    public Set loadVO() throws Exception {
        return this.dao.loadVO(TaxaVO.class);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(TaxaVO.class, where);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof TaxaBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Taxa.getModuloAcesso(), "Cadastro de Taxas");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 2, 75);
        tela.adicionaCampo("descricao", "Descri\u00e7\u00e3o", 0, "", 2, 0);
        tela.setFiltroInicial("Descri\u00e7\u00e3o", 2);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
        tela.setService(this);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((TaxaDao)this.dao).getBean(chaves);
    }

    public TaxaVO getDescricaoTaxa(String filial, String descricaoTaxa) throws ThreadDaoException {
        return ((TaxaDao)this.dao).getTaxaDescricao(filial, descricaoTaxa);
    }
}

