/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Variaveis;
import jalis.laboratorio.cadastro.PorteTabelaCBHPM;
import jalis.laboratorio.cadastro.TabelaPreco;
import jalis.model.AbstractThreadBean;
import jalis.model.dao.cadastro.TabelaPrecoDao;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.DetalheTabelaPrecoMetodologiaVO;
import jalis.model.vo.cadastro.TabelaPrecoVO;
import jalis.model.vo.cadastro.tabelaPreco.PrecosAlterados;
import jalis.model.vo.cadastro.tabelaPreco.TabelaPrecoExameUsuarioVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class TabelaPrecoService
extends AbstractThreadService {
    TabelaPrecoDao dao = new TabelaPrecoDao();
    private final String NAO_INFORMADO = "N\u00e3o informado";

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.insert(bean, filialPadrao);
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.update(bean, filialPadrao);
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        this.dao.delete(bean, filialPadrao);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    public Set load() throws Exception {
        return this.dao.load(TabelaPreco.class);
    }

    @Override
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return null;
    }

    public List<TabelaPrecoExameUsuarioVO> pesquisarHistorico(Integer codigoFilial, String dataInicio, String dataFinal, String usuario, String codigoTabela) throws SQLException {
        if (Funcoes.textoVazio(dataInicio) && Funcoes.textoVazio(dataFinal)) {
            dataInicio = Funcoes.formataData("yyyy-MM-dd", Funcoes.somaDias(new Date(), -10));
            dataFinal = Funcoes.formataData("yyyy-MM-dd", new Date());
        }
        return this.dao.pesquisarHistorico(codigoFilial, dataInicio, dataFinal, usuario, codigoTabela);
    }

    public List<PorteTabelaCBHPM> buscaPorte(String codigoFilial, String codigoTabela) throws SQLException {
        return this.dao.buscaPorte(codigoFilial, codigoTabela, "");
    }

    public void registrarHistoricoPorte(PorteTabelaCBHPM porte, String codigoFilial, String codigoTabela) throws SQLException {
        List<PorteTabelaCBHPM> listaPorte = this.dao.buscaPorte(codigoFilial, codigoTabela, porte.getPorte());
        if (listaPorte.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Cadastro realizado Porte ");
            buf.append(porte.getPorte());
            buf.append(" com valor de ").append(Funcoes.formataDecimal("0.00", porte.getValor()));
            new TabelaPrecoService().inserirHistorico(buf.toString(), codigoTabela);
        }
        for (PorteTabelaCBHPM porteTabelaCBHPM : listaPorte) {
            if (!this.porteAlterado(porte, porteTabelaCBHPM)) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("Cadastro alterado Porte ");
            buf.append(porte.getPorte()).append(" de ");
            buf.append(Funcoes.formataDecimal("0.00", porteTabelaCBHPM.getValor()));
            buf.append(" para ").append(Funcoes.formataDecimal("0.00", porte.getValor()));
            new TabelaPrecoService().inserirHistorico(buf.toString(), codigoTabela);
        }
    }

    public void registrarHistoricoPorte(List<PorteTabelaCBHPM> listaPorte, String codigoFilial, String codigoTabela) throws SQLException {
        if (listaPorte != null) {
            for (PorteTabelaCBHPM porteTabelaCBHPM : listaPorte) {
                List<PorteTabelaCBHPM> portes = this.dao.buscaPorte(codigoFilial, codigoTabela, porteTabelaCBHPM.getPorte());
                if (!portes.isEmpty()) continue;
                StringBuilder buf = new StringBuilder();
                buf.append("Cadastro removido Porte ");
                buf.append(porteTabelaCBHPM.getPorte());
                new TabelaPrecoService().inserirHistorico(buf.toString(), codigoTabela);
            }
        }
    }

    private boolean porteAlterado(PorteTabelaCBHPM porte, PorteTabelaCBHPM porteTabelaCBHPM) {
        return porte.getPorte().equals(porteTabelaCBHPM.getPorte()) && porte.getValor() != porteTabelaCBHPM.getValor();
    }

    public void registraHistoricoExameCodigoAMB(PrecosAlterados precosAlterados, String codigoTabela, boolean precoMetodologia, List<DetalheTabelaPrecoMetodologiaVO> listaDtp) throws NumberFormatException, SQLException {
        for (DetalheTabelaPrecoMetodologiaVO detalheTabelaPrecoVO : listaDtp) {
            if (!this.exameEncontrado(detalheTabelaPrecoVO, precosAlterados) || !this.campoAlterado(precosAlterados.getCodigoAMB(), detalheTabelaPrecoVO.getCodigoAmb())) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("Exame ").append(precosAlterados.getCodigoExame() + " (").append(precosAlterados.getMaterial().getCodigo()).append(") alterado ");
            String texto = buf.toString();
            buf = new StringBuilder();
            buf.append(texto);
            buf.append("C\u00f3digo AMB de ");
            buf.append(Funcoes.textoVazio(detalheTabelaPrecoVO.getCodigoAmb()) ? "N\u00e3o informado" : detalheTabelaPrecoVO.getCodigoAmb());
            buf.append(" para ").append(Funcoes.textoVazio(precosAlterados.getCodigoAMB()) ? "N\u00e3o informado" : precosAlterados.getCodigoAMB());
            this.inserirHistorico(buf.toString(), codigoTabela);
            break;
        }
    }

    public List<DetalheTabelaPrecoMetodologiaVO> buscarPreco(Statement st, Integer filial, String codigoTabela, boolean precoMetodologia) throws NumberFormatException, SQLException {
        List<DetalheTabelaPrecoMetodologiaVO> listaDtp = null;
        listaDtp = precoMetodologia ? this.dao.buscarPrecoMetodologia(st, Integer.valueOf(Variaveis.filialPadrao), codigoTabela) : this.dao.buscarPreco(st, Integer.valueOf(Variaveis.filialPadrao), codigoTabela);
        return listaDtp;
    }

    public void registrarHistoricoExamePorteProibido(PrecosAlterados precosAlterados, String codigoTabela, boolean precoMetodologia, List<DetalheTabelaPrecoMetodologiaVO> listaDtp) throws NumberFormatException, SQLException {
        for (DetalheTabelaPrecoMetodologiaVO detalheTabelaPrecoVO : listaDtp) {
            if (!this.exameEncontrado(detalheTabelaPrecoVO, precosAlterados)) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("Exame ").append(precosAlterados.getCodigoExame() + " (").append(precosAlterados.getMaterial().getCodigo()).append(") alterado ");
            String texto = buf.toString();
            if (this.campoAlterado(precosAlterados.getPorte(), detalheTabelaPrecoVO.getPorte().getCodigo())) {
                buf = new StringBuilder();
                buf.append(texto);
                buf.append("Porte de ");
                buf.append(Funcoes.textoVazio(detalheTabelaPrecoVO.getPorte().getCodigo()) ? "N\u00e3o informado" : detalheTabelaPrecoVO.getPorte().getCodigo());
                buf.append(" para ").append(precosAlterados.getPorte());
                this.inserirHistorico(buf.toString(), codigoTabela);
            }
            if (!this.booleanoAlterado(precosAlterados.isProibido(), detalheTabelaPrecoVO.getProibido())) break;
            buf = new StringBuilder();
            buf.append(texto);
            buf.append("Proibido de ");
            buf.append(detalheTabelaPrecoVO.getProibido() != false ? "True" : "False");
            buf.append(" para ").append(precosAlterados.isProibido() ? "True" : "False");
            this.inserirHistorico(buf.toString(), codigoTabela);
            break;
        }
    }

    public void registrarHistoricoExame(PrecosAlterados precosAlterados, String codigoTabela, boolean precoMetodologia, List<DetalheTabelaPrecoMetodologiaVO> listaDtp) throws NumberFormatException, SQLException {
        this.registraHistoricoExameCodigoAMB(precosAlterados, codigoTabela, precoMetodologia, listaDtp);
        this.registrarHistoricoExamePorteProibido(precosAlterados, codigoTabela, precoMetodologia, listaDtp);
        this.registrarHistoricoExameValores(precosAlterados, codigoTabela, precoMetodologia, listaDtp);
    }

    public void registrarHistoricoExameValores(PrecosAlterados precosAlterados, String codigoTabela, boolean precoMetodologia, List<DetalheTabelaPrecoMetodologiaVO> listaDtp) throws NumberFormatException, SQLException {
        for (DetalheTabelaPrecoMetodologiaVO detalheTabelaPrecoVO : listaDtp) {
            if (!this.exameEncontrado(detalheTabelaPrecoVO, precosAlterados)) continue;
            StringBuilder buf = new StringBuilder();
            buf.append("Exame ").append(precosAlterados.getCodigoExame() + " (").append(precosAlterados.getMaterial().getCodigo()).append(") alterado ");
            String texto = buf.toString();
            String formatoValor = "0.00";
            if (!Funcoes.objectIsNull(detalheTabelaPrecoVO.getPorte().getCodigo()) || !Funcoes.objectIsNull(precosAlterados.getPorte())) {
                formatoValor = "0.000";
            }
            if (this.doubleAlterado(precosAlterados.getValorCusto(), detalheTabelaPrecoVO.getValorCh())) {
                buf = new StringBuilder();
                buf.append(texto);
                buf.append("Valor de ");
                buf.append(Funcoes.formataDecimal(formatoValor, detalheTabelaPrecoVO.getValorCh()));
                buf.append(" para ");
                buf.append(Funcoes.formataDecimal(formatoValor, precosAlterados.getValorCusto()));
                this.inserirHistorico(buf.toString(), codigoTabela);
            }
            if (!this.doubleAlterado(precosAlterados.getPercentual(), detalheTabelaPrecoVO.getPercentual())) break;
            buf = new StringBuilder();
            buf.append(texto);
            buf.append("Percentual de ");
            buf.append(Funcoes.formataDecimal("0.000", detalheTabelaPrecoVO.getPercentual()));
            buf.append(" para ").append(Funcoes.formataDecimal("0.000", precosAlterados.getPercentual()));
            this.inserirHistorico(buf.toString(), codigoTabela);
            break;
        }
    }

    public void inserirHistorico(String texto, String codigoTabela) throws SQLException {
        TabelaPrecoExameUsuarioVO tpeu = new TabelaPrecoExameUsuarioVO();
        tpeu.setCodigoFilial(Integer.valueOf(Variaveis.filialPadrao));
        tpeu.setCodigoTabelaPreco(Integer.valueOf(codigoTabela));
        tpeu.setCodigoUsuario(Variaveis.login);
        tpeu.setDataHoraAlteracao(new Date());
        tpeu.setAlteracao(texto);
        this.dao.inserirHistorico(tpeu);
    }

    public void registrarHistorico(TabelaPrecoVO tabelaPrecoVO) throws NumberFormatException, SQLException {
        List<TabelaPrecoVO> listaDtp = this.dao.buscarTabelaPreco(Integer.valueOf(Variaveis.filialPadrao), tabelaPrecoVO.getCodigo());
        for (TabelaPrecoVO tp : listaDtp) {
            StringBuilder buf;
            if (!this.tabelaAlterado(tp.getCodigo(), tabelaPrecoVO.getCodigo())) continue;
            String texto = "Cadastro alterado";
            if (this.campoAlterado(tp.getDescricao(), tabelaPrecoVO.getDescricao())) {
                buf = new StringBuilder();
                buf.append(texto);
                buf.append(" descri\u00e7\u00e3o de ").append(Funcoes.textoVazio(tp.getDescricao()) ? "N\u00e3o informado" : tp.getDescricao());
                buf.append(" para ").append(Funcoes.textoVazio(tabelaPrecoVO.getDescricao()) ? "N\u00e3o informado" : tabelaPrecoVO.getDescricao());
                this.inserirHistorico(buf.toString(), tabelaPrecoVO.getCodigo().toString());
            }
            if (this.campoAlterado(tp.getMoeda(), tabelaPrecoVO.getMoeda())) {
                buf = new StringBuilder();
                buf.append(texto);
                buf.append(" moeda de ").append(Funcoes.textoVazio(tp.getMoeda()) ? "N\u00e3o informado" : tp.getMoeda());
                buf.append(" para ").append(Funcoes.textoVazio(tabelaPrecoVO.getMoeda()) ? "N\u00e3o informado" : tabelaPrecoVO.getMoeda());
                this.inserirHistorico(buf.toString(), tabelaPrecoVO.getCodigo().toString());
            }
            if (!tp.getValorUco().equals(tabelaPrecoVO.getValorUco())) {
                buf = new StringBuilder();
                buf.append(texto);
                buf.append(" Valor UCO de ").append(Funcoes.formataDecimal("0.00", tp.getValorUco()));
                buf.append(" para ").append(Funcoes.formataDecimal("0.00", tabelaPrecoVO.getValorUco()));
                this.inserirHistorico(buf.toString(), tabelaPrecoVO.getCodigo().toString());
            }
            if (!tp.getValorCh().equals(tabelaPrecoVO.getValorCh())) {
                buf = new StringBuilder();
                buf.append(texto);
                buf.append(" Valor CH de ").append(Funcoes.formataDecimal("0.00000", tp.getValorCh()));
                buf.append(" para ").append(Funcoes.formataDecimal("0.00000", tabelaPrecoVO.getValorCh()));
                this.inserirHistorico(buf.toString(), tabelaPrecoVO.getCodigo().toString());
            }
            if (this.campoAlterado(tp.getTabelaANS(), tabelaPrecoVO.getTabelaANS())) {
                buf = new StringBuilder();
                buf.append(texto);
                buf.append(" Padr\u00e3o ANS ").append(Funcoes.textoVazio(tp.getTabelaANS()) ? "N\u00e3o informado" : tp.getTabelaANS());
                buf.append(" para ").append(Funcoes.textoVazio(tabelaPrecoVO.getTabelaANS()) ? "N\u00e3o informado" : tabelaPrecoVO.getTabelaANS());
                this.inserirHistorico(buf.toString(), tabelaPrecoVO.getCodigo().toString());
            }
            if (!this.booleanoAlterado(tp.isTipoCbhpm(), tabelaPrecoVO.isTipoCbhpm())) break;
            buf = new StringBuilder();
            buf.append(texto);
            buf.append(" Tabela CBHPM ").append(tp.isTipoCbhpm() ? "True" : "False");
            buf.append(" para ").append(tabelaPrecoVO.isTipoCbhpm() ? "True" : "False");
            this.inserirHistorico(buf.toString(), tabelaPrecoVO.getCodigo().toString());
            break;
        }
    }

    private boolean doubleAlterado(double percentual, Double datalheTabelaPrecoVOPercentual) {
        return percentual != datalheTabelaPrecoVOPercentual;
    }

    private boolean exameEncontrado(DetalheTabelaPrecoMetodologiaVO detalheTabelaPrecoVO, PrecosAlterados precosAlterados) {
        return detalheTabelaPrecoVO.getExame().getCodigo().equals(precosAlterados.getCodigoExame()) && (detalheTabelaPrecoVO.getMatColeta() != null && detalheTabelaPrecoVO.getMatColeta().getCodigo().intValue() == precosAlterados.getMaterial().getCodigo() || detalheTabelaPrecoVO.getMetodologia() != null && detalheTabelaPrecoVO.getMetodologia().getCodigo() == precosAlterados.getCodigoMetodologia());
    }

    private boolean booleanoAlterado(boolean tipoCbhpmAlterado, boolean tipoCbhpm) {
        return tipoCbhpmAlterado != tipoCbhpm;
    }

    private boolean campoAlterado(String descricaoAlterada, String descricao) {
        if (Funcoes.objectIsNull(descricaoAlterada)) {
            descricaoAlterada = "";
        }
        if (Funcoes.objectIsNull(descricao)) {
            descricao = "";
        }
        return !descricaoAlterada.equals(descricao);
    }

    private boolean tabelaAlterado(Integer codigoAlterado, Integer codigo) {
        return codigoAlterado == codigo;
    }
}

