/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.qualidade.naoconformidade.AbrirNaoConformidade;
import jalis.mensagens.NovaMensagem;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.NaoConformidadeBean;
import jalis.model.bean.cadastro.NaoConformidadeLoteBean;
import jalis.model.bean.cadastro.RequisicaoNaoConformidadeBean;
import jalis.model.bean.cadastro.RequisicaoNaoConformidadeVO;
import jalis.model.bean.cadastro.SetorNaoConformidadeBean;
import jalis.model.bean.cadastro.SetorNaoConformidadeUsuarioBean;
import jalis.model.bean.configuracao.UsuarioMensagemBean;
import jalis.model.dao.cadastro.NaoConformidadeDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.NaoConformidadeLoteVO;
import jalis.model.vo.cadastro.NaoConformidadeVO;
import jalis.model.vo.cadastro.SetorNaoConformidadeVO;
import jalis.model.vo.estoque.MaterialLoteVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.AbstractThreadService;
import jalis.service.cadastro.AcoesNaoConformidadeService;
import jalis.service.cadastro.AnalisarNaoConformidadeService;
import jalis.service.cadastro.NaoConformidadeLoteService;
import jalis.service.cadastro.RequisicaoNaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeService;
import jalis.service.cadastro.SetorNaoConformidadeUsuarioService;
import jalis.service.cadastro.auxiliares.UsuarioMensagemService;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NaoConformidadeService
extends AbstractThreadService {
    private RequisicaoNaoConformidadeService requisicaoNaoConfomidadeService = new RequisicaoNaoConformidadeService();
    private NaoConformidadeLoteService naoConformidadeLoteService = new NaoConformidadeLoteService();
    private SetorNaoConformidadeService setorNaoConformidadeService = new SetorNaoConformidadeService();
    private SetorNaoConformidadeUsuarioService setorNaoConformidadeUsuarioService = new SetorNaoConformidadeUsuarioService();
    private UsuarioMensagemService usuarioMensagemService = new UsuarioMensagemService();
    private AcoesNaoConformidadeService acoesNaoConformidadeService = new AcoesNaoConformidadeService();
    private AnalisarNaoConformidadeService analisarNaoConformidadeService = new AnalisarNaoConformidadeService();
    private static final String ASSUNTO_NCF_NAO_URGENTE = "N\u00e3o conformidade aberta.";
    private static final String ASSUNTO_NCF_URGENTE = "URGENTE, n\u00e3o conformidade aberta.";

    public NaoConformidadeService() {
        this.dao = new NaoConformidadeDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof NaoConformidadeBean) {
            ((NaoConformidadeBean)bean).setCodigo((Integer)codigo);
            this.dao.insert(bean, filialPadrao);
            String assuntoMsg = ASSUNTO_NCF_NAO_URGENTE;
            if (((NaoConformidadeBean)bean).getUrgente().booleanValue()) {
                assuntoMsg = ASSUNTO_NCF_URGENTE;
            }
            for (RequisicaoVO reqVo : ((NaoConformidadeBean)bean).getRequisicaoVos()) {
                if (reqVo == null) continue;
                RequisicaoNaoConformidadeBean requisicaoNaoConformidadeBean = new RequisicaoNaoConformidadeBean();
                requisicaoNaoConformidadeBean.setFilial(((NaoConformidadeBean)bean).getFilial());
                requisicaoNaoConformidadeBean.setNaoConformidade((NaoConformidadeVO)bean.toVO());
                requisicaoNaoConformidadeBean.setRequisicao(reqVo);
                this.requisicaoNaoConfomidadeService.insert(requisicaoNaoConformidadeBean, codigo, filialPadrao, filiais);
            }
            for (MaterialLoteVO mlvo : ((NaoConformidadeBean)bean).getLoteVos()) {
                if (mlvo == null) continue;
                NaoConformidadeLoteBean naoConformidadeLoteBean = new NaoConformidadeLoteBean();
                naoConformidadeLoteBean.setFilial(((NaoConformidadeBean)bean).getFilial());
                naoConformidadeLoteBean.setMaterialLote(mlvo);
                naoConformidadeLoteBean.setNaoConformidade((NaoConformidadeVO)bean.toVO());
                this.naoConformidadeLoteService.insert(naoConformidadeLoteBean, codigo, filialPadrao, filiais);
            }
            for (SetorNaoConformidadeVO setorVo : ((NaoConformidadeBean)bean).getSetorNaoConformidadeVOs()) {
                if (setorVo == null) continue;
                SetorNaoConformidadeBean setorNaoConformidadeBean = new SetorNaoConformidadeBean();
                setorNaoConformidadeBean.setFilial(((NaoConformidadeBean)bean).getFilial());
                setorNaoConformidadeBean.setNaoConformidade((NaoConformidadeVO)bean.toVO());
                setorNaoConformidadeBean.setCodResponsavelSetor(setorVo.getCodResponsavelSetor());
                setorNaoConformidadeBean.setSetor(setorVo.getSetor());
                setorNaoConformidadeBean.setTipo("R");
                this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(setorNaoConformidadeBean, 0, filialPadrao, filiais);
                for (SetorNaoConformidadeUsuarioBean setorUser : setorVo.getNaoConformidadeUsuarioBeans()) {
                    setorUser.setSetorNaoConformidadeVO((SetorNaoConformidadeVO)setorNaoConformidadeBean.toVO());
                    setorUser.setNaoConformidade((NaoConformidadeVO)((NaoConformidadeBean)bean).toVO());
                    setorUser.setFilial(((NaoConformidadeBean)bean).getFilial());
                    this.setorNaoConformidadeUsuarioService.insert(setorUser, 0, filialPadrao, filiais);
                    NovaMensagem.enviarMensagemNcf(Conexao.getStatement(), Variaveis.login, setorUser.getUsuarioVO().getCodigo(), assuntoMsg, "N\u00e3o conformidade com o c\u00f3digo " + ((NaoConformidadeBean)bean).getCodigo() + " adicionada sobre sua responsabilidade.", false, ((NaoConformidadeBean)bean).getFilial().getCodigo(), ((NaoConformidadeBean)bean).getCodigo(), setorUser.getSetorNaoConformidadeVO().getCodigo(), setorUser.getUsuarioVO().getCodigo());
                }
            }
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        String assuntoMsg = ASSUNTO_NCF_NAO_URGENTE;
        if (((NaoConformidadeBean)bean).getUrgente().booleanValue()) {
            assuntoMsg = ASSUNTO_NCF_URGENTE;
        }
        HashSet<String> usuariosNotificar = new HashSet<String>();
        for (SetorNaoConformidadeVO setorNaoConformidadeVO : ((NaoConformidadeBean)bean).getSetorNaoConformidadeVOs()) {
            if (setorNaoConformidadeVO == null || setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans() == null) continue;
            for (SetorNaoConformidadeUsuarioBean setorUser : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans()) {
                if (this.setorNaoConformidadeUsuarioService.usuarioNotificado(((NaoConformidadeBean)bean).getCodigo(), setorUser.getUsuarioVO().getCodigo())) continue;
                usuariosNotificar.add(setorUser.getUsuarioVO().getCodigo());
            }
        }
        for (SetorNaoConformidadeVO setorNaoConformidadeVO : ((NaoConformidadeBean)bean).getSetorNaoConformidadeVOsTemp()) {
            if (setorNaoConformidadeVO == null || setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans() == null || setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp() == null) continue;
            for (SetorNaoConformidadeUsuarioBean setorUser : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp()) {
                for (UsuarioMensagemBean usuarioMensagemBean : setorUser.getUsuarioMensagemBeans()) {
                    this.usuarioMensagemService.delete(usuarioMensagemBean, codigo, filialPadrao, filiais);
                }
            }
        }
        for (NaoConformidadeLoteVO naoConformidadeLoteVO : ((NaoConformidadeBean)bean).getNaoConformidadeLoteVOs()) {
            if (naoConformidadeLoteVO == null) continue;
            this.naoConformidadeLoteService.gravaAutoCopiaSemCommit(naoConformidadeLoteVO, 2, Variaveis.filialPadrao, filiais);
        }
        for (RequisicaoNaoConformidadeVO requisicaoNaoConformidadeVO : ((NaoConformidadeBean)bean).getRequisicaoNaoConformidadeVOs()) {
            if (requisicaoNaoConformidadeVO == null) continue;
            this.requisicaoNaoConfomidadeService.gravaAutoCopiaSemCommit(requisicaoNaoConformidadeVO, 2, Variaveis.filialPadrao, filiais);
        }
        for (SetorNaoConformidadeVO setorNaoConformidadeVO : ((NaoConformidadeBean)bean).getSetorNaoConformidadeVOsTemp()) {
            if (setorNaoConformidadeVO == null) continue;
            if (setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp() != null) {
                for (SetorNaoConformidadeUsuarioBean beanSetorUser : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp()) {
                    this.setorNaoConformidadeUsuarioService.delete(beanSetorUser, filialPadrao);
                }
            }
            this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(setorNaoConformidadeVO, 2, Variaveis.filialPadrao, filiais);
        }
        if (bean instanceof NaoConformidadeBean) {
            this.dao.update(bean, filialPadrao);
            for (RequisicaoVO requisicaoVO : ((NaoConformidadeBean)bean).getRequisicaoVos()) {
                if (requisicaoVO == null) continue;
                RequisicaoNaoConformidadeBean requisicaoNaoConformidadeBean = new RequisicaoNaoConformidadeBean();
                requisicaoNaoConformidadeBean.setFilial(((NaoConformidadeBean)bean).getFilial());
                requisicaoNaoConformidadeBean.setNaoConformidade((NaoConformidadeVO)bean.toVO());
                requisicaoNaoConformidadeBean.setRequisicao(requisicaoVO);
                this.requisicaoNaoConfomidadeService.insert(requisicaoNaoConformidadeBean, codigo, filialPadrao, filiais);
            }
            for (MaterialLoteVO materialLoteVO : ((NaoConformidadeBean)bean).getLoteVos()) {
                if (materialLoteVO == null) continue;
                NaoConformidadeLoteBean naoConformidadeLoteBean = new NaoConformidadeLoteBean();
                naoConformidadeLoteBean.setFilial(((NaoConformidadeBean)bean).getFilial());
                naoConformidadeLoteBean.setMaterialLote(materialLoteVO);
                naoConformidadeLoteBean.setNaoConformidade((NaoConformidadeVO)bean.toVO());
                this.naoConformidadeLoteService.insert(naoConformidadeLoteBean, codigo, filialPadrao, filiais);
            }
            for (SetorNaoConformidadeVO setorNaoConformidadeVO : ((NaoConformidadeBean)bean).getSetorNaoConformidadeVOs()) {
                if (setorNaoConformidadeVO == null) continue;
                SetorNaoConformidadeBean setorNaoConformidadeBean = new SetorNaoConformidadeBean();
                setorNaoConformidadeBean.setFilial(((NaoConformidadeBean)bean).getFilial());
                setorNaoConformidadeBean.setNaoConformidade((NaoConformidadeVO)bean.toVO());
                setorNaoConformidadeBean.setCodResponsavelSetor(setorNaoConformidadeVO.getCodResponsavelSetor());
                setorNaoConformidadeBean.setSetor(setorNaoConformidadeVO.getSetor());
                setorNaoConformidadeBean.setTipo("R");
                this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(setorNaoConformidadeBean, 0, filialPadrao, filiais);
                if (setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans() == null) continue;
                for (SetorNaoConformidadeUsuarioBean setorUser : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeans()) {
                    setorUser.setSetorNaoConformidadeVO((SetorNaoConformidadeVO)setorNaoConformidadeBean.toVO());
                    setorUser.setNaoConformidade((NaoConformidadeVO)((NaoConformidadeBean)bean).toVO());
                    setorUser.setFilial(((NaoConformidadeBean)bean).getFilial());
                    this.setorNaoConformidadeUsuarioService.insert(setorUser, 0, filialPadrao, filiais);
                    for (UsuarioMensagemBean mensagemBean : setorUser.getUsuarioMensagemBeans()) {
                        mensagemBean.setSetorNaoConformidadeVO((SetorNaoConformidadeVO)setorNaoConformidadeBean.toVO());
                        this.usuarioMensagemService.insert(mensagemBean, 0, filialPadrao, filiais);
                    }
                    if (!usuariosNotificar.contains(setorUser.getUsuarioVO().getCodigo())) continue;
                    Statement statement = Conexao.getStatement();
                    NovaMensagem.enviarMensagemNcf(Conexao.getStatement(), Variaveis.login, setorUser.getUsuarioVO().getCodigo(), assuntoMsg, "N\u00e3o conformidade com o c\u00f3digo " + ((NaoConformidadeBean)bean).getCodigo() + " adicionada sobre sua responsabilidade.", false, ((NaoConformidadeBean)bean).getFilial().getCodigo(), ((NaoConformidadeBean)bean).getCodigo(), setorUser.getSetorNaoConformidadeVO().getCodigo(), setorUser.getUsuarioVO().getCodigo());
                    statement.close();
                }
            }
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        for (NaoConformidadeLoteVO naoConformidadeLoteVO : ((NaoConformidadeBean)bean).getNaoConformidadeLoteVOs()) {
            if (naoConformidadeLoteVO == null) continue;
            this.naoConformidadeLoteService.gravaAutoCopiaSemCommit(naoConformidadeLoteVO, 2, Variaveis.filialPadrao, filiais);
        }
        for (RequisicaoNaoConformidadeVO requisicaoNaoConformidadeVO : ((NaoConformidadeBean)bean).getRequisicaoNaoConformidadeVOs()) {
            if (requisicaoNaoConformidadeVO == null) continue;
            this.requisicaoNaoConfomidadeService.gravaAutoCopiaSemCommit(requisicaoNaoConformidadeVO, 2, Variaveis.filialPadrao, filiais);
        }
        for (SetorNaoConformidadeVO setorNaoConformidadeVO : ((NaoConformidadeBean)bean).getSetorNaoConformidadeVOsTemp()) {
            if (setorNaoConformidadeVO != null && setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp() != null) {
                for (SetorNaoConformidadeUsuarioBean setorUser : setorNaoConformidadeVO.getNaoConformidadeUsuarioBeansTemp()) {
                    for (UsuarioMensagemBean mensagemBean : setorUser.getUsuarioMensagemBeans()) {
                        this.usuarioMensagemService.delete(mensagemBean, codigo, filialPadrao, filiais);
                    }
                    this.setorNaoConformidadeService.delete(setorUser, filialPadrao);
                }
            }
            if (setorNaoConformidadeVO == null) continue;
            this.setorNaoConformidadeService.gravaAutoCopiaSemCommit(setorNaoConformidadeVO, 2, Variaveis.filialPadrao, filiais);
        }
        if (bean instanceof NaoConformidadeBean || bean instanceof NaoConformidadeVO) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((NaoConformidadeDao)this.dao).getBean(chaves);
    }

    public AbstractThreadBean getBeanAnalise(Map<String, Object> chaves) throws ThreadDaoException {
        return ((NaoConformidadeDao)this.dao).getBeanAnalise(chaves);
    }

    public AbstractThreadBean getBeanConcluir(Map<String, Object> chaves) throws ThreadDaoException {
        return ((NaoConformidadeDao)this.dao).getBeanConcluir(chaves);
    }

    public AbstractThreadVO getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((NaoConformidadeDao)this.dao).getVO(chaves);
    }

    @Override
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return this.dao.getVO(codigo);
    }

    @Override
    public Set load() throws Exception {
        return null;
    }

    @Override
    public Set load(String where) throws Exception {
        return null;
    }

    @Override
    public Set loadVO() throws Exception {
        return null;
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(NaoConformidadeVO.class, where);
    }

    public AbstractThreadVO pesquisaVONcf(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String situacao) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(AbrirNaoConformidade.getModuloAcesso(), titulo);
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("ncfData", "Data", 2, "", 3, 75);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao + " and nac_situacao = '" + situacao + "'");
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVONcfSituacaoDiferente(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro, String situacao) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(AbrirNaoConformidade.getModuloAcesso(), titulo);
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("ncfData", "Data", 2, "", 3, 75);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao + " and nac_situacao <> '" + situacao + "'");
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(AbrirNaoConformidade.getModuloAcesso(), "Pesquisando n\u00e3o conformidades em aberto");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("ncfData", "Data", 2, "", 3, 75);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao + " and nac_situacao = '" + "A" + "'");
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public AbstractThreadVO pesquisaVOSemSituacao(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(AbrirNaoConformidade.getModuloAcesso(), "Pesquisando n\u00e3o conformidades em aberto");
        }
        tela.adicionaCampo("codigo", "C\u00f3digo", 1, "", 3, 75);
        tela.adicionaCampo("ncfData", "Data", 2, "", 3, 75);
        tela.setColunaOrdenacao("C\u00f3digo");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + Variaveis.filialPadrao);
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    public void update(AbstractThreadBean bean, String filial) throws ThreadDaoException, IllegalArgumentException, IllegalAccessException {
        this.dao.update(bean, filial);
    }
}

