/*
 * Decompiled with CFR 0.152.
 */
package jalis.service.cadastro;

import jalis.comum.Variaveis;
import jalis.comum.pesquisa.FrmPesquisaService;
import jalis.laboratorio.cadastro.Medico;
import jalis.model.AbstractThreadBean;
import jalis.model.AbstractThreadDao;
import jalis.model.bean.cadastro.MedicoBean;
import jalis.model.dao.cadastro.medico.MedicoDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import java.util.Map;
import java.util.Set;

public class MedicoService
extends AbstractThreadService {
    public MedicoService() {
        this.dao = new MedicoDao();
    }

    @Override
    public void insert(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof MedicoBean) {
            this.dao.insert(bean, filialPadrao);
        }
    }

    @Override
    public void update(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof MedicoBean) {
            this.dao.update(bean, filialPadrao);
        }
    }

    @Override
    public void delete(AbstractThreadBean bean, Object codigo, String filialPadrao, String filiais) throws Exception {
        if (bean instanceof MedicoBean) {
            this.dao.delete(bean, filialPadrao);
        }
    }

    @Override
    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, boolean mostrarCadastro) {
        return this.pesquisaVO(owner, bean, titulo, null, mostrarCadastro);
    }

    public AbstractThreadVO pesquisaVO(Object owner, AbstractThreadVO bean, String titulo, String filial, boolean mostrarCadastro) {
        FrmPesquisaService tela = FrmPesquisaService.novaInstancia(owner, titulo, bean);
        if (mostrarCadastro) {
            tela.setTelaCadastro(Medico.getModuloAcesso(), "Cadastro de M\u00e9dico");
        }
        tela.adicionaCampo("conselho", "Conselho", 0, "", 3, 75);
        tela.adicionaCampo("crm", "CRM", 0, "", 3, 75);
        tela.adicionaCampo("uf", "UF", 0, "", 2, 0);
        tela.adicionaCampo("nome", "Nome", 0, "", 2, 0);
        tela.setFiltroInicial("Nome", 2);
        tela.setColunaOrdenacao("Nome");
        tela.setService(this);
        tela.setFiltro(" fil_codigo = " + (Funcoes.textoVazio(filial) ? Variaveis.filialPadrao : filial));
        tela.setExecutarAoAbrir(false);
        tela.setVisible(true);
        return tela.getRegistroSelecionado();
    }

    @Override
    public Set load(String where) throws Exception {
        return AbstractThreadDao.load(MedicoBean.class, where);
    }

    @Override
    public Set loadVO(String where) throws Exception {
        return this.dao.loadVO(MedicoVO.class, where);
    }

    public AbstractThreadBean getBean(Map<String, Object> chaves) throws ThreadDaoException {
        return ((MedicoDao)this.dao).getBean(chaves);
    }

    public AbstractThreadBean getVO(Map<String, Object> chaves) throws ThreadDaoException {
        return ((MedicoDao)this.dao).getVO(chaves);
    }

    @Override
    @Deprecated
    public AbstractThreadBean get(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public AbstractThreadBean getVO(String codigo) throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set load() throws Exception {
        return null;
    }

    @Override
    @Deprecated
    public Set loadVO() throws Exception {
        return null;
    }
}

